(*%F _fdata *)
(*# call(seg_name => null) *)
(*%E *)
(*# module(implementation=>off) *)
(*# data(seg_name => null) *)
(*# call(o_a_copy => off) *)
(*# check(stack=>off,
          index=>off,
          range=>off,
          overflow=>off,
          nil_ptr=>off) *)

IMPLEMENTATION MODULE NFIO;

(* A module for JPI Topspeed Modula-2 *)
(* By Carl Neiburger
   169 N. 25th St.
   San Jose, Calif.

   CompuServe No. 72336,2257

NOTE: THIS IS AN ABRIDGED VERSION OF NFIO THAT INCLUDES
PROCEDURES NEEDED FOR FILE TRANSFER PROTOCOLS

*)

FROM Str IMPORT Copy, Concat;
IMPORT Lib;

CONST
  MaxHandle = MaxOpenFiles+3;

VAR
  EOFstat: ARRAY[0..MaxHandle] OF BOOLEAN;

PROCEDURE GetName(name: ARRAY OF CHAR; VAR fn: PathStr);
BEGIN
  Copy(fn,name);
  fn[SIZE(fn)-1] := CHR(0);
END GetName;

PROCEDURE Create(Name: ARRAY OF CHAR) : File;
VAR fn: PathStr; F: File;
BEGIN
  GetName(Name,fn);
  F := FioAsm.Create(fn);
  IF F <= MaxHandle THEN
    EOFstat[F] := TRUE;
    RETURN F
  END;
  RETURN MAX(CARDINAL)
END Create;

PROCEDURE Open(Name: ARRAY OF CHAR) : File;
VAR
  fn: PathStr; F: File;
BEGIN
  GetName(Name,fn);
  F := FioAsm.Open(fn, FioAsm.InputOutput);
  IF F <= MaxHandle THEN
    EOFstat[F] := Size(F) = 0;
    RETURN F
  END;
  RETURN MAX(CARDINAL)
END Open;

PROCEDURE EOF(F: File): BOOLEAN;
BEGIN
  RETURN EOFstat[F]
END EOF;

PROCEDURE RdChar(F: File ) : CHAR;
VAR c : CHAR;
BEGIN
  OK := TRUE;
  IF RdBin( F,c,1 ) = 0 THEN
    OK := FALSE;
    c  := CHR(26);
  END;
  EOFstat[F] := c = CHR(26);
  RETURN c;
END RdChar;

PROCEDURE RdStr(F: File; VAR Buf: ARRAY OF CHAR);
VAR
  i,h : CARDINAL;
  c   : CHAR;
BEGIN
  i  := 0;
  h  := HIGH( Buf );
  OK := TRUE;
  LOOP
     IF i > h THEN RETURN END;
     c := RdChar( F );
     IF c = CHR( 26 ) THEN
       Buf[ i ] := CHR(0);
       EOFstat[F] := i = 0;
       RETURN;
     ELSIF c = CHR( 13 ) THEN
       Buf[ i ] := CHR(0);
       RETURN;
     ELSIF c # CHR( 10 ) THEN
       Buf[ i ] := c;
       INC( i );
     END;
  END;
END RdStr;

PROCEDURE WrBin(F: File; Buf: ARRAY OF BYTE; Count: CARDINAL);
BEGIN
  OK := (Count = Write( F,Buf,Count ) ) AND (IOresult() = 0);
END WrBin;

PROCEDURE RdBin(F: File; VAR Buf: ARRAY OF BYTE; Count: CARDINAL) : CARDINAL;
VAR i : CARDINAL;
BEGIN
  i   := 0;
  OK  := TRUE;
  EOFstat[F] := FALSE;
  IF Count > 0 THEN
    i  := Read( F,Buf,Count );
    OK := (IOresult() =0);
    IF i < Count THEN EOFstat[F] := TRUE END;
  END;
  RETURN i;
END RdBin;

PROCEDURE Exists(Name: ARRAY OF CHAR) : BOOLEAN;
VAR d : FioAsm.DirEntry;
    b : BOOLEAN ;
    dta : ADDRESS;
BEGIN
  dta := FioAsm.GetDTA();
  b := FioAsm.ReadFirstEntry(Name, FioAsm.FileAttr{},d);
  FioAsm.SetDTA(dta);
  RETURN b;
END Exists;

PROCEDURE GetPos (F: File) : LONGCARD;
BEGIN
    RETURN FioAsm.GetPos(F, OK )
END GetPos; 

PROCEDURE Size(F: File) : LONGCARD;
VAR
    p, q: LONGCARD;
BEGIN
  p := GetPos(F);
  FioAsm.SeekEOF(F, OK);
  q := GetPos(F);
  FioAsm.Seek(F, p, OK);
  RETURN q
END Size;

PROCEDURE GetDir(drive: SHORTCARD; VAR Name: ARRAY OF CHAR);
VAR
  dr : ARRAY [0..2] OF CHAR;
BEGIN
  FioAsm.GetDir(drive, Name);
  IF drive = 0 THEN drive := FioAsm.GetDrive() END;
  dr[0] := CHR(drive + 64);
  dr[1] := ':';
  dr[2] := '\';
  Concat(Name,dr,Name)
END GetDir;

PROCEDURE ChDir (Name: ARRAY OF CHAR);
BEGIN
    IF Name[1] = ':' THEN
         OK := FioAsm.SetDrive(VAL(SHORTCARD,CAP(Name[0]))-VAL(SHORTCARD,'@'));
         IF (NOT OK) OR (Name[2] = 0C) THEN RETURN END;
    END;
    OK := FioAsm.ChDir(Name)
END ChDir;

PROCEDURE Erase (Name: ARRAY OF CHAR);
BEGIN
    OK := FioAsm.Erase(Name)
END Erase;

PROCEDURE Close (F: File);
BEGIN
    OK := FioAsm.Close(F);
END Close; 

PROCEDURE Rename(Name,NewName : ARRAY OF CHAR);
BEGIN
    OK := FioAsm.Rename(Name,NewName);
END Rename; 

BEGIN
  Lib.Fill( ADR(EOFstat), SIZE(EOFstat), 0);
  OK      := TRUE;
END NFIO.

