-- This program is a cellular automata where each cell plays against each of
-- its neighbours (and itself), and then assumes the strategy (either cooperate
-- or defect) of its highest scoring neighbour. This is an adaption of a QBASIC
-- program from the June '95 Scientific American, which is why the code is so
-- messy (ie no procedures, single letter variable names, etc). Maybe I'll fix
-- this sometime. Or not.
-- In the prisoner's dilemma each of 2 prisoners is asked whether the other
-- committed a crime; their level of punishment depends on whether one, both or
-- neither indicates the other's guilt (defects).
-- In this program the constant b represents the payoff for defecting when your
-- opponent cooperates. Different values of b alter the behaviour of the board.
-- 1 is the code for cooperating, 2 for defecting, in the payoff matrix pm.
-- This runs around 10 times faster than in QBASIC.
-- Any comments/question/suggestion etc to:
-- Gavin Doig, marrcps@aol.com.
-- This is my school's account, so I may take a while to get back to you.
-- 27.03.97

include graphics.e
global sequence s,sn,c,payoff,count,pm
constant b = 1.85
constant n = 100   -- length of sides of board
constant p = .25  -- initial proportion of defectors

-- Generate random initial strategies. Change this to see what happens to a few
-- isolated or clustered individual with a different strategy, ie single
-- defectors can 'infiltrate' a population of cooperators, but a block of
-- cooperators is needed to survive, surrounded by defectors.
procedure generate()
    atom centre
	for i = 1 to n do
	    for j = 1 to n do
		    s[i][j] = 1
		    if rand(1000) <=
		     p*1000 then
			s[i][j] = 2
		    end if
	    end for
    end for
    centre = floor(n/2)
    -- Uncomment next line to give 1 defector in center of board. (Set p = 0)
--      s[centre][centre] = 2
    -- Uncomment next 4 lines to give block of 4 cooperators (p = 1)
--      s[centre][centre] = 1
--      s[centre][centre+1] = 1
--      s[centre+1][centre] = 1
--      s[centre+1][centre+1] = 1
end procedure

procedure setup()
	atom graph
	graph = graphics_mode(18)
	pm = {{1,0},{b,0}}
	c = {{1,2},{14,4}}
	s = repeat (repeat (1,n),n)
	payoff = s
	generate()
	sn = s
	count = {0,0}
end procedure

function getpos(atom x) -- wraps edges of board to opposite edges
    atom r
    r = x
    if x = 0 then
	r =  n
    end if
    if x = n + 1 then
	r = 1
    end if
    return r
end function

atom gen,gn,tt,t,ext,change,pa,hp,pos1,pos2,xscale,yscale
sequence colour
object key

setup()

xscale = floor(500 / n + .5)   -- Scales for drawing board
yscale = floor(410 / n + .5)
gen = 0
tt = 0
t = 0
key = ""
ext = 0

while ext = 0 do
    -- Count the number of cooperators and defectors, and how many change
    count[1] = 0
    count[2] = 0
    change = 0
    
    -- Display board, and do counting
    for i = 1 to n do
	colour = repeat(0,n*xscale)
	for j = 1 to n do
	    colour [j*xscale] = c[sn[i][j]][s[i][j]]
	    count[s[i][j]] = count[s[i][j]] + 1
	    if s[i][j] != sn[i][j] then
		change = change + 1
	    end if
	    s[i][j] = sn[i][j]
	end for
	pixel (colour, {0,i*yscale})
    end for
    position(28,1)
    printf(1,"Generation  = %6d    ",gen)
--  printf(1,"Time = %6.3f   ",t)
    printf(1,"Total     = %6.3f    ",tt)
    gn = gen
    if gen = 0  then
	gn = 1
    end if
    printf(1,"Average time = %6.3f\n",tt/gn)
    printf(1,"Cooperators = %6d    ",count[1])
    printf(1,"Defectors = %6d    ",count[2])
--  printf(1,"No. changing = %6d\n",change)
    printf(1,"%% changing   = %6.3f\n",((change / (n*n))*100))
    
    t = time()
    gen = gen + 1
    
    -- Calculate payoffs for each player
    -- Note that k = l = 0 plays the player against itself
    for i = 1 to n do
	for j = 1 to n do
	    pa = 0
	    for k = -1 to 1 do
		for l = -1 to 1 do
		    pos1 = getpos(i + k)
		    pos2 = getpos(j + l)
		    pa = pa + pm[s[i][j]][s[pos1][pos2]]
		end for
	    end for
	payoff[i][j] = pa
	end for
    end for

    -- Now find highest payoff in each neighbourhood, and update strategies
    sn = s
    for i = 1 to n do
	for j = 1 to n do
	    hp = payoff[i][j]
	    for k = -1 to 1 do
		for l = -1 to 1 do
		    pos1 = getpos(i + k)
		    pos2 = getpos(j + l)
		    if payoff[pos1][pos2] > hp then
			hp = payoff[pos1][pos2]
			sn[i][j] = s[pos1][pos2]
		    end if
		end for
	    end for
	end for
    end for

    key = get_key()
    t = time() - t
    tt = tt + t
    
    if key != -1 then
	puts(1,"End program (Y/n)?")
	key = gets(0)
	if key[1] != 'N' and key[1] != 'n' then
	    ext = 1
	end if
	key = -1
    end if
end while
if graphics_mode(-1) then
end if

