%
% "bubble.t" demonstrates the bubble sort algorithm
%
% The main routine reads from the terminal an array
% of ten real numbers and calls the procedure Bubble
% to sort them.
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const TABLEN : int := 10                        % length of reals table

type TABLE : array[TABLEN] of real              % Table of reals type

var R : TABLE                                   % The table itself
var i : int                                     % Table index

%
% The sorting routine to sort in ascending order
%
procedure Bubble( var t : TABLE )

    var i, j : int
    var temp : real

    for i := 0 ... TABLEN - 2 do                % the outer loop

        for j := i + 1 ... TABLEN - 1 do        % the inner loop

            if t[i] > t[j] then

                temp := t[i]
                t[i] := t[j]
                t[j] := temp

            end if

        end for

    end for

end procedure

program

    var n : int

    put "Bubble Sort Demonstration Program"

    for i := 0 ... TABLEN - 1 do

        prompt "input real number no. " & intstr( i + 1, 2 ) & ":"
        get R[i]

    end for

    Bubble( R )                                 % sort the array

    put "The sorted list from lowest to highest is:"

    for i := 0 ... TABLEN - 1 do

        put R[i]
        n := ( i + 1 ) mod 5
        
        if n = 0 then
     
            put ""
        
        end if

    end for

end program