%
% "golden.t" computes the golden ratio by iteration using the
% last two items of a fibonacci sequence
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

var fib0, fib1, fib2 : int
var golden, old_gold : real

program

    fib0 := 0
    fib1 := 1
    old_gold := 0

    loop

        fib2 := fib1 + fib0
        fib0 := fib1
        fib1 := fib2
        golden := fib1 / fib0

        exit when old_gold = golden

        old_gold := golden
        put golden:16:12

    end loop

end program