%
% "sieve.t" uses the sieve of Eratosthenes to identify
% prime numbers in the range 1..N.
% This method originated in the 3rd century B.C.
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const N : int := 5000
var a : array[N] of boolean

program

    var i, j : int 

    init_a

    put "working "

    for i := 2...floor( N/2 ) do

        for j := 2...floor( N/i ) do

            a[i*j-1] := false

        end for

    end for

    put ""  

    for i := 1 ... N do

        if a[i-1] then

            put i : 10

        end if

    end for

end program

procedure init_a

    var i : int

    for i := 1 ... N do

        a[i-1] := true

    end for

end procedure