-- cmdline.e - provides enhanced command line processing
-- Jeff Zeitlin (jeff.zeitlin@execnet.com)

-- switch processing - switches are case-sensitive; i.e., /s != /S

-- switch(object s)
--   Is there a switch s on the command line?
--   Accepts either /s or -s as valid switch.
--   Returns 0 for no switch, param # if exists

-- switchval(object s, integer valrequired)
--    returns sequence containing one of:
--      switch /s not present:  0 (atom)
--      switch /s present:      param # (atom)
--      valrequired = 1:
--        switch of form /sx:   x as sequence (text)
--        switch of form /s x:  x as sequence (text)
--        switch not present:   0 (atom)
--      valrequired = 0
--        switch of form /sx:   x as sequence (text)
--        switch of form /s x:  param # (x may != value) (atom)
--        switch not present:   0 (atom)
--    leading character of switch may be - or /

global function switch(object s)
    sequence cmdline
    sequence sw1, sw2
    integer found, i
    
    cmdline = command_line()
    sw1 = "/" & s
    sw2 = "-" & s
    found = 0
    i = 1
    while (not found) and (i <= length(cmdline)) do
	found = (match(sw1,cmdline[i]) = 1) or (match(sw2,cmdline[i]) = 1)
	if found then
	    return i
	else
	    i = i + 1
	end if
    end while
    return found
end function

global function switchval(object s, integer required)
    sequence cmdline
    sequence val
    integer i
    
    cmdline = command_line()
    i = switch(s)
    if i = 0 then
	return 0
    else
	val = cmdline[i][length(s)+2..length(cmdline[i])]
	if required then
	    if compare(val,{}) = 0 then
		val = cmdline[i+1]
	    end if
	else
	    if compare(val,{}) = 0 then
		return i
	    end if
	end if
    end if
    return val
end function
