-- sets.e
-- implements a generic set type for Euphoria.

-- set type - just a sequence, including an empty one

global type set(sequence s)
    return 1
end type

-- s = set_incl(s,o) - includes object o as element of s.

global function set_incl(set s, object o)
    integer found
    
    if s = {} then
	return {o}
    end if
    found = find(o,s)
    if not found then
	return append(s,o)
    else
	return s
    end if
end function

-- s = set_excl(s,o) - excludes object o from set s

global function set_excl(set s, object o)
    integer found
    
    found = find(o,s)
    if found then
	return s[1..found-1] & s[found+1..length(s)]
    else
	return s
    end if
end function

-- s = set_union(s1,s2) - returns set of all elements from either set

global function set_union(set s1, set s2)
    set newset
    
    newset = s1
    for i = 1 to length(s2) do
	newset = set_incl(newset,s2[i])
    end for
    return newset
end function

-- b = set_member(s,o) - returns 1 (true) if o is a member of s

global function set_member(set s, object o)
    return (find(o,s) != 0)
end function

-- b = set_empty(s) - returns 1 (true) if set is empty (no members)

global function set_empty(set s)
    return (length(s) = 0)
end function

-- s = set_intersection(s1, s2) - return set of elements in both sets

global function set_intersection(set s1, set s2)
    set newset
    
    newset = {}
    for i = 1 to length(s1) do
	if set_member(s2,s1[i]) then
	    newset = set_incl(newset,s1[i])
	end if
    end for
    return newset
end function

-- s = set_difference(s1, s2) - return elements of s1 not in s2.

global function set_difference(set s1, set s2)
    set newset
    
    newset = {}
    for i = 1 to length(s1) do
	if not set_member(s2,s1[i]) then
	    newset = set_incl(newset,s1[i])
	end if
    end for
    return newset
end function

-- s = set_symmdiff(s1, s2) returns elements of both s1 and s2 that are not
-- in both.

global function set_symmdiff(set s1, set s2)
    set union
    set intersect
    set newset
    
    union = set_union(s1, s2)
    intersect = set_intersection(s1, s2)
    newset = set_difference(union, intersect)
    return newset
end function
