-- stack.e
-- by Jeff Zeitlin (jeff.zeitlin@execnet.com)

-- implements a stack type for Euphoria with proper syntax.

-- stack s
--      declares the type stack, and checks to see if it is initialized

-- stack s
-- s = init()
--      creates a new stack, returns a "handle" to be used to refer to this
--      stack hereafter.

-- push(stack s, object o)
--      puts object o on the top of stack s

-- object o
-- o = pop(stack s)
--      takes object off top of stack s, and returns it.

-- boolean/integer b
-- b = empty(stack s)
--      returns TRUE (1) if there are no objects on stack s, FALSE (0) otherwise

-- clear(stack s)
--      makes existing stack s empty, discarding all information on it.


-- private procedures and variables

procedure errorexit(integer code, sequence message)
    printf(2,"%s",{message})
    abort(code)
end procedure

sequence stacks
stacks = {}

-- public interface

global type stack(integer s)
    return s <= length(stacks)
end type

global function init()
    stacks = append(stacks,{})
    return length(stacks)
end function

global procedure push(stack s, object o)
    stacks[s] = append(stacks[s], o)
end procedure

global function empty(stack s)
    return length(stacks[s]) = 0
end function

global function pop(stack s)
    object val
    
    if empty(s) then
	errorexit(1,"stack underflow error\n")
    end if
    val = stacks[s][length(stacks[s])]
    stacks[s] = stacks[s][1..length(stacks[s])-1]
    return val
end function

global procedure clear(stack s)
    stacks[s] = {}
end procedure
