-- stddefs.e

-- Standard definitions for general use

-- bool type - FALSE and TRUE

global constant bFALSE=0
global constant bTRUE=1

global type bool(integer b)
    return b=bFALSE or b=bTRUE
end type

-- standard file handles

global constant STD_IN=0
global constant STD_OUT=1
global constant STD_ERR=2

-- errorexit - prints message and exits, setting exit code.

global procedure errorexit(integer exitcode, sequence msg)
    puts(STD_ERR, msg)
    abort(exitcode)
end procedure

-- xor - logical exclusive-or.  Supplements AND, OR, NOT of basic language

global function xor(object l, object r)
    return ((l and (not r)) or ((not l) and r))
end function

-- xslice - extended slices - allows discontinuous subscripts and subscripts
--          not in strict ascending order.

global function xslice(sequence var, sequence subscripts)
    sequence result

    result = {}
    for i = 1 to length(subscripts) do
	if subscripts[i] > length(var) then
	    errorexit(1,"Invalid subscript in extended slice.\n")
	end if
	result = append(result,var[subscripts[i]])
    end for
    return result
end function


-- trim function - returns string stripped of leading and trailing white space

global function trim(sequence s)
    sequence t

    if length(s)=0 then
	return s
    end if
    t = s
    while (t[1]=' ') or (t[1]='\t') or (t[1]='\n') or (t[1]='\r') do
	t = t[2..length(t)]
	if length(t)=0 then
	    return t
	end if
    end while
    while (t[length(t)]=' ') or (t[length(t)]='\t') or
	  (t[length(t)]='\n') or (t[length(t)]='\r') do
	t = t[1..length(t)-1]
	if length(t)=0 then
	    return t
	end if
    end while
    return t
end function

-- left - returns leftmost slice of length i of a string

global function left(sequence s, integer i)
    if i > length(s) then
	errorexit(1,"Can't slice more than the whole thing.\n")
    end if
    return s[1..i]
end function

-- right - returns rightmost slice of length i of a string

global function right(sequence s, integer i)
    if i > length(s) then
	errorexit(1,"Can't slice more than the whole thing.\n")
    end if
    return s[length(s)-i+1..length(s)]
end function

-- any - returns logical true (non-zero) if any member of parameter is non-zero

global function any(object v)
    if atom(v) then
	return v
    end if
    return find(0, not v)
end function

-- all - returns logical true (non-zero) if all members of parameter
--       are non-zero

global function all(object v)
    if atom(v) then
	return v
    end if
    return not find(0,v)
end function

