{================================================}
{     This program is taken from the book,       }
{ "PASCAL programs in science and engineering"   }
{    by Jules H. Gilder & J. Scott Barrus        }
{   Published by, HAYDEN ISBN 0-8104-6265-6      }
{                                                }
{================================================}
{                                                }
{ Title:  Circle Finder                          }
{                                                }
{ Program Summary: Program will find the center  }
{ and radius of a circle that is formed by three }
{ points not in a straight line.                 }
{                                                }
{================================================}

Program Circle_Finder;

 uses Crt;

  var
    answer,
    cont     : Char;
    out      : Text;
    X1,X2,X3,
    Y1,Y2,Y3,
    Part1,
    Part2,
    Part3,
    Part4,
    X,Y,
    Radius   : Real;

Procedure Title;
   begin
        Clrscr;
        Writeln;
        Writeln('Circle Finder');
        Writeln;Writeln;
        Writeln('This program will find the center and');
        Writeln('radius of a circle that is determined');
        Writeln('by any three points in a plane that ');
        Writeln('does not form a straight line.');
        Writeln;
        Writeln('Note: For all entries that require');
        Writeln('      data entries (x,y); separate ');
        Writeln('      all data with a space.');
        Writeln;Writeln;
   end;  { Title }

Procedure Input;
  begin
     Write('Enter first point  (X,Y):   ');
     Readln(X1,Y1);
     Write('Enter second point (X,Y):   ');
     Readln(X2,Y2);
     Write('Enter third point  (X,Y):   ');
     Readln(X3,Y3);
     Writeln;Writeln;Writeln;
  end;

Procedure Find;
   begin
     Part1 := ((X2-X1) * (X2+X1) + (Y2-Y1) * (Y2 + Y1)) / (2.0 * (X2-X1));
     Part2 := ((X3-X1) * (X3+X1) + (Y3-Y1) * (Y3 + Y1)) / (2.0 * (X3-X1));
     Part3 := (Y2 - Y1) / (X2 - X1);
     Part4 := (Y3 - Y1) / (X3 - X1);
     Y := (Part2 - Part1) / (Part4 - Part3);
     X := Part2 - Part4 * Y;
     Radius := SQRT (SQR (X3 - X) + SQR (Y3 - Y));
   end;

Procedure Print1;
   begin
      Writeln('The circle defined by the following');
      Writeln('three points:');
      Writeln;
      Writeln(' X1 = ',X1:7:4,' Y1 = ',Y1:7:4);
      Writeln(' X2 = ',X2:7:4,' Y2 = ',Y2:7:4);
      Writeln(' X3 = ',X3:7:4,' Y3 = ',Y3:7:4);
      Writeln;
      Writeln('has a radius = ',Radius:4:4);
      Writeln;
      Writeln('at a center located at:');
      Writeln;
      Writeln(' X = ',X:4:4,'    Y = ',Y:4:4);
   end; { Print1 }

begin  { Main }
  Repeat
        Title;
           Writeln;Writeln;
        Input;
        Find;
        Print1;
          Writeln;Writeln;
          Write('Do you have another 3 points? (Y/N)');
          Readln(cont);
   Until cont in ['n','N'];
end.
