{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$M 16384,0,655360}
{*****************************************************************************}
{* Dumb Terminal Demonstration Program                                       *}
{* (C) 1989-1993, Rising Edge Data Services                 Updated 08/09/93 *}
{*                                                                           *}
{* This simple program demonstrates some of the capabilities and calling     *}
{* conventions of common ASYNC routines.  Since this program uses DOS for    *}
{* all screen output, the terminal will properly display ANSI graphics IF    *}
{* you load ANSI.SYS or a compatible device driver in your CONFIG.SYS file.  *}
{* Handshaking by default is disabled but you can enable CTS/RTS handshaking *}
{* by removing the '$DEFINE NoHandshake' line that follows this comment      *}
{* block.                                                                    *}
{*****************************************************************************}

{$DEFINE NoHandshake}

Program DumbTerminal;

Uses CRT,ASYNC;

{Feel free to modify the constants below to suit your needs.}

Const
  ComPort    : Byte = 1;
  Baud       : Word = 2400;
  Wordsize   : Byte = 8;
  Parity     : Char = 'N';
  Stopbits   : Byte = 1;
  InBufSize  : Word = 256;
  OutBufSize : Word = 32;

  ExitKey = #59;                       {Exit key scan code: <F1> = 59}

Var
  Ch : Char;
  Done : Boolean;

Begin
  Assign(Output,'');                    {Use DOS for text output}
  Rewrite(Output);
  ClrScr;

  {Display introduction}

  Writeln('Dumb Terminal Demonstration            (C) 1990-1993, Rising Edge Data Services');
  Writeln;
  {$IFDEF NoHandshake}
  Writeln('Compiled with CTS/RTS handshaking DISABLED');
  {$ELSE}
  Writeln('Compiled with CTS/RTS handshaking ENABLED');
  {$ENDIF}
  Writeln;
  Writeln('Initializing: COM',ComPort,':',Baud,',',Wordsize,Parity,Stopbits);


  {Set communications parameters for selected port}

  ComParams(ComPort,Baud,Wordsize,Parity,Stopbits);
  If C_Error <> C_NoError Then
    Begin
      Writeln('Error initializing port, error code = ',C_Error);
      Halt(1);
    End;

  {Attempt to open port}
  {Turn on DTR & RTS if port successfully opened}

  OpenCom(ComPort,InBufSize,OutBufSize,True);
  If C_Error <> C_NoError Then
    Begin
      Writeln('Cannot open port, error code = ',C_Error);
      Halt(1);
    End;
  SetDTR(ComPort,'S');
  SetRTS(ComPort,'S');

  {If you would like to experiment with handshaking, remove the}
  {'$DEFINE NoHandshake' declaration at the start of the code.}

{$IFNDEF NoHandshake}
  {Enable hardware handshaking, receive and transmit}
  HandshakeMode(ComPort,'H','B',True);
  {Use RTS line for received data flow control}
  HardHSOutput(ComPort,2,2);
  {Use CTS line for transmitted data flow control}
  HardHSInput(ComPort,1,1);
  {Unassert RTS when receive buffer has less than 16 bytes space left}
  {Re-assert RTS when receive buffer has over 8 bytes space left}
  HandshakeOnOff(ComPort,16,8);
{$ENDIF}

  {Dumb terminal main loop}
  {Transmit any key pressed (except F1) to the selected COM port}
  {Display any character received from the COM port on the console}

  Writeln('Press F1 to exit.');
  Repeat
    If Keypressed Then
      Begin
        Ch := Readkey;
        If Keypressed Then
          Begin
            Ch := Readkey;
            Done := (Ch = ExitKey);
          End
        Else
          ComWriteCh(ComPort,Ch);
      End;

    If Not ComBufEmpty(ComPort,'I') Then
      Begin
        Ch := ComReadCh(ComPort);
        Write(Ch);
      End;
  Until Done;

  {F1 pressed - Close COM port, unassert DTR & RTS}

  Writeln;
  CloseCom(ComPort,0);
  Writeln('Port closed, code = ',C_Error);
  SetDTR(ComPort,'R');
  SetRTS(ComPort,'R');
End.
