%TITLE	"TIMER Assembly drivers          (C) 1990-1993 Rising Edge Data Services   V1.02"
%OUT	TIMER V1.02 Assembly drivers            (C) 1990-1993 Rising Edge Data Services
;********************************************************
;*							*
;*   Assembly language drivers for the TIMER101 unit	*
;*	 (interrupt-driven timer/counter system)	*
;*							*
;*	     Designed for Turbo Pascal V5.00+		*
;*							*
;*------------------------------------------------------*
;*							*
;*  Copyright (C) 1990, 1991 Rising Edge Data Services	*
;*		Author: Mark L. Schultz			*
;*							*
;*------------------------------------------------------*
;* Version 1.02				   Sat 08/07/93	*
;*------------------------------------------------------*
;* Note: This module was designed to be assembled with	*
;*	 Borland's Turbo Assembler (V1.02+).  It will	*
;*       not assemble correctly using Microsoft's MASM.	*
;*------------------------------------------------------*
;*							*
;* Revision history:					*
;*							*
;* 1.00 - 04/04/90					*
;*   First release for alpha testing.			*
;* 1.01 - 08/12/90					*
;*   Additional comments added/changed.			*
;* 1.02 - 01/01/91 (Happy B-day to me!)			*
;*   Various minor enhancements made to improve		*
;*   ISR efficiency.					*
;*							*
;********************************************************

; Timing modes (mode placed in T_Mode[])
;------------------------------------------------------------------------------
; Mode 0
;	Count down, recycle mode
;	Toggle status bit when T_Count[] = 0
;------------------------------------------------------------------------------
; Mode 1
;	Count up, recycle mode
;	Toggle status bit when T_Count[] = 0
;------------------------------------------------------------------------------
; Mode 2
;	Count down, recycle mode
;	Toggle status bit when T_Count[] = 0 OR	T_Count[] = T_Match[]
;------------------------------------------------------------------------------
; Mode 3
;	Count up, recycle mode
;	Toggle status bit when T_Count[] = 0 OR T_Count[] = T_Match[]
;------------------------------------------------------------------------------
; Mode 4
;	Count down, one-shot mode
;	Stop when T_Count[] = 0
;------------------------------------------------------------------------------
; Mode 5
;	Count up, one-shot mode
;	Stop when T_Count[] = 0
;------------------------------------------------------------------------------
; Mode 6
;	Count down, one-shot mode
;	Stop when T_Count[] = 0
;	Toggle status bit when T_Count[] = T_Match[]
;------------------------------------------------------------------------------
; Mode 7
;	Count up, one-shot mode
;	Stop when T_Count[] = 0
;	Toggle status bit when T_Count[] = T_Match[]
;------------------------------------------------------------------------------
; Mode 8
;	Count down, recycle mode
;	Reset T_Count[] to T_Match[] when T_Count[] = 0
;------------------------------------------------------------------------------
; Mode 9
;	Count up, recycle mode
;	Reset T_Count[] to 0 when T_Count[] = T_Match[]
;------------------------------------------------------------------------------
; Mode 10
;	Count direction determined by status flag (1=Up, 0=Down)
;	Counter operates in recycle mode
;	Toggle status when T_Count[] = 0 OR T_Count[] = T_Match[]
;------------------------------------------------------------------------------
%NEWPAGE
%SUBTTL	"Variable declarations"
;********************************************************
;*							*
;*		  Variable definitions			*
;*							*
;********************************************************

DATA	SEGMENT WORD PUBLIC

;	Externally accessed variables (declared in TIMER.PAS)

	EXTRN	T_Status	:WORD	;Timer status register
	EXTRN	T_Halt		:BYTE	;Halt ALL timers if <> 0

	EXTRN	T_Mode		:BYTE	;Timer mode
	EXTRN	T_Count		:WORD	;Counter
	EXTRN	T_Match		:WORD	;Match word
	EXTRN	T_MaxTimer	:WORD	;# of timers
	EXTRN	T_LongCount	:DWORD	;Longword count-up timer

;	Constants

MaxMode	EQU	10			;Highest valid mode #

;	Local variables

BitMask	DW	?			;Bit mask for status set/reset

DATA	ENDS
%NEWPAGE
%SUBTTL	"Timer interrupt service routine"
;********************************************************
;*							*
;*	  TIMER Interrupt Service Routine (ISR)		*
;*							*
;********************************************************

CODE	SEGMENT BYTE PUBLIC
	ASSUME	CS:CODE,DS:DATA

	PUBLIC	TimerISR		;Make address of ISR available to unit
	PUBLIC	T_OldISR		;Pass pointer to exit JMP address field

TimerISR PROC	FAR

	PUSH	AX			;Save environment
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;
	PUSH	SI			;
	PUSH	DI			;
	PUSH	DS			;

        MOV     AX,SEG DATA             ;AX <- Turbo Pascal data segment
        MOV     DS,AX                   ;Data segment <- TP data segment

;	Unconditionally increment longword timer

	INC	WORD PTR T_LongCount	;Bump low word of longword counter
	JNZ	Time1			;Continue if no overflow
	INC	WORD PTR T_LongCount+2	;Bump high word of longword counter

;	Stop (suspend) timing operations if T_Halt = TRUE

Time1:	CMP	T_Halt,0		;Stop all timers ?
	JNZ	TimeX			; Yes, exit

;	Update timers based on timing mode

	MOV	BitMask,1		;Initialize bit mask (start w/timer 0)
	XOR	SI,SI			;SI <- Byte array index
	MOV	AX,T_Status		;AX <- Status register

Time2:  MOV     BL,T_Mode[SI]           ;BL <- Timer mode
	CMP	BL,MaxMode		;Valid timer mode ?
	JA	Time3			; No, don't update timer

;	Valid timer mode was found in T_Mode[]
;	Execute timer mode subroutine

	MOV	DI,SI			;DI <- Timer #
	SHL	DI,1			;DI <- Timer # * 2 for word index
	MOV	CX,T_Count[DI]		;CX <- Count register for timer
	MOV	DX,T_Match[DI]		;DX <- Match register for timer
        XOR     BH,BH                   ;BX <- Timer mode
        SHL     BX,1                    ;BX <- Timer mode * 2 for word index
	MOV	BX,CS:ModeAdr[BX]	;BX <- Address of mode handler
	CALL	BX			;Invoke
	MOV	T_Count[DI],CX		;Save revised count register

;	Update continues here if timer mode not valid

Time3:	SHL	BitMask,1		;Advance bitmask to next status bit
	INC	SI			;Bump array index (timer #)
	CMP	SI,T_MaxTimer		;All done ?
	JB	Time2			; No, continue

;	All timers updated, exit

	MOV	T_Status,AX		;Save revised status register
TimeX:	POP	DS			;Restore environment
	POP	DI			;
	POP	SI			;
	POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	AX			;

;	Note: The UNIT initialization code must overwrite the address
;	portion of the following FAR JMP to point to the address of the old
;	INT 1Ch vector.  If this is done, the ISR will pass control to the
;	previous INT 1Ch handler when it is done, maintaining the interrupt
;	"chain".

	IDEAL
Here:	JMP	FAR 0:0			;Resume execution @ old ISR address
	MASM
T_OldISR EQU	Here + 1		;Pointer to address portion of JMP

;	Mode handler call table (NEAR addresses)

ModeAdr	DW	Mode0,Mode1,Mode2,Mode3,Mode4,Mode5,Mode6,Mode7
	DW	Mode8,Mode9,Mode10

TimerISR ENDP

%NEWPAGE
%SUBTTL	"Timer mode control subroutines"
;********************************************************
;*							*
;*	      Timer MODE control routines		*
;*							*
;*------------------------------------------------------*
;*							*
;* These subroutines control how the timers are updated	*
;* based on the MODE variable.  There is one subroutine	*
;* per MODE.  If new mode(s) are added, the subroutine	*
;* address must be placed in the ModeAdr table and the	*
;* constant MaxMode must be changed.  Entry and exit	*
;* conditions for these routines are detailed below:	*
;*							*
;* On entry:						*
;*   AX -> Timer status flags (bit 0 = Timer 0)		*
;*   CX -> Timer value word				*
;*   DX -> Timer MATCH word				*
;*   BitMask -> WORD with single bit set corresponding	*
;*		to the current timer #.  May be used to	*
;*		AND, OR or XOR the timer status flags.	*
;*							*
;* On exit:						*
;*   AX <- Revised timer status flags			*
;*   CX <- Revised timer value				*
;*							*
;* BX and DX may be used as temporaries.		*
;* SI and DI must be preserved.				*
;*							*
;********************************************************

;************************************************
;* Mode 0					*
;* Count down, recycle mode			*
;* Toggle status bit when T_Count[] = 0		*
;************************************************

Mode0	PROC	NEAR

	CMP	CX,0			;Timer = 0 ?
	JNE	Mode0A			; No, don't toggle status
	XOR	AX,BitMask		; Yes, flip status bit
Mode0A:	DEC	CX			;Decrement timer
	RET				;Exit

Mode0	ENDP

;************************************************
;* Mode 1					*
;* Count up, recycle mode			*
;* Toggle status bit when T_Count[] = 0		*
;************************************************

Mode1	PROC	NEAR

	INC	CX			;Bump timer
	CMP	CX,0			;Timer = 0 ?
	JNE	Mode1A			; No, don't toggle status
	XOR	AX,BitMask		; Yes, flip status bit
Mode1A:	RET				;Exit

Mode1	ENDP

;************************************************
;* Mode 2					*
;* Count down, recycle mode			*
;* Toggle status bit when T_Count[] = 0 OR	*
;* T_Count[] = T_Match[]			*
;************************************************

Mode2	PROC	NEAR

	CMP	CX,0			;Timer = 0 ?
	JNE	Mode2A			; No, don't toggle status
	XOR	AX,BitMask		; Yes, flip status bit
Mode2A:	CMP	CX,DX			;Timer = Match ?
	JNE	Mode2B			; No, don't toggle status
	XOR	AX,BitMask		; Yes, filp status bit
Mode2B:	DEC	CX			;Decrement timer
	RET				;Exit

Mode2	ENDP

;************************************************
;* Mode 3					*
;* Count up, recycle mode			*
;* Toggle status bit when T_Count[] = 0 OR	*
;* T_Count[] = T_Match[]			*
;************************************************

Mode3	PROC	NEAR

	INC	CX			;Bump timer
	CMP	CX,0			;Timer = 0 ?
	JNE	Mode3A			; No, don't toggle status
	XOR	AX,BitMask		; Yes, flip status bit
Mode3A:	CMP	CX,DX			;Timer = Match ?
	JNE	Mode3B			; No, don't toggle status
	XOR	AX,BitMask		; Yes, filp status bit
Mode3B:	RET				;Exit

Mode3	ENDP

;************************************************
;* Mode 4					*
;* Count down, one-shot mode			*
;* Stop when T_Count[] = 0			*
;************************************************

Mode4	PROC	NEAR

	CMP	CX,0			;Timer = 0 ?
	JNE	Mode4A			; No, continue counting
	XOR	AX,BitMask		;Toggle status bit
	MOV	T_Mode[SI],0FFh		;Stop timer
	RET				;Exit
Mode4A:	DEC	CX			;Decrement timer
	RET				;Exit

Mode4	ENDP

;************************************************
;* Mode 5					*
;* Count up, one-shot mode			*
;* Stop when T_Count[] = 0			*
;************************************************

Mode5	PROC	NEAR

Mode5A:	INC	CX			;Bump timer
	JNZ	Mode5B			; Exit now if timer <> 0
	XOR	AX,BitMask		;Toggle status bit
	MOV	T_Mode[SI],0FFh		;Stop timer
Mode5B:	RET				;Exit

Mode5	ENDP

;************************************************
;* Mode 6					*
;* Count down, one-shot mode			*
;* Stop when T_Count[] = 0			*
;* Toggle status bit when T_Count[] = T_Match[]	*
;************************************************

Mode6	PROC	NEAR

	CMP	CX,0			;Timer = 0 ?
	JNE	Mode6A			; No, continue counting
	XOR	AX,BitMask		;Toggle status bit
	MOV	T_Mode[SI],0FFh		;Stop timer
	RET				;Exit
Mode6A:	CMP	CX,DX			;Timer = Match ?
	JNE	Mode6B			; No, don't toggle status
	XOR	AX,BitMask		;Flip status bit
Mode6B:	DEC	CX			;Decrement timer
	RET				;Exit

Mode6	ENDP

;************************************************
;* Mode 7					*
;* Count up, one-shot mode			*
;* Stop when T_Count[] = 0			*
;* Toggle status bit when T_Count[] = T_Match[]	*
;************************************************

Mode7	PROC	NEAR

	INC	CX			;Bump timer
	JNZ	Mode7A			; Continue if <> 0
	XOR	AX,BitMask		;Toggle status bit
	MOV	T_Mode[SI],0FFh		;Stop timer
	RET				;Exit
Mode7A:	CMP	CX,DX			;Timer = Match ?
	JNE	Mode7B			; No, exit
	XOR	AX,BitMask		; Yes, toggle status bit
Mode7B:	RET				;Exit

Mode7	ENDP

;************************************************
;* Mode 8					*
;* Count down, recycle mode			*
;* Reset T_Count[] to T_Match[] when T_Count[]=0*
;************************************************

Mode8	PROC	NEAR

	CMP	CX,0			;Timer = 0 ?
	JNE	Mode8A			; No, continue
	XOR	AX,BitMask		;Toggle status bit
	MOV	CX,DX			;Reset timer to match word
	RET				;Exit
Mode8A:	DEC	CX			;Decrement timer
	RET				;Exit

Mode8	ENDP

;************************************************
;* Mode 9					*
;* Count up, recycle mode			*
;* Reset T_Count[] to 0 when T_Count[]=T_Match[]*
;************************************************

Mode9	PROC	NEAR

	INC	CX			;Bump timer
	CMP	CX,DX			;Timer = Match ?
	JNE	Mode9A			; No, exit
	XOR	AX,BitMask		;Toggle status bit
	XOR	CX,CX			;Reset timer
Mode9A:	RET				;Exit

Mode9	ENDP

;************************************************
;* Mode 10					*
;* Timer operates in recycle (continuous) mode	*
;* Count up when timer status bit = 1		*
;* Count down when timer status bit = 0		*
;* Toggle status when T_Count[] = 0 OR		*
;* T_Count[] = T_Match[]			*
;************************************************

Mode10	PROC	NEAR

	TEST	AX,BitMask		;Status bit set ?
	JZ	Mode10A			; No, count down
	INC	CX			;Bump timer
	JMP	SHORT Mode10B		;Check for status inversion
Mode10A:DEC	CX			;Decrement timer
Mode10B:JNZ	Mode10D			;If timer <> 0, check for timer=match
Mode10C:XOR	AX,BitMask		;Flip status bit
	RET				;Exit
Mode10D:CMP	CX,DX			;Timer = Match ?
	JE	Mode10C			; Yes, flip status bit & exit
	RET				; No, exit now

Mode10	ENDP

Code	ENDS
	END
