; *** CONSTANTS

buffer_size	equ	256
int_number	equ	255

; *** PORT DEFINITIONS

RBR		EQU	8
THR		EQU	8
DLL		EQU	8
DLH		EQU	9
IER		EQU	9
IIR		EQU	10
LCR		EQU	11
MCR		EQU	12
LSR		EQU	13
MSR		EQU	14

; *** PAGE 0 DEFINITIONS

abs0		segment at 0
		assume	es:abs0
		org	int_number*4
intc8vec	dw	?
abs0		ends

; *** CODE SEGMENT

code		segment
		assume	cs:code,ds:code,ss:code
		org	100h
start:		jmp	near ptr main

oldc		dw	?,?		;Old interrupt vectors
comnum		dw	?		;0 or 1 for COM1 or COM2
comport		dw	?		;3F0 or 2F0 for COM1 or COM2
comint		dw	?		;0C*4 or 0B*4 for COM1 or COM2
comports	dw	3f0h,2f0h
comints		dw	0ch*4,0bh*4
comors		db	16,8		;Or value to enable interrupt

buffer_head	dw	?		;Address where next character will go
buffer_tail	dw	?		;Address where first character is
buffer_start	dw	?		;Pointer: Start of buffer
buffer_end	dw	?		;Pointer: End of buffer
buffer		db	buffer_size dup (?)


; *** SUBROUTINES

rets		proc

inc_bx:		inc	bx			;Add 1 to BX, wrap around
		cmp	bx,buffer_end		;the buffer
		jne	ibx1
		mov	bx,buffer_start
ibx1:		ret

add_char:	push	bx
		mov	bx,buffer_head
		mov	[bx],al
		call	inc_bx
		mov	buffer_head,bx
		pop	bx
		ret

; *** CHECK IF THERE ARE CHARACTERS

chars_yn:	push	bx		;JZ will jump if there are no chars.
		mov	bx,buffer_tail	;If there are no chars, AL is
		mov	al,[bx]		;undefined.  If there are characters,
		cmp	bx,buffer_head	;AL holds the next character but it
		pop	bx		;is not taken out of the buffer.
		ret

; *** GET CHARACTER FROM BUFFER

get_char:	call	chars_yn	;JZ will jump if there are no chars.
		jnz	gc1		;If there are chars, the next WILL be
		xor	ax,ax		;taken out of the buffer as well as
		ret			;being in AL.  Otherwise, AL will
gc1:		push	bx		;have 0.
		mov	bx,buffer_tail
		mov	al,[bx]
		call	inc_bx
		mov	buffer_tail,bx
		pop	bx
		xor	ah,ah
		ret

num_chars:	mov	ax,buffer_head	;AX=# of characters in the buffer
		sub	ax,buffer_tail
		cmp	ax,0
		jge	nc1
		add	ax,buffer_size
nc1:		ret

; *** SEND CHARACTER IN AL OVER COMM LINE

send_char:	push	dx		;On exit, AH=128 not allowing to send
		push	ax
		mov	dx,comport
		add	dx,lsr
		xor	cx,cx
sc1:		in	al,dx
		test	al,20h
		jnz	sc2
		loop	sc1
		pop	ax
		mov	ah,80h
		jmp	short sc3
sc2:		add	dx,thr-lsr
		pop	ax
		out	dx,al
		xor	ah,ah
sc3:		pop	dx
		ret

rets		endp

;*** NEW INTERRUPT PROCEDURES

ints		proc

;*** HANDLE ANOTHER CHARACTER OVER THE COMM LINE

newc:		push	es
		push	ds
		push	di
		push	si
		push	bp
		push	dx
		push	cx
		push	bx
		push	ax
		mov	ax,cs
		mov	ds,ax
		xor	ax,ax
		mov	es,ax
		mov	dx,comport
		add	dx,rbr
		in	al,dx
		call	add_char
		mov	al,20h
		out	20h,al
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	bp
		pop	si
		pop	di
		pop	ds
		pop	es
		iret

ints		endp

;*** MAIN ROUTINES CALLABLE WITH AN INT 200D
;AH	Function
;--	--------
;0	Initialize; AX=1/2 for COM1: / COM2:.  Buffer is cleared.
;1	Return # characters in buffer in AX
;2	Receive characer, if any, else return 0
;3	Send character
;4	Disable routines
;5	Unused
;6	Hang up
;7	Set modem paramaters & init COM port and INT C/B
;	    AX= 1: 1=Even parity, 0=No parity
;	    BX= Baud rate
	
mains		proc

;*** INITIALIZE BUFFER

init:		cli			;AX=1 for COM1 or 2 for COM2
		push	dx
		push	bx
		push	ax
		dec	ax
		mov	comnum,ax
		shl	ax,1
		mov	bx,ax
		mov	ax,comports[bx]
		mov	comport,ax
		mov	ax,comints[bx]
		mov	comint,ax
		mov	ax,offset buffer
		mov	buffer_start,ax
		mov	buffer_head,ax
		mov	buffer_tail,ax
		add	ax,buffer_size
		mov	buffer_end,ax
		mov	bx,comint
		mov	cx,cs
		mov	ax,es:[bx+2]
		cmp	ax,cx
		je	already
		mov	ax,es:[bx]
		mov	oldc,ax
		mov	ax,es:[bx+2]
		mov	oldc[2],ax
		mov	ax,offset newc
		mov	es:[bx],ax
		mov	es:[bx+2],cx
already:	mov	dx,comport
		add	dx,ier
		mov	al,1
		out	dx,al		;ier
		inc	dx
		mov	al,1
		out	dx,al		;iir
		inc	dx
		mov	al,3
		out	dx,al		;lcr
		inc	dx
		mov	al,9
		out	dx,al		;mcr
		inc	dx
		mov	al,60h
		out	dx,al		;lsr
		inc	dx
		mov	al,30h
		out	dx,al		;msr
		mov	bx,comnum
		mov	ah,comors[bx]
		xor	ah,255
		in	al,21h
		and	al,ah
		out	21h,al
		pop	ax
		pop	bx
		pop	dx
		sti
		ret

disable:	push	dx
		push	cx
		push	bx
		push	ax
		mov	ax,oldc
		mov	cx,oldc[2]
		mov	bx,comint
		cli
		mov	es:[bx],ax
		mov	es:[bx+2],cx
		mov	bx,comnum
		in	al,21h
		or	al,comors[bx]
		out	21h,al
		sti
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		ret

enable:		ret

hang_up:	push	dx
		push	ax
		mov	dx,comport
		add	dx,mcr
		mov	al,0
		out	dx,al
		pop	ax
		pop	dx
		ret

param_tbl	db	3,1ah

set_param:	push	dx
		push	cx
		push	bx
		push	ax
		mov	dx,1		;dxax-1c200h
		mov	ax,0c200h
		div	bx
		mov	bx,ax
		mov	dx,comport
		add	dx,lcr
		mov	al,128
		out	dx,al
		mov	ax,bx
		add	dx,dll-lcr
		out	dx,al
		inc	dx
		mov	al,ah
		out	dx,al
		pop	ax		;Recover AX
		push	ax		;Push it back
		mov	bx,ax
		and	bx,1
		add	dx,lcr-dlh
		mov	al,param_tbl[bx]
		out	dx,al
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		ret

vectors		dw	init,num_chars,get_char,send_char,disable
		dw	enable,hang_up,set_param
end_vectors	label	byte

newc8:		push	es
		push	ds
		push	di
		push	si
		push	bp
		push	dx
		push	cx
		push	bx
		push	ax
		mov	ax,cs
		mov	ds,ax
		xor	ax,ax
		mov	es,ax
		pop	ax
		push	ax
		xor	al,al
		xchg	al,ah
		shl	ax,1
		mov	si,ax
		pop	ax
		add	si,offset vectors
		cmp	si,offset end_vectors
		jae	nfunc
		call	word ptr [si]
nfunc:		pop	bx
		pop	cx
		pop	dx
		pop	bp
		pop	si
		pop	di
		pop	ds
		pop	es
		iret

mains		endp

eop:
		db	128 dup (?)
eos:

;*** ENTRY PROCEDURE: INITIALIZE INT 0CH, INT 200D

main		proc
		mov	ax,cs
		mov	ds,ax
		cli
		mov	ss,ax
		mov	sp,offset eos
		sti
		xor	ax,ax
		mov	es,ax
		mov	ax,es:intc8vec
		cmp	ax,offset newc8
		jne	notinstalled
		mov	dx,offset almsg
		mov	ah,9
		int	21h
		int	20h
almsg:		db	"Modem driver already installed!",13,10,36
notinstalled:	mov	ax,offset newc8
		mov	es:intc8vec,ax
		mov	ax,cs
		mov	es:intc8vec[2],ax
		mov	ax,1			;Initialize the modem for COM1
		int	int_number
		mov	dx,offset eop+100h
		int	27h
main		endp
code		ends
		end	start

