{****************************************************************************
                     This is a source file of Free Vision

                      Copyright (c) 1996 by Florian Klaempfl
                            This code is freeware
 ****************************************************************************}

{ History:
   3/10/1996 Version 0.1
      - screen routines implemented
   3/11/1996
      - buffer routines implemented
   3/15/1996
      - getkeyevent implemented
      - getshiftstate implemented
      - key codes adapded to TV
      - showmouse implemented
      - hidemouse implemented
    3/17/1996 Version 0.2
      - interface is completed
}
{$E-}
unit drivers;

  interface

    uses
       mouse,objects;

    const
       kbnokey = $0000;
       kbesc = $011B;
       kbaltspace = $0200;
       kbctrlins = $0400;
       kbshiftins = $0500;
       kbctrldel = $0600;
       kbshiftdel = $0700;
       kbback = $0E08;
       kbctrlback = $0E7F;
       kbshifttab = $0F00;
       kbtab = $0F09;
       kbaltq = $1000;
       kbaltw = $1100;
       kbalte = $1200;
       kbaltr = $1300;
       kbaltt = $1400;
       kbalty = $1500;
       kbaltu = $1600;
       kbalti = $1700;
       kbalto = $1800;
       kbaltp = $1900;
       kbctrlenter = $1C0A;
       kbenter = $1C0D;
       kbalta = $1E00;
       kbalts = $1F00;
       kbaltd = $2000;
       kbaltf = $2100;
       kbaltg = $2200;
       kbalth = $2300;
       kbaltj = $2400;
       kbaltk = $2500;
       kbaltl = $2600;
       kbaltz = $2C00;
       kbaltx = $2D00;
       kbaltc = $2E00;
       kbaltv = $2F00;
       kbaltb = $3000;
       kbaltn = $3100;
       kbaltm = $3200;
       kbf1 = $3B00;
       kbf2 = $3C00;
       kbf3 = $3D00;
       kbf4 = $3E00;
       kbf5 = $3F00;
       kbf6 = $4000;
       kbf7 = $4100;
       kbf8 = $4200;
       kbf9 = $4300;
       kbf10 = $4400;
       kbhome = $4700;
       kbup = $4800;
       kbpgup = $4900;
       kbgrayminus = $4A2D;
       kbleft = $4B00;
       kbright = $4D00;
       kbgrayplus = $4E2B;
       kbend = $4F00;
       kbdown = $5000;
       kbpgdn = $5100;
       kbins = $5200;
       kbdel = $5300;
       kbshiftf1 = $5400;
       kbshiftf2 = $5500;
       kbshiftf3 = $5600;
       kbshiftf4 = $5700;
       kbshiftf5 = $5800;
       kbshiftf6 = $5900;
       kbshiftf7 = $5A00;
       kbshiftf8 = $5B00;
       kbshiftf9 = $5C00;
       kbshiftf10 = $5D00;
       kbctrlf1 = $5E00;
       kbctrlf2 = $5F00;
       kbctrlf3 = $6000;
       kbctrlf4 = $6100;
       kbctrlF5 = $6200;
       kbctrlf6 = $6300;
       kbctrlf7 = $6400;
       kbctrlF8 = $6500;
       kbctrlf9 = $6600;
       kbctrlf10 = $6700;
       kbaltF1 = $6800;
       kbaltf2 = $6900;
       kbaltf3 = $6A00;
       kbaltF4 = $6B00;
       kbaltf5 = $6C00;
       kbaltf6 = $6D00;
       kbaltf7 = $6E00;
       kbaltf8 = $6F00;
       kbaltf9 = $7000;
       kbaltf10 = $7100;
       kbctrlprtsc = $7200;
       kbctrlleft = $7300;
       kbctrlright = $7400;
       kbctrlend = $7500;
       kbctrlpgdn = $7600;
       kbctrlhome = $7700;
       kbalt1 = $7800;
       kbalt2 = $7900;
       kbalt3 = $7A00;
       kbalt4 = $7B00;
       kbalt5 = $7C00;
       kbalt6 = $7D00;
       kbalt7 = $7E00;
       kbalt8 = $7F00;
       kbalt9 = $8000;
       kbalt0 = $8100;
       kbaltminus = $8200;
       kbaltequal = $8300;
       kbctrlpgup = $8400;
       kbaltback = $0800;

       { masks for getshiftstate }

       kbinsstate = $80;
       kbcapsstate = $40;
       kbnumstate = $20;
       kbscrollstate = $10;
       kbaltshift = 8;
       kbctrlshift = 4;
       kbleftshift = 2;
       kbrightshift = 1;

       { values for tevent.what }
       evmousedown = $1;
       evmouseup = $2;
       evmousemove = $4;
       evmouseauto = $8;
       evkeydown = $10;
       evcommand = $100;
       evbroadcast = $200;


       evnothing = $0;
       evmouse = $f;
       evkeyboard = $10;
       evmessage = $ff00;

       mbleftbutton = $1;
       mbrightbutton = $2;

    type
       pevent = ^tevent;

       tevent = record
          case what : word of
             evnothing : ();
             evmouse : (buttons : byte;double : boolean;where : tpoint);
             evkeydown : (case integer of
                             0 : (keycode : word);
                             1 : (charcode : char;scancode : byte)
                         );
              evmessage : (case word of
                              0 : (infoptr : pointer);
                              1 : (infolong : longint);
                              2 : (infoword : word);
                              3 : (infoint : integer);
                              4 : (infobyte : byte);
                              5 : (infochar : char);
              );
       end;

       tsyserrorfunc = function(errorcode : integer;drive : byte) : integer;

    procedure initevents;
    procedure doneevents;
    procedure showmouse;
    procedure hidemouse;
    procedure getmousevent(var event : tevent);
    procedure getkeyevent(var event : tevent);
    function getshiftstate : byte;

    function getaltchar(keycode : word) : char;
    function getaltcode(ch : char) : word;
    function getctrlchar(keycode : word) : char;
    function getcrtcode(ch : char) : word;
    function ctrltoarrow(keycode : word) : char;

    procedure formatstr(var result : string;const format : string;var params);
    procedure printstr(const s : string);

    function systemerror(errorcode : integer;drive : byte) : integer;
    procedure initsyserror;
    procedure donesyserror;

    const
       smbw80 = 2;
       smco80 = 3;
       smmono = 7;
       smfont8x8 = $100;

       { mouse: }
       buttoncount : byte = 0;
       mouseevents : boolean = false;
       mousereverse : boolean = false;
       doubledelay : word = 8;
       repeatdelay : word = 8;

       { system error handling }
       syscolorattr : word = $4e4f;
       sysmonoattr : word = $7070;
       ctrlbreakhit : boolean = false;
       savectrlbreak : boolean = false;
       syserroractive : boolean = false;
       syserrorfunc : tsyserrorfunc = systemerror;

    var
       screenmode : word;
       screenwidth : word;
       screenheight : word;
       hiresscreen : boolean;
       startupmode : word;

       { set to false, but never used }
       checksnow : boolean;

       { is only used by DOS }
       screenbuffer : pointer;

       cursorlines : word;

       { mouse: }
       mouseintflags : byte;
       mousebuttons : byte;
       mousewhere : tpoint;

    procedure initvideo;
    procedure donevideo;
    procedure setvideomode(mode : word);
    procedure clearscreen;

    procedure movebuf(var dest;var source;attr : byte;count : longint);
    procedure movechar(var dest;c : char;attr : byte;count : longint);
    procedure movecstr(var dest;const str : string;attrs : word);
    procedure movestr(var dest;const str : string;attr : byte);
    function cstrlen(const s : string) : longint;

  implementation

    procedure movebuf(var dest;var source;attr : byte;count : longint);

      var
         i : longint;

      begin
         for i:=0 to count-1 do
           begin
              if attr<>0 then
                twordarray(dest)[i]:=attr shl 8;
              tbytearray(dest)[i*2]:=tbytearray(source)[i];
           end;
      end;

    procedure movechar(var dest;c : char;attr : byte;count : longint);

      var
         i : longint;

      begin
         for i:=0 to count-1 do
           begin
              if attr<>0 then
                twordarray(dest)[i]:=attr shl 8;
              tbytearray(dest)[i*2]:=byte(c);
           end;
      end;

    procedure movecstr(var dest;const str : string;attrs : word);

      var
         i : longint;
         is_low : boolean;

      begin
         is_low:=true;
         for i:=0 to length(str)-1 do
           begin
              if str[i+1]='~' then
                is_low:=not(is_low)
              else
                begin
                   if is_low then
                     twordarray(dest)[i]:=lo(attrs) shl 8
                   else
                     twordarray(dest)[i]:=attrs;
                   tbytearray(dest)[i*2]:=byte(str[i+1]);
                end;
           end;
      end;

    procedure movestr(var dest;const str : string;attr : byte);

      var
         i : longint;

      begin
         for i:=0 to length(str)-1 do
           begin
              if attr<>0 then
                twordarray(dest)[i]:=attr shl 8;
              tbytearray(dest)[i*2]:=byte(str[i+1]);
           end;
      end;

    function cstrlen(const s : string) : longint;

      var
         i,j : longint;

      begin
         j:=0;
         for i:=1 to length(s) do
           if s[i]<>'~' then
             inc(j);
         cstrlen:=j;
      end;

    var
       times_mouse_is_not_visible : longint;

    procedure initevents;

      begin
         times_mouse_is_not_visible:=0;
      end;

    procedure doneevents;

      begin
         {!!!!!}
      end;

    procedure showmouse;

      begin
         if mouseevents then
           begin
              dec(times_mouse_is_not_visible);
              if times_mouse_is_not_visible<1 then
                mouseon;
           end;
      end;

    procedure hidemouse;

      begin
         if mouseevents then
           begin
              inc(times_mouse_is_not_visible);
              if times_mouse_is_not_visible=1 then
                mouseoff;
           end;
      end;

    procedure getmousevent(var event : tevent);

      begin
         {!!!!!}
      end;

    procedure getkeyevent(var event : tevent);

      function is_keypressed : boolean;

        begin
           asm
              movb $1,%ah
              pushl %ebp
              int $0x16
              popl %ebp
              // ZF cleared if key pressed
              sete %al
              leave
              // remove EBP of getkeyevent
              ret $4
           end ['EAX'];
        end;

      function get_keycode : word;

        begin
           asm
              movb $0,%ah
              pushl %ebp
              int $0x16
              popl %ebp
              leave
              // remove EBP of getkeyevent
              ret $4
           end ['EAX'];
        end;

      begin
         if is_keypressed then
           begin
              event.what:=evkeydown;
              event.keycode:=get_keycode;
           end
         else
           event.what:=evnothing;
      end;

    function getshiftstate : byte;

      begin
         asm
            movb 0xe0000417,%al
            leave
            ret
         end ['EAX'];
      end;


    function getscreenmode : byte;

      begin
         asm
            movb 0xe0000449,%al
            leave
            ret
         end ['EAX'];
      end;

    procedure setscreenmode(mode : byte);

      begin
         asm
            movb 8(%ebp),%al
            xorb %ah,%ah
            pushl %ebp
            int $0x10
            popl %ebp
         end ['EAX'];
      end;

    function screenrows : byte;

      begin
         asm
            movb 0xe0000484,%al
            incb %al
            leave
            ret
         end ['EAX'];
      end;

    function screencols : byte;

      begin
         asm
            movb 0xe000044a,%al
            leave
            ret
         end ['EAX'];
      end;

    function getscreenprimary : longint;

      begin
         asm
            movl _ScreenPrimary,%eax
            leave
            ret
         end ['EAX'];
      end;

    procedure set8x8;

      begin
         asm
            movw $0x1112,%ax
            xorb %bl,%bl
            pushl %ebp
            int $0x10
            popl %ebp
         end ['EAX','EBX'];
      end;

    procedure set_cursor_lines(w : word);

      begin
         asm
            movb   $1,%ah
            movw   8(%ebp),%cx
            pushl %ebp
            int   $0x10
            popl %ebp
         end ['EAX','ECX'];
      end;

    function get_cursor_lines : word;

      begin
         asm
            // select the page
            movb $0,%bh
            // read cursor
            movb $3,%ah
            pushl %ebp
            int   $0x10
            popl %ebp
            movw %cx,%ax
            leave
            ret
         end ['EAX','EBX','ECX'];
      end;

    procedure initvideo;

      begin
         { switch always the screen mode }
         startupmode:=getscreenmode;
         hiresscreen:=true;
         cursorlines:=get_cursor_lines;
         setvideomode(smco80);
      end;

    procedure donevideo;

      begin
         setscreenmode(startupmode);
         set_cursor_lines(cursorlines);
         clearscreen;
      end;

    procedure setvideomode(mode : word);

      begin
         checksnow:=false;
         setscreenmode(lo(mode));
         screenmode:=mode;
         if hiresscreen and ((mode and smfont8x8)<>0) then
           set8x8;
         screenheight:=screenrows;
         screenwidth:=screencols;
         screenbuffer:=pointer(getscreenprimary);
         clearscreen;
      end;

    procedure clearscreen;

      begin
         {!!!!!!}
      end;

    function getaltchar(keycode : word) : char;

      begin
         {!!!!!!}
      end;

    function getaltcode(ch : char) : word;

      begin
         {!!!!!!}
      end;

    function getctrlchar(keycode : word) : char;

      begin
         {!!!!!!}
      end;

    function getcrtcode(ch : char) : word;

      begin
         {!!!!!!}
      end;

    function ctrltoarrow(keycode : word) : char;

      begin
         {!!!!!!}
      end;

    procedure formatstr(var result : string;const format : string;var params);

      begin
         {!!!!!!}
      end;

    procedure printstr(const s : string);

      begin
         {!!!!!!}
      end;

    function systemerror(errorcode : integer;drive : byte) : integer;

      begin
         {!!!!!!}
      end;

    procedure initsyserror;

      begin
         {!!!!!!}
      end;

    procedure donesyserror;

      begin
         {!!!!!!}
      end;

end.
