<<<-------------Start of File ------------------------------------->>>
<<<-------------File ran16.pas (1 of 2) starts here -------------->>>
PROGRAM RandomTest;

VAR
    s1, s2, s3 : INTEGER;
    i, j       : LONGINT;
    bin        : ARRAY[0..10] OF INTEGER;

FUNCTION Random16 : REAL;
{
  Random number generator for systems having 16 bit integers.
  The values s1, s2 and s3 need to be defined globally so that their
  values persist between calls to Random16.

  The generator is initialized by storing seed values into s1 and s2.

  This generator is from the article:

    Efficient and Portable Combined Random Number Generators
    by Pierre L'Ecuyer
    June 1988 Communications of the ACM Page 742

  The author of the article performed extensive statistical tests
  (over 200 hours of VAX 11/780 cpu time) to verify the quality of
  this generator.
}

VAR
    z, k : INTEGER;

BEGIN
  k := s1 DIV 206;
  s1 := 157 * (s1 - k * 206) - k * 21;
  IF s1 < 0 THEN 
    s1 := s1 + 32363;

  k := s2 DIV 217;
  s2 := 146 * (s2 - k * 217) - k * 45;
  IF s2 < 0 THEN 
    s2 := s2 + 31727;

  k := s3 DIV 222;
  s3 := 142 * (s3 - k * 222) - k * 133;
  IF s3 < 0 THEN 
    s3 := s3 + 31657;

  z := s1 - s2;
  IF z > 706 THEN 
    z := z - 32362;

  z := z + s3;
  IF z < 1 THEN 
    z := z + 32362;

  Random16 := z * 3.0899E-5;
END;  { Random16 }

BEGIN
  Write('Enter s1 '); Readln(s1);
  Write('Enter s2 '); Readln(s2);
  Write('Enter s3 '); Readln(s3);

{ Print out a sample of random values }
  FOR i := 1 TO 10 DO
    Writeln(Random16:16:12);

{ Do a simple minded test to verify that nothing has been lost in transit.
  The results should be that bin[0] .. bin[9] should contain approx. 1000, 
  and bin[10] should contain 0.
}
  FOR i := 0 TO 10 DO
    bin[i] := 0;
  FOR i := 1 TO 10000 DO
    BEGIN
      j := TRUNC( 10.0 * Random16);
      bin[j] := bin[j] + 1;
    END;
  FOR i := 0 TO 10 DO
    Writeln(i:4, '  ',bin[i]:5);
END.
<<<-------------File ran16.pas (1 of 2) stops here  -------------->>>
<<<-------------File ran32.pas (2 of 2) starts here -------------->>>
PROGRAM RandomTest;

VAR
    s1, s2 : LONGINT;
    i, j   : LONGINT;
    bin    : ARRAY[0..10] OF INTEGER;

FUNCTION Random32 : REAL;
{
  Random number generator for systems having 32 bit LONGINTs.
  The values s1 and s2 need to be defined globally so that their
  values persist between calls to Random32.

  The generator is initialized by storing seed values into s1 and s2.

  This generator is from the article:

    Efficient and Portable Combined Random Number Generators
    by Pierre L'Ecuyer
    June 1988 Communications of the ACM Page 742

  The author of the article performed extensive statistical tests
  (over 200 hours of VAX 11/780 cpu time) to verify the quality of
  this generator.
}

VAR
    z, k : LONGINT;

BEGIN
  k := s1 DIV 53668;
  s1 := 40014 * (s1 - k * 53668) - k * 12211;
  IF s1 < 0 THEN 
    s1 := s1 + 2147483563;

  k := s2 DIV 52774;
  s2 := 40692 * (s2 - k * 52774) - k * 3791;
  IF s2 < 0 THEN 
    s2 := s2 + 2147483399;

  z := s1 - s2;
  IF z < 1 THEN 
    z := z + 2147483562;

  Random32 := z * 4.656613E-10;
END;  { Random32 }

BEGIN
  Write('Enter s1 '); Readln(s1);
  Write('Enter s2 '); Readln(s2);

{ Write out a sample of random values }
  FOR i := 1 TO 10 DO
    Writeln(Random32:16:12);

{ Do a simple minded test to verify that nothing has been lost in transit.
  The results should be that bin[0] .. bin[9] should contain approx. 1000, 
  and bin[10] should contain 0.
}
  FOR i := 0 TO 10 DO
    bin[i] := 0;
  FOR i := 1 TO 10000 DO
    BEGIN
      j := TRUNC( 10.0 * Random32);
      bin[j] := bin[j] + 1;
    END;
  FOR i := 0 TO 10 DO
    Writeln(i:4, '  ',bin[i]:5);
END.
<<<-------------File ran32.pas (2 of 2) stops here  -------------->>>
<<<-------------End of file --------------------------------------->>>
