;Ŀ
; Little example source of how to use SATplayer. written by Lone Ranger/AcmE 
;

P286                                    ; Uses 286 instructions
jumps                                   ; Let TASM handle out-of-range jumps

Extrn   SAT_Player:Far
Extrn   SAT_Equalizer:byte
Extrn   SAT_SongPos:byte
Extrn   SAT_PatternPos:Word

_Code   segment para public 'Code'
assume  cs:_Code, ds:_Code, es:_Code, ss:_Stack

; Messages 

NoCommLineMessage:                      ; message if no command line
        db      'SAT Player, written by Lone Ranger/AcmE',13,10
        db      13,10
        db      'Usage:   SATplay <filename>',13,10,'$'

FileErrorMessage:                       ; message if a file error occurd
        db      7, 'File does not exist!',13,10,'$'

NoSATfileMessage:                       ; message if file is no SAT file
        db      7, 'This is not a SAT file!',13,10,'$'

NoFMchipMessage:                        ; message if no FM chip has been found
        db      7, 'No FM chip found!', 13, 10, '$'

EndMessage:                             ; end message
        db      'SATplayer v0.1, (c) Copyright 1993 by Lone Ranger/AcmE',13,10
        db      '$'

; Start of program 

ProgStart:

; Get PSP seg and prepare filename 

        mov     ah, 51h                 ; Get current process ID (PSP address)
        int     21h
        mov     es, bx
        cmp     byte ptr es:[80h], 0    ; is there any commandline?
        je      No_CommandLine          ; nope
        mov     di, 82h
        mov     al, 0dh
        mov     cx, 120
        repne   scasb                   ; scan for 'enter'
        dec     di
        xor     al, al
        stosb                           ; put a 0 there

; Load file 

        mov     ax, es
        mov     ds, ax

        mov     dx, 82h
        mov     ah, 3dh
        mov     al, 0
        int     21h                     ; open file
        jc      FileError

        mov     bx, ax                  ; set BX to file handle
        mov     ax, seg _MusicSeg
        mov     ds, ax
        xor     dx, dx
        mov     ah, 3fh
        mov     cx, 65500
        int     21h                     ; load 65500 bytes of file in buffer

        mov     ah, 3eh                 ; close file
        int     21h

; Check for SAT file 

        cmp     word ptr ds:[0] ,'AS'   ; check for 'SAdT'
        jne     No_SATfile
        cmp     word ptr ds:[2], 'Td'
        jne     No_SATfile

; Setup screen 

        mov     ax, 0003h
        int     10h

        mov     ah, 1
        mov     ch, 32
        xor     cl, cl
        int     10h                     ; del cursor

        mov     ax, cs
        mov     ds, ax
        mov     ax, 0B800h
        mov     es, ax
        mov     si, offset EQU_Screen
        xor     di, di
        mov     cx, 2000
        rep     movsw                   ; copy screen

; Draw FileName 

        mov     ah, 51h                 ; Get current process ID (PSP address)
        int     21h
        mov     ds, bx
        mov     si, 82h
        mov     di, 2*18*80+9*2
        mov     ax, 0b800h
        mov     es, ax

        mov     cx, 20
Copy_SongName:
        lodsb
        cmp     al, 0
        je      Copy_SongName_Done
        stosb
        inc     di
        loop    Copy_SongName
Copy_SongName_Done:

        mov     ax, seg _MusicSeg
        mov     es, ax

        mov     di, 2*18*80+62*2
        mov     dl, byte ptr es:[44Bh]
        Call    WriteHEX                ; Write Songlen

; Start playing 

        mov     bx, 0
        Call    SAT_Player              ; Check for FM chip
        jc      No_FMchip

        mov     bx, 1
        Call    SAT_Player              ; Reset FM chip

        mov     ax, seg _MusicSeg
        mov     es, ax
        mov     bx, 2                   ; use TIMER mode
        mov     al, 0
        Call    SAT_Player              ; Init player

        mov     bx, 3
        call    SAT_Player              ; Start playing

BigLoop:

; Draw equalizer 

        mov     ax, seg SAT_Equalizer
        mov     ds, ax
        mov     si, offset SAT_Equalizer; seg:offset of Equalizer data

        mov     ax, 0b800h              ; seg of screen
        mov     es, ax
        mov     cx, 36                  ; 36 bars
        mov     bp, 16*80*2+4*2
EQ_loop:
        push    cx
        lodsb                           ; load equ data

        mov     di, BP                  ; get screen pointer
        mov     cx, 16                  ; bars are 16 chars high
        xor     ah, ah
EQ_Loop1:
        mov     bl, 219                 ; ''
        cmp     al, ah
        ja      Dont_Write_block
        mov     bl, 0
dont_write_block:
        mov     byte ptr es:[di], bl
        mov     byte ptr es:[di+2], bl
        sub     di, 80*2
        add     ah, 4
        loop    EQ_Loop1
        add     bp, 2*2
        pop     cx
        loop    EQ_Loop                 ; Do all 36 bars

; Draw SongPosition 

        mov     di, 2*18*80+59*2
        mov     ax, seg SAT_SongPos
        mov     es, ax
        mov     dl, byte ptr es:[offset SAT_SongPos]
        Call    WriteHEX

; Draw current Row 

        mov     di, 2*18*80+72*2
        mov     ax, seg SAT_PatternPos
        mov     es, ax
        mov     ax, es:[offset SAT_PatternPos]
        mov     cl, 9*5
        div     cl
        mov     dl, al
        Call    WriteHEX

;        mov     bx, 4                  ; uncomment this if you are using
;        call    SAT_player             ; polling mode

        in      al, 60h
        cmp     al, 1
        jne     BigLoop

        mov     bx, 5
        call    SAT_Player              ; stop player

; Restore screen and display end message 

        mov     ax, 0003h
        int     10h

        mov     ax, cs
        mov     ds, ax
        mov     dx, offset EndMessage
        mov     ah, 9
        int     21h

        mov     ax, 4c00h
        int     21h                     ; Get out of here!

;
; Write number DL to screen position DI 
;

WriteHEX:
        mov     ax, 0b800h
        mov     es, ax

        mov     al, dl
        shr     al, 4
        add     al, '0'                 ;
        cmp     al, ':'                 ;
        jb      No_char1                ;
        add     al, 'A'-':'             ; convert to hex
No_Char1:                               ;
        stosb
        mov     al, dl
        and     al, 15
        add     al, '0'                 ;
        cmp     al, ':'                 ;
        jb      No_Char2                ;
        add     al, 'A'-':'             ; convert to hex
No_Char2:                               ;
        inc     di
        stosb
        ret

FileError:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset FileErrorMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

No_CommandLine:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset NoCommLineMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

No_SATfile:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset NoSATfileMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

No_FMchip:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset NoFMchipMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

Include  equ.inc

_Code   ends
_MusicSeg segment para public 'Data'
        db      65500 dup (?)
_MusicSeg ends
_Stack  segment para stack 'stack'
        db      512 dup (?)
_Stack  ends

End     ProgStart
