;****************************************************************************
;*	Module contenant des fonctions DOS de base pour rserver de la
;*	RAM, ATTENTION toutes ces fonctions sont de type NEAR
;*
;* Programm par Sbastien Granjoux
;* Commenc le 20/12/94
;* Modification le 02/01/95

IDEAL
P386N

PUBLIC	UNLOADMOD

INCLUDE "CRYSLOAD.INC"
INCLUDE	"CRYSERR.INC"

SEGMENT CSEG PARA PUBLIC USE16 'CODE'

ASSUME	cs:CSEG

UsedFs	DW	0

;***************************************************************************
;*      Libre la mmoire prise par la fonction loadmod utilise en ds:di
;*      l'adresse des instruments et en ds:si l'adresse de la partition

PROC    Unloadmod FAR

	push	ds

	mov	ax,SEG PatternSeg
	mov	ds,ax
	mov     ax,[ds:PatternSeg]
	or	ax,ax
	je	@@not_alloc
	mov	es,ax
	call	freemem
@@not_alloc:

	mov	bx,OFFSET Instrument1
	mov	cl,MAX_INST
@@sample:
	mov     ax,[(INSTRUMENT PTR ds:bx).adrseg]
	or	ax,ax
	je      @@no_sample
	mov     es,ax
	call	freemem
@@no_sample:
	add 	bx,SIZE INSTRUMENT
	dec	cl
	jne	@@sample

	pop	ds

	ret

ENDP

;**************************************************************************
;*	ouvre un fichier suivant diffrent mode
;*
;* Entre:
;*	CS:BX	adresse du driver de fichier  utiliser
;*	DS:DX   paramtre pour le driver (gnralement nom du fichier)
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	open

	mov     [cs:UsedFs],bx
	mov	bx,[(FILESYS PTR cs:bx).open]
	jmp	bx
ENDP

;***************************************************************************
;*	lit des informations dans un fichier
;*
;* Entre:
;*	CX	nombre d'octet  lire
;*	DS:DX	pointeur sur le buffer
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	read

	mov	bx,[cs:UsedFs]
	mov	bx,[(FILESYS PTR cs:bx).read]
	jmp	bx

ENDP

;***************************************************************************
;*	se dplace dans un fichier par rapport  la position courante
;*
;* Entre:
;*	CX:DX   dplacement dans le fichier
;*
;* Sortie:
;*	AX	erreur si C=1


PROC	seek

	mov	bx,[cs:UsedFs]
	mov	bx,[(FILESYS PTR cs:bx).seek]
	jmp	bx

ENDP

;***************************************************************************
;*	Ferme un fichier
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	close

	mov	bx,[cs:UsedFs]
	mov	bx,[(FILESYS PTR cs:bx).close]
	jmp	bx

ENDP


;***************************************************************************
;*	Reserve de la mmoire
;*
;* Entre:
;*	BX	nombre de paragraphe  rserver
;*
;* Sortie:
;*	AX	erreur si C=1
;*	AX	adresse de segment de la zone rserv

PROC	allocmem

	mov	ah,48h
	int		21h
	ret
ENDP

;***************************************************************************
;*	Rend un bloc mmoire au systme
;*
;* Entre:
;*	ES	adresse de segment du bloc  rendre
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	freemem

	mov	ah,49h
	int	21h
	ret

ENDP

;**************************************************************************
;*	Recupre l'adresse du bloc d'environnement
;*
;* Sortie
;*	AX	adresse du bloc d'environnement

PROC	getenvadr FAR

	mov	ah,62h
	int	21h
	mov	es,bx
	mov	ax,[es:2Ch]
	ret

ENDP

ENDS
END