;*************************************************************************
;*	Quelques routines graphiques pour travailler en mode texte  80*25
;*	 en 16 couleurs
;* Programm par Sbastien Granjoux
;* Commenc le 26/12/93
;* Dernire modification le 26/12/93

IDEAL

P386N
MODEL	SMALL

PUBLIC	SetMode3
PUBLIC	ResetMode
PUBLIC	SetPage
PUBLIC	PutCpkBlk
PUBLIC	PutText
PUBLIC	PutVu

VIDEO_MOD	EQU	3
LEN_LINE	EQU	160
NB_LINE		EQU	25
VIDEO_SEG	EQU	0b800h
CRT_INDEX	EQU	3D4h
GREEN		EQU	10
YELLOW		EQU	14
GRAY		EQU	8
RED		EQU	12

PAGE0		EQU	0

DATASEG

OldMode	DB ?

CODESEG

;*************************************************************************
;*	Initialise le mode texte 3
;*
;* Sortie:
;*	ES	segment de la RAM video

PROC    SetMode3

	mov     ah,0fh          ; sauve l'ancien mode
	int     10h
	mov     [ds:OldMode],al

	mov     ax,VIDEO_MOD	; passe en mode 3
	int     10h

	mov	ax,VIDEO_SEG
	mov	es,ax

	mov	dx,CRT_INDEX	; efface le curseur
	mov	ax,1f0ah
	out	dx,ax

	ret

ENDP

;***************************************************************************
;*      Reprend le mode d'avant le dernier setmode

PROC    ResetMode

	movzx   ax,[byte ptr ds:OFFSET OldMode]
	int     10h

	ret

ENDP

;*************************************************************************
;*	Change de page ecran
;*
;* Entre:
;*	BX	adresse de la nouvelle page ecran
;*
;* Sortie:
;*	ES	segment de la nouvelle page

PROC	SetPage

	mov	dx,CRT_INDEX	; Change l'adresse de la RAM video
	mov	ah,bl
	mov	al,0Dh
	out	dx,ax
	mov	ah,bh
	dec	al
	out	dx,ax

	shr	bx,4
	add	bx,VIDEO_SEG
	mov	es,bx

	ret
ENDP

;*************************************************************************
;*	Affiche une image a l'ecran contenant des codes de controles
;*	La routine reconnait les code de controle suivant:
;*	00	fin de l'image
;*	01-08	nouvelle couleur du fond +1
;*	09	bascule du clignotement
;*	10	nouvelle ligne
;*	11 N	affiche N espace
;*	12 N X  affiche N caractre X
;*	16-31	nouvelle couleur des caractres + 16
;*
;*
;* Entre:
;*	DL	X de l'image
;*	DH	Y de l'image
;*	ES	segment de l'image a l'ecran
;*	DS:SI	position de l'image en mmoire

PROC	PutCpkBlk

	mov	di,dx
	shr	di,8
	lea	di,[edi*4+edi]
	shl	di,4
	and	dx,00ffh
	add	di,dx
	add	di,di

	xor	ch,ch
	mov	ah,7
	mov	dx,di
@@next_car:
	lodsb
	cmp	al,31
	jbe	@@control
	stosw
	jmp	@@next_car

@@control:
	dec	al
	js	@@exit

	cmp	al,8
	ja	@@no_back
	je	@@blink

	shl	al,4
	and	ah,8Fh
	or	ah,al
	jmp	@@next_car

@@blink:
	xor	ah,80h
	jmp	@@next_car

@@no_back:
	sub	al,15
	jb	@@no_fore

	and	ah,0F0h
	or	ah,al
	jmp	@@next_car

@@no_fore:
	cmp	al,-5
	jb	@@new_line

	lodsb
	mov	cl,al
	mov	al,' '
	je	@@tabulation
	lodsb
@@tabulation:

	rep	stosw
	jmp	@@next_car

@@new_line:
	add	dx,LEN_LINE
	mov	di,dx
	jmp	@@next_car

@@exit:
	ret

ENDP

;*************************************************************************
;*	Affiche  l'cran une chaine de caractre sans modifier l'attribut
;*	de l'ecran
;*
;* Entre:
;*	CL	longeur de la chaine
;*	DL	position en X de la chaine  l'ecran
;*	DH	position en Y de la chaine  l'ecran
;*	DS:SI	adresse de la chaine
;*	ES	segment video de la mmoire cran


PROC	PutText

	mov	di,dx
	shr	di,8
	lea	di,[edi*4+edi]
	shl	di,4
	and	dx,00ffh
	add	di,dx
	add	di,di

@@next_char:
	movsb
	inc	di
	dec	cl
	jne	@@next_char

	ret

ENDP

;*************************************************************************
;*	Affiche une barre en jouant uniquement sur les attributs
;*	La barre en verte (10) puis jaune (4) puis rouge (2) sinon gris
;*
;* Entre:
;*	CL	longeur de la barre
;*	CH	longeur totale de la barre
;*	DL	position en X de la barre  l'ecran
;*	DH	position en Y de la barre  l'ecran

PROC	PutVu

	mov	di,dx
	shr	di,8
	lea	di,[edi*4+edi]
	shl	di,4
	and	dx,00ffh
	add	di,dx
	add	di,di
	inc	di

	or	cl,cl
	je	@@gray_part
	mov	ah,ch
	shr	ah,1
@@green_part:
	mov	al,GREEN
@@next_green:
	stosb
	inc	di
	dec	cl
	je	@@gray_part
	dec	ch
	cmp	ch,ah
	jne	@@next_green

	mov	al,YELLOW
	shr	ah,1
@@next_yellow:
	stosb
	inc	di
	dec	cl
	je	@@gray_part
	dec	ch
	cmp	ch,ah
	jne	@@next_yellow

	mov	al,RED
@@next_red:
	stosb
	inc	di
	dec	cl
	je	@@gray_part
	dec	ch
	jne	@@next_red

	ret

@@gray_part:
	mov	al,GRAY
@@next_gray:
	stosb
	inc	di
	dec	ch
	jne	@@next_gray
	ret

ENDP

END