(******************************************************************************
File: 		 mem.pas
Version:	 2.22
Tab stops: every 2 columns
Project:   any STK related code
Copyright: 1994-1995 DiamondWare, Ltd.	All rights reserved. *
Written:	 Erik Lorenzen
DPMI Ver:  Tom Repstad
Purpose:   Contains a routine to handle any error generated by the STK
History:	 95/10/18 EL Started
					 95/10/25 EL Finalized for 2.20
					 95/12/07 EL Finalized for 2.21, no changes
					 96/10/10 EL Finalized for 2.22, no changes

Notes
-----
*Permission is expressely granted to use this unit or any derivitive made
 from it to registered users of the STK.
******************************************************************************)


unit mem;


interface


{$IFDEF DPMI}
	uses crt, dws, winapi;
{$ELSE}
	uses crt, dws;
{$ENDIF}


procedure mem_GetDOS(var p : dws_ADDRESS; size : word);

procedure mem_FreeDOS(var p : dws_ADDRESS; size : word);


implementation


(*
 . Please note that pointers in real mode and protected mode are different.
 .
 . In pmode the STK needs the pmode selector and the rmode segment and the
 . offset.	This information will be encapsulted in the dws_ADDRESS struct.
*)

(*
 .		dws_ADDRESS = record
 .			ptr 	: pointer;
 .			rmseg : longint;
 .		end;
 .
 . If a variable is declared
 .		var sound : dws_ADDRESS;
 .
 . It could be accessed like:
 .		1) blockread(fp, sound.ptr^, soundsize);
 .		2) blockread(fp, pointer(@sound)^, soundsize);
*)

procedure mem_GetDOS(var p : dws_ADDRESS; size : word);
{$IFDEF DPMI}
var
	tmp : longint;
{$ENDIF}

begin
	{$IFDEF DPMI}
		(*
		 . GlobalDosAlloc returns a longint.	The high word is the
		 . real mode segment.  The low word is the protected mode
		 . selector.	The STK needs both of these values.
		*)
		tmp := GlobalDosAlloc(size);

		if tmp = 0 then
		begin
			writeln('Memory Allocation Failure');
			exit;
		end;

		p.ptr 	:= Ptr(word(tmp), 0); {Always starts at an offset of 0}
		p.rmseg := word(tmp SHR 16);
	{$ELSE}
		getmem(p, size);
	{$ENDIF}
end;


procedure mem_FreeDOS(var p : dws_ADDRESS; size : word);
begin
	{$IFDEF DPMI}
		if GlobalDosFree(longint(p.ptr) SHR 16) <> 0 then
		begin
			writeln('Memory De-Allocation Failure');
			exit;
		end;
	{$ELSE}
		freemem(p, size);
	{$ENDIF}
end;

end.
