{ fmtest.pas }
{ FMSOUND Copyright 1997 by Ethan Brodsky.  All rights reserved. }

program FMtest;
  uses
    CRT,
    FM;

const
  min  = 1;     {Hz}
  max  = 20000;
  step = 1;
  del  = 0;     {ms}

var
  i: integer;
begin
  if not(fm_detect)
    then
      begin
        writeln('ERROR: FM not detected');
        exit;
      end
    else
      writeln('ERROR: FM detected');

  fm_reset;

  fm_load_patch(0, fm_get_patch_sine);

  for i := (min div step) to (max div step) do
    begin
      fm_play_tone(0, step*i, 63);

      writeln(step*i);

      Delay(del);

      if (KeyPressed)
        then
          begin
            ReadKey;
            break;
          end;
    end;

  fm_stop_tone(0);

end.
