{$M 32000,0,650000}
{$A+,B-,D+,F-,G+,I-,L-,O-,R-,S-,V-,X+}

{-----------------------------------------------------------------------}
{                                                                       }
{                           LongPlay V1.00                              }
{                    Copyright (c) 1994 Huseyin Nakturk                 }
{                                                                       }
{      Please DO NOT modify anything unless it is a bug or you ar       }
{                       adding some of missing features [see DOC]       }
{                                                                       }
{ Finished   : February 1994                                            }
{ Last Touch : June 1994                                                }
{-----------------------------------------------------------------------}

Program LongPlay;

Uses MyCrt,
     Dos,
     GraphV,
{
     Time,
}
     Rexx,
     CPUInfo;

{ --------------------------------------------------------------------------}

Const

     { Sort types }
     _toname            = 0;
     _tosize            = 1;
     _toext             = 2;

     { Known cpu types }
     cputype            : Array[1..4] of String[10] = ( '8088/8086',
                                                        '80286',
                                                        '80386',
                                                        '80486');
     BLANKBYTE          = $80;
     MAXRATE            = 48000;
     MINRATE            = 4000;
     _FADEIN            = 0;
     _FADEOUT           = 1;
     _SELECTED          = 1;
     _NOTSELECTED       = 0;

     _BLOCK             = 0;
     _WHOLE             = 1;
     _CANCEL            = 2;
     _OK                = 3;

     DefaultName        = '        ';
     DefaultTwin        =  True;
     DefaultFadeSPer    =   100;
     DefaultFadeFPer    =     0;

     MagicNum           = 1193180 div 256;

     _file              =     0;          { Type of FilePos }
     _dir               =     1;          { Type of FilePos }
     _drive             =     2;          { Type of FilePos }

     BUTTON             =     0;          { Type of ButtonTree }
     WINDOW             =     1;          { Type of ButtonTree }
     NoNo               =    -1;

     KB                 =  1024;
     MB                 = KB*KB;
     _16KB              = 16*KB;
     _32KB              = 32*KB;
     _64KB              = $FFFF;

     Version            ='1.00';
     RegisteredTo       ='* UNREGISTERED *';
     MaxFile            =   512;              { Maximum Number of files expected    }
     MaxLevel           =     2;              { Maximum Tree Level                  }
     MaxProc            =     4;              { Maximum Number of Procedures        }
     MaxScr             =     4;              { Maximum Number of preserved screens }
     MaxVGAMode         =     6;              { Maximum Number of SVGA Modes        }
     MaxSample          =    35;              { Maximum Number of Samples to handle }
     MaxButton          = 45+MaxSample;       { Maximum number of Pressable Buttons }
     MaxDevice          =     3;              { Maximum number of supported devices }
     MaxBmp             =    17;              { Maximum number of bitmaps }
     _magic             =  4660;              { 1193180 / 256                       }
     SIZE_X             =    11;              { Mouse Width                         }
     SIZE_Y             =    18;              { Mouse Height                        }
     CharW              =     8;              { Char Width                          }
     CharH              =     8;              { Char Height                         }
     Black              =     0;
     Red                =    32;
     Green              =    64;
     Blue               =    96;
     Yellow             =   128;
     Turquise           =   160;
     Gray               =   192;
     Rest               =   224;
     SVGA640x480x256	=   $101;	(* 640x480x256   Svga *)
     SVGA800x600x256	=   $103;	(* 800x600x256   Svga *)
     SVGA1024x768x256	=   $105;	(* 1024x768x256  Svga *)
     boxcolor           = Black;
     osilocolor         = Green+31;
     midcolor           = Red+16;

{ --------------------------------------------------------------------------}

Type
    MASK = Array[0..SIZE_Y+4] of Word;

    PString = ^String;

    ProcType = Procedure;

    Tree = record
         Xmin,
         Xmax,
         Ymin,
         Ymax     : Word;
         Text     : String[20];
         Fit,
         TextColor,
         BoxColor : Word;
         Pressed  : Boolean;
         Proc     : ProcType;
         No       : Integer;
         typ      : Byte;
    End;

    TreeArray = Array[0..MaxButton,0..MaxLevel] of TREE;

    Location = record
             x : word;
             y : word;
             Size : Longint;
    End;

    ModeInfo = record
             Available : Boolean;
             Name      : String[30];
             Proc      : ProcType;
    End;

    SampleType = record
             Name      : String[8];
             Rate      : Word;
             BlockStart: LongInt;
             BlockEnd  : LongInt;
             Pos       : Longint;
             Start     : LongInt;
             Length    : LongInt;
             Volume    : Byte;
             Twin      : Boolean;
             Active    : Boolean;
             Signed    : Boolean;
             EMSHandle : Word;
             Zoomed    : Boolean;
             Cntr      : Byte;
    End;

    DeviceType = record
             Name      : String[16];
             Handler   : ProcType;
             Proc      : ProcType;
             Available : Boolean;
             Ext1      : Word;
             Ext2      : Word;
             Ext3      : Word;
             Ext4      : Word;
    End;

    FileInfoType = record
                 Name : String[12];
                 typ  : Byte;
                 Size : LongInt;
                 Status : Byte;
    End;

    FileTreeType = Array[0..MaxFile] of FileInfoType;

    PosType      = record
                 name : String[13];
                 typ  : Byte;
                 MainNo : Word;
    End;

    BmpType      = record
                 w,
                 h      :Word;
                 Buffer :Pointer;
                 Found  :Boolean;
    End;

{ --------------------------------------------------------------------------}

Var
   IsMC              : Boolean; { Micro Channel }
   LPPath,
   TempPath,
   SndPath           : String;
   OldVideoMode      : Byte;
   InFile            : File;
   IsItAU            : Boolean;
   MixPercent        : Word;
   MixSample1,
   MixSample2        : Byte;
   MaxEchoDelay      : LongInt;
   EchoDelay         : LongInt;
   EchoPercent       : Word;
   FadeStartPercent,
   FadeFinishPercent : Word;
   osiloorgx,
   osiloorgy,
   osilox,
   osiloy        :Word;
   Cntr1,
   Cntr2,
   Cntr3,
   StatusBoxActive,
   ShowOsilo     :Boolean;
   Opened        :Boolean;
   rc            :Word;
   CorrecFactor  :Real;
   Palette       :Array[0..255] of Array[0..2] of Byte;
   Handler       :Word;
   _isend        :Byte;
   _smpoff       :Word;
   _emsbase      :Word;
   _emsupage     :Word;
   _emshandle    :Word;
   _cntr         :Byte;
   _maxcntr      :Byte;
   _smplenlo     :Word;
   _smplenhi     :Word;
   _signed       :Byte;
   _amplify      :Byte;
   _twin         :Byte;
   _old8o        :Word;
   _old8s        :Word;
   _old9o        :Word;
   _old9s        :Word;
   _old21        :Byte;
   _baserate     :Byte;
   _samplerate   :Byte;
   _osilooff     :Word;
   _osilowidth   :Word;
   _osilolen     :Word;
   MAXX          :Word;
   MAXY          :Word;
   HALFMAXX      :Word;
   HALFMAXY      :Word;
   DummyPtr      :Integer;
   DummyWord     :Word;
   DummyByte,
   DummyByte2    :Byte;
   Under         :^Byte;
   ANDMASK       :^MASK;
   XORMASK       :^MASK;
   ButtonTree    :^TreeArray;
   Playing,
   Stoped,
   Paused        :Boolean;
   TreePtr       :Array[0..MaxLevel] of Byte;
   TreeLevel     :Byte;
   ProgEnded     :Boolean;
   MainProc      :Array[0..MaxProc] of ProcType;
   SecondProc    :ProcType;
   BlockSelected,
   WholeSelected,
   Canceled      :Boolean;
   Okay          :Boolean;
   ProcNo        :Byte;
   Activebutton  :Array[0..MaxProc] of Byte;
   ScrPtr        :Array[0..MaxScr] of Pointer;
   LocScr        :Array[0..MaxScr] of Location;
   ScrNo         :Byte;
   SrchByte      :Byte;
   MaxCX         :Word;
   MouseActive   :Boolean;
   V640,
   V800,
   V1024         :Boolean;
   ButtonPos     :Boolean;
   GraphDriver,
   GraphMode     :Integer;
   FreeEMS       :Word;
   VGAMode       :Array[0..MaxVGAMode] of ModeInfo;
   GlobalNo      :Integer;
   SampleInfo    :Array[1..MaxSample] of SampleType;
   DeviceInfo    :Array[1..MaxDevice] of DeviceType;
   Device        :Byte;
   ActiveSample  :Byte;
   LPT1,
   LPT2          :Word;
   SampleLen,
   Position,
   BlockStart,
   BlockEnd      :LongInt;
   Rate          :Word;
   Volume        :Byte;
   Twin          :Boolean;
   IncVal        :Word;
   Inc1,
   Inc10,
   Inc100,
   Inc1000       :Boolean;
   DriveAvailable:Array[0..25] of Boolean;
   EnterancePath,
   LoadFile,
   DefaultPath,
   CurrentPath   :String;
   lx1,lx2,
   ly1,ly2       :Word;
   MaxFptr,
   Fptr          :Word;
   FileTree      :^FileTreeType;
   FilePattern   :String[12];
   CallProc      :ProcType;
   FilePosition  :Array[0..17] of PosType;
   OldProcNo     :Byte;
   EMSBase       :Word;
   SampleBase    :Byte;
   FileBuffer    :Pointer;
   OldMouseXCor,
   OldMouseYCor  :Word;
   Zoomed        :Boolean;
   Signed        :Boolean;
   LastPage      :Word;
   DeviceButton  :Byte;
   EMSfit        :Boolean;
   OldSelected   :Word;
   CmpDate,
   CmpTime       :Pstring;
   VolPercent    :Word;
   SaveFile      :String[12];
   BmpArray      :Array[0..MaxBmp] of BmpType;
   BackBmp       :Byte;
   DefaultCntr   :Byte;
   DefaultRate   :Word;
   DefaultVolume :Byte;

{ --------------------------------------------------------------------------}


Procedure Ulawtable;External;
{$L ulawtbl.obj }

Procedure ConvertUlaw(USeg,UOfs,ULen:Word);Assembler;
Asm
   push es
   mov es,useg
   mov di,uofs
   mov cx,ulen
   push ds
   push cs
   pop  ds
@@convert:
   mov  bh,0
   mov  bl,es:[di]
   add  bx,bx
   mov  ax,cs:[offset ulawtable+bx]
   shr  ax,8
   add  al,080h
   mov  es:[di],al
   inc  di
   loop @@convert
   pop  ds
   pop  es
End;

{
Procedure RawPlay(RawData:Pointer;Len,RawRate:Word;Vol:Byte;Cntr:Byte);Forward;
}

Procedure Kernel           ;Forward;
Procedure ShowPos          ;Forward;
Procedure ShowSampleInfo   ;Forward;
Procedure SetSampleInfo    ;Forward;
Procedure ScreenInitialize ;Forward;
{$i mouse.inc   }
{$i general.inc }
{$i scr.inc     }
{$i music.inc   }

Procedure SetSampleInfo;
Begin
     if ActiveSample > 0 then
     Begin
          Rate       := SampleInfo[ActiveSample].Rate;
          Twin       := SampleInfo[ActiveSample].Twin;
          _maxCntr   := SampleInfo[ActiveSample].Cntr;
          cntr1 := False;
          cntr2 := False;
          cntr3 := False;
          Case _maxcntr of
               1 : Cntr1 := True;
               2 : Cntr2 := True;
               3 : Cntr3 := True;
          End;
          Volume     := SampleInfo[ActiveSample].Volume;
          SampleLen  := SampleInfo[ActiveSample].Length;
          BlockStart := SampleInfo[ActiveSample].BlockStart;
          BlockEnd   := SampleInfo[ActiveSample].BlockEnd;
          Position   := SampleInfo[ActiveSample].Pos;
          Zoomed     := SampleInfo[ActiveSample].Zoomed;
          Signed     := SampleInfo[ActiveSample].Signed;
          if Signed then _signed := 1 else _signed := 0;
     End;
     ShowSampleInfo;
End;

Procedure TreeClear;
Begin
     For DummyByte := 0 to MaxLevel do
         TreePtr[TreeLevel] := 0;
End;

Procedure BlockShow;
Var
   Y    :Word;
Begin
     Y := MAXY-256-CharH*6;
     BoxPrint(2*CharW      ,Y,S(BlockStart,8,TRUE),8,Black+31,Gray,True);
     BoxPrint(MAXX-CharW*11,Y,S(BlockEnd,8,TRUE)  ,8,Black+31,Gray,True);
End;


{ Buffer must be <= 16K }
Procedure BlockPeek(Handle,Page,Offs,Len:Word;Buffer:Pointer);
Var
   BS,
   BO    : Word;
Begin
     BS := Seg(Buffer^);
     BO := Ofs(Buffer^);

     Asm
        push es                                 { Preserver ES }
        cld                                     { Clear Direction flag }
        mov  cx,len                             { cx = len }
        dec  page                               { page-- }
@@loop:
        inc page                                { page++ }
        push cx
        mov len,cx
        mov ah,44h
        mov al,00h
        mov bx,page
        mov dx,handle
        int 67h
        mov si,Offs
        mov cx,Len
        cmp cx,4000h
        jb @@goon
        mov cx,4000h
@@goon:
        mov ax,4000h
        sub ax,si
        cmp cx,ax
        jbe @@nochange
        mov cx,ax
@@nochange:
        push cx
        push ds
        mov  di,BO
        mov  es,BS
        mov  ds,EMSBASE
        shr  cx,1
        rep  movsw
        adc  cx,cx
        rep  movsb
        mov  BO,di
        pop  ds
        pop  dx
        mov Offs,0
        pop cx
        sub cx,dx
        jnz @@loop
@@quit:
        pop es
     End;
End;

{ Buffer must be <= 16K }
Procedure BlockPoke(Handle,Page,Offs,Len:Word;Buffer:Pointer);
Var
   BS,
   BO    : Word;
Begin
     BS := Seg(Buffer^);
     BO := Ofs(Buffer^);
     Asm
        push es
        cld
        mov  cx,len
        dec  page
@@loop:
        inc page
        push cx
        mov len,cx
        mov ah,44h
        mov al,00h
        mov bx,page
        mov dx,handle
        int 67h
        mov di,Offs
        mov cx,Len
        cmp cx,4000h
        jb @@goon
        mov cx,04000h
@@goon:
        mov ax,4000h
        sub ax,di
        cmp cx,ax
        jbe @@nochange
        mov cx,ax
@@nochange:
        push cx
        push ds
        mov  si,BO
        mov  es,EMSBASE
        mov  ds,BS
        shr  cx,1
        rep  movsw
        adc  cx,cx
        rep  movsb
        mov  BO,si
        pop  ds
        pop  dx
        mov Offs,0
        pop cx
        sub cx,dx
        jnz @@loop
@@quit:
        pop es
     End;
End;

{ Buffer must be <= 16K }
Procedure BlockReverse(Len:Word;Buffer:Pointer);
Var
   BS,
   BO   :Word;
Begin
     BS := Seg(Buffer^);
     BO := Ofs(Buffer^);
     Asm
        push ds
        push es
        mov  es,BS
        mov  di,BO
        mov  si,BO
        add  si,len
        dec  si
        mov  cx,len
        shr  cx,1
        mov  ds,BS
@@loop:
        mov  bl,es:[di]
        mov  al,ds:[si]
        mov  es:[di],al
        mov  ds:[si],bl
        inc  di
        dec  si
        loop @@loop
        pop  es
        pop  ds
     End;
End;

Procedure BlockMix(Len:Word;Buf1,Buf2:Pointer;signed1,signed2:Boolean;MixPercent:Word);
Var
   BS1,
   BS2,
   BO1,
   BO2  : Word;
   _signed1,
   _signed2     :Byte;
Begin
     BS1 := Seg(Buf1^);
     BO1 := Ofs(Buf1^);
     BS2 := Seg(Buf2^);
     BO2 := Ofs(Buf2^);
     MixPercent := Round(MixPercent*2.56);
     Asm
        cli
        push ds
        push es
        mov  cx,Len
        mov  bx,MixPercent
        mov  si,BO2
        mov  di,BO1
        mov  es,BS1 { es:di = buffer1 ds:si = buffer 2 }
        mov  ds,BS2
@@loop1:
        mov  ah,0
        mov  al,es:[di]
        cmp  signed1,true
        jnz  @@notsigned1
        add  al,080h
@@notsigned1:
        cmp  al,080h
        jb   @@smaler1
        jz   @@done
@@bigger:
        sub  al,080h
        mul  bx
        cmp  dx,0
        jz   @@noff1
        mov  ax,0ffffh
@@noff1:
        shr  ax,8
        cmp  al,080h
        jb   @@nocor1
        mov  al,07fh
@@nocor1:
        add  al,080h
        jmp  @@done
@@smaler1:
        mov  dh,080h
        sub  dh,al
        mov  al,dh
        mul  bx
        cmp  dx,0
        jz   @@noff2
        mov  ax,0ffffh
@@noff2:
        shr  ax,8
        cmp  al,080h
        jb   @@nocor2
        mov  al,07fh
@@nocor2:
        mov  dh,080h
        sub  dh,al
        mov  al,dh
@@done:
        mov  ah,ds:[si]
        cmp  signed2,true
        jnz  @@notsigned2
        add  ah,080h
@@notsigned2:
        add  ah,al
        sub  ah,080h
        cmp  signed1,true
        jnz  @@signed3
        add  ah,080h
@@signed3:
        mov  es:[di],ah
        inc  si
        inc  di
        loop @@loop1
        pop  es
        pop  ds
        sti
     End;
End;

Procedure BlockVolumeSet(Len:Word;Buffer:Pointer;Percent:Word);
Var
   BS,
   BO   :Word;
Begin
     BS := Seg(Buffer^);
     BO := Ofs(Buffer^);
     Percent := Round(Percent * 2.56);
     Asm
        push es
        mov  cx,Len
        mov  bx,percent
        mov  es,BS
        mov  di,BO
@@loop:
        mov  ah,0
        mov  al,es:[di]
        cmp  _signed,true
        jnz  @@notsigned
        add  al,080h
@@notsigned:
        cmp  al,080h
        jz   @@nothing
        jb   @@smaler
        sub  al,080h
        mul  bx
        shr  ax,8
        cmp  al,080h
        jb   @@nocor1
        mov  al,07fh
@@nocor1:
        add  al,080h
        jmp  @@nothing
@@smaler:
        mov  dh,080h
        sub  dh,al
        mov  al,dh
        mul  bx
        shr  ax,8
        cmp  al,080h
        jb   @@nocor2
        mov  al,07fh
@@nocor2:
        mov  dh,080h
        sub  dh,al
        mov  al,dh
@@nothing:
        cmp  _signed,true
        jnz  @@notsigned2
        sub  al,080h
@@notsigned2:
        mov  es:[di],al
        inc  di
        loop @@loop
        pop  es
     End;
End;

Procedure FillEMSPage(Handle,Page,Offs,Len:Word;FillWith:Byte);
Begin
     Asm
        push es
        mov  es,EMSBASE
        cld
        mov cx,Len
        dec page
@@loop:
        inc page
        push cx
        mov  len,cx
        mov ah,44h
        mov al,0
        mov bx,page
        mov dx,handle
        int 67h
        mov di,Offs
        mov cx,Len
        cmp cx,4000h
        jb @@goon
        mov cx,04000h
@@goon:
        mov ax,4000h
        sub ax,di
        cmp cx,ax
        jbe @@nochange
        mov cx,ax
@@nochange:
        mov al,FillWith
        push cx
        rep stosb
        pop  dx
        mov Offs,0
        pop cx
        cmp cx,04000h
        jbe @@quit
        sub cx,dx
        jmp @@loop
@@quit:
        Pop ES
     End;
End;

Procedure Poke(Addrr:LongInt;Value:Byte);Assembler;
Asm
   mov ax,[bp+6]
   mov dx,[bp+8]      { dx:ax = Addrr (LongInt) }
   push ax
   push dx                      { Save original Addrr }
   mov cx,14
@@div1:
   clc
   rcr dx,1
   rcr ax,1
   loop @@div1                  { dx:ax = page = dx:ax div 16KB }
   mov si,ax                    { si = page }
   mov cx,14
@@mul1:
   clc
   rcl ax,1
   rcl dx,1
   loop @@mul1                  { dx:ax = page * 16KB }
   mov bx,ax
   mov cx,dx
   pop dx
   pop ax
   sub dx,cx
   sub ax,bx                    { ax = offs }
   cmp si,lastpage
   jz  @@samepage
   push ax
   push dx
   mov  ah,44h
   mov  al,0
   mov  bx,si
   mov  dx,_emshandle
   int  67h
   pop  dx
   pop  ax
@@samepage:
   mov  es,EMSBase
   mov  di,ax
   mov  ax,[bp+4]
   mov  es:[di],al
End;

Function Peek(Addrr:LongInt):Byte;Assembler;
Asm
   mov ax,[bp+4]
   mov dx,[bp+6]      { dx:ax = Addrr (LongInt) }
   push ax
   push dx                      { Save original Addrr }
   mov cx,14
@@div1:
   clc
   rcr dx,1
   rcr ax,1
   loop @@div1                  { dx:ax = page = dx:ax div 16KB }
   mov si,ax                    { si = page }
   mov cx,14
@@mul1:
   clc
   rcl ax,1
   rcl dx,1
   loop @@mul1                  { dx:ax = page * 16KB }
   mov bx,ax
   mov cx,dx
   pop dx
   pop ax
   sub dx,cx
   sub ax,bx                    { ax = offs }
   cmp si,lastpage
   jz  @@samepage
   push ax
   push dx
   mov  ah,44h
   mov  al,0
   mov  bx,si
   mov  dx,_emshandle
   int  67h
   pop  dx
   pop  ax
@@samepage:
   mov  es,EMSBase
   mov  di,ax
   mov  al,es:[di]
End;

Function GetSampleByte(Addrr:LongInt):Integer;
Var
   y : Byte;
Begin
     _emshandle := SampleInfo[ActiveSample].EMSHandle;
     y := Peek(Addrr);
     Asm
        mov al,y
        mov bl,volume
        cmp signed,true
        jnz @@notsigned
        add al,080h
@@notsigned:
        cmp al,080h
        jb  @@smaler
        ja  @@bigger
        jmp @@quit
@@smaler:
        mov cl,al
        mov al,080h
        sub al,cl
        mul bl
        cmp al,07fh
        jbe @@smaler2
        mov al,07fh
@@smaler2:
        mov bl,al
        mov al,080h
        sub al,bl
        jmp @@quit
@@bigger:
        sub al,080h
        mul bl
        cmp al,07fh
        jbe @@smaler3
        mov al,07fh
@@smaler3:
        add al,080h
@@quit:
        mov y,al
     End;
     GetSampleByte := y;
End;

Procedure ShowPos;
Var
     Length : LongInt;
     Width  : Longint;
     Jumper : Real;
     X      : Word;
Begin
     if Zoomed then
        Length := BlockEnd - BlockStart
     else
        Length := SampleInfo[ActiveSample].Length;
     Width := MAXX-CharW*2;
     Jumper := Length / Width;
     if (Position - BlockStart) > 0 then
     Begin
        if Zoomed then
           X := Round((Position - BlockStart) / Jumper)
        else
           X := Round(Position / Jumper);
     End
     else
        X := 0;
     SetColor(Red+31);
     SetWriteMode(XORPUT);
     MoveTo(CharW+X,MAXY-256-CharW*3);
     LineRel(0,256);
     SetWriteMode(COPYPUT);
End;

Procedure ShowBlockStart;
Var
     Length : LongInt;
     Width  : Longint;
     Jumper : Real;
     X      : Word;
Begin
     if Zoomed then
     Begin
          SetColor(Blue+31);
          SetWriteMode(XORPUT);
          MoveTo(CharW,MAXY-256-CharW*3);
          LineRel(0,256);
          SetWriteMode(COPYPUT);
     End
     else
     Begin
          Length := SampleInfo[ActiveSample].Length;
          Width := MAXX-CharW*2;
          Jumper := Length / Width;
          if BlockStart > 0 then
             X := Trunc(BlockStart / Jumper)
          else
             X := 0;
          SetColor(Blue+31);
          SetWriteMode(XORPUT);
          MoveTo(CharW+X,MAXY-256-CharW*3);
          LineRel(0,256);
          SetWriteMode(COPYPUT);
     End;
End;


Procedure ShowBlockEnd;
Var
     Length : LongInt;
     Width  : Longint;
     Jumper : Real;
     X      : Word;
Begin
     if Zoomed then
     Begin
          SetColor(Blue+31);
          SetWriteMode(XORPUT);
          MoveTo(MAXX-CharW,MAXY-256-CharW*3);
          LineRel(0,256);
          SetWriteMode(COPYPUT);
     End
     else
     Begin
          Length := SampleInfo[ActiveSample].Length;
          Width := MAXX-CharW*2;
          Jumper := Length / Width;
          if BlockEnd > 0 then
             X := Trunc(BlockEnd / Jumper)
          else
             X := 0;
          SetColor(Blue+31);
          SetWriteMode(XORPUT);
          MoveTo(CharW+X,MAXY-256-CharW*3);
          LineRel(0,256);
          SetWriteMode(COPYPUT);
     End;
End;

Procedure Analyser;
Var
   OX,OY  : Word;
   Length : LongInt;
   Width  : LongInt;
   Jumper : Real;
   YOrg,
   X2     : Word;
   X      : LongInt;
   Y      : Integer;
   OldBussy : Byte;
Begin
     OldBussy := BussyState;
     Bussy;
     LastPage := $FFFF;
     SetFillStyle(SolidFill,Black);
     Bar(CharW,MAXY-256-CharH*3,MAXX-CharW,MAXY-CharH*3);
     SetColor(Red+31);
     MoveTo(CharW,Maxy-128-CharH*3);
     LineRel(MAXX-CharW*2,0);
     if (ActiveSample > 0) and (SampleInfo[ActiveSample].Length > 0) then
     Begin
          YOrg := MAXY-CharW*3;
          if Zoomed then
             Length := BlockEnd - BlockStart
          else
              Length := SampleInfo[ActiveSample].Length;
          Width  := MAXX-CharW*2;
          Jumper := Length / Width;
          SetColor(Green+24);
          X2  := CharW;
          MoveTo(X2,Yorg-GetSampleByte(0));
          For X := 1 to Width do
          Begin
               if Zoomed then
                   y := GetSampleByte(BlockStart+Trunc(X*Jumper))
               else
                   y := GetSampleByte(Trunc(X*Jumper));
               LineTo(X2,Yorg-Y);
               Inc(X2);
          End;
     End;
     ShowPos;
     ShowBlockStart;
     ShowBlockEnd;
     if OldBussy = 0 then
     NotBussy;
End;

{$F+}
Procedure ZoomSet;
Begin
     Bussy;
     if Zoomed then Zoomed := False else Zoomed := True;
     Analyser;
     SampleInfo[ActiveSample].Zoomed := Zoomed;
     ButtonPos := Zoomed;
     NotBussy;
End;

Procedure SignSet;
Begin
     Bussy;
     if Signed then Signed := False else Signed := True;
     if Signed then _signed := 1 else _signed := 0;
     Analyser;
     SampleInfo[ActiveSample].Signed := Signed;
     ButtonPos := Signed;
     NotBussy;
End;

Procedure IncSet;
Var
   OldVal : Word;
Begin
     Bussy;
     OldVal := IncVal;
     ButtonPos := True;
     Case GlobalNo of
          1 : Begin
                   IncVal :=    1;
                   Inc1   := True;
                   Inc10  := False;
                   Inc100 := False;
                   Inc1000:= False;
              End;

          2 : Begin
                   if IncVal = 10 then ButtonPos := True;
                   IncVal :=   10;
                   Inc1   := False;
                   Inc10  := True;
                   Inc100 := False;
                   Inc1000:= False;
              End;

          3 : Begin
                   IncVal :=  100;
                   Inc1   := False;
                   Inc10  := False;
                   Inc100 := True;
                   Inc1000:= False;
              End;
          4 : Begin
                   IncVal := 1000;
                   Inc1   := False;
                   Inc10  := False;
                   Inc100 := False;
                   Inc1000:= True;
              End;
     End;
     if OldVal <> IncVal then
     Begin
          Case OldVal of
                  1 : BoxPrint(MAXX-CharW*10,CharH*12,   '1',4,Black,Gray,False);
                 10 : BoxPrint(MAXX-CharW*5 ,CharH*12,  '10',4,Black,Gray,False);
                100 : BoxPrint(MAXX-CharW*10,CharH*14, '100',4,Black,Gray,False);
               1000 : BoxPrint(MAXX-CharW*5 ,CharH*14,'1000',4,Black,Gray,False);
          End;
     End;
     NotBussy;
End;

Procedure Rateup;
Var
   LeftPressed : Boolean;
Begin
     Bussy;
     PushMouse;
     if Rate > (65535-IncVal) then
        Rate := IncVal - 1
     else
        Rate := Rate + IncVal;
     if Rate > MAXRATE then Rate := MINRATE;
     vrestoremouse;
     BoxPrint(33*CharW,MAXY-256-CharH*6,S(Rate,5,TRUE),6,Black+31,Gray,True);
     vputmouse;
     VertWait;
     Delay(100);
     LeftPressed := LeftButton;
     While LeftPressed do
     Begin
          if Rate > (65535-IncVal) then
              Rate := IncVal - 1
          else
              Rate := Rate + IncVal;
          vrestoremouse;
          BoxPrint(33*CharW,MAXY-256-CharH*6,S(Rate,5,TRUE),6,Black+31,Gray,True);
          vputmouse;
          VertWait;
          LeftPressed := LeftButton;
     End;
     if ActiveSample > 0 then
        SampleInfo[ActiveSample].Rate := Rate;
     vrestoremouse;
     PopMouse;
     ButtonPos := False;
     NotBussy;
End;

Procedure RateDown;
Var
   LeftPressed : Boolean;
Begin
     Bussy;
     PushMouse;
     if Rate < IncVal then
        Rate := 65536 - IncVal + Rate
     else
        Rate := Rate - IncVal;
     if Rate < MINRATE then Rate := MAXRATE;
     vrestoremouse;
     BoxPrint(33*CharW,MAXY-256-CharH*6,S(Rate,5,TRUE),6,Black+31,Gray,True);
     vputmouse;
     VertWait;
     Delay(100);
     LeftPressed := LeftButton;
     While LeftPressed do
     Begin
          if Rate < IncVal then
              Rate := 65536 - IncVal + Rate
          else
              Rate := Rate - IncVal;
          vrestoremouse;
          BoxPrint(33*CharW,MAXY-256-CharH*6,S(Rate,5,TRUE),6,Black+31,Gray,True);
          vputmouse;
          VertWait;
          LeftPressed := LeftButton;
     End;
     if ActiveSample > 0 then
        SampleInfo[ActiveSample].Rate := Rate;
     vrestoremouse;
     PopMouse;
     ButtonPos := False;
     NotBussy;
End;

Procedure Volumeup;
Var
   OldVolume : Byte;
   LeftPressed : Boolean;
Begin
     Bussy;
     OldVolume := Volume;
     PushMouse;
     Begin
          Inc(Volume);
          vrestoremouse;
          BoxPrint(44*CharW,MAXY-256-CharH*6,S(Volume,3,TRUE),4,Black+31,Gray,True);
          vputmouse;
          VertWait;
          Delay(100);
          LeftPressed := LeftButton;
          While LeftPressed do
          Begin
               Inc(Volume);
               VertWait;
               vrestoremouse;
               BoxPrint(44*CharW,MAXY-256-CharH*6,S(Volume,3,TRUE),4,Black+31,Gray,True);
               vputmouse;
               VertWait;
               LeftPressed := LeftButton;
          End;
     End;
     if ActiveSample > 0 then
        SampleInfo[ActiveSample].Volume := Volume;
     vrestoremouse;
     if OldVolume <> Volume then
        Analyser;
     PopMouse;
     ButtonPos := False;
     NotBussy;
End;

Procedure VolumeDown;
Var
   OldVolume   : Byte;
   LeftPressed : Boolean;
Begin
     Bussy;
     OldVolume := Volume;
     PushMouse;
     Begin
          Dec(Volume);
          vrestoremouse;
          BoxPrint(44*CharW,MAXY-256-CharH*6,S(Volume,3,TRUE),4,Black+31,Gray,True);
          vputmouse;
          VertWait;
          Delay(100);
          LeftPressed := LeftButton;
          While LeftPressed do
          Begin
               Dec(Volume);
               VertWait;
               vrestoremouse;
               BoxPrint(44*CharW,MAXY-256-CharH*6,S(Volume,3,TRUE),4,Black+31,Gray,True);
               vputmouse;
               VertWait;
               LeftPressed := LeftButton;
          End;
     End;
     if ActiveSample > 0 then
        SampleInfo[ActiveSample].Volume := Volume;
     vrestoremouse;
     if OldVolume <> Volume then
        Analyser;
     PopMouse;
     ButtonPos := False;
     NotBussy;
End;

Procedure BlockStartDown;
Var
   LeftPressed : Boolean;
Begin
     Bussy;
     if BlockStart >= IncVal then
     Begin
          PushMouse;
          ShowBlockStart;
          if RightButton then
             BlockStart := BlockStart div 2
          else
             BlockStart := BlockStart - IncVal;
          ShowBlockStart;
          vrestoremouse;
          BoxPrint(2*CharW      ,MAXY-256-CharH*6,S(BlockStart,8,TRUE),8,Black+31,Gray,True);
          vputmouse;
          Delay(100);
          LeftPressed := LeftButton;
          While LeftPressed and (BlockStart >= IncVal) do
          Begin
               ShowBlockStart;
               BlockStart := BlockStart - IncVal;
               ShowBlockStart;
               vrestoremouse;
               BoxPrint(2*CharW      ,MAXY-256-CharH*6,S(BlockStart,8,TRUE),8,Black+31,Gray,True);
               vputmouse;
               VertWait;
               LeftPressed := LeftButton;
          End;
          vrestoremouse;
          if Zoomed then
             Analyser;
          PopMouse;
     End;
     SampleInfo[ActiveSample].BlockStart := BlockStart;
     ButtonPos := False;
     NotBussy;
End;

Procedure BlockStartUp;
Var
   LeftPressed : Boolean;
Begin
     Bussy;
     if BlockStart <= (Position-IncVal) then
     Begin
          PushMouse;
          ShowBlockStart;
          if RightButton then
               BlockStart := BlockStart + (Position - BlockStart) div 2
          else
              BlockStart := BlockStart + IncVal;
          ShowBlockStart;
          vrestoremouse;
          BoxPrint(2*CharW      ,MAXY-256-CharH*6,S(BlockStart,8,TRUE),8,Black+31,Gray,True);
          vputmouse;
          Delay(100);
          LeftPressed := LeftButton;
          While LeftPressed and (BlockStart <= (Position - IncVal)) do
          Begin
               ShowBlockStart;
               BlockStart := BlockStart + IncVal;
               ShowBlockStart;
               vrestoremouse;
               BoxPrint(2*CharW      ,MAXY-256-CharH*6,S(BlockStart,8,TRUE),8,Black+31,Gray,True);
               vputmouse;
               VertWait;
               LeftPressed := LeftButton;
          End;
          vrestoremouse;
          if Zoomed then
             Analyser;
          PopMouse;
     End;
     SampleInfo[ActiveSample].BlockStart := BlockStart;
     ButtonPos := False;
     NotBussy;
End;

Procedure BlockEndDown;
Var
   LeftPressed : Boolean;
Begin
     Bussy;
     if BlockEnd >= (Position + IncVal) then
     Begin
          PushMouse;
          ShowBlockEnd;
          if RightButton then
             BlockEnd := Position + (BlockEnd - Position) div 2
          else
             BlockEnd := BlockEnd - IncVal;
          ShowBlockEnd;
          vrestoremouse;
          BoxPrint(MAXX-CharW*11   ,MAXY-256-CharH*6,S(BlockEnd,8,TRUE),8,Black+31,Gray,True);
          vputmouse;
          Delay(100);
          LeftPressed := LeftButton;
          While LeftPressed and (BlockEnd >= (Position + IncVal)) do
          Begin
               ShowBlockEnd;
               BlockEnd := BlockEnd - IncVal;
               ShowBlockEnd;
               vrestoremouse;
               BoxPrint(MAXX-CharW*11    ,MAXY-256-CharH*6,S(BlockEnd,8,TRUE),8,Black+31,Gray,True);
               vputmouse;
               VertWait;
               LeftPressed := LeftButton;
          End;
          vrestoremouse;
          if Zoomed then
             Analyser;
          PopMouse;
     End;
     SampleInfo[ActiveSample].BlockEnd := BlockEnd;
     ButtonPos := False;
     NotBussy;
End;

Procedure BlockEndUp;
Var
   LeftPressed : Boolean;
Begin
     Bussy;
     if BlockEnd <= (SampleInfo[ActiveSample].Length- IncVal) then
     Begin
          PushMouse;
          ShowBlockEnd;
          if RightButton then
             BlockEnd := BlockEnd + (SampleInfo[ActiveSample].Length - BlockEnd) div 2
          else
              BlockEnd := BlockEnd + IncVal;
          ShowBlockEnd;
          vrestoremouse;
          BoxPrint(MAXX-CharW*11   ,MAXY-256-CharH*6,S(BlockEnd,8,TRUE),8,Black+31,Gray,True);
          vputmouse;
          Delay(100);
          LeftPressed := LeftButton;
          While LeftPressed and (BlockEnd <= (SampleInfo[ActiveSample].Length - IncVal)) do
          Begin
               ShowBlockEnd;
               BlockEnd := BlockEnd + IncVal;
               ShowBlockEnd;
               vrestoremouse;
               BoxPrint(MAXX-CharW*11    ,MAXY-256-CharH*6,S(BlockEnd,8,TRUE),8,Black+31,Gray,True);
               vputmouse;
               VertWait;
               LeftPressed := LeftButton;
          End;
          vrestoremouse;
          if Zoomed then
             Analyser;
          PopMouse;
     End;
     SampleInfo[ActiveSample].BlockEnd := BlockEnd;
     ButtonPos := False;
     NotBussy;
End;
{$F-}


Procedure ShowSampleInfo;
Var
   Y    :Word;
   OldBussy : Byte;
Begin
     OldBussy := BussyState;
     Bussy;
     Y := MAXY-256-CharH*6;
     BlockShow;
     BoxPrint(13*CharW,Y,S(SampleLen,8,TRUE),8,Black+31,Gray,True);
     BoxPrint(22*CharW,Y,S(Position,8,TRUE) ,8,Black+31,Gray,True);
     BoxPrint(33*CharW,Y,S(Rate,5,TRUE)     ,6,Black+31,Gray,True);
     BoxPrint(44*CharW,Y,S(Volume,3,TRUE)   ,4,Black+31,Gray,True);
     BoxPrint(55*CharW,Y,'1',1,Blue+31,Gray,Cntr1);
     BoxPrint(57*CharW,Y,'2',1,Blue+31,Gray,Cntr2);
     BoxPrint(59*CharW,Y,'3',1,Blue+31,Gray,Cntr3);
     BoxPrint(61*CharW,Y,'zOOm'        ,5,Blue+31  ,Gray,Zoomed);
     BoxPrint(51*CharW,Y,'+/-'         ,3,Blue+31  ,Gray,Signed);
     if OldBussy = 0 then NotBussy;
End;

{$F+}
Procedure Rewind;
Var
   LeftPressed :Boolean;
Begin
     Bussy;
     if ActiveSample = 0 then
          OKBox('No sample cell selected.')
     Else
     if SampleInfo[ActiveSample].Pos = 0 then
          OKBox('Already at the beginning of the sample.')
     else
     Begin
          if Position >= (BlockStart+IncVal) then
          Begin
               PushMouse;
               ShowPos;
               if RightButton then
                  Position := Position - (Position - BlockStart) div 2
               else
                   Position := Position - IncVal;
               ShowPos;
               vrestoremouse;
               BoxPrint(22*CharW,MAXY-256-CharH*6,S(Position,8,TRUE) ,8,Black+31,Gray,True);
               vputmouse;
               Delay(100);
               LeftPressed := LeftButton;
               While (LeftPressed) and (Position >= (BlockStart + IncVal)) do
               Begin
                    ShowPos;
                    Position := Position - IncVal;
                    ShowPos;
                    VertWait;
                    vrestoremouse;
                    BoxPrint(22*CharW,MAXY-256-CharH*6,S(Position,8,TRUE) ,8,Black+31,Gray,True);
                    vputmouse;
                    VertWait;
                    LeftPressed := LeftButton;
               End;
               SampleInfo[ActiveSample].Pos := Position;
               vrestoremouse;
               PopMouse;
          End;
     End;
     ButtonPos := False;
     NotBussy;
End;

Procedure ToStart;
Begin
     Bussy;
     if ActiveSample = 0 then
          OKBox('No sample cell selected.')
     Else
     if SampleInfo[ActiveSample].Pos = 0 then
          OKBox('Already at the beginning of the sample.')
     else
     Begin
          ShowPos;
          Position := BlockStart;
          ShowPos;
          BoxPrint(22*CharW,MAXY-256-CharH*6,S(Position,8,TRUE) ,8,Black+31,Gray,True);
          SampleInfo[ActiveSample].pos := Position;
     End;
     NotBussy;
     ButtonPos := False;
End;

Procedure Play;
Var
   LI   :LongInt;
Begin
    if RightButton then
    Begin
         Bussy;
         ShowPos;
         Position := BlockStart;
         ShowPos;
         BoxPrint(22*CharW,MAXY-256-CharH*6,S(Position,8,TRUE) ,8,Black+31,Gray,True);
         SampleInfo[ActiveSample].Pos := Position;
         NotBussy;
     End;
     if ActiveSample = 0 then
          OKBox('No sample cell selected.')
     Else
     if SampleInfo[ActiveSample].Length = 0 then
          OKBox('Cell is empty.Nothing to play.')
     else
     if SampleInfo[ActiveSample].Pos = SampleInfo[ActiveSample].Length then
          OKBox('At the end of the sample.Rewind.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
          OKBox('Empty cell.Nothing to play.')
     else
     if SampleInfo[ActiveSample].Pos = BlockEnd then
          OKBox('At the end of the block.Rewind')
     else
     Begin
          Bussy;
          _emsupage := Position div (_16KB);
          _smpoff  := Position - (_emsupage*_16KB);
          _emsbase := EMSBase;
          _emshandle := SampleInfo[ActiveSample].EMSHandle;
          SetNext4;
          li := BlockEnd - Position;
          _smplenhi := li div 65535;
          _smplenlo := li mod 65535;
          _samplerate := rate div 256;
          _baserate   := rate div 256;
          _amplify    := 1;
          if twin then _twin := 1 else _twin:= 0;
          ShowPos;
          playing := True;
          PushMouse;
          vputmouse;
          if ShowOsilo then
          Begin
               SaveScreen(osilox-CharW,osiloy-CharH,osilox+_osilolen+CharW,osiloy+_osilowidth+CharH);
               MsgBox(osilox-CharW,osiloy-CharH,osilox+_osilolen+CharW,osiloy+_osilowidth+CharH,Blue,BoxColor);
               MoveTo(osiloorgx,osiloorgy);
               LineRel(0,0);
          End;
          _cntr := _maxcntr;
          if isMC then Bussy;
          StartPlaying;
          if isMC then NotBussy;
          if ShowOsilo then RestoreScreen;
          vrestoremouse;
          PopMouse;
          playing := False;
          li := _smplenhi;
          li := li * 65535;
          li := li + _smplenlo;
          if li < BlockEnd then
             li := BlockEnd - li
          else
              li := BlockEnd;
          position := li;
          ShowPos;
          SampleInfo[ActiveSample].pos := Position;
          BoxPrint(22*CharW,MAXY-256-CharH*6,S(Position,8,TRUE) ,8,Black+31,Gray,True);

          NotBussy;
     End;
     ButtonPos := False;
End;

Procedure Frward;
Var
   LeftPressed : Boolean;
Begin
     if ActiveSample = 0 then
          OKBox('No sample cell selected.')
     Else
     if SampleInfo[ActiveSample].Pos = SampleInfo[ActiveSample].Length then
          OKBox('Already at the end of the sample.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
          OKBox('Empty cell.')
     else
     Begin
          Bussy;
          if Position <= (BlockEnd - IncVal) then
          Begin
               PushMouse;
               ShowPos;
               if RightButton then
                   Position := Position + (BlockEnd - Position) div 2
               else
                   Position := Position + IncVal;
               ShowPos;
               vrestoremouse;
               BoxPrint(22*CharW,MAXY-256-CharH*6,S(Position,8,TRUE) ,8,Black+31,Gray,True);
               vputmouse;
               Delay(100);
               LeftPressed := LeftButton;
               While (LeftPressed) and (Position <= (BlockEnd - IncVal)) do
               Begin
                    ShowPos;
                    Position := Position + IncVal;
                    ShowPos;
                    VertWait;
                    vrestoremouse;
                    BoxPrint(22*CharW,MAXY-256-CharH*6,S(Position,8,TRUE) ,8,Black+31,Gray,True);
                    vputmouse;
                    vertwait;
                    LeftPressed := LeftButton;
               End;
               SampleInfo[ActiveSample].pos := Position;
               vrestoremouse;
               PopMouse;
          End;
          NotBussy;
     End;
     ButtonPos := False;
End;

Procedure ToEnd;
Begin
     if ActiveSample = 0 then
          OKBox('No sample cell selected.')
     Else
     if SampleInfo[ActiveSample].Pos = SampleInfo[ActiveSample].Length then
          OKBox('Already at the end of the sample.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
          OKBox('Empty cell.')
     else
     Begin
          Bussy;
          ShowPos;
          Position := BlockEnd;
          ShowPos;
          BoxPrint(22*CharW,MAXY-256-CharH*6,S(Position,8,TRUE) ,8,Black+31,Gray,True);
          Sampleinfo[ActiveSample].pos := Position;
          NotBussy;
     End;
     ButtonPos := False;
End;

Procedure Free;
Var
   i,
   j,
   DHandle : Word;
Begin
     if ActiveSample = 0 then
          OKBox('No sample cell selected.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
          OKBox('Cell is empty.Nothing to free.')
     else
     if ASKBox('Do you really want to free '+Strip(SampleInfo[ActiveSample].Name)+' ?') then
     Begin
          Bussy;
          DHandle := SampleInfo[ActiveSample].EMSHandle;
          Asm
             mov ah,45h
             mov dx,Dhandle
             int 67h
             mov rc,ax
          End;
          if hi(rc) <> 0 then
             OKBox('Unable to free allocated memory.EMS error.')
          else
          Begin
               SampleInfo[ActiveSample].name       := DefaultName;
               SampleInfo[ActiveSample].Rate       := DefaultRate;
               SampleInfo[ActiveSample].BlockStart := 0;
               SampleInfo[ActiveSample].BlockEnd   := 0;
               SampleInfo[ActiveSample].Pos        := 0;
               SampleInfo[ActiveSample].Start      := 0;
               SampleInfo[ActiveSample].Length     := 0;
               SampleInfo[ActiveSample].Volume     := DefaultVolume;
               SampleInfo[ActiveSample].Twin       := DefaultTwin;
               SampleInfo[ActiveSample].Cntr       := DefaultCntr;
               SampleInfo[ActiveSample].Active     := True;
               SampleInFo[ActiveSample].Signed     := False;
               SampleInfo[ActiveSample].EMSHandle  := 0;
               SampleInfo[ActiveSample].Zoomed     := False;
               ButtonTree^[SampleBase+ActiveSample-1,0].Text := SampleInfo[ActiveSample].Name;
               i := ActiveSample div 7;
               j := ActiveSample - (i*7);
               if j = 0 then
               Begin
                    j := 7;
                    dec(i);
               End;
               BoxPrint(9*(j-1)*CharW,(CharH*6)+i*CharH*2,
               SampleInfo[ActiveSample].Name,8,Yellow+31,Blue,SampleInfo[ActiveSample].Active);
               SampleLen := SampleInfo[ActiveSample].Length;
               Position  := SampleInfo[ActiveSample].Pos;
               Volume    := SampleInfo[ActiveSample].Volume;
               BlockStart:= SampleInfo[ActiveSample].BlockStart;
               BlockEnd  := SampleInfo[ActiveSample].BlockEnd;
               Signed    := SampleInfo[ActiveSample].Signed;
               Zoomed    := SampleInfo[ActiveSample].Zoomed;
               _MaxCntr  := SampleInfo[ActiveSample].Cntr;
               Twin      := SampleInfo[ActiveSample].Twin;
               ShowSampleInfo;
               Analyser;
          End;
          NotBussy;
     End;
     ButtonPos := False;
End;

{$I loadpart.inc}
{$I savepart.inc}

Procedure About;
Var
   X1,
   X2,
   Y1,
   Y2           :Word;

Begin
     Bussy;
     PushMouse;
     x1 := (Maxx-320) div 2;
     y1 := (Maxy-100) div 2;
     x2 := Maxx - x1;
     y2 := Maxy - y1;
     SaveScreen(x1,y1,x2,y2);
     MsgBox(x1,y1,x2,y2,Blue,Blue+31);
     Inc(TreeLevel);
     Okay := False;
     ButtonPrint(x2-CharW*6,y2 - CharH * 3,'OK',4,Black,Gray,False,Ok,NoNo);
     vsetmousecoor(x2-CharW*4,y2-CharH*2);
     SetColor(Black+31);
     OutTextXY(x1+CharW*10,y1+CharH*3,'LongPlay Version:'+Version);
     SetColor(Black+16);
     OutTextXY(x1+CharW*10,y1+CharH*5,'By H.Nakturk (c) 1994');
     SetColor(Yellow+31);
     OutTextXY(x1+CharW*5,y1+CharH*8,'Registered to: '+RegisteredTo);
     SetColor(Green+16);
     OutTextXY(x1+CharW*9,y1+charh*10,'Memory Available: '+S(MemAvail div 1024,4,TRUE)+'Kb');
     NotBussy;
     Repeat
           if ProcNo = 2 then
           Begin
                MainProc[ProcNo];
                MainProc[ProcNo]:= Nothing;
                ProcNo := 1;
           End;
     Until Okay;
     Bussy;
     Dec(TreePtr[TreeLevel]);
     Dec(TreeLevel);
     RestoreScreen;
     PopMouse;
     ButtonPos := False;
     NotBussy;
End;

Procedure Quit;
Begin
     if ASKBox('Do you really want to Quit ?') then
         ProgEnded := True
     else
         ProgEnded := False;
End;

Procedure V640X480;
Begin
    if Not V640 then
    Begin
        DisableVGA;
        vdisablemouse;
        V640  := True;
        V800  := False;
        V1024 := False;
        TreeClear;
        VGAInitialize(SVGA640X480X256);
        DisableVGA;
        TreeLevel := 0;
        ScreenInitialize;
        _osilooff := 300+(320-_osilolen) div 2;
        osilox := 172+(320-_osilolen) div 2;
        osiloy := 204;
        osiloorgx := 100;
        osiloorgy := 300;
        venablemouse(LeftPressed,RightPressed);
        EnableVGA;
    End;
    ButtonPos := True;
End;

Procedure V800X600;
Begin
     If not V800 then
     Begin
          DisableVGA;
          vdisablemouse;
          V640  := False;
          V800  := True;
          V1024 := False;
          TreeClear;
          VGAInitialize(SVGA800X600X256);
          DisableVGA;
          TreeLevel := 0;
          Screeninitialize;
          _osilooff := 360+(320-_osilolen) div 2;
          osilox := 232+(320-_osilolen) div 2;
          osiloy := 164;
          osiloorgx := 100;
          osiloorgy := 200;
          venablemouse(LeftPressed,RightPressed);
          EnableVGA;
     End;
     ButtonPos := True;
End;

Procedure V1024X768;
Begin
     if Not V1024 then
     Begin
          DisableVGA;
          vdisablemouse;
          V640  := False;
          V800  := False;
          V1024 := True;
          TreeClear;
          VGAInitialize(SVGA1024X768X256);
          DisableVGA;
          TreeLevel := 0;
          Screeninitialize;
          _osilooff := 360+(320-_osilolen) div 2;
          osilox := 360+(320-_osilolen) div 2;
          osiloy := 192;
          osiloorgx := 100;
          osiloorgy := 200;
          venablemouse(LeftPressed,RightPressed);
          EnableVGA;
     End;
     ButtonPos := True;
End;

Procedure SampleSelect;
Var
   i,j  :Word;
Begin
     Bussy;
     if ActiveSample = 0 then
     Begin
          ActiveSample := GlobalNo;
          SampleInfo[ActiveSample].Active := True;
          ButtonPos := True;
     End
     else
     if GlobalNo = ActiveSample then
     Begin
          ButtonPos := True;
     End
     else
     if ActiveSample <> GlobalNo then
     Begin
          i := ActiveSample div 7;
          j := ActiveSample - (i*7);
          SampleInfo[ActiveSample].Active := False;
          if j = 0 then
          Begin
               j := 7;
               dec(i);
          End;
          BoxPrint(9*(j-1)*CharW,(CharH*6)+i*CharH*2,
          SampleInfo[ActiveSample].Name,8,Yellow+31,Blue,SampleInfo[ActiveSample].Active);
          ActiveSample := GlobalNo;
          SampleInfo[ActiveSample].Active := True;
          ButtonPos := True;
     End;
     SetSampleInfo;
     Analyser;
     NotBussy;
End;

Procedure DeviceInit;
var
   x1,y1 : Word;
Begin
     Bussy;
     x1 := HALFMAXX - 10*CharW;
     y1 := HALFMAXY - 10*CharH;
     BoxPrint(x1+CharW*2,y1+CharH*3*Device,DeviceInfo[device].Name,16,Black+31,Blue,False);
     Device := GlobalNo;
     BoxPrint(x1+CharW*2,y1+CharH*3*Device,DeviceInfo[device].Name,16,Black+31,Blue,True);
     NotBussy;
End;

Procedure DeviceSet;
Var
   x1,
   y1,
   x2,
   y2   : Word;
   db   : Byte;
   OldTreePtr : Byte;
   OldDevice : Byte;
Begin
     Bussy;
     PushMouse;
     OldDevice := Device;
     x1 := HALFMAXX - 10*CharW;
     x2 := HALFMAXX + 11*CharW;
     y1 := HALFMAXY - 10*CharH;
     y2 := y1+ (MaxDevice*4+2)*CharH+CharH;
     SaveScreen(x1,y1,x2,y2);
     MsgBox(x1,y1,x2,y2,Gray,Gray+16);
     Inc(TreeLevel);
     OldTreePtr := TreePtr[TreeLevel];
     For db := 1 to MaxDevice do
     Begin
          ButtonPrint(x1+CharW*2,y1+CharH*3*db,DeviceInfo[db].Name,16,Black+31,Blue,(Device = db),DeviceInit,db);
     End;
     ButtonPrint(x1+CharW,y2-CharH*3,'OK',5,Black+31,Green,False,Ok,NoNo);
     ButtonPrint(x2-CharW*8,y2-CharH*3,'FORGET',6,Black+31,Red,False,Cancel,NoNo);
     vsetmousecoor(x1+CharW*4,y2-CharH*3);
     Okay := False;
     Canceled := False;
     NotBussy;
     Repeat
           if ProcNo = 2 then
           Begin
                MainProc[ProcNo];
                MainProc[ProcNo] := Nothing;
                ProcNo := 1;
           End;
     Until (Okay) or (Canceled);
     if Canceled then Device := OldDevice;
     Bussy;
     TreePtr[TreeLevel] := OldTreePtr;
     Dec(TreeLevel);
     ButtonTree^[DeviceButton,0].Text := DeviceInfo[Device].Name;
     Handler := Ofs(DeviceInfo[Device].Handler);
     RestoreScreen;
     PopMouse;
     ButtonPos := False;
     NotBussy;
End;

Procedure SetOsilo;
Begin
     if ShowOsilo then ShowOsilo := False else ShowOsilo := True;
     ButtonPos := ShowOsilo;
End;

Procedure Reverse;
Var
   LastPercent,
   Percent : Byte;
   Stemp   : Byte;
   FLen,
   SLen,
   SStart,
   SEnd   : LongInt;
   Buffer1,
   Buffer2      :Pointer;
   BufSize2,
   BufSize      :Word;
   _handle      :word;
Begin

     if ActiveSample = 0 then
        OKBox('No sample cell selected.')
     else
     if SampleInfo[ActiveSample].Length < 2 then
        OKBox('Nothing to reverse.')
     else
     Begin
          Bussy;
          PushMouse;
          BufSize := _16KB;
          if MemAvail < 2*_16KB then
          BufSize := MemAvail div 2;
          SStart  := 0;
          SEnd    := SampleInfo[ActiveSample].Length;
          _handle := SampleInfo[ActiveSample].EMSHandle;
          Stemp   := BlockBox('Reverse selected block or whole sample ?');
          if Stemp <> _CANCEL then
          Begin
               GetMem(Buffer1,BufSize);
               GetMem(Buffer2,BufSize);
               if Stemp = _BLOCK then
               Begin
                    SStart:= BlockStart;
                    SEnd  := BlockEnd;
               End;
               StatusBox('Working...',0);
               LastPercent := 0;
               Slen := SEnd - SStart;
               FLen := Slen DIV 2;
               While SLen > (BufSize * 2) do
               Begin
                    BlockPeek(_handle,SStart div _16KB          ,SStart mod _16KB         ,BufSize,Buffer1);
                    BlockPeek(_handle,(SEnd-BufSize) div _16KB  ,(SEnd-BufSize) mod _16KB ,BufSize,Buffer2);
                    BlockReverse(BufSize,Buffer1);
                    BlockReverse(BufSize,Buffer2);
                    BlockPoke(_handle,SStart div _16KB          ,SStart mod _16KB          ,BufSize,Buffer2);
                    BlockPoke(_handle,(Send-BufSize) div _16KB  ,(Send-BufSize) mod _16KB  ,BufSize,Buffer1);
                    SStart := SStart + BufSize;
                    SEnd   := SEnd - BufSize;
                    if SEnd < SStart then Halt;
                    Slen := SEnd - SStart;
                    if Stemp <> _BLOCK then
                       Percent := SStart div (FLen div 100)
                    else
                       Percent := (SStart - BLockStart) div (Flen div 100);
                    if Percent > LastPercent then
                    Begin
                         StatusBox('',Percent);
                         LastPercent := Percent;
                    End;
               End;
               if Slen > 0 then
               Begin
                    BlockPeek(_handle,SStart div _16KB             ,SStart mod _16KB             ,Slen div 2,Buffer1);
                    BlockPeek(_handle,(SEnd-(Slen div 2)) div _16KB,(Send-(Slen div 2)) mod _16KB,Slen div 2,Buffer2);
                    BlockReverse(Slen div 2,Buffer1);
                    BlockReverse(Slen div 2,Buffer2);
                    BlockPoke(_handle,SStart div _16KB             ,SStart mod _16KB             ,Slen div 2,Buffer2);
                    BlockPoke(_handle,(Send-(Slen div 2)) div _16KB,(Send-(Slen div 2)) mod _16KB,Slen div 2,Buffer1);
                    SStart := SStart + Slen div 2;
                    if Stemp <> _BLOCK then
                       Percent := SStart div (FLen div 100)
                    else
                       Percent := (SStart-BlockStart) div (Flen div 100);
                    if Percent > LastPercent then
                    Begin
                         StatusBox('',Percent);
                         LastPercent := Percent;
                    End;
               End;
               if StatusBoxActive then StatusBox('',100);
               FreeMem(Buffer2,BufSize);
               FreeMem(Buffer1,BufSize);
               AnalySer;
          End;
          PopMouse;
          NotBussy;
     End;
     ButtonPos := False;
End;

Procedure EchoProcess;
Var
   SLen,
   PLen,
   SStart,
   SEnd,
   Sptr1,
   Sptr2,
   Sptr         :LongInt;
   DByte        :Byte;
   Dword        :Word;
   _handle      :Word;
   OldPages     :Word;
   NewPages     :Word;
   BufSize      :Word;
   Buffer1,
   Buffer2      :Pointer;
   DFile        :Text;
   Percent,
   LastPercent  :Byte;
Begin
     DByte := BlockBox('Echo to which part of the sample ?');
     if DByte <> _CANCEL then
     Begin
          BufSize := _16KB;
          if MemAvail < BufSize*2 then BufSize := MemAvail div 2;
          _handle := SampleInfo[ActiveSample].EMSHandle;
          SStart := 0;
          SEnd   := SampleInfo[ActiveSample].Length;
          if DByte = _BLOCK then
          Begin
               SStart := BlockStart;
               SEnd   := BlockEnd;
          End;
          Slen := SEnd - SStart;
          Plen := 0;
          if Slen >  0 then
          Begin
               if (SEnd + EchoDelay) > SampleInfo[ActiveSample].Length then
               Begin
                    OldPages := (SampleInfo[ActiveSample].Length div _16KB)+1;
                    NewPages := ((Send + EchoDelay) div _16KB)+1;
                    FillEMSPage(_handle,OldPages,SampleInfo[ActiveSample].Length mod _16KB,
                                OldPages*_16KB-SampleInfo[ActiveSample].Length,$80);
                    if NewPages <> OldPages then
                    Begin
                         Asm
                            mov ah,51h
                            mov dx,_handle
                            mov bx,newpages
                            int 67h
                         End;
                    End;
                    NewPages := NewPages - OldPages;
                    For DWord := 1 to NewPages do
                        FillEMSPage(_handle,OldPages+DWord,0,$4000,$80);
                    SampleInfo[ActiveSample].Length := SEnd + EchoDelay;
                    SampleLen := SampleInfo[ActiveSample].Length;
               End;
               GetMem(Buffer1,BufSize);
               GetMem(Buffer2,BufSize);
               Sptr1 := Send;
               Sptr2 := Send+EchoDelay;
               StatusBox('Working...',0);
               LastPercent := 0;
               Repeat
                    Sptr1 := Sptr1 - BufSize;
                    Sptr2 := Sptr2 - BufSize;
                    BlockPeek(_handle,Sptr1 div _16KB,Sptr1 mod _16KB,BufSize,Buffer1);
                    BlockPeek(_handle,Sptr2 div _16KB,Sptr2 mod _16KB,Bufsize,Buffer2);
                    BlockMix(BufSize,Buffer1,Buffer2,SampleInfo[ActiveSample].Signed,
                    SampleInfo[ActiveSample].Signed,EchoPercent);

                    BlockPoke(_handle,Sptr2 div _16KB,Sptr2 mod _16KB,BufSize,Buffer1);
                    Plen := Plen + BufSize;
                    Percent := Plen div (Slen div 100);
                    if Percent <> LastPercent then
                    Begin
                         StatusBox('',Percent);
                         LastPercent := Percent;
                    End;
               Until (Sptr1 - SStart) < BufSize;
               if Sptr1 > SStart then
               Begin
                    Sptr2 := Sptr2 -(Sptr1 - SStart);

                    BlockPeek(_handle,SStart div _16KB,
                    SStart mod _16KB,(Sptr1-SStart),Buffer1);

                    BlockPeek(_handle,Sptr2 div _16KB,
                    Sptr2  mod _16KB,(Sptr1-SStart),Buffer2);

                    BlockMix(BufSize,Buffer1,Buffer2,SampleInfo[ActiveSample].Signed,
                    SampleInfo[ActiveSample].Signed,EchoPercent);

                    BlockPoke(_handle,Sptr2 div _16KB,
                    Sptr2  mod _16KB,(Sptr1-SStart),Buffer1);
               End;
               if StatusBoxActive then StatusBox('',100);
               BlockEnd := Send+EchoDelay;
               SampleInfo[ActiveSample].BlockEnd := BlockEnd;
               FreeMem(Buffer2,BufSize);
               FreeMem(Buffer1,BufSize);
          End;
     End;
End;

Procedure ShowEchoVars;
Begin
     vrestoremouse;
     if EchoDelay > MaxEchoDelay then EchoDelay := MaxEchoDelay;
     if EchoDelay < 1 then EchoDelay := 1;
     if EchoPercent > 999 then EchoPercent := 1;
     if EchoPercent < 1 then EchoPercent := 999;
     SetColor(Black+31);
     SetFillStyle(SolidFill,Black);
     Bar(HALFMAXX - 4*CharW,ly2-CharH*6,HALFMAXX + 4*CharW,ly2-CharH*4);
     OutTextXY(HALFMAXX - 4*CharW,ly2-CharH*5-CharH div 2,S(EchoDelay,8,True));
     Bar(HALFMAXX-2*CharW,ly1+CharH*4,HALFMAXX+2*CharW,ly1+CharH*6);
     OutTextXY(HALFMAXX-2*CharW,ly1+CharH*4+CharH div 2,S(EchoPercent,3,True)+'%');
     vputmouse;
End;

Procedure EchoSet;
Var
   LeftPressed : Boolean;
   OMX,OMY     : Word;
Begin
     OMX := MouseX;
     OMY := MouseY;
     Case GlobalNo of
          1 : Begin
                   if RightButton then
                      EchoDelay := (EchoDelay div 2)+1
                   else
                       Dec(EchoDelay);
                   ShowEchoVars;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                         Dec(EchoDelay);
                         ShowEchoVars;
                         VertWait;
                         LeftPressed := LeftButton;
                   End;
              End;
          2 : Begin
                   if RightButton then
                      EchoDelay := EchoDelay + EchoDelay div 2
                   else
                      Inc(EchoDelay);
                   ShowEchoVars;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                         Inc(EchoDelay);
                         ShowEchoVars;
                         VertWait;
                         LeftPressed := LeftButton;
                   End;
              End;
          3 : Begin
                   if RightButton then
                      EchoPercent := (EchoPercent div 2)+1
                   else
                      Dec(EchoPercent);
                   ShowEchoVars;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                         Dec(EchoPercent);
                         ShowEchoVars;
                         VertWait;
                         LeftPressed := LeftButton;
                   End;
              End;
          4 : Begin
                   if RightButton then
                      EchoPercent := EchoPercent + EchoPercent div 2
                   else
                      Inc(EchoPercent);
                   ShowEchoVars;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                         Inc(EchoPercent);
                         ShowEchoVars;
                         VertWait;
                         LeftPressed := LeftButton;
                   End;
              End;
     End;
     vrestoremouse; { vputmouse from ShowEchoVars }
     vsetmousecoor(OMX,OMY);
End;

Procedure Echo;
Var
   OldTreePtr   :Byte;
   FreePages    :Word;
Begin
     if ActiveSample = 0 then
        OKBox('No sample selected.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
        OKBox('Cell is empty.')
     else
     Begin
          Asm
             mov ah,42h
             int 67h
             mov FreePages,bx
          End;
          if FreePages = 0 then
             OKBox('No memory to shift sample.')
          else
          Begin
               Bussy;
               PushMouse;
               MaxEchoDelay := FreePages;
               MaxEchoDelay := MaxEchoDelay * _16KB;
               lx1 := HALFMAXX-10*CharW;
               ly1 := HALFMAXY-7*CharH;
               lx2 := HALFMAXX+10*CharW;
               ly2 := HALFMAXY+7*CharH;
               SaveScreen(lx1,ly1,lx2,ly2);
               MsgBox(lx1,ly1,lx2,ly2,Blue,Blue+4);
               Inc(TreeLevel);
               OldTreePtr := TreePtr[TreeLevel];
               ButtonPrint(lx1+CharW,ly2-CharH*3,'OK',6,Black,Green,False,OK,NoNo);
               ButtonPrint(lx2-CharW*8,ly2-CharH*3,'CANCEL',6,Black,Red,False,Cancel,NoNo);
               ButtonPrint(HALFMAXX-6*CharW,ly2-CharH*6,chr(17),1,Black,Gray,False,EchoSet,1);
               ButtonPrint(HALFMAXX+4*CharW,ly2-CharH*6,chr(16),1,Black,Gray,False,EchoSet,2);
               ButtonPrint(HALFMAXX-CharW*4,ly1+CharH*4,Chr(17),1,Black,Gray,False,EchoSet,3);
               ButtonPrint(HALFMAXX+CharW*2,ly1+CharH*4,Chr(16),1,Black,Gray,False,EchoSet,4);
               vsetmousecoor(lx2-CharW*3,ly2-CharH*3);
               SetColor(Black+31);
               OutTextXY(HALFMAXX-CharW*3,ly1+CharH*3,'Volume');
               OutTextXY(HALFMAXX-CharW*2-CharW div 2,ly2-CharH*7,'Delay');
               ShowEchoVars;
               vrestoremouse; { vputmouse comes from showechovars}
               Okay := False;
               Canceled := False;

               NotBussy;
               Repeat
                     if ProcNo = 2 then
                     Begin
                          Bussy;
{
                          MainProc[ProcNo];
                          MainProc[ProcNo] := Nothing;
                          ProcNo := 1;
}
                          Kernel;
                          NotBussy;
                     End;
               Until (okay) or (Canceled);
               Bussy;
               if Okay then EchoProcess;
               TreePtr[TreeLevel] := OldTreePtr;
               Dec(TreeLevel);
               RestoreScreen;
               if Okay then
               Begin
                    Analyser;
                    SetSampleInfo;
               End;
               PopMouse;
               NotBussy;
          End;
     End;
     ButtonPos := False;
End;

Procedure ShowVolPercent;
Begin
     vrestoremouse;
     if VolPercent > 999 then VolPercent := 1;
     if VolPercent < 1 then VolPercent := 999;
     SetColor(Black+31);
     SetFillStyle(Solidfill,Black);
     Bar(lx1+CharW*6,ly1+CharH*3,lx1+CharW*10,ly1+CharH*4);
     OutTextXY(lx1+CharW*6,ly1+CharH*3,S(VolPercent,3,TRUE)+'%');
     vputmouse;
End;

Procedure VolPerChange;
Var
   LeftPressed : Boolean;
   OMX,
   OMY         : Word;
Begin
     OMX := MouseX;
     OMY := MouseY;
     Case GlobalNo of
          1 : Begin
                   if RightButton then
                      VolPercent := VolPercent + (999 - VolPercent) div 2
                   else
                       Inc(VolPercent);
                   ShowVolPercent;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                        Inc(VolPercent);
                        ShowVolPercent;
                        VertWait;
                        LeftPressed := LeftButton;
                   End;
             End;
          2 : Begin
                   if RightButton then
                      VolPercent := VolPercent - (VolPercent - 2) div 2
                   else
                      Dec(VolPercent);
                   ShowVolPercent;
                   Delay(100);
                   LeftPressed := Leftbutton;
                   While LeftPressed do
                   Begin
                        Dec(VolPercent);
                        ShowVolPercent;
                        VertWait;
                        LeftPressed := LeftButton;
                   End;
              End;
     End;
     vRestoreMouse; { vputmouse from showvolpercent }
     vsetmousecoor(OMX,OMY);
End;

Procedure VolProcess;
Var
   SStart,
   SEnd,
   FLen,
   SLen,
   SPtr         :LongInt;
   STemp,
   Percent,
   LastPercent  : Byte;
   _handle,
   BufSize      : Word;
   Buffer       : Pointer;
Begin

   STemp := BlockBox('Modify volume of which part of the sample ?');
   if Stemp <> _CANCEL then
   Begin
        BufSize := _16KB;
        if MemAvail < BufSize then BufSize := MemAvail;
        StatusBox('Working...',0);
        LastPercent := 0;
        SStart := 0;
        SEnd   := SampleInfo[ActiveSample].Length;
        if Stemp = _BLOCK then
        Begin
             SStart := BlockStart;
             SEnd   := BlockEnd;
        End;
        SLen := SEnd - SStart;
        FLen := 0;
        _handle := SampleInfo[ActiveSample].EMSHandle;
        GetMem(Buffer,BufSize);
        For SPtr := 1 to (SLen div BufSize) do
        Begin
             if SStart > SEnd then Halt;
             BlockPeek(_handle,SStart div _16KB,SStart mod BufSize,BufSize,Buffer);
             BlockVolumeSet(BufSize,Buffer,VolPercent);
             BlockPoke(_handle,SStart div _16KB,SStart mod BufSize,BufSize,Buffer);
             SStart := SStart + BufSize;
             FLen := Flen + BufSize;
             Percent := Flen div (SLen div 100);
             if Percent <> LastPercent then
             Begin
                  StatusBox('',Percent);
                  LastPercent := Percent;
             End;
        End;
        if (SEnd - SStart) > 0 then
        Begin
             BlockPeek(_handle,SStart div _16KB,SStart mod BufSize,Send - SStart,Buffer);
             BlockVolumeSet(Send-SStart,Buffer,VolPercent);
             BlockPoke(_handle,SStart div _16KB,SStart mod BufSize,Send - SStart,Buffer);
             SStart := SEnd;
        End;
        FreeMem(Buffer,BufSize);
        if StatusBoxActive then StatusBox('',100);
   End;
End;

Procedure VolumeSet;
Var
   OldTreePtr : Byte;
Begin
     if ActiveSample = 0 then
        OKBox('No cell selected.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
        OKBox('Cell is empty.')
     else
     Begin
          Bussy;
          PushMouse;
          lx1 := HALFMAXX - 8*CharW;
          lx2 := HALFMAXX + 8*CharW;
          ly1 := HALFMAXY - 5*CharH;
          ly2 := HALFMAXY + 5*CharH;
          VolPercent := 200;
          SaveScreen(lx1,ly1,lx2,ly2);
          MsgBox(lx1,ly1,lx2,ly2,blue,blue+4);
          Inc(TreeLevel);
          OldTreePtr := TreePtr[TreeLevel];
          ButtonPrint(lx1+CharW,ly2-CharH*3,'OK',6,Black,Green,False,OK,NoNo);
          ButtonPrint(lx2-CharW*8,ly2-CharH*3,'CANCEL',6,Black,Red,False,Cancel,NoNo);
          ButtonPrint(lx1+CharW*6,ly1+CharH,Chr(30),3,Black,Gray,False,VolPerChange,1);
          ButtonPrint(lx1+CharW*6,ly1+CharH*4,Chr(31),3,Black,Gray,False,VolPerChange,2);
          ShowVolPercent;
          vrestoremouse; { vputmouse from showvolpercent }
          vsetmousecoor(lx2-CharW*5,ly2-CharH*3);

          Canceled := False;
          Okay := False;
          NotBussy;
          Repeat
                if ProcNo = 2 then
                Begin
                     Bussy;
{
                     MainProc[ProcNo];
                     MainProc[ProcNo] := Nothing;
                     ProcNo := 1;
}
                     Kernel;

                     NotBussy;
                End;
          Until (Okay) or (Canceled);
          Bussy;
          if (Okay) and (VolPercent <> 100) then VolProcess;
          TreePtr[TreeLevel] := OldTreePtr;
          Dec(TreeLevel);
          RestoreScreen;
          if (Okay) and (VolPercent <> 100) then Analyser;
          PopMouse;
          NotBussy;
     End;
     ButtonPos := False;
End;


Procedure ShowFadePercent;
Begin
     vrestoremouse;
     if FadeStartPercent  > 999  then FadeStartPercent  :=   0;
     if FadeFinishPercent > 999  then FadeFinishPercent :=   0;
     SetColor(Black+31);
     SetFillStyle(SolidFill,Black);
     Bar(lx1+CharW*3,ly1+CharH*7,lx1+CharW*7,ly1+CharH*8);
     OutTextXY(lx1+CharW*3,ly1+CharH*7,S(FadeStartPercent,3,TRUE)+'%');
     Bar(lx1+CharW*21,ly1+CharH*7,lx1+CharW*25,ly1+CharH*8);
     OutTextXY(lx1+CharW*21,ly1+CharH*7,S(FadeFinishPercent,3,TRUE)+'%');
     vputmouse;
End;

Procedure FadePerChange;
Var
   LeftPressed : Boolean;
   OMX,
   OMY : Word;
Begin
     OMX := MouseX;
     OMY := MouseY;
     Case GlobalNo of
          1 : Begin
                   Inc(FadeStartPercent);
                   ShowFadePercent;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                        Inc(FadeStartPercent);
                        ShowFadePercent;
                        VertWait;
                        LeftPressed := LeftButton;
                   End;
              End;
          2 : Begin
                   Dec(FadeStartPercent);
                   ShowFadePercent;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                        Dec(FadeStartPercent);
                        ShowFadePercent;
                        VertWait;
                        LeftPressed := LeftButton;
                   End;
              End;
          3 : Begin
                   Inc(FadeFinishPercent);
                   ShowFadePercent;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                        Inc(FadeFinishPercent);
                        ShowFadePercent;
                        VertWait;
                        LeftPressed := LeftButton;
                   End;
              End;
          4 : Begin
                   Dec(FadeFinishPercent);
                   ShowFadePercent;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                        Dec(FadeFinishPercent);
                        ShowFadePercent;
                        VertWait;
                        LeftPressed := LeftButton;
                   End;
              End;
     End;
     vrestoremouse;
     vsetmousecoor(OMX,OMY);
End;

Procedure FadeProcess;
Var
   Percent,
   LastPercent  : Byte;
   SDummy,
   Slen,
   PLen,
   SStart,
   SEnd,
   Sptr         :LongInt;
   Stemp        :Byte;
   FadeLen      :LongInt;
   FadeDif      :Integer;
   Buffer       :Pointer;
   _handle      :Word;
   BufSize      :Word;
   WPtr         :Word;
Begin

     Stemp := BlockBox('Fade which part of the sample ?');

     if Stemp <> _CANCEL then
     Begin
          BufSize := _16KB;
          if MemAvail < Bufsize then BufSize := MemAvail;
          SStart := 0;
          SEnd   := SampleInfo[ActiveSample].Length;
          if Stemp = _BLOCK then
          Begin
               SStart := BlockStart;
               SEnd   := BlockEnd;
          End;
          Slen := SEnd - SStart;
          if Slen > 0 then
          Begin
               Plen := 0;
               FadeDif := FadeFinishPercent - FadeStartPercent;
               if FadeDif <> 0 then
                  FadeLen := SLen div Abs(FadeDif)
               else
                   FadeLen := Slen;
                   GetMem(Buffer,BufSize);
                   _handle := SampleInfo[ActiveSample].EMSHandle;
                   StatusBox('Fading...',0);
                   LastPercent := 0;
                   For Sptr := 0 to Abs(FadeDif) do
                   Begin
                        if FadeLen < BufSize then
                   Begin
                        BlockPeek(_handle,SStart div _16KB,SStart mod _16KB,FadeLen,Buffer);
                        BlockVolumeSet(FadeLen,Buffer,FadeStartPercent+Sign(FadeDif)*Sptr);
                        BlockPoke(_handle,SStart div _16KB,SStart mod _16KB,FadeLen,Buffer);
                        SStart := SStart + FadeLen;
                        Plen := PLen + FadeLen;
                        Percent := Plen div (Slen div 100);
                        if Percent <> LastPercent then
                        Begin
                             StatusBox('',Percent);
                             LastPercent := Percent;
                        End;
                   End
                   else
                   Begin
                        SDummy := SStart+FadeLen;
                        For Wptr := 1 to (FadeLen div BufSize) do
                        Begin
                             BlockPeek(_handle,SStart div _16KB,SStart mod _16KB,BufSize,Buffer);
                             BlockVolumeSet(BufSize,Buffer,FadeStartPercent+Sign(FadeDif)*Sptr);
                             BlockPoke(_handle,SStart div _16KB,SStart mod _16KB,BufSize,Buffer);
                             SStart := SStart + BufSize;
                             Plen := PLen + BufSize;
                             Percent := Plen div (Slen div 100);
                             if Percent <> LastPercent then
                             Begin
                                  StatusBox('',Percent);
                                  LastPercent := Percent;
                             End;
                        End;
                        if SStart < SDummy then
                        Begin
                             BlockPeek(_handle,SStart div _16KB,SStart mod _16KB,SDummy-SStart,Buffer);
                             BlockVolumeSet(Sdummy-SStart,Buffer,FadeStartPercent+Sign(FadeDif)*Sptr);
                             BlockPoke(_handle,SStart div _16KB,SStart mod _16KB,SDummy-SStart,Buffer);
                             Plen := Plen + SDummy - SStart;
                             Percent := Plen div (Slen div 100);
                             if Percent <> LastPercent then
                             Begin
                                  StatusBox('',Percent);
                                  LastPercent := Percent;
                             End;
                             SStart := SDummy;
                        End;
                   End;
               End;
               if SStart < SEnd then
               Begin
                    BlockPeek(_handle,SStart div _16KB,SStart mod _16KB,SEnd-SStart,Buffer);
                    BlockVolumeSet(SEnd-SStart,Buffer,FadeFinishPercent);
                    BlockPoke(_handle,SStart div _16KB,SStart mod _16KB,SEnd-SStart,Buffer);
               End;
               if StatusBoxActive then StatusBox('',100);
               FreeMem(Buffer,BufSize);
          End;
     End;
End;

Procedure Fade;
Var
   OldTreePtr : Byte;
Begin
     if ActiveSample = 0 then
        OKBox('No sample selected.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
        OKBox('Cell is empty.')
     else
     Begin
          Bussy;
          PushMouse;
          lx1 := HALFMAXX - 14*CharW;
          lx2 := HALFMAXX + 14*CharW;
          ly1 := HALFMAXY - 7*CharH;
          ly2 := HALFMAXY + 7*CharH;
          SaveScreen(lx1,ly1,lx2,ly2);
          MsgBox(lx1,ly1,lx2,ly2,blue,blue+4);
          Inc(TreeLevel);
          OldTreePtr := TreePtr[TreeLevel];
          ButtonPrint(lx1+CharW,ly2-CharH*3,'OK',6,Black,Green,False,OK,NoNo);
          ButtonPrint(lx2-CharW*8,ly2-CharH*3,'CANCEL',6,Black,Red,False,Cancel,NoNo);
          ButtonPrint(lx1+CharW*3 ,ly1+CharH*5,Chr(30),3,Black,Gray,False,FadePerChange,1);
          ButtonPrint(lx1+CharW*3 ,ly1+CharH*8,Chr(31),3,Black,Gray,False,FadePerChange,2);
          ButtonPrint(lx1+CharW*21,ly1+CharH*5,Chr(30),3,Black,Gray,False,FadePerChange,3);
          ButtonPrint(lx1+CharW*21,ly1+CharH*8,Chr(31),3,Black,Gray,False,FadePerChange,4);
          SetColor(Black+31);
          OutTextXY(HALFMAXX - 8*CharW,ly1+CharH+CharH div 2,'Volume by Percent');
          OutTextXY(lx1+CharW*2+CharW div 2,ly1+CharH*4,'Start');
          OutTextXY(lx2-CharW*8,ly1+CharH*4,'Finish');
          ShowFadePercent;
          vrestoremouse;
          vsetmousecoor(lx2-CharW*4,ly2-CharH*3);
          Okay := False;
          Canceled := False;

          NotBussy;
          Repeat
                if ProcNo = 2 then
                Begin
                     Bussy;
{
                     MainProc[ProcNo];
                     MainProc[ProcNo] := Nothing;
                     ProcNo := 1;
}
                     Kernel;
                     NotBussy;
                End;
          Until (Okay) or (Canceled);
          Bussy;
          if (Okay) then FadeProcess;
          TreePtr[TreeLevel] := OldTreePtr;
          Dec(TreeLevel);
          RestoreScreen;
          if Okay then Analyser;
          PopMouse;
          NotBussy;
     End;
     ButtonPos := False;
End;

Procedure MixSampleSelect;
Begin
     SetColor(Black+31);
     MixSample2 := ((MouseY div (CharH*2) - 3)*7) + (MouseX div (CharW*9))+1;
     if MixSample2 > MaxSample then MixSample2 := 0
     else
     if  SampleInfo[MixSample2].Length=0 then MixSample2 := 0
     else
     if  MixSample2 = ActiveSample then MixSample2 := 0;
     SetFillStyle(SolidFill,Blue+4);
     Bar(HALFMAXX-CharW*4,ly1+CharH*5,HALFMAXX+CharH*4,ly1+CharH*6);
     if MixSample2 > 0 then
     OutTextXY(HALFMAXX-CharW*4,ly1+CharH*5,Center(Strip(SampleInfo[MixSample2].Name),8,' '));
End;

Procedure MixPercentShow;
Begin
     vRestoreMouse;
     if MixPercent > 999 then MixPercent :=   1;
     if MixPercent < 1   then MixPercent := 999;
     SetColor(Black+31);
     SetFillStyle(SolidFill,Black);
     Bar(lx1+CharW*12,ly2-CharH*3,lx1+CharW*16,ly2-CharH*1);
     OutTextXY(lx1+CharW*12,ly2-Round(CharH*2.5),S(MixPercent,3,TRUE)+'%');
     vPutMouse;
End;

Procedure MixPercentSet;
Var
   LeftPressed : Boolean;
   OMX,
   OMY         : Word;
Begin
     OMX := MouseX;
     OMY := MouseY;
     Case GlobalNo of
          1 : Begin
                   if RightButton then
                      MixPercent := MixPercent + (999 - MixPercent) div 2
                   else
                       Inc(VolPercent);
                   MixPercentShow;
                   Delay(100);
                   LeftPressed := LeftButton;
                   While LeftPressed do
                   Begin
                        Inc(MixPercent);
                        MixPercentShow;
                        VertWait;
                        LeftPressed := LeftButton;
                   End;
             End;
          2 : Begin
                   if RightButton then
                      MixPercent := MixPercent - (MixPercent - 2) div 2
                   else
                      Dec(MixPercent);
                   MixPercentShow;
                   Delay(100);
                   LeftPressed := Leftbutton;
                   While LeftPressed do
                   Begin
                        Dec(MixPercent);
                        MixPercentShow;
                        VertWait;
                        LeftPressed := LeftButton;
                   End;
              End;
     End;
     vRestoreMouse;
     vsetmousecoor(OMX,OMY);
     ButtonPos := False;
End;

Procedure MixProcess;
Var
   Buffer1,
   Buffer2      :Pointer;
   DB           :Byte;
   MixIt        :Boolean;
   SStart,
   SEnd,
   SLen,
   PLen         :LongInt;
   BufSize      :Word;
   ReadTo       :Word;
   _handle1,
   _handle2     :Word;
   Percent,
   LastPercent  :Byte;
Begin

     MixIt := TRUE;
     if SampleInfo[MixSample1].Length < SampleInfo[MixSample2].Length then
        MixIt := AskBox('Swapping Samples.');
     if MixIt then
     Begin
          BufSize := _16KB;
          if MemAvail < 2*BufSize then BufSize := MemAvail div 2;
          if SampleInfo[MixSample1].Length < SampleInfo[MixSample2].Length then
          Begin
               DB := MixSample1;
               MixSample1 := MixSample2;
               MixSample2 := DB;
          End;
          SStart := 0;
          SEnd   := SampleInfo[MixSample2].Length;
          SLen   := SEnd - SStart;
          Plen   := 0;
          GetMem(Buffer1,BufSize);
          GetMem(Buffer2,BufSize);
          _handle1 := SampleInfo[MixSample1].EMSHandle;
          _handle2 := SampleInfo[MixSample2].EMSHandle;
          StatusBox('Mixing...',0);
          LastPercent := 0;
          Repeat
                if SEnd - SStart > BufSize then
                   ReadTo := BufSize
                else
                    ReadTo := SEnd - SStart;
                BlockPeek(_handle1,SStart div _16KB,SStart mod _16KB,ReadTo,Buffer1);
                BlockPeek(_handle2,SStart div _16KB,SStart mod _16KB,ReadTo,Buffer2);
                BlockMix(ReadTo,Buffer2,Buffer1,SampleInfo[MixSample1].Signed,
                         SampleInfo[MixSample2].Signed,MixPercent);
                BlockPoke(_handle1,SStart div _16KB,SStart mod _16KB,ReadTo,Buffer2);
                SStart := SStart + ReadTo;
                Plen := Plen + ReadTo;
                Percent := Plen div (Slen div 100);
                if Percent <> LastPercent then
                Begin
                     StatusBox('',Percent);
                     LastPercent := Percent;
                End;
          Until SStart = SEnd;
          if StatusBoxActive then StatusBox('',100);
          FreeMem(Buffer2,BufSize);
          FreeMem(Buffer1,BufSize);
     End;
End;

Procedure Mix;
Var
   OldTreePtr : Byte;
Begin
     if ActiveSample = 0 then
        OKBox('No cell selected.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
        OKBox('Cell is empty.')
     else
     Begin
        Bussy;
        PushMouse;
        lx1 := HALFMAXX - 14*CharW;
        lx2 := HALFMAXX + 14*CharW;
        ly1 := HALFMAXY;
        ly2 := HALFMAXY+10*CharH;
        SaveScreen(lx1,ly1,lx2,ly2);
        MsgBox(lx1,ly1,lx2,ly2,Blue,Blue+4);
        Inc(TreeLevel);
        OldTreePtr := TreePtr[TreeLevel];
        ButtonPrint(lx1+CharW,ly2-CharH*3,'MIX',6,Black,Green,False,OK,NoNo);
        ButtonPrint(lx2-CharW*8,ly2-CharH*3,'CANCEL',6,Black,Red,False,CANCEL,NoNo);
        ButtonPrint(lx1+CharW*10,ly2-CharH*3,chr(17),1,Black,Gray,False,MixPercentSet,1);
        ButtonPrint(lx1+CharW*16,ly2-CharH*3,chr(16),1,Black,Gray,False,MixPercentSet,2);
        MixSample1 := ActiveSample;
        MixSample2 := 0;
        SetColor(Black+16);
        OutTextXY(HALFMAXX-Round(CharW*1.5),ly1+CharH*2,'Mix');
        SetColor(Black+31);
        OutTextXY(HALFMAXX-CharW*4,ly1+CharH*3,Center(Strip(SampleInfo[MixSample1].Name),8,' '));
        SetColor(Black+16);
        OutTextXY(HALFMAXX-CharW*2,ly1+CharH*4,'With');
        RegisterWindow(0,CharH*6,9*CharW*7,CharH*16,MixSampleSelect);
        MixPercentShow;
        vRestoreMouse;
        vsetmousecoor(lx2-CharW*4,ly2-CharH*3);
        Okay := False;
        Canceled := False;
        NotBussy;
        Repeat
              if ProcNo = 2 then
              Begin
                   Bussy;
{
                   MainProc[ProcNo];
                   MainProc[ProcNo] := Nothing;
                   ProcNo := 1;
}
                   Kernel;

                   NotBussy;
              End;
        Until (Okay) or (Canceled);
        Bussy;
        if (Okay) and (MixSample2 <> 0) then MixProcess;
        TreePtr[TreeLevel] := OldTreePtr;
        Dec(TreeLevel);
        RestoreScreen;
        if Okay then Analyser;
        PopMouse;
        NotBussy;
     End;
     ButtonPos := False;
End;

Procedure _Copy_;
Var
   CopyFile     :File;
   CopySize     :LongInt;
   OrgSize      :LongInt;
   Buffer       :Pointer;
   BufSize      :Word;
   dhandle      :Word;
   Start        :LongInt;
   Percent,
   LastPercent  :Byte;
   ReadTo       :Word;
Begin
     if ActiveSample = 0 then
        OKBox('No sample cell selected.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
        OKBox('Cell is empty.')
     else
     Begin
          CopySize := BlockEnd - BlockStart;
          if CopySize = 0 then
             OKBox('Block is empty.')
          else
          if DiskFree(0) < CopySize then
             OKBox('No space for copy file.')
          else
          Begin
               {$I-}
               Assign(CopyFile,ClearSlash(TempPath+'LONGPCPY.$$$'));
               ReWrite(CopyFile,1);
               {$I+}
               if IOResult <> 0 then
                  OKBox('Problems while creating copy file.')
               else
               Begin
                    Bussy;
                    OrgSize := CopySize;
                    BufSize := _16KB;
                    if MemAvail < BufSize then BufSize := MemAvail;
                    dhandle := SampleInfo[ActiveSample].EMSHandle;
                    Start := BlockStart;
                    GetMem(Buffer,BufSize);
                    StatusBox('Copying...',0);
                    LastPercent := 0;
                    While CopySize > 0 do
                    Begin
                          BlockPeek(dhandle,Start div _16KB,Start mod _16KB,BufSize,Buffer);
                          if CopySize > BufSize then
                             ReadTo := BufSize
                          else
                             ReadTo := CopySize;
                          BlockWrite(CopyFile,Buffer^,ReadTo);
                          CopySize := CopySize - ReadTo;
                          Percent := (Orgsize - Copysize) div (OrgSize div 100);
                          if Percent <> LastPercent then
                          Begin
                               StatusBox('',Percent);
                               LastPercent := Percent;
                          End;
                          Start := Start + BufSize;
                    End;
                    if StatusBoxActive then StatusBox('',100);
                    FreeMem(Buffer,BufSize);
                    NotBussy;
               End;
               Close(CopyFile);
          End;
     End;
     ButtonPos := False;
End;

Procedure Del;
Var
   BufSize      : Word;
   Buffer       : Pointer;
   DelLen,
   Sptr1,
   Sptr2        : LongInt;
   _handle      : Word;
   newpages     : Word;
Begin
     if ActiveSample = 0 then
        OKBox('No sample selected.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
        OKBox('Cell is Empty')
     else
     if (BlockStart = 0) and (BlockEnd = SampleInfo[ActiveSample].Length) then
        OKBox('To delete whole sample use FREE button')
     else
     Begin
          Bussy;
          BufSize := _16KB;
          if MemAvail < BufSize then BufSize := MemAvail;
          _handle := SampleInfo[ActiveSample].EMSHandle;
          DelLen := BlockEnd - BlockStart;
          if (DelLen > 0) and AskBox('Deleting block.Are you sure ?') then
          Begin
               GetMem(Buffer,BufSize);
               Sptr2 := BlockStart;
               For Sptr1 := 0 to ((SampleInfo[ActiveSample].Length-BlockStart) div BufSize) do
               Begin
                    BlockPeek(_handle,(Sptr2+Dellen) div _16KB,(Sptr2+Dellen) mod _16KB,BufSize,Buffer);
                    BlockPoke(_handle,Sptr2 div _16KB,Sptr2 mod _16KB,BufSize,Buffer);
                    Sptr2 := Sptr2 + BufSize;
               End;
               SampleInfo[ActiveSample].Length := SampleInfo[ActiveSample].Length - Dellen;
               BlockEnd := SampleInfo[ActiveSample].Length;
               if Position > BlockEnd then Position := BlockEnd;
               SampleInfo[ActiveSample].BlockEnd := BlockEnd;
               SampleInfo[ActiveSample].Pos := Position;
               newpages := SampleInfo[ActiveSample].Length div _16KB + 1;
               Asm
                  mov ah,51h
                  mov dx,_handle
                  mov bx,newpages
                  int 67h
               end;
               SetSampleInfo;
               ShowSampleInfo;
               Analyser;
               FreeMem(Buffer,BufSize);
          End;
          NotBussy;
     End;
     ButtonPos := False;
End;

Procedure Blank;
Var
   Selection : Byte;
   Sptr      : LongInt;
   SStart    : LongInt;
   Slen      : LongInt;
   Send      : LongInt;
   Spage     : Word;
   LastPercent,
   Percent   : Byte;
Begin
     if ActiveSample = 0 then
        OKBox('No sample cell selected.')
     else
     if SampleInfo[ActiveSample].Length < 2 then
        OKBox('Nothing to blank.')
     else
     Begin

          Selection := BlockBox('Blank selected block or whole sample.[no UNDO]');
          if Selection <> _CANCEL then
          Begin
               Bussy;
               SStart := 0;
               SEnd   := SampleInfo[ActiveSample].Length;
               if Selection = _BLOCK then
               Begin
                    SStart := BlockStart;
                    SEnd   := BlockEnd;
               End;
               StatusBox('Working...',0);
               Slen := SEnd - SStart;
               if SLen <= $FFFF then
                    FillEMSPage(SampleInfo[ActiveSample].EMSHandle,SStart div _16KB,SStart,SLen,BLANKByte)
               else
               Begin
                    if (SStart mod _64KB) <> 0 then
                    Begin
                         FillEMSPage(SampleInfo[ActiveSample].EMSHandle,SStart div _16KB,SStart mod _64KB,
                         (_64KB-(SStart mod _64KB)),BLANKBYTE);
                         Percent := (_64KB-(SStart Mod _64KB)) div (Slen Div 100);
                         if (Percent > 0) and (Percent<100) then
                            StatusBox('',Percent);
                         Slen := Slen - (_64KB-(SStart mod _64KB));
                         SStart := SStart+(_64KB-(SStart mod _64KB));
                    End;
                    if (SEnd mod _64KB) <> 0 then
                    Begin
                         FillEMSPage(SampleInfo[ActiveSample].EMSHandle,(SEnd - (Send mod _64KB)) div _16KB,
                         (SEnd - (SEnd mod _64KB)) mod _64KB,SEnd Mod _64KB,BLANKBYTE);
                         Percent := (Send Mod _64KB) div (SLen div 100);
                         if (Percent>0) and (Percent<100) then
                            StatusBox('',Percent);
                         SLen := Slen - (Send Mod _64KB);
                         SEnd := SEnd - (SEnd mod _64KB) - 1;
                    End;
                    if (SEnd - SStart) > 0 then
                    Begin
                         For SPage := (SStart div _16KB) to (SEnd div _16KB) do
                         Begin
                              FillEMSPage(SampleInfo[ActiveSample].EMSHandle,SPage,0,$FFFF,BLANKBYTE);
                              if Slen > 99 then
                              Begin
                                 Percent := 50+_64KB div (Slen div 100);
                                 If (Percent>0) and (Percent<100) then
                                    StatusBox('',Percent);
                              End;
                              Slen := Slen - _64KB;
                         End;
                    End;
               End;
               if StatusBoxActive then StatusBox('',100);
               Analyser;
               NotBussy;
          End;
     End;
     ButtonPos := False;
End;

Procedure Paste;
Var
   PasteFile    :File;
   SStart,
   SEnd,
   SSize        :LongInt;
   dhandle      :Word;
   NewPages     :Word;
   Buffer1      :Pointer;
   Buffer2      :Pointer;
   BufSize      :Word;
   PSize1,
   PSize2       :LongInt;
   Percent,
   LastPercent  :Byte;
Begin
     Bussy;
     if ActiveSample = 0 then
        OKBox('No cell selected.')
     else
     if SampleInfo[ActiveSample].Length = 0 then
        OKBox('Cell is empty.Nothing to paste to')
     else
     Begin
          {$I-}
          Assign(PasteFile,ClearSlash(TempPath+'LONGPCPY.$$$'));
          Reset(PasteFile,1);
          {$I-}
          If IOResult <> 0 then
             OKBox('No copy file found.')
          else
          Begin
               Asm
                  mov ah,42h
                  int 67h
                  mov FreeEMS,bx
               End;
               SSize := FreeEMS;
               SSize := SSize * _16KB;
               if FileSize(PasteFile) > SSize then
                  OKBox('No memory to paste.')
               else
               Begin
                    dhandle := SampleInfo[ActiveSample].EMSHandle;
                    newpages := (SampleInfo[ActiveSample].Length + FileSize(PasteFile)) div _16KB;
                    Inc(NewPages);
                    Asm
                       mov ah,51h
                       mov dx,dhandle
                       mov bx,newpages
                       int 67h
                    End;
                    BufSize := _16KB;
                    if MemAvail < BufSize*2 then BufSize := MemAvail div 2;
                    GetMem(Buffer1,BufSize);
                    SStart := SampleInfo[ActiveSample].BlockEnd;
                    SEnd   := SampleInfo[ActiveSample].Length + FileSize(PasteFile);
                    SSize := SStart - Position;
                    PSize1 := SSize + FileSize(PasteFile);
                    PSize2 := 0;
                    LastPercent := 0;
                    StatusBox('Processing...',0);
                    While SSize > BufSize do
                    Begin
                         BlockPeek(dhandle,(SStart - BufSize) div _16KB,(SStart - BufSize) mod _16KB,BufSize,Buffer1);
                         BlockPoke(dhandle,(SEnd - BufSize) div _16KB  ,(Send - BufSize) mod _16KB,BufSize,Buffer1);
                         SSize := SSize - BufSize;
                         SStart := SStart - BufSize;
                         SEnd := SEnd - BufSize;
                         PSize2 := PSize2 + Bufsize;
                         Percent := PSize2 div (PSize1 div 100);
                         if Percent <> LastPercent then
                         Begin
                              StatusBox('',Percent);
                              LastPercent := Percent;
                         End;
                    End;
                    if SSize > 0 then
                    Begin
                         BlockPeek(dhandle,(SStart - SSize) div _16KB,(SStart - SSize) mod _16KB,SSize,Buffer1);
                         BlockPoke(dhandle,(SEnd - SSize) div _16KB,(Send - SSize) mod _16KB,SSize,Buffer1);
                         SStart := SStart - SSize;
                         SEnd := SEnd - SSize;
                         PSize2 := PSize2 + SSize;
                         Percent := PSize2 div (PSize1 div 100);
                         if Percent <> LastPercent then
                         Begin
                              StatusBox('',Percent);
                              LastPercent := Percent;
                         End;
                         SSize := 0;
                    End;
                    SSize := FileSize(PasteFile);
                    While SSize > BufSize do
                    Begin
                         BlockRead(PasteFile,Buffer1^,BufSize);
                         BlockPoke(dhandle,SStart div _16KB,SStart mod _16KB,BufSize,Buffer1);
                         SStart := SStart + BufSize;
                         SSize := SSize - BufSize;
                         PSize2 := PSize2 + BufSize;
                         Percent := PSize2 div (PSize1 div 100);
                         if Percent <> LastPercent then
                         Begin
                              StatusBox('',Percent);
                              LastPercent := Percent;
                         End;
                    End;
                    if SSize > 0 then
                    Begin
                         BlockRead(PasteFile,Buffer1^,SSize);
                         BlockPoke(dhandle,SStart div _16KB,SStart mod _16KB,SSize,Buffer1);
                         SStart := SStart + SSize;
                         PSize2 := PSize2 + SSize;
                         Percent := PSize2 div (PSize1 div 100);
                         if Percent <> LastPercent then
                         Begin
                              StatusBox('',Percent);
                              LastPercent := Percent;
                         End;
                         SSize := 0;
                    End;
                    if StatusBoxActive then StatusBox('',100);
                    FreeMem(Buffer1,BufSize);
                    SampleInfo[ActiveSample].Length := SampleInfo[ActiveSample].Length + FileSize(PasteFile);
                    SampleInfo[ActiveSample].BlockEnd := BlockEnd + FileSize(PasteFile);
                    SetSampleInfo;
                    ShowSampleInfo;
                    Analyser;
               End;
               Close(PasteFile);
          End;
     End;
     NotBussy;
     ButtonPos := False;
End;

Procedure CntrSet;
Var
   Y : Word;
Begin
     Bussy;
     Case GlobalNo of
          1 : Begin
                   Twin := False;
                   SampleInfo[ActiveSample].Twin := False;
                   SampleInfo[ActiveSample].Cntr := 1;
                   _maxcntr := 1;
                   cntr1 := True;
                   cntr2 := False;
                   cntr3 := False;
              End;
          2 : Begin
                   Twin := True;
                   SampleInfo[ActiveSample].Twin := True;
                   SampleInfo[ActiveSample].Cntr := 2;
                   _maxcntr := 2;
                   cntr1 := False;
                   cntr2 := True;
                   cntr3 := False;
              End;
          3 : Begin
                   Twin := True;
                   SampleInfo[ActiveSample].Twin := True;
                   SampleInfo[ActiveSample].Cntr := 3;
                   _maxcntr := 3;
                   cntr1 := False;
                   cntr2 := False;
                   cntr3 := True;
              End;
     End;
     Y := MAXY-256-CharH*6;
     BoxPrint(55*CharW,Y,'1',1,Blue+31,Gray,Cntr1);
     BoxPrint(57*CharW,Y,'2',1,Blue+31,Gray,Cntr2);
     BoxPrint(59*CharW,Y,'3',1,Blue+31,Gray,Cntr3);
     ButtonPos := True;
     NotBussy;
End;

Procedure ShowBitMap;
Var
   bx,by        :Word;
   w,
   h            :Word;

Begin
     w  := 25*CharW;
     h  := 19*CharH;
     if BmpArray[BackBmp].W < W then W := BmpArray[BackBmp].W;
     if BmpArray[BackBmp].H < H then H := BmpArray[BackBmp].H;
     bx := HALFMAXX-(w div 2);
{
     by := HALFMAXY-(h div 2)-3*CharH;
}
     by := ly1+CharH;
     SetFillStyle(SolidFill,Blue+4);
     Bar(lx1+(CharW div 2),ly1+(CharH div 2),lx2-(CharW div 2),ly2-CharH*5);
     FillBmp(bx,by+1,bx+w+1,by+h,BackBmp);
     BoxPrint(HALFMAXX-CharW*2,ly2-CharH*3,S(BackBmp,3,TRUE),3,Black,Gray,BmpArray[BackBmp].Found);
End;

Procedure SelectBitMap;
Begin
     case GlobalNo of
          1 : Dec(BackBmp);
          2 : Inc(BackBmp);
     End;
     if BackBmp = $FF then BackBmp := MaxBmp;
     if BackBmp > MaxBmp then BackBmp := 0;
     ButtonPos := False;
End;
Procedure SetBitMap;
Var
   OldTreePtr : Byte;
   OldBackBmp : Byte;
Begin
     Bussy;
     PushMouse;
     OldBackBmp := BackBmp;
     lx1 := HALFMAXX - 15*CharW;
     lx2 := HALFMAXX + 15*CharW;
     ly1 := HALFMAXY - 15*CharH;
     ly2 := HALFMAXY + 10*CharH;
     SaveScreen(lx1,ly1,lx2,ly2);
     MsgBox(lx1,ly1,lx2,ly2,Blue,Blue+4);
     Inc(TreeLevel);
     OldTreePtr := TreePtr[TreeLevel];
     ButtonPrint(lx1+CharW,ly2-CharH*3,'OK',6,Black,Gray,False,OK,NoNo);
     ButtonPrint(lx2-CharW*8,ly2-CharH*3,'CANCEL',6,Black,Gray,False,CANCEL,NoNo);
     ButtonPrint(lx1+CharW*1,ly2-CharH*5,chr(17),2,Black+31,Gray,False,SelectBitMap,1);
     ButtonPrint(lx2-CharW*4,ly2-CharH*5,chr(16),2,Black+31,Gray,False,SelectBitMap,2);
     vsetmousecoor(lx2-CharW*4,ly2-CharH*2);
     Okay := False;
     Canceled := False;
     ShowBitMap;
     NotBussy;
     Repeat
           if ProcNo = 2 then
           Begin
                Bussy;
                KerNel;
                ShowBitMap;
                NotBussy;
           End;
     Until (OKay) or (Canceled);
     Bussy;
     TreePtr[TreeLevel] := OldTreePtr;
     Dec(TreeLevel);
     RestoreScreen;
     PopMouse;
     if Okay then
     Begin
         OldBackBmp := BackBmp;
         DisableVGA;
         TreeClear;
         ScreenInitialize;
         TreeLevel := 0;
         EnableVGA;
     End;
     BackBmp := OldBackBmp;
     NotBussy;
     ButtonPos := False;
End;

{$F-}

Procedure ScreenInitialize;
Var
   i,j  :Byte;
   OldBussy : Byte;
Begin
     OldBussy := BussyState;
     Bussy;
{
     SetFillStyle(SolidFill,Gray+2);
     Bar(0,0,MAXX,MAXY);
}
     FillBmp(0,0,MAXX,MAXY,BackBmp);
     BoxPrint(0,0,'LongPlay V'+Version+' Copyright (c) 1994 Huseyin Nakturk ',
     MAXCX-1,Black+31,Blue,False);
     DummyWord := CharH*3;
     ButtonPrint(       0,DummyWord,'>' ,7,Black,Gray,Playing,Play   ,NoNo);
     ButtonPrint(CharW* 8,DummyWord,'<I',3,Black,Gray,False  ,Rewind ,NoNo);
     ButtonPrint(CharW*12,DummyWord,'' ,3,Black,Gray,False  ,ToStart,NoNo);
     ButtonPrint(CharW*16,DummyWord,'' ,3,Black,Gray,False  ,ToEnd  ,NoNo);
     ButtonPrint(CharW*20,DummyWord,'I>',3,Black,Gray,False  ,Frward ,NoNo);

     DeviceButton := TreePtr[TreeLevel];
     ButtonPrint(MAXX-CharW*47,DummyWord,DeviceInfo[Device].Name,16,Black,Gray,False ,DeviceSet,NoNo);
     ButtonPrint(MAXX-CharW*30,DummyWord,'Load',5,Black+31,Red,False  ,Load   ,NoNo);
     ButtonPrint(MAXX-CharW*24,DummyWord,'Save',5,Black+31,Red,False  ,Save   ,NoNo);
     ButtonPrint(MAXX-CharW*18,DummyWord,'Free',5,Black+31,Red,False  ,Free   ,NoNo);
     ButtonPrint(MAXX-CharW*10,CharH*6 , '640x480',9,Black,Turquise,V640 ,V640X480 ,NoNo);
     ButtonPrint(MAXX-CharW*10,CharH*8 , '800x600',9,Black,Turquise,V800 ,V800X600 ,NoNo);
     ButtonPrint(MAXX-CharW*10,CharH*10,'1024X768',9,Black,Turquise,V1024,V1024x768,NoNo);
     ButtonPrint(CharW*26,CharH*3 ,'OSILO'   ,6,Green+31,Gray    ,ShowOsilo,SetOsilo,NoNo);

     ButtonPrint(MAXX-CharW*10,CharH*12,   '1',4,Black,Gray,Inc1   ,IncSet,1);
     ButtonPrint(MAXX-CharW*5 ,CharH*12,  '10',4,Black,Gray,Inc10  ,IncSet,2);
     ButtonPrint(MAXX-CharW*10,CharH*14, '100',4,Black,Gray,Inc100 ,IncSet,3);
     ButtonPrint(MAXX-CharW*5 ,CharH*14,'1000',4,Black,Gray,Inc1000,IncSet,4);

     ButtonPrint(MAXX-CharW*6 ,DummyWord,'Quit' ,5,Black+31,Green,False,Quit ,NoNo);
     ButtonPrint(MAXX-CharW*12,DummyWord,'About',5,Black+31,Green,False,About,NoNo);

     DummyWord := MAXY-256-CharH*6;
     ButtonPrint(11*CharW,DummyWord,Chr(16),1,Red+31,Gray,False,BlockStartUp   ,NoNo);
     ButtonPrint( 0*CharW,DummyWord,Chr(17),1,Red+31,Gray,False,BlockStartDown ,NoNo);
     ButtonPrint(31*CharW,DummyWord,Chr(30),1,Red+31,Gray,False,RateUp         ,NoNo);
     ButtonPrint(40*CharW,DummyWord,Chr(31),1,Red+31,Gray,False,RateDown       ,NoNo);
     ButtonPrint(42*CharW,DummyWord,Chr(30),1,Red+31,Gray,False,VolumeUp       ,NoNo);
     ButtonPrint(49*CharW,DummyWord,Chr(31),1,Red+31,Gray,False,VolumeDown     ,NoNo);
     ButtonPrint(MAXX-CharW* 2,DummyWord,Chr(16),1,Red+31,Gray,False,BlockEndUp,NoNo);
     ButtonPrint(MAXX-CharW*13 ,DummyWord,Chr(17),1,Red+31,Gray,False,BlockEndDown,NoNo);
     ButtonPrint(55*CharW,DummyWord,'1',1,Blue+31,Gray,Cntr1,CntrSet,1);
     ButtonPrint(57*CharW,DummyWord,'2',1,Blue+31,Gray,Cntr2,CntrSet,2);
     ButtonPrint(59*CharW,DummyWord,'3',1,Blue+31,Gray,Cntr3,CntrSet,3);
     ButtonPrint(61*CharW,DummyWord,'zOOm',5,Blue+31,Gray,Zoomed,ZoomSet,NoNo);
     ButtonPrint(51*CharW,DummyWord,'+/-',3,Blue+31,Gray,Signed,SignSet,NoNo);
     DummyWord := MAXY-256-CharH*10;
     ButtonPrint(       0,DummyWord,'Reverse' ,8,Black,Gray  ,False,Reverse,NoNo);
     ButtonPrint( 9*CharW,DummyWord,'Echo'    ,8,Black,Gray  ,False,Echo,NoNo);
     ButtonPrint(18*CharW,DummyWord,'Volume'  ,8,Black,Gray  ,False,VolumeSet,NoNo);
     ButtonPrint(27*CharW,DummyWord,'Fade'    ,8,Black,Gray  ,False,Fade,NoNo);
     ButtonPrint(36*CharW,DummyWord,'Mix'     ,8,Black,Gray  ,False,Mix,Nono);
     ButtonPrint(45*CharW,DummyWord,'Delete'  ,8,Black,Gray  ,False,Del,NoNo);
     ButtonPrint(54*CharW,DummyWord,'Blank'   ,8,Black,Gray  ,False,Blank,NoNo);
     ButtonPrint(63*CharW,DummyWord,'Copy'    ,8,Black,Gray  ,False,_Copy_,NoNo);
     ButtonPrint(72*CharW,DummyWord,'Paste'   ,7,Black,Gray  ,False,Paste,NoNo);
     DummyWord := MAXY-256-CharH*12;
     ButtonPrint(       0,DummyWord,'Bitmap'  ,8,Black,Gray  ,False,SetBitMap,NoNo);
     ShowSampleInfo;
     MsgBox(0,MaxY-256-CharH*4,MAXX,MAXY-CharH*2,Black,Black);

     SetColor(Yellow+31);
     MoveTo(CharW,Maxy-128-CharH*3);
     LineRel(MAXX-CharW*2,0);

     SampleBase := TreePtr[TreeLevel];
     For i := 0 to (MaxSample div 7)-1 do
     Begin
          For j := 1 to 7 do
          Begin
              ButtonPrint(9*(j-1)*CharW,(CharH*6)+i*CharH*2,
              SampleInfo[(i*7)+j].Name,8,Yellow+31,Blue,SampleInfo[(i*7)+j].Active,
              SampleSelect,(i*7)+j);
          End;
     End;
     DummyWord := MAXY-256-Round(CharH*7.5);
     BoxPrint(0,MAXY-256-CharH*8,' ',MAXCX-1,Turquise+31,Gray,False);
     SetColor(Blue+16);
     OuttextXY(Round(CharW* 4.5),DummyWord,'start');
     OuttextXY(Round(CharW*14.5),DummyWord,'length');
     OuttextXY(Round(CharW*22.5),DummyWord,'position');
     OuttextXY(Round(CharW*34.5),DummyWord,'rate');
     OuttextXY(Round(CharW*43),DummyWord,'magnify');
     outtextXY(Round(CharW*(MAXCX-8)),DummyWord,'end');
     EMSInfo;
     Analyser;
     if OldBussy = 0 then NotBussy;
End;


Procedure VARInitialize;
Begin
     BackBmp      := 0;
     LoadFile     := '';
     EchoDelay    := 1000;
     EchoPercent  := 100;
     MixPercent   := 50;
     FadeStartPercent  := DefaultFadeSPer;
     FadeFinishPercent := DefaultFadeFPer;
     ShowOsilo    := True;
     Handler      := Ofs(PCHandler);
     LPT1         := memw[$0040:$0008];
     LPT2         := memw[$0040:$000A];
     osiloorgx    := 100;
     osiloorgy    := 300;
     _osilooff    := 300+80;
     _osilowidth  := 64;
     _osilolen    := 160;
     osilox       := 172+80;
     osiloy       := 204;
     _maxcntr     := DefaultCntr;
     cntr1 := False;
     cntr2 := False;
     cntr3 := False;
     Case _maxcntr of
          1 : Cntr1 := True;
          2 : Cntr2 := True;
          3 : Cntr3 := True;
     End;
     Rate         := DefaultRate;
     Volume       := DefaultVolume;
     Twin         := True;
     Position     := 0;
     SampleLen    := 0;
     ActiveSample := 0;
     GlobalNo     := NoNo;
     Inc1         := True;
     Inc10        := False;
     Inc100       := False;
     Inc1000      := False;
     IncVal       := 1;
     ProgEnded    := False;
     Stoped       := False;
     Playing      := False;
     Paused       := False;
     V640         := True;
     V800         := False;
     V1024        := False;
     Zoomed       := False;
     Signed       := False;
     TreeLevel    := 0;
     ProcNo       := 0;
     ScrNo        := 0;
     DefaultPath  := ClearSlash(SndPath);
     CurrentPath  := DefaultPath;
     FPtr         := 0;
     MaxFptr      := 0;
     EMSFit       := True;
     FilePattern  := '*.*';
     CallProc     := Nothing;
     For DummyByte := 0 to MaxLevel do
         TreePtr[DummyByte] := 0;

     For DummyByte := 0 to MaxProc do
         MainProc[DummyByte] := Nothing;

     if MemAvail < SizeOF(ButtonTree^) then
     Begin
          WriteLn('Not enough memory.');
          Halt;
     End;
     GetMem(ButtonTree,SizeOf(ButtonTree^));

     if MemAvail < SizeOf(FileTree^) then
     Begin
          WriteLn('Not enough memory to get file tree.');
          Halt;
     End;
     GetMem(FileTree,SizeOf(FileTree^));

     For DummyByte := 1 to MaxSample do
     Begin
          SampleInfo[DummyByte].name       := DefaultName;
          SampleInfo[DummyByte].Rate       := DefaultRate;
          SampleInfo[DummyByte].BlockStart := 0;
          SampleInfo[DummyByte].BlockEnd   := 0;
          SampleInfo[DummyByte].Pos        := 0;
          SampleInfo[DummyByte].Start      := 0;
          SampleInfo[DummyByte].Length     := 0;
          SampleInfo[DummyByte].Volume     := DefaultVolume;
          SampleInfo[DummyByte].Twin       := DefaultTwin;
          SampleInfo[DummyByte].Cntr       := DefaultCntr;
          SampleInfo[DummyByte].Active     := False;
          SampleInFo[DummyByte].Signed     := False;
          SampleInfo[DummyByte].EMSHandle  := 0;
          SampleInfo[DummyByte].Zoomed     := False;
     End;
     Device   := 1;   { PC Speaker }

     DeviceInfo[1].name      := 'PC Speaker';
     DeviceInfo[1].Handler   :=    PCHandler;
     DeviceInfo[1].Proc      :=      Nothing;
     DeviceInfo[1].Available :=         True;
     DeviceInfo[1].ext1      :=            0;
     DeviceInfo[1].ext2      :=            0;
     DeviceInfo[1].ext3      :=            0;
     DeviceInfo[1].ext4      :=            0;

     DeviceInfo[2].name      := 'DAC on LPT1';
     DeviceInfo[2].Handler   :=   LPT1Handler;
     DeviceInfo[2].Proc      :=       Nothing;
     DeviceInfo[2].Available :=         False;
     DeviceInfo[2].ext1      :=             0;
     DeviceInfo[2].ext2      :=             0;
     DeviceInfo[2].ext3      :=             0;
     DeviceInfo[2].ext4      :=             0;

     DeviceInfo[3].name      := 'DAC on LPT2';
     DeviceInfo[3].Handler   :=   LPT2Handler;
     DeviceInfo[3].Proc      :=       Nothing;
     DeviceInfo[3].Available :=         False;
     DeviceInfo[3].ext1      :=             0;
     DeviceInfo[3].ext2      :=             0;
     DeviceInfo[3].ext3      :=             0;
     DeviceInfo[3].ext4      :=             0;
End;

Procedure EMSCheck;
Var
   Free,
   Total  : Word;
Begin
     Asm
        mov ah,46h
        int 67h
        mov rc,ax
     End;
     if Hi(RC) <> 0 then
     Begin
          WriteLn('Unable to find EMS driver.');
          WriteLn('You should have at least one :)');
          Halt(1);
     End;
     WriteLn('  EMS driver detected. Version ',lo(RC) shr 4,'.',lo(rc) and 15);
     Asm
        mov ah,42h
        int 67h
        mov rc,ax
        mov free,bx
        mov total,dx
        mov ah,41h
        int 67h
        mov EMSBase,bx
     end;
     if hi(RC) <> 0 then WriteLn('Unable to determine total number of EMS pages.')
     else
     Begin
         WriteLn('  Free conventional mem :  ',((MemAvail) div KB):4,'Kb');
         WriteLn('  Total expanded memory : ',(total*16):5,'Kb');
         WriteLn('  Free  expanded memory : ',(free*16):5,'Kb');
         WriteLn('  EMS Base frame Address:  ',h2s(EMSBase));
     End;
End;

Procedure MouseCheck;
Var
   RC,
   NumOfBut     :Word;
Begin
     Asm
        mov ax,0
        int 33h
        mov RC,ax
        mov NumOfBut,bx
     End;
     if RC <> $ffff then
     Begin
          WriteLn('Unable to find mouse driver.');
          WriteLn('You should have at least one :)');
          Halt;
     End;
     WriteLn('  Mouse found.(',NumOfBut,' buttons)');
End;

Procedure CheckDrives;
Var
   Exist : Boolean;
Begin
     Asm
        Mov ah,19h
        int 21h
        push ax
     End;
     For DummyByte := 0 to 25 do
     Begin
          Asm
             mov ah,0eh
             mov dl,DummyByte
             int 21h
             mov ah,19h
             int 21h
             mov exist,FALSE
             cmp al,DummyByte
             jne @@NotExist
             mov exist,TRUE
@@notexist:
         End;
         DriveAvailAble[DummyByte] := Exist;
    End;
    Asm
        pop ax
        mov ah,0eh
        mov dl,al
        int 21h
    End;
    { Now check for Drive B existance }
    Asm
       mov ah,15h
       mov dl,1
       int 13h
       mov exist,TRUE
       cmp ah,00h
       jne @@bexist
       mov exist,FALSE
@@bexist:
    End;
    DriveAvailable[1] := Exist;
    if Exist then WriteLn('  A real B: drive detected.');

End;

(*
Procedure SpeedCheck;
Var
   SpStart,
   SpEnd    : LongInt;
Begin
     Asm{Cli};end;
     SpStart := Clock;
     Asm
        cli
        mov cx,$FFFF
@@lop:
        nop
        nop
        nop
        Loop @@lop
        sti
     End;
     SpEnd := Clock;
     Asm{Sti};end;
     CorrecFactor := (SpEnd - SpStart) / MySpeed;
     CorrecFactor := 1.00 / CorrecFactor;
     WriteLn('  Machine Speed: ',CorrecFactor:2:2,' [aprx 1.0 for 486DX33]');
End;
*)

{$L DT.OBJ}

Procedure CompDate;External;
Procedure CompTime;External;
(*
Procedure LoadSamples;
Var
   InFile       :File;
Begin
     OkFound := False;
     CancelFound := False;
     {$I-}
     Assign(InFile,'OK.RAW');
     Reset(InFile,1);
     {$I+}
     if IOResult = 0 then
     Begin
          WriteLn('OK.RAW Found.');
          OkSize := FileSize(InFile);
          GetMem(OKPtr,OkSize);
          BlockRead(InFile,OKPtr^,OkSize);
          OkFound := True;
          Close(InFile);
     End;
     {$I-}
     Assign(InFile,'CANCEL.RAW');
     Reset(InFile,1);
     {$I+}
     if IOResult = 0 then
     Begin
          WriteLn('CANCEL.RAW Found.');
          CancelSize := FileSize(InFile);
          GetMem(CancelPtr,CancelSize);
          BlockRead(InFile,CancelPtr^,CancelSize);
          CancelFound := True;
          Close(InFile);
     End;
End;
*)
Procedure Kernel;
Var
   OldBussy : Byte;
Begin
     OldBussy := BussyState;
     if ButtonTree^[ActiveButton[ProcNo],TreeLevel].typ = BUTTON then
     Begin
          Bussy;
          vrestoremouse;
          if ButtonTree^[ActiveButton[ProcNo],TreeLevel].Pressed = False then
               BoxPrint(ButtonTree^[ActiveButton[ProcNo],TreeLevel].Xmin,ButtonTree^[ActiveButton[ProcNo],TreeLevel].YMin,
               ButtonTree^[ActiveButton[ProcNo],TreeLevel].Text,ButtonTree^[ActiveButton[ProcNo],TreeLevel].Fit,
               ButtonTree^[ActiveButton[ProcNo],TreeLevel].TextColor,
               ButtonTree^[ActiveButton[ProcNo],TreeLevel].BoxColor,
               True);
          vputmouse;
          vrestoremouse;
          if OldBussy = 0 then NotBussy;
     End;
     MainProc[ProcNo];
     MainProc[ProcNo] := Nothing;
     if ButtonTree^[ActiveButton[ProcNo],TreeLevel].typ = BUTTON then
     Begin
          Bussy;
          vrestoremouse;
          ButtonTree^[ActiveButton[ProcNo],TreeLevel].Pressed := ButtonPos;
          BoxPrint(ButtonTree^[ActiveButton[ProcNo],TreeLevel].Xmin,ButtonTree^[ActiveButton[ProcNo],TreeLevel].YMin,
                   ButtonTree^[ActiveButton[ProcNo],TreeLevel].Text,ButtonTree^[ActiveButton[ProcNo],TreeLevel].Fit,
                   ButtonTree^[ActiveButton[ProcNo],TreeLevel].TextColor,
                   ButtonTree^[ActiveButton[ProcNo],TreeLevel].BoxColor,
                   ButtonTree^[ActiveButton[ProcNo],TreeLevel].Pressed);
          vputmouse;
          vrestoremouse;
          if OldBussy = 0 then NotBussy;
     End;
     Dec(ProcNo);
End;

Procedure LoadBmp;
Var
   BmpFile :File;
   BmpPtr  :Byte;
Begin
     For BmpPtr := 0 to MaxBmp do
     Begin
          BmpArray[BmpPtr].Found := FALSE;
          {$I-}
          Assign(BmpFile,ClearSlash(LPPath+'LP'+S(BmpPtr,2,TRUE)+'.CEL'));
          Reset(BmpFile,1);
          {$I+}
          if IOResult = 0 then
          Begin
               if (FileSize(BmpFile)-800) < MemAvail-KB*100 then
               Begin
                    BmpArray[BmpPtr].Found := TRUE;
                    Seek(BmpFile,2);
                    BlockRead(BmpFile,BmpArray[BmpPtr].w,2);
                    BlockRead(BmpFile,BmpArray[BmpPtr].h,2);
{
                    WriteLn('  ',BmpPtr:2,'  ',BmpArray[BmpPtr].w,'x',BmpArray[BmpPtr].h,' bitmap found.');
}
                    GetMem(BmpArray[BmpPtr].Buffer,BmpArray[BmpPtr].w*BmpArray[BmpPtr].h);
                    Seek(BmpFile,800);
                    BlockRead(BmpFile,BmpArray[BmpPtr].Buffer^,BmpArray[BmpPtr].w*BmpArray[BmpPtr].h);
               End;
               Close(BmpFile);
          End;
     End;
End;

{
  Check for Micro Channel Existance
}
Procedure MCCheck;
Begin
     isMC := False;
     Asm
        push es
        mov ah,0c0h
        int 15h
        jc @@nomc
        mov al,es:[bx+05]
        test al,010b
        jz @@nomc
        mov isMC,1
@@nomc:
        pop es
     End;
     if isMC then WriteLn('  Micro Channel found.');
End;

Begin
     OldVideoMode := mem[$0040:$0049];
     GetDir(0,EnterancePath);
     LPPath := GetEnv('LPBINPTH');
     if LPPath = '' then LPPath := EnterancePath;
     if Right(LPPath,1) <> '\' then LPPath := LPPath + '\';
     TempPath := GetEnv('TEMP');
     if TempPath = '' then TempPath := LPPath;
     if Right(TempPath,1) <> '\' then TempPath := TempPath + '\';
     SndPath  := GetEnv('LPSNDPTH');
     if SndPath = '' then SndPath := LPPath;
     if Right(SndPath,1) <> '\' then SndPath := SndPath + '\';
     if GetEnv('LPRATE') <> '' then
        Val(GetEnv('LPRATE'),DefaultRate,DummyWord)
     else
        DefaultRate := 8000;
     if Rate < MINRATE then Rate := MINRATE;
     if Rate > MAXRATE then Rate := MAXRATE;
     if GetEnv('LPVOL') <> '' then
        Val(GetEnv('LPVOL'),DefaultVolume,DummyWord)
     else
        DefaultVolume := 3;
     if GetEnv('LPCNTR') <> '' then
        Val(GetEnv('LPCNTR'),DefaultCntr,DummyWord)
     else
        DefaultCntr := 3;
     CmpDate := @CompDate;
     CmpTime := @CompTime;
     WriteLn(' LongPlay V'+Version+' Copyright (c) Huseyin Nakturk 1994');
     WriteLn(' Last compiled at ',CmpTime^,' ',CmpDate^);
     WriteLn(' Checking requirements...');
     WriteLn('  ',cputype[WhatCPU],' ',CPUSpd,'Mhz detected.');
     if WhatCpu < 2 then
     Begin
          WriteLn('You need at least an AT to run LongPlay.');
          Halt;
     End;
     if WhatCpu = 2 then
        WriteLn('  80286 detected.Problems may occur.');
     CheckDrives;
     MCCheck;
     EMSCheck;
     LoadBmp;
     MouseCheck;
     Delay(500);
     VarInitialize;
     GraphMode := SVGA640X480X256;
     VGAInitialize(SVGA640X480X256);
     if (Status_al <> $4f) then
     Begin
          WriteLn('VESA not found.');
          Halt;
     End;
     if (Status_ah <> 0) then
     Begin
          WriteLn('Your VESA even can not support 640x480 mode.');
          Halt;
     End;
     TreeClear;
     MouseActive := False;
     vscrollup(MAXY);
     vfillblock(0,MAXY,MAXX,MAXY*2,0);
     BoxPrint(HALFMAXX-9*CharW,MAXY+HALFMAXY,' Initializing... ',18,Black+31,Blue,False);
     MouseInitialize;
     MouseActive := True;
     ScreenInitialize;
     for Dummyword := MAXY div 8 downto 0 do
         vscrolldown(8);
     EMSInfo;
     Repeat
           if ProcNo = 1 then
           Begin
               EMSInfo;
               Kernel;
               EMSInfo;
           End;
     Until ProgEnded;
     vdisablemouse;
     if MAXY < 601 then
     Begin
          FillBmp(0,MAXY,MAXX,MAXY*2,BackBmp);
          BoxPrint(HALFMAXX-15*CharW,MAXY+HALFMAXY,'Longplay (c) 1994 H.Nakturk',30,Black+31,Red,False);
          BoxPrint(HALFMAXX-6*CharW,MAXY+HALFMAXY+4*CharH,'GoodBye ...',12,Black+31,Blue,False);
          for DummyWord := MAXY div 6 downto 0 do
              vscrollup(6);
          Delay(500);
     End;
     CloseGraph;
     ExitRoutine;
     Asm
        mov ah,00
        mov al,OldVideoMode
        int 10h
     End;
     WriteLn;
     WriteLn('LongPlay has left the building ...');
     {$I-}
     ChDir(EnterancePath);
     {$I+}
End.
