; vfillblock
; fills a rectangular region with given color
; input    : x1,y1,x2,y2 and color
; on return: -
; call type: procedure vfillblock(x1,y1,x2,y2:Word;Color:Byte)
public vfillblock
vfillblock   proc far
             prefix
             cld
             mov es,winaseg
             mov ax,[bp+8]      ; y2
             cmp ax,[bp+12]     ; y2 > y1
             ja  @@yok          ; yes
             mov bx,[bp+8]
             mov ax,[bp+12]
             mov [bp+8],ax
             mov [bp+12],bx
@@yok:                          ; y ok
             mov ax,[bp+10]     ; x2
             cmp ax,[bp+14]     ; x2 > x2
             ja  @@xok
             mov bx,[bp+10]     ; x2
             mov ax,[bp+14]     ; x1
             mov [bp+10],ax
             mov [bp+14],bx
@@xok:                          ; x ok
             mov cx,[bp+8]      ; y2
             sub cx,[bp+12]     ; y1
             jz  @@donothing    ; y1 = y2.Do nothing
             inc cx
@@loop:
             push cx
             mov ax,[bp+12]     ; y1
             mov bx,[bp+14]     ; x1
             call vsetoffset    ; get ax = offset and dx = bank
             mov di,ax
             mov ax,[bp+6]      ; Color
             mov ah,al          ; for stosw
             mov cx,BankEnd
             sub cx,di
             mov bx,[bp+10]      ; x2
             sub bx,[bp+14]      ; x1
             cmp bx,cx           ; bx > cx ?
             ja @@bchange       ; yes we will change blocks
             mov cx,bx
@@bchange:
             sub bx,cx
@@draw:
             inc cx
             shr cx,1
             rep stosw
             adc cx,cx
             rep stosb
             cmp bx,0
             je  @@end
             inc  dx
             call vsetbank
             dec bx
             mov cx,bx
             xor bx,bx
             xor di,di
             jmp @@draw
@@end:
             pop cx
             inc word ptr [bp+12]
             loop @@loop
@@donothing:
             postfix
             ret 10
vfillblock   endp
; vfloodfill
; fills any closed shape with given color
; input    : x,y,color
; on return: -
; call type: procedure vfloodfill(x,y:Word;Color:Byte)
public vfloodfill
vfloodfill      proc far
                cli
                prefix
                mov ax,[bp+6]   ; color
                mov fillcolor,al
                mov ax,[bp+8]   ; y
                mov bx,[bp+10]  ; x
                push bx
                push ax
                call vget
                mov  fillval,al
                cmp  al,fillcolor
                je   @@nofill
                mov  es,winaseg
                push [bp+10]    ; x
                push [bp+08]    ; y
                push wptr 1     ; d
                push [bp+10]    ; x
                push [bp+10]    ; x
                call vlinefill
@@nofill:
                postfix
                sti
                ret 6
vfloodfill      endp

; vlinefill
; used by vfloodfill,recursive horizantal fill routine
; for internal use
; a stack eater.
; mostly optimized:
; optimization result: (for the same shape and same start point)
;    pascal version  840
;    first  asm      320
;    second asm      240
;    current          93
;         20 x
;         18 y
;         16 d
;         14 prevxl
;         12 prevxr
;         10 ofs
;          8 oldbp
;          6 xl
;          4 xr
;        + 2 i
; bp --->    ????

vlinefill       proc near
                push bp
                sub  sp,8
                mov  bp,sp
                mov  bx,[bp+20]                 ; ax = x
                mov  [bp+06],bx                 ; xl = x
                mov  [bp+04],bx                 ; xr = x
                mov  ax,[bp+18]
                call vsetoffset
                mov  di,ax
                push di
@@repeat1:
                dec  wptr [bp+06]               ; dec(xl)
                cmp  [bp+06],0ffffh             ; xl < 0 ?
                jz   @@until1                   ; if so terminate loop
                dec di
                cmp di,0ffffh
                jnz @@nobank1
                inc dx
                call vsetbank
@@nobank1:
                mov  al,es:[di]
                cmp  al,fillval                 ; vget(xl,y) <> fillval ?
                jne  @@until1                   ; if so terminate loop
                jmp  @@repeat1
@@until1:
                inc  wptr [bp+06]               ; inc(xl)
                pop  di
                mov  si,bankend
@@repeat2:
                inc  wptr [bp+04]               ; inc(xr)
                mov  ax,[bp+04]                 ; ax = xr
                cmp  ax,scrwidth                ; xr > maxx ?
                ja   @@until2                   ; if so terminate loop
                inc  di
                cmp  di,si
                jnz  @@nobank2
                inc  dx
                call vsetbank
@@nobank2:
                mov  al,es:[di]
                cmp  al,fillval                 ; vget(xr,y) <> fillval ?
                jne  @@until2                   ; if so terminate loop
                jmp  @@repeat2
@@until2:
                dec  wptr [bp+04]               ; dec(xr)
                push [bp+18]                    ; y
                push [bp+06]                    ; xl
                push [bp+04]                    ; xr
                push wptr fillcolor             ; color
                call vhrzline                   ; vhrzline(y,xl,xr,color);
                mov  ax,[bp+18]                 ; ax = y
                add  ax,[bp+16]                 ; inc(y,d)
                mov  [bp+18],ax                 ; y = ax
                cmp  ax,scrheight               ; y <= maxy
                ja   @@jump1                    ; if not jump
                mov  bx,[bp+06]                 ; bx = xl
                dec  bx                         ; dec(x)
                mov  [bp+20],bx                 ; x = xl
@@forloop1:
                inc  wptr [bp+20]               ; inc(x)
                mov  ax,[bp+04]                 ; ax = xr
                cmp  [bp+20],ax                 ; x > xr
                ja   @@jump1                    ; if so, terminate for loop
                mov  ax,[bp+18]                 ; y
                mov  bx,[bp+20]                 ; x
                call vsetoffset
                mov  di,ax
                mov  al,es:[di]
                cmp  al,fillval                 ; vget(x,y) = fillval ?
                jne  @@forloop1                 ; if not continue for loop
                push [bp+20]                    ; x
                push [bp+18]                    ; y
                push [bp+16]                    ; d
                push [bp+06]                    ; xl
                push [bp+04]                    ; xr
                call vlinefill                  ; recursive call
                mov  [bp+20],ax                 ; x = linefill(x,y,d,xl,xr)
                cmp  ax,[bp+04]                 ; x > xr
                jbe  @@forloop1                 ; no, continue.
@@jump1:
                mov ax,[bp+18]                  ; ax = y
                sub ax,[bp+16]                  ; y = y - d
                sub ax,[bp+16]                  ; y = y - d
                mov [bp+18],ax                  ; y = ax
;               neg wptr [bp+16]                ; neg d
                cmp ax,scrheight                ; y <= maxy
                jbe @@continue
                jmp @@jump2                     ; if not, jump
@@continue:
                mov bx,[bp+06]                  ; bx = xl
                dec bx                          ; dec(x)
                mov [bp+20],bx                  ; x = xl
@@forloop2:
                inc wptr [bp+20]                ; inc(x)
                mov ax,[bp+14]                  ; ax = prevxl
                cmp [bp+20],ax                  ; x > prevxl
                ja  @@jump22                    ; if so, terminate for loop
                mov ax,[bp+18]                  ; y
                mov bx,[bp+20]                  ; x
                call vsetoffset
                mov di,ax
                mov al,es:[di]
                cmp  al,fillval                 ; vget(x,y) = fillval ?
                jne  @@forloop2                 ; if not, continue for loop
                push [bp+20]                    ; x
                push [bp+18]                    ; y
                push [bp+16]                    ; d
                push [bp+06]                    ; xl
                push [bp+04]                    ; xr
                call vlinefill                  ; recursive call
                mov  bx,[bp+20]                 ; bx = x
                cmp  bx,[bp+14]                 ; x > prevxl ?
                jbe  @@forloop2                 ; if not, continue
@@jump22:
                mov bx,[bp+12]                  ; bx = prevxr
                dec bx                          ; dec(x)
                mov [bp+20],bx                  ; x = prevxr
@@forloop3:
                inc wptr [bp+20]                ; inc(x}
                mov ax,[bp+04]                  ; ax = xr
                cmp [bp+20],ax                  ; x > xr
                ja  @@jump2                     ; if so, terminate for loop
                mov ax,[bp+18]                  ; y
                mov bx,[bp+20]                  ; x
                call vsetoffset
                mov di,ax
                mov al,es:[di]
                cmp al,fillval                  ; vget(x,y) = fillval ?
                jne  @@forloop3                 ; if not, continue for loop
                push [bp+20]                    ; x
                push [bp+18]                    ; y
                push [bp+16]                    ; d
                push [bp+06]                    ; xl
                push [bp+04]                    ; xr
                call vlinefill                  ; recursive call
                mov  bx,[bp+20]                 ; bx = x
                cmp  bx,[bp+04]                 ; x > xr
                jbe  @@forloop3
@@jump2:
                mov ax,[bp+04]                  ; vlinefill = xr
                add sp,8
                pop bp
                ret 10
vlinefill       endp

; vboundaryfill
; fills a closed shape with given boundary color
; input    : x,y,fillcolor,boundarycolor
; on return: -
; call type: procedure vboundaryfill(x,y:Word;FillColor,BoundaryColor:Byte);
public vboundaryfill
vboundaryfill   proc far
                cli
                prefix
                mov ax,[bp+6]   ; boundary color
                mov fillval,al
                mov ax,[bp+8]   ; fill color
                mov fillcolor,al
                mov ax,[bp+10]  ; y
                mov bx,[bp+12]  ; x
                push bx
                push ax
                call vget
                cmp al,fillcolor
                je  @@nofill
                mov  es,winaseg
                push [bp+12]    ; x
                push [bp+10]    ; y
                push wptr 1     ; d
                push [bp+12]    ; x
                push [bp+12]    ; x
                call vlinefill2
@@nofill:
                postfix
                sti
                ret 8
vboundaryfill   endp

; vlinefill2
; used by vboundary,recursive horizantal fill routine
; for internal use
; a stack eater.
; mostly optimized:
; optimization result: (for the same shape and same start point)
;    pascal version  -
;    first  asm      -
;    second asm      -
;    current         102
;         20 x
;         18 y
;         16 d
;         14 prevxl
;         12 prevxr
;         10 ofs
;          8 oldbp
;          6 xl
;          4 xr
;        + 2 i
; bp --->    ????

vlinefill2      proc near
                push bp
                sub  sp,8
                mov  bp,sp
                mov  bx,[bp+20]                 ; ax = x
                mov  [bp+06],bx                 ; xl = x
                mov  [bp+04],bx                 ; xr = x
                mov  ax,[bp+18]
                call vsetoffset
                mov  di,ax
                push di
@@repeat1:
                dec  wptr [bp+06]               ; dec(xl)
                cmp  [bp+06],0ffffh             ; xl < 0 ?
                jz   @@until1                   ; if so terminate loop
                dec di
                cmp di,0ffffh
                jnz @@nobank1
                inc dx
                call vsetbank
@@nobank1:
                mov  al,es:[di]
                cmp  al,fillval                 ; vget(xl,y) <> fillval ?
                je   @@until1                   ; if so terminate loop
                jmp  @@repeat1
@@until1:
                inc  wptr [bp+06]               ; inc(xl)
                pop  di
                mov  si,bankend
@@repeat2:
                inc  wptr [bp+04]               ; inc(xr)
                mov  ax,[bp+04]                 ; ax = xr
                cmp  ax,scrwidth                ; xr > maxx ?
                ja   @@until2                   ; if so terminate loop
                inc  di
                cmp  di,si
                jnz  @@nobank2
                inc  dx
                call vsetbank
@@nobank2:
                mov  al,es:[di]
                cmp  al,fillval                 ; vget(xr,y) <> fillval ?
                je   @@until2                   ; if so terminate loop
                jmp  @@repeat2
@@until2:
                dec  wptr [bp+04]               ; dec(xr)
                push [bp+18]                    ; y
                push [bp+06]                    ; xl
                push [bp+04]                    ; xr
                push wptr fillcolor             ; color
                call vhrzline                   ; vhrzline(y,xl,xr,color);
                mov  ax,[bp+18]                 ; ax = y
                add  ax,[bp+16]                 ; inc(y,d)
                mov  [bp+18],ax                 ; y = ax
                cmp  ax,scrheight               ; y <= maxy
                ja   @@jump1                    ; if not jump
                mov  bx,[bp+06]                 ; bx = xl
                dec  bx                         ; dec(x)
                mov  [bp+20],bx                 ; x = xl
@@forloop1:
                inc  wptr [bp+20]               ; inc(x)
                mov  ax,[bp+04]                 ; ax = xr
                cmp  [bp+20],ax                 ; x > xr
                ja   @@jump1                    ; if so, terminate for loop
                mov  ax,[bp+18]                 ; y
                mov  bx,[bp+20]                 ; x
                call vsetoffset
                mov  di,ax
                mov  al,es:[di]
                cmp  al,fillval                 ; vget(x,y) = fillval ?
                je   @@forloop1                 ; if not continue for loop
                cmp  al,fillcolor
                je   @@forloop1
                push [bp+20]                    ; x
                push [bp+18]                    ; y
                push [bp+16]                    ; d
                push [bp+06]                    ; xl
                push [bp+04]                    ; xr
                call vlinefill2                 ; recursive call
                mov  [bp+20],ax                 ; x = linefill(x,y,d,xl,xr)
                cmp  ax,[bp+04]                 ; x > xr
                jbe  @@forloop1                 ; no, continue.
@@jump1:
                mov ax,[bp+18]                  ; ax = y
                sub ax,[bp+16]                  ; y = y - d
                sub ax,[bp+16]                  ; y = y - d
                mov [bp+18],ax                  ; y = ax
;               neg wptr [bp+16]                ; neg d
                cmp ax,scrheight                ; y <= maxy
                jbe @@continue
                jmp @@jump2                     ; if not, jump
@@continue:
                mov bx,[bp+06]                  ; bx = xl
                dec bx                          ; dec(x)
                mov [bp+20],bx                  ; x = xl
@@forloop2:
                inc wptr [bp+20]                ; inc(x)
                mov ax,[bp+14]                  ; ax = prevxl
                cmp [bp+20],ax                  ; x > prevxl
                ja  @@jump22                    ; if so, terminate for loop
                mov ax,[bp+18]                  ; y
                mov bx,[bp+20]                  ; x
                call vsetoffset
                mov di,ax
                mov al,es:[di]
                cmp  al,fillval                 ; vget(x,y) = fillval ?
                je   @@forloop2                 ; if not, continue for loop
                cmp  al,fillcolor
                je   @@forloop2
                push [bp+20]                    ; x
                push [bp+18]                    ; y
                push [bp+16]                    ; d
                push [bp+06]                    ; xl
                push [bp+04]                    ; xr
                call vlinefill2                 ; recursive call
                mov  bx,[bp+20]                 ; bx = x
                cmp  bx,[bp+14]                 ; x > prevxl ?
                jbe  @@forloop2                 ; if not, continue
@@jump22:
                mov bx,[bp+12]                  ; bx = prevxr
                dec bx                          ; dec(x)
                mov [bp+20],bx                  ; x = prevxr
@@forloop3:
                inc wptr [bp+20]                ; inc(x}
                mov ax,[bp+04]                  ; ax = xr
                cmp [bp+20],ax                  ; x > xr
                ja  @@jump2                     ; if so, terminate for loop
                mov ax,[bp+18]                  ; y
                mov bx,[bp+20]                  ; x
                call vsetoffset
                mov di,ax
                mov al,es:[di]
                cmp al,fillval                  ; vget(x,y) = fillval ?
                je  @@forloop3                  ; if not, continue for loop
                cmp al,fillcolor
                je  @@forloop3
                push [bp+20]                    ; x
                push [bp+18]                    ; y
                push [bp+16]                    ; d
                push [bp+06]                    ; xl
                push [bp+04]                    ; xr
                call vlinefill2                 ; recursive call
                mov  bx,[bp+20]                 ; bx = x
                cmp  bx,[bp+04]                 ; x > xr
                jbe  @@forloop3
@@jump2:
                mov ax,[bp+04]                  ; vlinefill = xr
                add sp,8
                pop bp
                ret 10
vlinefill2      endp
