; vputrect
; copies a rectangle to the specified position
; input    : buffer,x,y,xlen,ylen,width,puttype
; on return: -
; call type: procedure(buffer:Pointer;x,y,xlen,ylen,width:word;PutType:Byte)
; needs some optimization
; last touched: 15-4-1994
; available put types:
;       COPY_PUT  = 0
;       XOR_PUT   = 1
;       AND_PUT   = 2
;       TRANS_PUT = 3
andit           db false
andwith         db 0
public vputrect
vputrect        proc far
@@bufseg        equ <[bp+20]>
@@bufofs        equ <[bp+18]>
@@x             equ <[bp+16]>
@@y             equ <[bp+14]>
@@xlen          equ <[bp+12]>
@@ylen          equ <[bp+10]>
@@width         equ <[bp+08]>
@@puttype       equ <[bp+06]>
                prefix
                mov al,iambussy
                mov oldbussy,al
                mov iambussy,1
                cld
                jmp @@jumparound
@@getout:
                jmp @@donothing
@@noclip2:
                jmp @@noclip
@@jumparound:
                cmp bptr clip,1                         ; clipping ?
                jnz @@noclip2                           ; no.
                mov ax,clipx2                           ;
                cmp wptr @@x,ax                         ; x > clipx2
                jg @@getout                             ; if so, do nothing
                mov ax,clipx1                           ;
                cmp wptr @@x,ax                         ; x < clipx1
                jge @@cl1                               ; no,
                mov bx,ax                               ;
                sub bx,@@x                              ; bx = clipx1 - x
                cmp bx,@@xlen                           ; bx > xlen
                jge @@getout                            ; yes, do nothing
                add @@bufofs,bx                         ; bufofs = bufofs + bx
                sub wptr @@xlen,bx                      ; xlen = xlen - bx
                mov wptr @@x,ax                         ; x = clipx1
@@cl1:
                mov ax,@@x
                add ax,@@xlen
                cmp ax,clipx2                           ; (x+xlen) > clipx2
                jle @@cl2                               ; no.
                mov ax,clipx2                           ;
                sub ax,@@x                              ; ax = clipx2 - x
                mov @@xlen,ax                           ; ylen = ax = clipx2 - x
@@cl2:
                cmp wptr @@xlen,0
                jle @@getout
                mov ax,clipy2                           ;
                cmp wptr @@y,ax                         ; y > clipy2
                jg @@getout                             ; if so, do nothing
                mov ax,clipy1                           ;
                cmp wptr @@y,ax                         ; y < clipy1
                jge @@cl3                               ; no.
                mov bx,ax                               ;
                sub bx,@@y                              ; bx = clipy1 - y
                cmp bx,@@ylen                           ; bx > ylen
                jge @@getout                            ; yes, do nothing
                push ax
                mov ax,@@width
                mul bx
                add @@bufofs,ax                         ; bufofs = bufofs + bx*width
                sub wptr @@ylen,bx                      ; ylen = ylen - bx
                pop ax
                mov wptr @@y,ax                         ; y = clipy1
@@cl3:
                mov ax,@@y
                add ax,@@ylen
                cmp ax,clipy2                           ; (y+ylen) > clipy2
                jle @@cl4                               ; no.
                mov ax,clipy2                           ;
                sub ax,@@y                              ; ax = clipy2 - y
                mov @@ylen,ax                           ; ylen = ax = clipy2 - y
@@cl4:
@@noclip:
                cmp wptr @@ylen,0
                ja @@ok
                jmp @@donothing
@@ok:
                mov es,winaseg
                mov cx,@@ylen
                mov ds,@@bufseg
                mov si,@@bufofs
                dec wptr @@xlen
@@loop:
                push si
                push cx
                mov ax,@@y
                mov bx,@@x
                call vsetoffset    ; get ax = offset and dx = bank
                mov di,ax
                mov cx,BankEnd
                sub cx,di
                mov bx,@@xlen
                cmp bx,cx           ; bx > cx ?
                ja @@bchange       ; yes we will change blocks
                mov cx,bx
@@bchange:
                sub bx,cx
@@draw:
                inc cx
                cmp byte ptr @@puttype,XOR_PUT
                jnz @@n1
@@xorloop:
                lodsb
                cmp andit,true
                jnz @@noand1
                and al,andwith
@@noand1:
                xor es:[di],al
                inc di
                loop @@xorloop
                jmp @@putok
@@n1:
                cmp byte ptr @@puttype,AND_PUT
                jnz @@n2
@@andloop:
                lodsb
                cmp andit,true
                jnz @@noand2
                and al,andwith
@@noand2:
                and es:[di],al
                inc di
                loop @@andloop
                jmp @@putok
@@n2:
                cmp byte ptr @@puttype,TRANS_PUT
                jnz @@n3
@@transloop:
                lodsb
                cmp andit,true
                jnz @@noand3
                and al,andwith
@@noand3:
                or al,al
                jz  @@dontput
                mov es:[di],al
@@dontput:
                inc di
                loop @@transloop
                jmp @@putok
@@n3:
                                    ; default COPY_PUT
                cld
                shr cx,1
                cmp cx,0
                jz @@33
@@11:
                lodsw
                cmp andit,true
                jnz @@noand4
                and al,andwith
                and ah,andwith
@@noand4:
                stosw
                loop @@11
@@33:
                adc cx,cx
                jz @@putok
@@22:
                lodsb
                cmp andit,true
                jnz @@noand5
                and al,andwith
@@noand5:
                stosb
@@putok:
                cmp bx,0
                je  @@end
                inc  dx
                call vsetbank
                dec bx
                mov cx,bx
                xor bx,bx
                xor di,di
                jmp @@draw
@@end:
                pop cx
                pop si
                add si,@@width             ; source = source + width
                inc word ptr @@y           ; y = y + 1
                dec cx
                jz @@donothing
                jmp @@loop
@@donothing:
                mov al,oldbussy
                mov iambussy,al
                postfix
                ret 16
vputrect        endp


; vgetrect
; copies a rectangle from screen to buffer
; input    : buffer,x,y,xlen,ylen,width
; on return: -
; call type: procedure(buffer:Pointer;x,y,xlen,ylen,width:word)
public vgetrect
vgetrect        proc far
@@bufseg        equ <[bp+18]>
@@bufofs        equ <[bp+16]>
@@x             equ <[bp+14]>
@@y             equ <[bp+12]>
@@xlen          equ <[bp+10]>
@@ylen          equ <[bp+08]>
@@width         equ <[bp+06]>
                prefix
                mov al,iambussy
                mov oldbussy,al
                mov iambussy,1
                cld
                mov ds,winaseg
                mov cx,@@ylen
;               inc cx
                mov es,@@bufseg
                mov di,@@bufofs
                dec wptr @@xlen
@@loop:
                push di
                push cx
                mov ax,@@y
                mov bx,@@x
                call vsetoffset    ; get ax = offset and dx = bank
                mov si,ax
                mov cx,BankEnd
                sub cx,si
                mov bx,@@xlen
                cmp bx,cx           ; bx > cx ?
                ja @@bchange       ; yes we will change blocks
                mov cx,bx
@@bchange:
                sub bx,cx
@@draw:
                inc cx
                shr cx,1
                rep movsw
                adc cx,cx
                rep movsb
                cmp bx,0
                je  @@end
                inc  dx
                call vsetbank
                dec bx
                mov cx,bx
                xor bx,bx
                xor si,si
                jmp @@draw
@@end:
                pop cx
                pop di
                add di,@@width             ; source = source + width
                inc word ptr @@y           ; y = y + 1
                loop @@loop
@@donothing:
                mov al,oldbussy
                mov iambussy,al
                postfix
                ret 14
vgetrect        endp

; vsetputmode
; set put mode for line and point
; input    : put type
; on return: -
; call type: procedure vsetputmode(mode:Byte)
public vsetputmode
vsetputmode     proc far
@@mode          equ <[bp+06]>
                prefix
                mov al,@@mode
                mov vputmode,al
                postfix
                ret 2
vsetputmode     endp
