; venablemouse
; enables mouse handler
; input    : leftbutton and rightbutton handlers;
; on return: -
; call type: procedure venablemouse(leftbutton:proctype;rightbutton:proctype)
;            where proctype =  Type proctype = procedure;
public venablemouse
venablemouse proc far
             prefix
             mov ax,[bp+6]
             mov rightofs,ax
             mov ax,[bp+8]
             mov rightseg,ax
             mov ax,[bp+10]
             mov leftofs,ax
             mov ax,[bp+12]
             mov leftseg,ax
             mov ax,8
             mov cx,0
             mov dx,scrheight
;            sub dx,mouseh
             dec dx
             int 33h
             mov ax,7
             mov cx,0
             mov dx,scrwidth
             sub dx,mousew
             dec dx
             int 33h
             mov ax,0ch
             mov cx,1+2+8
             push cs
             pop  es
             lea  dx,vmousehandler
             int  33h
             call vputmouse
             mov  mouseactive,1
             postfix
             ret 8
venablemouse endp

; vdisablemouse
; disables mouse handler
; input    : -
; on return: -
; call type: procedure vdisablemouse;
public vdisablemouse
vdisablemouse proc far
              prefix
              mov ax,0ch
              mov cx,0
              push cs
              pop es
              lea dx,vmousehandler
              int 33h
              call vrestoremouse
              mov mouseactive,0
              postfix
              retf
vdisablemouse endp
; bussy
; halt mouse operations until notbussy
; input    : -
; on return: -
; call type: procedure bussy
public bussy
bussy        proc far
             prefix
             cmp mouseactive,0
             jz  @@no
             cmp iambussy,1
             jz @@no
             call vrestoremouse
             mov iambussy,1
@@no:
             postfix
             retf
bussy        endp

; notbussy
; reverse of bussy
; input    : -
; on return: -
; call type: procedure notbussy
public notbussy
notbussy     proc far
             prefix
             cmp mouseactive,0
             jz @@no
             cmp iambussy,0
             jz @@no
             call vputmouse
             mov iambussy,0
@@no:
             postfix
             retf
notbussy     endp

; vmousehandler
; handles mouse driver requests
; for internal use
oldclip       db 0
vmousehandler proc far
              cli
              pusha
              push ds
              push es
              push currentbank
              push ax
              mov  al,clip
              mov oldclip,al
              mov bptr clip,0
              pop ax
              mov  mousemask,al
              cmp  iambussy,1
              jz   @@nomove
              test mousemask,1
              jz   @@nomove
              pusha
              push ds
              mov  vmousex,cx
              mov  vmousey,dx
              call vertwait
              call vrestoremouse
              call vputmouse
              pop ds
              popa
@@nomove:
              test mousemask,2
              jz   @@noleft
              pusha
              push ds
              call dptr cs:[leftofs]
              pop ds
              popa
@@noleft:
              test mousemask,8
              jz @@done
              pusha
              push ds
              call dptr cs:[rightofs]
              pop ds
              popa
@@done:
              pop ax
              cmp ax,currentbank
              jz @@ok
              mov currentbank,ax
              mov dx,ax
              mov ax,04f05h
              mov bx,0000h
              int 10h
@@ok:
              mov al,oldclip
              mov clip,al
              pop  es
              pop  ds
              popa
              sti
              retf
vmousehandler endp

; vrestoremouse
; retores the bitmap under mouse
; input    : -
; on return: -
; call type: procedure vrestoremouse;
public vrestoremouse
vrestoremouse proc far
              prefix
              mov ax,lineskip
              push ax
              push cs
              push offset mouseunder
              push oldmousex
              push oldmousey
              push mousew
              push mouseh
              push mousew
              push 0000        ; COPY_PUT
              call vputrect
              pop ax
              mov lineskip,ax
              postfix
              retf
vrestoremouse endp

; vputmouse
; puts mouse cursor to the mousex,mousey
; input    : -
; on return: -
; call type: procedure vputmouse
oldandit2    db 0
oldandwith2  db 0
public vputmouse
vputmouse    proc far
             prefix
             mov al,andit
             mov oldandit2,al
             mov al,andwith
             mov oldandwith2,al
             mov bptr andit,false
             mov ax,lineskip
             push ax
             push cs
             push offset mouseunder
             push vmousex
             push vmousey
             push mousew
             push mouseh
             push mousew
             call vgetrect
             push cs
             push offset mousespr
             push vmousex
             push vmousey
             push mousew
             push mouseh
             push mousew
             push 0003  ; TRANS_PUT i.e 0's transparent
             call vputrect
             mov ax,vmousex
             mov oldmousex,ax
             mov ax,vmousey
             mov oldmousey,ax
             pop ax
             mov lineskip,ax
             mov al,oldandit2
             mov andit,al
             mov al,oldandwith2
             mov andwith,al
             postfix
             retf
vputmouse    endp
; mousex
; returns current x coordinate of the mouse
; input    : -
; on return: mouse x coordinate
; call type: function MouseX:Word
public mousex
mousex       proc far
             prefix
             mov ax,vmousex
             postfix
             retf
mousex       endp

; mousey
; returns current y coordinate of the mouse
; input    : -
; on return: mouse y coordinated
; call type: function MouseY:Word
public mousey
mousey       proc far
             prefix
             mov ax,vmousey
             postfix
             retf
mousey       endp

; bussystate
; returns bussystate
; input    :
; on return: bussy state
; call type: function BussyState:Byte
public bussystate
bussystate   proc far
             prefix
             mov al,iambussy
             postfix
             retf
bussystate   endp

; vsetmousecoor
; sets mouse x and y coordinates
; input    : newx,newy condition
; on return: -
; call type: procedure vsetmousecoor(newx,newy:word;restore:Boolean)
public vsetmousecoor
vsetmousecoor proc far
              cli
              prefix
              push cx
              push dx
              mov dx,[bp+6]
              mov vmousey,dx
              mov cx,[bp+8]
              mov vmousex,cx
              mov ax,4
              int 33h
              cmp iambussy,1
              jz @@noupdate
              call vrestoremouse
              call vputmouse
@@noupdate:
              pop dx
              pop cx
              postfix
              sti
              ret 4
vsetmousecoor endp
