ON ERROR GOTO Handler    'enables error handling
DIM chr36(3) AS STRING   'give dimensions of arrays in which length of file is stored as a base 256 number
DIM chr(3) AS STRING     '
DO                                       'main program control loop
GOSUB scrnone                            '
GOSUB wavtype                            '
IF wavtype% < 6 THEN GOSUB compwave      '
IF wavtype% = 6 THEN END                 '
LOOP                                     '
END                                      '

 
scrnone:                        'displays the main menu
        CLS
        LOCATE 1, 30
        PRINT "MAKE YOUR OWN WAVEFORM!"
        LOCATE 4, 1
        PRINT "Select the option you desire:"
        PRINT "    1) Sine"
        PRINT "    2) Square"
        PRINT "    3) Triangle"
        PRINT "    4) Positive slope sawtooth"
        PRINT "    5) Negative slope sawtooth"
        PRINT "    6) Exit"
        RETURN

wavtype:      'the numbers 1 thru 5 select one of he waveforms.
              '6 exits the program
        DO
        INPUT "Your choice:", wavtype%
        IF (wavtype% < 1) OR (wavtype% > 6) THEN PRINT "ERROR: SELECTION MUST BE BETWEEN 1 AND 6"
        LOOP UNTIL (wavtype% > 0) AND (wavtype% < 7)
        RETURN

compwave:              'computes the waveform
        GOSUB sample   'sends program to parameter gathering subroutines
        GOSUB freq     '
        GOSUB amp      '
        GOSUB leng     '
        GOSUB filenm   '
        period& = (samps& / freq!)        'computes length of one cycle of waveform
        REDIM info(period& + 1) AS INTEGER    'sets the dimension of "info" to the length of one cycle + 1
        IF wavtype% = 1 THEN GOSUB sine       'sends the program to the appropriate subroutine, which will fill "info" with the data for one cycle of the waveform
        IF wavtype% = 2 THEN GOSUB square     '
        IF wavtype% = 3 THEN GOSUB triangle   '
        IF wavtype% = 4 THEN GOSUB possaw     '
        IF wavtype% = 5 THEN GOSUB negsaw     '
        GOSUB length                          'goes to subroutine where chr, and chr36 are filled with the length, base 256
        OPEN file$ FOR OUTPUT AS #1           'opens the data file
'The next 8 lines initialize the file.  There is a long list of
'characters which must be present at the beginnin gof hte file for it
'to play properly.  Most of these characters are the same for every
'data file.  However, the characters stored in chr, and chr36
'depend upon the length of the file.
        PRINT #1, CHR$(82); CHR$(73); CHR$(70); CHR$(70);
        FOR i% = 0 TO 3       'writes length + 36, base 256, to data file
        PRINT #1, chr36(i%);  '
        NEXT                  '
        PRINT #1, CHR$(87); CHR$(65); CHR$(86); CHR$(69); CHR$(102); CHR$(109); CHR$(116); CHR$(32); CHR$(16); CHR$(0); CHR$(0); CHR$(0); CHR$(1); CHR$(0); CHR$(1); CHR$(0); CHR$(34); CHR$(86); CHR$(0); CHR$(0); CHR$(34); CHR$(86);
        PRINT #1, CHR$(0); CHR$(0); CHR$(1); CHR$(0); CHR$(8); CHR$(0); CHR$(100); CHR$(97); CHR$(116); CHR$(97);
        FOR i% = 0 TO 3      'writes length, base 256, to data file
        PRINT #1, chr(i%);   '
        NEXT                 '           'writes data from "info" over and over, until the data file has reached the requested length
        i& = 0                           '
        l& = 0                           '
        DO                               '
        PRINT #1, CHR$(info(i&));        '
        i& = i& + 1                      '
        IF i& = period& THEN i& = 0      '
        l& = l& + 1                      '
        LOOP UNTIL l& > (length& - 1)    '
        CLOSE #1                         '
        RETURN                           '

sample:      'prompts user for number of samples per second
        DO
        INPUT "Enter sampling rate. (Recomended=44100): ", samps&
        IF (samps& < 3908) OR (samps& > 48000) THEN PRINT "ERROR: SAMPLING RATE MUST BE BETWEEN 3908 AND 48,000"
        LOOP UNTIL (samps& > 3907) AND (samps& < 48001)
        RETURN

freq:         'prompts user for frequency of signal
        DO
        INPUT "What frequency would you like?", freq!
        IF (freq! < 45) OR (freq! > 20000) THEN PRINT "ERROR: FREQUENCY MUST BE BETWEEN 45 AND 20,000 Hz"
        LOOP UNTIL (freq! > 44) AND (NOT (freq! > 20000))
        RETURN

amp:           'prompts user for amplitude of signal
        DO
        INPUT "What amplitude would you like?", amp%
        IF (amp% < 0) OR (amp% > 127) THEN PRINT "ERROR: AMPLITUDE MUST BE BETWEEN 0 AND 127"
        LOOP UNTIL (amp% > 0) AND (amp% < 128)
        RETURN

leng:          'prompts user for length of file
        DO
        PRINT "How long would you like your sample? (1 unit = 1/"; samps&; " sec): ";
        INPUT "", length&
        IF (length& < 1) OR (length& > 16777180) THEN PRINT "ERROR: LENGTH MUST BE BETWEEN 1 AND 16,777,180"
        LOOP UNTIL (length& > 0) AND (length& < 16777181)
        RETURN

filenm:         'prompts user for filename
        PRINT "Enter the path and filename where your file will be saved."
        INPUT "(Include '.wav' ending): ", file$
        RETURN

       
sine:     'computes one cycle of a sine wave
        
        FOR i& = 0 TO period&
        tempsine! = amp% * SIN((6.28 / samps&) * (i& * freq!)) + 128
        intsine% = tempsine!
        info(i&) = intsine%
        NEXT i&
        RETURN

square:        'computes one cycle of a square wave
        state% = 1
        halfper& = period& / 2
        i& = 0
        DO
        FOR spot& = 0 TO halfper&
        IF state% = 1 THEN info(i&) = amp% + 128   'fills "info" with positive half of cycle
        IF state% = 0 THEN info(i&) = 128 - amp%   'fills "info" with negative half of cycle
        IF i& < (period&) THEN i& = i& + 1
        NEXT
        state% = 0
        LOOP UNTIL i& = period&
        RETURN

triangle:      'computes one cycle of a triangle wave
        state% = 1
        halfper& = period& / 2
        i& = 0
        DO
        FOR spot& = 0 TO halfper&
        IF state% = 1 THEN info(i&) = 2 * amp% * (spot& / halfper&) + (128 - amp%)
        IF state% = 0 THEN info(i&) = 2 * amp% * ((halfper& - spot&) / halfper&) + (128 - amp%)
        IF i& < (period&) THEN i& = i& + 1
        NEXT
        state% = 0
        LOOP UNTIL i& = period&
        RETURN

possaw:               'computes one cycle of a positive slope ramp
        FOR spot& = 0 TO period&
        info(spot&) = 2 * amp% * (spot& / period&) + (128 - amp%)
        NEXT
        RETURN

negsaw:               'computes one cycle of a negative slope ramp
        FOR spot& = 0 TO period&
        info(spot&) = 2 * amp% * ((period& - spot&) / period&) + (128 - amp%)
        NEXT
        RETURN
        
length:              'fills chr, and chr36, with the length of the file
                     'and the length + 36 respectively.  They are both written
                     'base 256.  These arrays are created, and written into the
                     'beginning of the data file because Windows will not play
                     ' a .wav file without them.  Don't ask me why.
        large% = FIX(length& / 65536)
        med% = FIX((length& - (large% * 65536)) / 256)
        small% = length& - (65536 * large%) - (256 * med%)
        chr(0) = CHR$(small%)
        chr(1) = CHR$(med%)
        chr(2) = CHR$(large%)
        chr(3) = CHR$(0)
        large36% = FIX((length& + 36) / 65536)
        med36% = FIX(((length& + 36) - (large36% * 65536)) / 256)
        small36% = (length& + 36) - (large36% * 65536) - (med36% * 256)
        chr36(0) = CHR$(small36%)
        chr36(1) = CHR$(med36%)
        chr36(2) = CHR$(large36%)
        chr36(3) = CHR$(0)
        RETURN

Handler:       'handles run-time errors
  PRINT "Error "; ERR; " on line "; ERL
  SELECT CASE ERR
    CASE 52
      INPUT "Invalid filename. Enter a new filename: ", file$
      RESUME
    CASE ELSE
      PRINT "Unexpected error, ending program."
      END
  END SELECT


