;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;                                   PVOC.EXE
;                         Public Domain VOC file player
;
;               Please feel free to distribute or use this code
;               according to the following restrictions:
;
;        1)This code must be distributed AS-IS.  Do not remove or change
;    any part/parts of it.  If you find a way to do something better, send
;    me a copy of what you've done and I'll release the update and you'll
;    get the credit.  Otherwise there will be 180000 versions and no way
;    to support them.
;
;       2)You may modify this code or use any piece of it for your own
;    purposes, but you must inform the end user that this code is Public
;    Domain, who wrote it, and where to get it.
;
;       3)If you need a piece of this for a commercial or shareware something
;    that you are working on, drop me a message and we'll discuss it.  There
;    wont be a charge, but I'd appreciate a mention and perhaps a copy of what
;    you write.
;
;       4)Go crazy.
;
;               CopyRight (C) 1991, All Rights Reserved
;               David Hoelzer
;
;       I can be reached at:
;               dhoelzer@gnu.ai.mit.edu
;       SnailMail:
;               Everest Systems
;               Suite 180, 16 Campus Plaza
;               Box 2000
;               Vestal, NY  13850
;               ATTN: D. Hoelzer
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
;As it is now:
;       Compile normally, but link with /CP:5000 (Works good for me) to allow
;    the program to allocate more memory.
;       Simply stick pvoc.exe in the path and ct-voice.drv in c:\
;    Now just type PVOC SOUNDFILE.VOC.  Pathnames should work as well.
;
;       The program now uses two 30k(~) buffers to output the file
;    continuously.  I have had a few minor problems and unexplained crashes,
;    but I feel that they are caused by my unusual setup.
;
;       NOTE:  If your interrupt settings are not the factory defaults,
;    you must change them in ct-voice yourself with inst-drv(I think..)
 
 
;Future Stuffs:
;
 
 
 
STACKSEG        SEGMENT PARA STACK
        DB      256 DUP (?)
STACKSEG        ENDS
 
DATA            SEGMENT PUBLIC WORD 'Data'
 
PARAMLENGTH     EQU     80H
PARAMSTART      EQU     81H
 
SOUNDDRIVER     DW      0
DRIVERSEGMENT   DW      ?
VOICEFILESEG    DW      ?
VOICEFILESEG2   DW      ?
VOICEOFFSET     DW      0
MEMERROR        DB      'Memory Allocation Error.',13,10,'$'
F_MESSAGE       DB      'Error opening file: '
FILENAME        DB      '                                       ',0,13,10
                DB      'Format: PVOC SOUNDFILE.VOC',13,10,'$'
DRIVERFILE      DB      'c:\CT-VOICE.DRV',0
FILEHANDLE      DW      ?
DRIVERFILEERR   DB      'Voice Driver not found!',13,10,'$'
D_MESSAGE       DB      'Sound Card Initialization Error.',10,13,'$'
CARDSTATUS      DW      0FFFFh
MORE            DW      1
STARTUPMESSAGE  DB      'Play Voc - Public Domain',13,10
                DB      'Version 1.1 -'
                DB      ' Copyright (C) 1991, All Rights Reserved',13,10
                DB      ' David Hoelzer',13,10,'$'
DATA            ENDS
 
CODE            SEGMENT PUBLIC BYTE 'Code'
        ASSUME CS:CODE, SS:STACKSEG, DS:DATA
 
MAIN            PROC    FAR
        PUSH    DS                              ;Set up for return
        XOR     AX,AX
        PUSH    AX
        MOV     AX,DATA
        MOV     DS,AX
        LEA     DX,STARTUPMESSAGE
        MOV     AH,9
        INT     21H
        MOV     AH,81
        INT     21H
        MOV     ES,BX
        XOR     CX,CX
        MOV     CL,ES:[PARAMLENGTH]
        JCXZ    A1
        CALL    GET_PARAMS
A1:     CALL    ALLOCATEBUFFERS
        JC      EXIT
        CALL    LOADDRIVER
        JC      EXIT
        CALL    INITIALIZEDRIVER
        JC      EXIT
        CALL    OPENSOUNDFILE
        JC      EXIT
        CALL    PLAYSOUND
        CALL    SHUTDOWNCARD
EXIT:   RETF
MAIN            ENDP
 
SHUTDOWNCARD    PROC    NEAR
WAITLOOP:
        MOV     BX,CARDSTATUS
        CMP     BX,0
        JNZ     WAITLOOP
        MOV     BX,8
        CALL    DWORD PTR SOUNDDRIVER
        MOV     BX,9
        CALL    DWORD PTR SOUNDDRIVER
        RET
SHUTDOWNCARD    ENDP
 
GET_PARAMS      PROC    NEAR
        MOV     BX,PARAMSTART
        LEA     DI,FILENAME
L_1:    MOV     AH,ES:[BX]
        CMP     AH,32
        JZ      CONTINUELOOP
        MOV     [DI],AH
        INC     DI
CONTINUELOOP:
        INC     BX
        LOOP    L_1
        RET
GET_PARAMS      ENDP
 
ALLOCATEBUFFERS PROC    NEAR
        MOV     AX,4800H
        MOV     BX,0100H                        ;100h paragraphs
        INT     21H
        JC      ERROR
        MOV     DRIVERSEGMENT,AX
        MOV     AH,48H
        MOV     BX,0800H                        ;FAA pararaphs
        INT     21H
        JC      ERROR
        MOV     VOICEFILESEG,AX
        MOV     AH,48H
        MOV     BX,0800H                        ;FAA pararaphs
        INT     21H
        JC      ERROR
        MOV     VOICEFILESEG2,AX
        CLC
        RET
ERROR:  LEA     DX,MEMERROR
        MOV     AH,9
        INT     21H
        STC
        RET
ALLOCATEBUFFERS ENDP
 
INITIALIZEDRIVER PROC   NEAR
        MOV     BX,3
        CALL    DWORD PTR SOUNDDRIVER           ;Init Driver call
        CMP     AX,0
        JNZ     DRIVER_ERROR
        MOV     BX,4                            ;Turn on speaker
        MOV     AL,1
        CALL    DWORD PTR SOUNDDRIVER
        MOV     AX,DS                           ;Set status word
        MOV     ES,AX
        MOV     DI, OFFSET CARDSTATUS
        MOV     BX,5
        CALL    DWORD PTR SOUNDDRIVER
        CLC
        RET
DRIVER_ERROR:
        LEA     DX,D_MESSAGE
        MOV     AH,9
        INT     21H
        STC
        RET
INITIALIZEDRIVER ENDP
 
OPENSOUNDFILE   PROC    NEAR
        MOV     AH,3DH                          ;Open File
        MOV     AL,0
        LEA     DX,FILENAME
        INT     21H
        JC      FOPEN_ERROR
        MOV     FILEHANDLE,AX
        MOV     AH,3FH                          ;Read File
        MOV     BX,FILEHANDLE
        MOV     CX,1AH                          ;1A Bytes
        PUSH    DS
        MOV     DX,VOICEFILESEG
        MOV     DS,DX
        MOV     DX,0                            ;To offset 0
        INT     21H                             ;Read them
        POP     DS
        CLC
        RET
FOPEN_ERROR:
        LEA     DX,F_MESSAGE
        MOV     AH,9
        INT     21H
        STC
        RET
OPENSOUNDFILE   ENDP
 
LOADDRIVER      PROC    NEAR
        MOV     AH,3DH                          ;Open File
        MOV     AL,0
        LEA     DX,DRIVERFILE
        INT     21H
        JC      ERROR_D
        MOV     FILEHANDLE,AX           ;NOW ACTUALLY READ THE DRIVER
        MOV     BX,FILEHANDLE
        MOV     AX,DRIVERSEGMENT
        MOV     CX,5000                         ;5000 Bytes - This is larger
        MOV     DX,0                            ;than the file.
        PUSH    DS
        MOV     DS,AX
        MOV     AH,3FH                          ;Read File Function
        INT     21H
        POP     DS
        MOV     AH,3EH                          ;Close File
        MOV     BX,FILEHANDLE
        INT     21H
        CLC
        RET
ERROR_D:
        LEA     DX,DRIVERFILEERR
        MOV     AH,9
        INT     21H
        MOV     AH,3EH
        MOV     BX,FILEHANDLE
        INT     21H
        STC
        RET
LOADDRIVER      ENDP
 
PLAYSOUND       PROC    NEAR
        MOV     AX,VOICEFILESEG
        MOV     ES,AX
        MOV     AX,VOICEFILESEG2
        PUSH    DS
        MOV     DS,AX
        MOV     CX,100                          ;Clear 100 locations just
        XOR     AX,AX                           ;to be safe
        MOV     BX,30000                        ;Offset after Voice data
FILLBYTES:
        MOV     ES:[BX],AX
        MOV     DS:[BX],AX
        INC     BX
        LOOP    FILLBYTES
        POP     DS
        MOV     AH,3FH                          ;Read File
        MOV     BX,FILEHANDLE
        MOV     CX,6                            ;6 bytes
        PUSH    DS                              ;These are the block number,
        MOV     DX,VOICEFILESEG                 ;file size, sampling rate and
        MOV     DS,DX                           ;encoding method.
        MOV     DX,0                            ;Load to DS:0
        INT     21H
        POP     DS
        MOV     AX,VOICEFILESEG
        MOV     BX,VOICEFILESEG2
        PUSH    DS
        MOV     DS,AX
        MOV     ES,BX
        MOV     CX,6
        MOV     SI,0
        MOV     DI,SI
        CLD
        REP     MOVSB
        POP     DS
 
LOOP1:  MOV     CX,30000                        ;30000 Bytes
        MOV     BX,FILEHANDLE
        MOV     AX,3F00H                        ;Read File
        MOV     DX,VOICEFILESEG
        PUSH    DS
        MOV     DS,DX
        MOV     DX,6                            ;Load to DS:6
        INT     21H
        POP     DS
        CMP     AX,CX                           ;Check number of Bytes Read
        JZ      CONT
        MOV     DX,0                            ;Set more to 0 at EOF
        MOV     MORE,DX
CONT:   MOV     BX,1                            ;File Size location
        MOV     CX,VOICEFILESEG
        MOV     ES,CX
        MOV     ES:[BX],AL                      ;File Size High byte
        INC     BX
        MOV     ES:[BX],AH                      ;File Size Low byte
        INC     BX
        MOV     CX,0
        MOV     ES:[BX],CL                      ;File Size Last byte
        MOV     DI,0                            ;Offset of voice block
ALOOP2: MOV     BX,CARDSTATUS                   ;Wait for voice to finish
        CMP     BX,0                            ;playing.
        JNZ     ALOOP2
        MOV     BX,6                            ;Play Voice
        CALL    DWORD PTR SOUNDDRIVER
        MOV     AX,MORE
        CMP     AX,1                            ;Should we continue?
        JNZ     FINISH
        JMP     BLOOP1
 
GOBACK: JMP     LOOP1                           ;A little kludge to jump back
 
BLOOP1: MOV     CX,30000                        ;30000 Bytes
        MOV     BX,FILEHANDLE
        MOV     AX,3F00H                        ;Read File
        MOV     DX,VOICEFILESEG2
        PUSH    DS
        MOV     DS,DX
        MOV     DX,6                            ;Load to DS:6
        INT     21H
        POP     DS
        CMP     AX,CX                           ;Check number of Bytes Read
        JZ      BCONT
        MOV     DX,0                            ;Set more to 0 at EOF
        MOV     MORE,DX
BCONT:  MOV     BX,1                            ;File Size location
        MOV     CX,VOICEFILESEG2
        MOV     ES,CX
        MOV     ES:[BX],AL                      ;File Size High byte
        INC     BX
        MOV     ES:[BX],AH                      ;File Size Low byte
        INC     BX
        MOV     CX,0
        MOV     ES:[BX],CL                      ;File Size Last byte
        MOV     DI,0                            ;Offset of voice block
BLOOP2: MOV     BX,CARDSTATUS                   ;Wait for voice to finish
        CMP     BX,0                            ;playing.
        JNZ     BLOOP2
        MOV     BX,6                            ;Play Voice
        CALL    DWORD PTR SOUNDDRIVER
        MOV     AX,MORE
        CMP     AX,1                            ;Should we continue?
        JZ      GOBACK
FINISH: MOV     AH,3EH                          ;Close File
        MOV     BX,FILEHANDLE
        INT     21H
        RET
PLAYSOUND       ENDP
CODE            ENDS
        END     MAIN

