/**********************************************************
 *   TMusic CMF Background Music Class Library v2.0       *
 *           Copyright (C) 1994 Peter Moore               *
 *                All Rights Reserved                     *
 *                                                        *
 *   File: TMUSICx.H                                      *
 *   Description : Header file for TMusic Library.        *
 *        Include this in all modules that use TMusic.    *
 *        x is the memory model.                          *
 **********************************************************/

#ifndef __LARGE__
#error TMUSIC Shareware Needs Large Memory Model
#endif

#ifndef __MSDOS__
#error TMUSIC Can only be run under DOS
#endif

#ifndef __cplusplus
#error TMUSIC Requires C++ Compile
#endif

#if (__BORLANDC__ < 0x310 || __TURBOC__ < 0x310)
#error TMUSIC Requires Borland(R) or Turbo C++(tm) Version 3.1 or Higher
#endif

#define   byte      unsigned char
#define   bytef     unsigned char far *
#define   word      unsigned

const byte 
     CMF_NO_ERROR = 0,
     CMF_ERROR_DRIVER_NOT_PRESENT = 1,
     CMF_ERROR_FILE_NOT_FOUND = 2,
     CMF_ERROR_WRONG_FILE_FORMAT = 3,
     CMF_STATUS_NO_EVENT = 0,
     CMF_STATUS_BEGUN_PLAYING = 0xFF,
     CMF_STATUS_CONTROL_EVENT = 0x66;

typedef struct {
     signed char id[4];         // CTMF
     word      cmfVersion;    // Usually 1.10; MSG = Major
     word      ofsInstrument; //     
     word      ofsMusic;
     word      ticks_per_quarter_note;
     word      clock_ticks_per_second;
     word      ofsTitle;
     word      ofsAuthor;
     word      ofsComments;
     byte      channels_in_use[16];
     word      numInstruments;
     word      cmfTempo;
} TCmf;

class TMusic {
     protected:
          TCmf cmfFile;                 // A TCmf Structure          
          bytef file;           
          int transpose;
          byte status;
          byte irq;
          byte errorcode;
          void setup(void);
          void setMusicStatusByte(void);    // Sets status byte
          void setInstrumentTable(void);
          void setDriverClockRate(void);          
          void resetDriver();
     public:
          TMusic(void);                     // Constructor - No Args
          TMusic (signed char *filename);      // Constructor - One Arg
          ~TMusic(void);                    // Destructor
          word getVersion(void);            // Gets the Version
          void fileLoad (signed char *filename); // Loads a file from disk
          void setClockRate(float freq);
          void Play(void);                       // Plays the song
          void Stop(void);                       // Stops the song
          void Pause(void);                      // Pauses the song
          void Resume(void);
          void Transpose(int halfSteps);
          byte getStatus(void);
          byte getErrorCode(void);
          void operator ++ (void);
          void operator -- (void);
};
