Unit  GUSUnit ;

{---------------------------------------------------------------------------

   Copyright (c) 1993 by TBH-Softworx
                 Oliver Fromme, Klingestr. 2, 3380 Goslar, Germany
                 Internet email:   inof@asterix.rz.tu-clausthal.de

   This is donated to the PUBLIC DOMAIN.

   Many many thanks to Tran of Renaissance and Joshua Jensen!
   This would be impossible without their tech specs.

   Enjoy!

---------------------------------------------------------------------------}
Interface

Const  Left   = 0 ;     {Used for VoiceBalance}
       Middle = 7 ;
       Right  = 15 ;

       Bit8  = 0 ;      {Used for VoiceMode and RampMode,}
       Bit16 = 4 ;      {e.g. VoiceMode (0,Bit8+LoopOn+UniDir+Forw)}
       LoopOff = 0 ;
       LoopOn  = 8 ;
       UniDir = 0 ;
       BiDir  = 16 ;
       Forw  = 0 ;
       Backw = 64 ;
       Up   = 0 ;
       Down = 64 ;


Var  GUSBase    : Word ;
     GUSEnv     : String[20] ;
     GUSPresent : Boolean ;
     GUSMemory  : Word ;
     MaxVoices  : Byte ;

Procedure  GUSInitialize ;
Function   GUSTest (PortAdr : Word) : Boolean ;
Procedure  GUSInit (VoicesMax : Byte) ;
Function   GUSMem : Word ;

Procedure  GUSPoke (Address : LongInt ; Value : ShortInt) ;
Procedure  GUSPokeW (Address : LongInt ; Value : Integer) ;
Function   GUSPeek (Address : LongInt) : ShortInt ;
Function   GUSPeekW (Address : LongInt) : Integer ;

Procedure  VoiceBalance (Voice : Byte ; Balance : Byte) ;
Procedure  VoiceVolume (Voice : Byte ; Volume : Word) ;
Procedure  VoiceFreq (Voice : Byte ; Freq : Word) ;
Procedure  VoiceStart (Voice : Byte) ;
Procedure  VoiceStop (Voice : Byte) ;
Procedure  VoiceMode (Voice : Byte ; Mode : Byte) ;

Procedure  VoiceSample (Voice : Byte ; Start,LoopStart,LoopEnd : LongInt) ;
Function   GetVoiceLoc (Voice : Byte) : LongInt ;

Procedure  RampStart (Voice : Byte) ;
Procedure  RampStop (Voice : Byte) ;
Procedure  RampMode (Voice : Byte ; Mode : Byte) ;
Procedure  RampRate (Voice : Byte ; Scale,Rate : Byte) ;
Procedure  RampRange (Voice : Byte ; Lower,Upper : Word) ;

{--------------------------------------------------------------------------}
Implementation
{$L GUSUNIT.OBJ}

Uses  DOS ;

Function   GUSTest (PortAdr : Word) : Boolean ; External ;
Procedure  GUSInit (VoicesMax : Byte) ; External ;
Function   GUSMem : Word ; External ;

Procedure  GUSPoke (Address : LongInt ; Value : ShortInt) ; External ;
Procedure  GUSPokeW (Address : LongInt ; Value : Integer) ; External ;
Function   GUSPeek (Address : LongInt) : ShortInt ; External ;
Function   GUSPeekW (Address : LongInt) : Integer ; External ;

Procedure  VoiceBalance (Voice : Byte ; Balance : Byte) ; External ;
Procedure  VoiceVolume (Voice : Byte ; Volume : Word) ; External ;
Procedure  VoiceFreq (Voice : Byte ; Freq : Word) ; External ;
Procedure  VoiceStart (Voice : Byte) ; External ;
Procedure  VoiceStop (Voice : Byte) ; External ;
Procedure  VoiceMode (Voice : Byte ; Mode : Byte) ; External ;

Procedure  VoiceSample (Voice : Byte ; Start,LoopStart,LoopEnd : LongInt) ;
                       External ;
Function   GetVoiceLoc (Voice : Byte) : LongInt ; External ;

Procedure  RampStart (Voice : Byte) ; External ;
Procedure  RampStop (Voice : Byte) ; External ;
Procedure  RampMode (Voice : Byte ; Mode : Byte) ; External ;
Procedure  RampRate (Voice : Byte ; Scale,Rate : Byte) ; External ;
Procedure  RampRange (Voice : Byte ; Lower,Upper : Word) ; External ;

Procedure  GUSInitialize ;
   Var  w,ec : Word ;
   Begin
      GUSBase := 0 ;
      w := $220 ;
      GUSEnv := GetEnv('ULTRASND') ;
      If GUSEnv<>'' Then Begin
         While (GUSEnv[1]=#32) And (Length(GUSEnv)>0) Do
            Delete (GUSEnv,1,1) ;
         Val ('$'+Copy(GUSEnv,1,3),w,ec) ;
         If (ec<>0) Or (w<$210) Or (w>$260) Or (w And $f<>0) Then
            w := $220
         Else
            If Not GUSTest(w) Then
               w := $220
      End ;
      If GUSBase<>0 Then
         If Not GUSTest(w) Then Begin
            w := $210 ;
            While (w<=$260) And Not GUSTest(w) Do
               Inc (w,$10)
         End ;
      GUSPresent := GUSBase<>0 ;
      If GUSPresent Then Begin
         GUSMemory := GUSMem ;
         GUSInit (16)
      End
   End {GUSInitialize} ;

End.
