/**************************************************************************
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 *  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
 *  PURPOSE.
 *
 *  Copyright (c) 1992-1996 Syntrillium Software Corporation.  All Rights Reserved.
 * 
 **************************************************************************/
#include <windows.h>
#include <math.h>        
#include "xfmsdll.c" 
#include "resource.h"

// Usa an Internal Structure for your function, and access it through a handle
#pragma pack(1)
typedef struct dtmf_tag
{
	double fVolume;
	double fShortSilence;
	double fLongSilence;
	double fToneOnTime;
	short iMode;
	char szDialString[256];
	char cPauseChar;
} DTMF;
#pragma pack()

// Structure Definition for Preset and Script handling
// list variable types as:  c char
//							b BOOL
//							i short or WORD 
//							f float
//							l long or DWORD
//							d double
//							g WORD representing a graph id
//
// Structure Preset Vars: 'y' to include in presets, 'n' to ignore.

#define STRUCTDEFINITION "ddddisc"
#define PRESETDEFINITION "yyyyyyy"

#define TRANSFORMNAME "DTMF Signals"

#define dsetitem(Id,dVal) {ftos(tmp,dVal); SetDlgItemText(hWndDlg,Id,tmp);}
#define MEMSIZE 64000

void ftos(char *tmp, double d)
{	double dd;
	double mplier;
	short maxdecimal=9;
	
	if (d==0)
	{ *tmp='0';
	  tmp++;
	  *tmp=0x00;
	  return;
	} 
	
	if (d<0)
	{	*tmp='-';
		tmp++;
		d=-d;
	}
	d=d+(1.0/65535.0/32768.0);
	dd=d;         
	mplier=1.0;
	while (dd>=1.0)
	{	dd/=10.0;
		mplier*=10.0;	
	}   
	mplier/=10.0;             
	while (mplier>=1.0)
	{	*tmp='0'+(short)(d/mplier);
		tmp++;
		d=d-mplier*(short)(d/mplier);
		mplier/=10.0;	
	}
    if (d!=0.0)
    {	short digit;
    	*tmp='.';
    	tmp++;
    	while ((d!=0.0) && (maxdecimal!=0))
    	{	d*=10.0;
    		digit=(short)d;
    		d-=(double)digit;
    		*tmp='0'+digit;
    		tmp++;
    		maxdecimal--;    	    	
    	}             
    	while (*(tmp-1)=='0')
    		tmp--;
    	if (*(tmp-1)=='.')
    		tmp--;
    }
       
    *tmp=0x00;
}                                  

long longfromstring(char **cursor)
{   long l=0;
	while ((**cursor!=',') && (**cursor!=0x00))
	{	l=l*10+(long)(**cursor-'0');
		(*cursor)++;	
	}          
	if (**cursor!=0x00)  // skip over comma
		(*cursor)++;
 	
 	return l;
}

BOOL WINAPI DllMain (HANDLE hModule, DWORD fdwReason, LPVOID lpReserved)
{
   switch (fdwReason)
   {
      case DLL_PROCESS_ATTACH:
        /* Code from LibMain inserted here.  Return TRUE to keep the
            DLL loaded or return FALSE to fail loading the DLL.
 
            You may have to modify the code in your original LibMain to
            account for the fact that it may be called more than once.
            You will get one DLL_PROCESS_ATTACH for each process that
            loads the DLL. This is different from LibMain which gets
            called only once when the DLL is loaded. The only time this
            is critical is when you are using shared data sections.
            If you are using shared data sections for statically
            allocated data, you will need to be careful to initialize it
            only once. Check your code carefully.
 
            Certain one-time initializations may now need to be done for
            each process that attaches. You may also not need code from
            your original LibMain because the operating system may now
            be doing it for you.
         */
         break;
 
      case DLL_THREAD_ATTACH:
         /* Called each time a thread is created in a process that has
            already loaded (attached to) this DLL. Does not get called
            for each thread that exists in the process before it loaded
            the DLL.
 
            Do thread-specific initialization here.
         */
         break;
 
      case DLL_THREAD_DETACH:
         /* Same as above, but called when a thread in the process
            exits.
 
            Do thread-specific cleanup here.
         */
         break;
 
      case DLL_PROCESS_DETACH:
         /* Code from _WEP inserted here.  This code may (like the
            LibMain) not be necessary.  Check to make certain that the
            operating system is not doing it for you.
         */
         break;
   }
 
   /* The return value is only used for DLL_PROCESS_ATTACH; all other
      conditions are ignored.  */
   return TRUE;   // successful DLL_PROCESS_ATTACH
}


// Fill XFMQUERY structure with information regarding this file filter

__declspec(dllexport) short FAR PASCAL QueryXfm(XFMQUERY far * cq)
{   lstrcpy(cq->szName,TRANSFORMNAME);         
	lstrcpy(cq->szCopyright,""); 
	cq->wSupports=XFM_MONO16|XFM_STEREO16;	
	cq->dwFlags=XF_GENERATE|XF_USESPRESETSAPI;
	cq->dwUserDataLength = sizeof(DTMF);
	lstrcpy(cq->szStructDef,STRUCTDEFINITION);
	lstrcpy(cq->szPresetDef,PRESETDEFINITION);
	lstrcpy(cq->szToolHelp,"Generate DTMF or MF signals");
	return XFM_VALIDLIBRARY;
} 

__declspec(dllexport) BOOL FAR PASCAL XfmInit(COOLINFO far *ci)
{	DTMF FAR * lpAmp;
	HANDLE hTones;
	hTones=ci->hUserData;         
	lpAmp=(DTMF FAR *)GlobalLock(hTones);
	if (!lpAmp)
		return FALSE;
		
	lpAmp->fVolume=0.5;
	lpAmp->fShortSilence=0.04;
	lpAmp->fLongSilence=0.5;
	lpAmp->fToneOnTime=0.1;
	lpAmp->iMode=0;
	lstrcpy(lpAmp->szDialString,"");
	lpAmp->cPauseChar=',';
	
	GlobalUnlock(hTones);
	return TRUE;
}

__declspec(dllexport) BOOL FAR PASCAL XfmDestroy(COOLINFO far *ci)
{   DTMF FAR * lpAmp;
	HANDLE hTones;
	hTones=ci->hUserData;         
	lpAmp=(DTMF FAR *)GlobalLock(hTones);
	if (!lpAmp)
		return FALSE;                       
		
 	// Do your de-initialization here
 	                
 	GlobalUnlock(hTones);
 }

__declspec(dllexport) BOOL FAR PASCAL XfmSetup(HWND hWnd, HINSTANCE hInst, COOLINFO far *ci)
{	short nRc;
	FARPROC lpfnDIALOGMsgProc;
	
	lpfnDIALOGMsgProc = GetProcAddress(hInst,(LPCSTR)MAKELONG(100,0));
	
	nRc = DialogBoxParam((HINSTANCE)hInst,(LPCSTR)MAKEINTRESOURCE(IDD_TRANSFORM), (HWND)hWnd, (DLGPROC)lpfnDIALOGMsgProc,(DWORD)ci);
	
	return nRc;
}

short tones0[16][2] = {697,1209,  // 1
					 697,1336,  // 2
					 697,1477,  // 3
					 770,1209,  // 4
					 770,1336,  // 5
					 770,1477,  // 6
					 852,1209,  // 7
					 852,1336,  // 8
					 852,1477,  // 9
					 941,1336,  // 0
					 941,1209,  // *
					 941,1477,  // #
					 697,1633,  // a
					 770,1633,  // b
					 852,1633,  // c
					 941,1633,  // d
					};

short tones1[15][2] = {	700,900,
						700,1100,
						900,1100,
						700,1300,
						900,1300,
						1100,1300,
						700,1500,
						900,1500,
						1100,1500,
						1300,1500,
						1100,1700,
						1500,1700,
						900,1700,
						1300,1700,
						700,1700
					};

void BuildValidString(short iMode,unsigned char cPause,LPSTR szTmp)
{	lstrcpy(szTmp,"?");
	switch (iMode)
	{	case 0: 
			wsprintf(szTmp,"1234567890*#abcd%c",cPause);	
			break;
		case 1:
		    wsprintf(szTmp,"1234567890*#abc%c",cPause);		
	    	break;
	}
}

DWORD CalculateSamples(COOLINFO far *ci,DTMF far *lpAmp)
{   short t;
	DWORD dwCount=0;
	BOOL bFirst=TRUE;
	char szValidString[20];
    
    BuildValidString(lpAmp->iMode,lpAmp->cPauseChar,(LPSTR)szValidString);
    
    for (t=0;t<lstrlen(lpAmp->szDialString);t++)
    {	char c;
    	short iOffset;
    	short w;
    	c=lpAmp->szDialString[t];
    	
    	iOffset=-1;
    	if (c==lpAmp->cPauseChar)
    	{	// Generate Silence
    	    dwCount+=(DWORD)(lpAmp->fLongSilence*(double)ci->lSamprate);    	    
    	    
    	}
    	else
    	{	for (w=0;w<lstrlen(szValidString);w++)
	    	{	if (szValidString[w]==c)
	    		{	iOffset=w;
	    			break;
	    		}
	    	}
	    	if (iOffset!=-1)
	    	{	if (!bFirst)
	    	    {
	    	     	dwCount+=(DWORD)(lpAmp->fShortSilence*(double)ci->lSamprate);
	    	    }
	    	    bFirst=FALSE;
	    	    
	    	    dwCount+=(DWORD)(lpAmp->fToneOnTime*(double)ci->lSamprate);
	    	}
	    	
        }    
    }                                            
    
    return dwCount;
}
     			  

__declspec(dllexport) DWORD FAR PASCAL XfmDo(COOLINFO far *ci)
{	DTMF FAR * lpAmp = NULL;
	HANDLE hTones = NULL;
	DWORD losamp, hisamp;
	DWORD nsamples=0L; 
	short t;
	char szValidString[20];
    HANDLE hBigMem;
    unsigned char far *pData;
    short far *piData;
    BOOL bFirst=TRUE; 
    DWORD startat;
    
    
    hTones=ci->hUserData;         
	lpAmp=(DTMF FAR *)GlobalLock(hTones);
	losamp=ci->dwLoSample;
	hisamp=ci->dwHiSample;
	              	 
    ProgressCreate(ci,"Generating DTMF signals",NULL);
    
    BuildValidString(lpAmp->iMode,lpAmp->cPauseChar,(LPSTR)szValidString);
    
    hBigMem=GlobalAlloc(GMEM_MOVEABLE,4096*ci->wBlockAlign);
    pData=(unsigned char far *)GlobalLock(hBigMem);
    piData=(short far *)pData;
    startat=losamp;
    
    for (t=0;t<lstrlen(lpAmp->szDialString);t++)
    {	char c;
    	short iOffset;
    	short w;
    	c=lpAmp->szDialString[t];
    	
    	iOffset=-1;
    	if (c==lpAmp->cPauseChar)
    	{	// Generate Silence
    	    DWORD dwSamples;
    	    dwSamples=(DWORD)(lpAmp->fLongSilence*(double)ci->lSamprate);
    	    while (dwSamples)
    	    {	long lAmount;     
    	    	
    	    	lAmount=min(dwSamples,4096);
    	    	dwSamples-=lAmount;
    	    	FillMemory(pData,lAmount*ci->wBlockAlign,0);
    	    	WriteData(ci,(char *)pData,startat*ci->wBlockAlign,lAmount*ci->wBlockAlign);
    	    	startat+=lAmount; 
    	    	nsamples+=lAmount;
    	    }    	    
    	}
    	else
    	{	
    	    
    		for (w=0;w<lstrlen(szValidString);w++)
	    	{	if (szValidString[w]==c)
	    		{	iOffset=w;
	    			break;
	    		}
	    	}
	    	if (iOffset!=-1)
	    	{	// Genrate Tones
	    	    short iTone1,iTone2;
	    	    DWORD dwSamples;
    	    	double fToneInc1,fToneInc2;
	    	   	double fToneAt1,fToneAt2;
	    	   		
    	    	if (!bFirst)  // interval silence time
	    	    {   dwSamples=(DWORD)(lpAmp->fShortSilence*(double)ci->lSamprate);
		    	    while (dwSamples)
		    	    {	long lAmount;
		    	    	lAmount=min(dwSamples,4096);
		    	    	dwSamples-=lAmount;
		    	    	FillMemory(pData,lAmount*ci->wBlockAlign,0);
		    	    	WriteData(ci,(char *)pData,startat*ci->wBlockAlign,lAmount*ci->wBlockAlign);
		    	    	startat+=lAmount; 
		    	    	nsamples+=lAmount;
		    	    }	    	    
	    	    }
	    	    bFirst=FALSE;
	    	                              
	    	    if (lpAmp->iMode==0)
	    	    {	iTone1=tones0[iOffset][0];
	    	    	iTone2=tones0[iOffset][1];
	    	    }
	    	    else
	    	    {	iTone1=tones1[iOffset][0];
	    	    	iTone2=tones1[iOffset][1];
	    	    }
	    	    
	    	    fToneAt1=fToneAt2=0;
	    	    fToneInc1=3.1415926535*2.0*(double)iTone1/(double)ci->lSamprate;
	    	    fToneInc2=3.1415926535*2.0*(double)iTone2/(double)ci->lSamprate;
	    	    
		    	dwSamples=(DWORD)(lpAmp->fToneOnTime*(double)ci->lSamprate);
	    	    while (dwSamples)
	    	    {	long lAmount;
	    	    	short t;
	    	    	double fVal;
	    	    	
	    	    	lAmount=min(dwSamples,4096);
	    	    	//if (ci->wBitsPerSample==16)
	    	    	{	if (ci->wChannels==1)
	    	    	    {   for (t=0;t<lAmount;t++)
			    	    	{	fVal=sin(fToneAt1)+sin(fToneAt2);
			    	    		fVal*=16384.0*(double)lpAmp->fVolume;
			    	    		if (dwSamples-t<20)
			    	    			fVal=fVal*(dwSamples-t)/20.0;
			    	    		if (fVal<-32768)
			    	    			fVal=-32768;
			    	    		if (fVal>32767)
			    	    			fVal=32767;
			    	    		piData[t]=(short)fVal;
			    	    		fToneAt1+=fToneInc1;
			    	    	    fToneAt2+=fToneInc2;
			    	    	}
			    	    }
			    	    else
			    	    {   short tt;
			    	    	for (t=0,tt=0;t<lAmount;t++,tt+=2)
			    	    	{	fVal=sin(fToneAt1)+sin(fToneAt2);
			    	    		fVal*=16384.0*(double)lpAmp->fVolume;
			    	    		if (dwSamples-t<20)
			    	    			fVal=fVal*(dwSamples-t)/20.0;
			    	    		if (fVal<-32768)
			    	    			fVal=-32768;
			    	    		if (fVal>32767)
			    	    			fVal=32767;
			    	    		piData[tt]=(short)fVal;
			    	    		piData[tt+1]=(short)fVal;
			    	    		fToneAt1+=fToneInc1;
			    	    	    fToneAt2+=fToneInc2;
			    	    	}
			    	    }	
	    	    	}
	    	    	/*
	    	    	else
	    	    	{   if (ci->wChannels==1)
	    	    	    {   for (t=0;t<lAmount;t++)
			    	    	{	fVal=sin(fToneAt1)+sin(fToneAt2);
			    	    		fVal=fVal*64.0*(double)lpAmp->fVolume;
			    	    		if (dwSamples-t<20)
			    	    			fVal=fVal*(dwSamples-t)/20.0;
			    	    		fVal+=128;	
			    	    		pData[t]=(unsigned char)fVal;
			    	    		fToneAt1+=fToneInc1;
			    	    	    fToneAt2+=fToneInc2;
			    	    	}
			    	    }
			    	    else
			    	    {   short tt;
			    	    	for (t=0,tt=0;t<lAmount;t++,tt+=2)
			    	    	{	fVal=sin(fToneAt1)+sin(fToneAt2);
			    	    		fVal=fVal*64.0*(double)lpAmp->fVolume;
			    	    		if (dwSamples-t<20)
			    	    			fVal=fVal*(dwSamples-t)/20.0;    
			    	    		fVal+=128;
			    	    		pData[tt]=(short)fVal;
			    	    		pData[tt+1]=(short)fVal;
			    	    		fToneAt1+=fToneInc1;
			    	    	    fToneAt2+=fToneInc2;
			    	    	}			    	    
			    	    }	    	    	
	    	    	}
	    	    	*/
	    	    	dwSamples-=lAmount;
	    	    	
	    	    	WriteData(ci,(char *)pData,startat*ci->wBlockAlign,lAmount*ci->wBlockAlign);
	    	    	startat+=lAmount;
	    	    	nsamples+=lAmount;
	    	    }	    	    
	    	}
        }    
    	ProgressMeter(ci,t,lstrlen(lpAmp->szDialString));
    	if (*ci->lpProgressCanceled) break;
 
    }
    
    ProgressDestroy(ci);
    
    
    GlobalUnlock(hTones);
	return nsamples;
}
		

    
    
void DialogToStruct(COOLINFO FAR *ci, HWND hWndDlg, DTMF FAR * lpAmp)
{	char tmp[30];
//	HANDLE hListBox;
	
	GetDlgItemText(hWndDlg,IDC_AMPLITUDE,tmp,29);
	lpAmp->fVolume=atof(tmp)/100.0;
	GetDlgItemText(hWndDlg,IDC_BREAKTIME,tmp,29);
	lpAmp->fShortSilence=atof(tmp)/1000.0;
	GetDlgItemText(hWndDlg,IDC_PAUSETIME,tmp,29);
	lpAmp->fLongSilence=atof(tmp)/1000.0;
	GetDlgItemText(hWndDlg,IDC_TONETIME,tmp,29);
	lpAmp->fToneOnTime=atof(tmp)/1000.0;
	lpAmp->iMode=IsDlgButtonChecked(hWndDlg,IDC_RADIO1)?0:1;
	GetDlgItemText(hWndDlg,IDC_DIALSTRING,lpAmp->szDialString,255);
	GetDlgItemText(hWndDlg,IDC_PAUSECHAR,tmp,5);
	lpAmp->cPauseChar=tmp[0];
	
}

void StructToDialog(COOLINFO FAR *ci, DTMF FAR *lpAmp, HWND hWndDlg)
{   char tmp[30];
    
    dsetitem(IDC_AMPLITUDE,lpAmp->fVolume*100.0);
    dsetitem(IDC_BREAKTIME,lpAmp->fShortSilence*1000.0);
    dsetitem(IDC_PAUSETIME,lpAmp->fLongSilence*1000.0);
    dsetitem(IDC_TONETIME,lpAmp->fToneOnTime*1000.0);
    CheckDlgButton(hWndDlg,IDC_RADIO1,lpAmp->iMode?FALSE:TRUE);
    CheckDlgButton(hWndDlg,IDC_RADIO2,lpAmp->iMode?TRUE:FALSE);
    SetDlgItemText(hWndDlg,IDC_DIALSTRING,lpAmp->szDialString);
    wsprintf(tmp,"%c",lpAmp->cPauseChar);
    SetDlgItemText(hWndDlg,IDC_PAUSECHAR,tmp);
    BuildValidString(lpAmp->iMode,lpAmp->cPauseChar,(LPSTR)tmp);
    SetDlgItemText(hWndDlg,IDC_USABLECHARS,tmp);
}    
    


void CopyToDlgItem(HWND hWndDlg, short iControl,COOLINFO far *ci,HANDLE hAmplify,  DTMF FAR *lpAmp)
{   char m[80];
	wsprintf(m,"%ld,%d,%ld",lpAmp,hAmplify,ci);
	SetDlgItemText(hWndDlg,iControl,m);	
}                                      

void CopyFromDlgItem(HWND hWndDlg, short iControl,  COOLINFO far **ci, HANDLE *hAmplify, DTMF FAR **lpAmp)
{	char m[80];
	char *cursor;         
	GetDlgItemText(hWndDlg,iControl,m,80);
	if (m[0]==0x00)
	{	*lpAmp=NULL;
		*hAmplify=0;
		*ci=NULL;
		return;
	}          
	cursor=m;
	*lpAmp=(DTMF FAR *)longfromstring(&cursor);
	*hAmplify=(HANDLE)longfromstring(&cursor);
	*ci=(COOLINFO far *)longfromstring(&cursor);
	
}

    
__declspec(dllexport) BOOL FAR PASCAL DIALOGMsgProc(HWND hWndDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{   DTMF FAR * lpAmp = NULL;
	HANDLE hTones = NULL;
	COOLINFO far *ci=NULL;
	switch(Message)
   	{	case WM_INITDIALOG:
		{	ci=(COOLINFO far *)lParam;
			hTones=ci->hUserData;         
			lpAmp=(DTMF FAR *)GlobalLock(hTones);
			
			CopyToDlgItem(hWndDlg,IDC_STORAGE,ci,hTones,lpAmp);
	        
			CenterDialog(ci,hWndDlg);
	        
	        if (!PresetsInit(ci, hWndDlg, TRANSFORMNAME))
	        {   // Put your own profile string defaults here...
				//WritePrivateProfileString(TRANSFORMNAME,"Item1","Fade In,3,0,0,100,100,none,none,none",ci->szIniFile); 
          	  	//WritePrivateProfileString(TRANSFORMNAME,"Item2","Fade Out,3,100,100,0,0,none,none,none",ci->szIniFile); 
          	  	//PresetsInit(ci,hWndDlg,TRANSFORMNAME);
          	}	          
	        
			StructToDialog(ci, lpAmp, hWndDlg);
	
	 		// using scripts, auto OK it.
	 		if ((ci->iScriptFile!=-1) && (!ci->iScriptDialogStop))
		 		PostMessage(hWndDlg,WM_COMMAND,IDOK,0L);	        
		}    		
        break; /* End of WM_INITDIALOG                                 */

    case WM_CLOSE:
         /* Closing the Dialog behaves the same as Cancel               */
         PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
         break; 
    case WM_COMMAND:
         CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hTones,&lpAmp);
	     switch(LOWORD(wParam))
           {  case ID_HLP:
           		 WinHelp(hWndDlg,XFM_HELPFILE,HELP_KEY,(DWORD)((LPSTR)"DTMF Tones"));
                 break;  
              case ID_PRESETS:
                 if (HandleID_PRESETS(ci, hWndDlg, TRANSFORMNAME, wParam, lParam))
                 {	StructToDialog(ci, lpAmp, hWndDlg);                    
                 }
                 break;
              case ID_ADD:
              	DialogToStruct(ci, hWndDlg, lpAmp);
              	HandleID_ADD(ci, hWndDlg, TRANSFORMNAME);       
              	break; 	 
              case ID_DEL:
              	HandleID_DEL(ci, hWndDlg, TRANSFORMNAME);
              	break;
              case ID_PRESETNAME:
              	HandleID_PRESETNAME(ci, hWndDlg);
              	break;	
              case IDC_PAUSECHAR:
              case IDC_RADIO1:
              case IDC_RADIO2:
                {	char tmp[29];
                	GetDlgItemText(hWndDlg,IDC_PAUSECHAR,tmp,5);
	            	lpAmp->cPauseChar=tmp[0];
	            	if (lpAmp->cPauseChar<32)
	            		lpAmp->cPauseChar=' ';	            	
	            	BuildValidString((short)(IsDlgButtonChecked(hWndDlg,IDC_RADIO1)?0:1),lpAmp->cPauseChar,(LPSTR)tmp);
    				SetDlgItemText(hWndDlg,IDC_USABLECHARS,tmp);                
                }
              	break;	
           	case IDOK:
              {	  if (GetFocus()==GetDlgItem(hWndDlg,ID_PRESETS))
                  {	PostMessage(hWndDlg,WM_COMMAND,ID_PRESETS,MAKELONG(GetDlgItem(hWndDlg,ID_PRESETS),LBN_DBLCLK));
                    break;
                  }
              	  DialogToStruct(ci, hWndDlg,lpAmp);
                  
                  GlobalUnlock(hTones); 
             	  hTones=NULL;
             	  
             	  ci->bReplacesHighlightedSelection=TRUE;
     			  ci->dwInsertBlankSamples=CalculateSamples(ci,lpAmp);
     			  
     			  
                  EndDialog(hWndDlg, TRUE);
               }
            	 break;                                                    
               case IDCANCEL:
                 /* Ignore data values entered into the controls        */
                 /* and dismiss the dialog window returning FALSE       */
                 GlobalUnlock(hTones);
                 hTones=NULL;
                 EndDialog(hWndDlg, FALSE);
                 break;
           }
         break;    /* End of WM_COMMAND                                 */

    default:
		return FALSE;
   }
 	return TRUE;
}
