/////////////////////////////////////////////////////////////////////
// GENERAL PURPOSE DEFS FOR CREATING CUSTOM TRANSFORMATION EFFECTS //
/////////////////////////////////////////////////////////////////////

#define XFM_MONO8		1
#define XFM_STEREO8 	2
#define XFM_MONO16		4
#define XFM_STEREO16	8  

#define XFM_HELPFILE "cool95.hlp"

typedef DWORD (CALLBACK*      DWFARPROC)();
typedef void  (CALLBACK*      VFARPROC)();

typedef struct xfmquery_tag
{	char szName[40];  	// Appears in Menu (without elipsis...)
	char szCopyright[80];
	char szToolHelp[70];
	WORD wSupports;		// OR's of XFM_MONO16, XFM_STEREO16, XFM_MONO8, XFM_STEREO8
	DWORD dwFlags;		// Any of the XF_ flags OR'd together
						// Must have either XF_TRANSFORM or XF_GENERATE
						// May have XF_HASPRESETS, XF_HASSCRIPTS	
	DWORD dwUserDataLength;		// Length of transform's internal data
	char szStructDef[48];	// Array of chars representing types in user data area
	char szPresetDef[48];	// Array of chars 'y' to include in presets, 'n' to ignore.	
} XFMQUERY;

#define XFM_VALIDLIBRARY 1152

#define XF_TRANSFORM    		1	// This function transforms highlighted audio
#define XF_GENERATE				2	// This function generates new pcm wave data
#define XF_USESPRESETSAPI		4	// Has a presets box (and uses the presets/scripts API)
#define XF_USESGRAPHAPI			8	// Uses the built in graph control functions
#define XF_MUSTHIGHLIGHT 		16  // If set, function only enabled if a selection is highlighted (normal)
#define XF_MUSTHAVECLIP    	 	32  // If set, function is grayed if nothing on clipboard
#define XF_MODIFIESTOENDOFVIEW  64  // Set this if function modifies data outside user's given selection							
#define XF_MODIFIESTOENDOFFILE  128 // Set this if function modifies data outside user's given selection							
#define XF_USESFFTAPI			256 // Uses Cool's FFT functions
#define XF_NOSINGLEEDIT			512 // Do not include if editing only one channel
#define XF_ANALYZE				1024 // This function analyzes data

#define XF_MODIFIESOUTSIDESEL	8192 // Set this if function modifies data outside selection, and fill dwModifyLeft and
									 // dwModifyRight upon exiting XfmSetup
#define XF_SYSTEM				16384 // System function - does not show up in drop-down list

#define XF_AUTOOK				0x80000000L	// If set, wm_initdialog should send "OK" message to close


//#define COOLCALLBACK	_far _pascal
//typedef int (COOLCALLBACK* COOLINTPROC)();

typedef struct coolinfo_tag
{	WORD wChannels;			// Number of channels
	WORD wBitsPerSample;	// Bit size, 8 or 16 for now
	WORD wBlockAlign;		// Bytes per sample (eg stereo 16-bit = 4)
	long lSamprate;			// Sample rate (8000,11025,22050, etc.) 
	HANDLE hUserData;		// Handle to specialized transform data, depends on DLL
	DWORD dwLoSample;       // Lowest sample to transform
	DWORD dwHiSample;		// Highest sample
	FARPROC lpTestFunction; 
	XFMQUERY FAR *cq;		// Pointer to query struct
	// General Purpose Tools
	FARPROC lpCenterDialog; // (HWND hWndDlg, int iUnused)  Center the dialog box
	
	// Reading and Writing audio data
	FARPROC lpReadData;		// (char huge *data,long offset,long amount)
	FARPROC lpWriteData;	// (char huge *data, DWORD offset,DWORD nbytes)	              
	
	// Progress Meter
	BOOL FAR *lpProgressCanceled;  // if TRUE, user hit Cancel button, you must stop processing NOW
	FARPROC lpProgressMeter; // (DWORD dwCurrent, DWORD dwTotal)  percent done is 100*dwCurrent/dwTotal
	FARPROC lpProgressCreate; // (LPCSTR szText)  szText is message to indicate type of processing
	FARPROC lpProgressDestroy; // (void)  Call to remove progress meter
	
	// Presets
	char far * szIniFile;    // Ini file
	FARPROC lpPresetsInit;	 // (HWND hWndDlg,LPSTR szGroupName)
    FARPROC lpHandleID_PRESETNAME;
	FARPROC lpHandleID_PRESETS;
	FARPROC lpHandleID_ADD;
	FARPROC lpHandleID_DEL;    
	
	// Graph control
	FARPROC lpGraphCreate;
	FARPROC lpGraphCount;
	FARPROC lpGraphGetPoint;
	FARPROC lpGraphGetValueAt;
	FARPROC lpGraphDraw;
	FARPROC lpGraphClear;
	FARPROC lpGraphInverse;
	FARPROC lpGraphDestroy;
	FARPROC lpGraphHandleWM_LBUTTONDOWN;
	FARPROC lpGraphHandleWM_LBUTTONUP;
	FARPROC lpGraphHandleWM_LBUTTONDBLCLK;
	FARPROC lpGraphHandleWM_MOUSEMOVE;
	FARPROC lpGraphSetDblClkScales;
	FARPROC lpGraphSetDblClkNames; 
	FARPROC lpGraphSetDialog;	
	
	short iScriptFile;  
	short iScriptDialogStop; 
	
	HFONT hFont; 	// smaller font for dialogs
	
	// for XF_GENERATE type, must be filled out during XfmSetup
	BOOL	bReplacesHighlightedSelection;	// if TRUE, highlighted selection is deleted before inserting blanks
	DWORD	dwInsertBlankSamples;			// the number of samples to generate
	BOOL	bHasCoprocessor;					// if TRUE, use fp, otherwise use table lookups and other speedups
	FARPROC lpFFT; // 	perform n-point FFT (radix-2 for now)
	FARPROC	lpWindowFFT;
	FARPROC lpIWindowFFT;
	FARPROC lpSetWindowType;  // 0..5: Triangular, von Hann, Hamming, Blackman, Cosine^2, Blackman-Harris
	FARPROC lpGetTempName; // get temporary file name
	
	FARPROC lpSetFFT16bit;
	FARPROC lpSetFFT8bit;
	FARPROC lpSetStereoFFT16bit;
	FARPROC lpSetStereoFFT8bit;
	FARPROC lpSetStereoFFT16bitInterleaved;
	FARPROC lpSetStereoFFT8bitInterleaved;
	FARPROC lpGetStereoFFT16bitInterleaved;
	FARPROC lpGetStereoFFT8bitInterleaved;    
	
	FARPROC lpCreateXfmVars;
	FARPROC lpSetXfmVar;
	DWFARPROC lpCallXfm;
	
	// Delayed writing
	VFARPROC lpDelayWrite;
	VFARPROC lpDelayWriteInit;
	VFARPROC lpDelayWriteDestroy;
	
	HINSTANCE hInst;
	
	FARPROC lpGraphCopy;
	FARPROC lpCutData;
	FARPROC lpInsertBlankData;
	FARPROC lpDeleteXfmVars; 
	
	DWORD dwRightSample;    // Current viewing screen rightmost sample
	DWORD dwLeftSample;		// and leftmost sample  
	FARPROC lpGraphSetPoint;
	
	DWORD dwExtraFlags;
	FARPROC lpLFFT;
	DWFARPROC lpConvolute;
		
	DWORD dwModifyLeft;
	DWORD dwModifyRight;		 		
	
	// Used for Preview mode
	HINSTANCE hInstThisLibrary;
	DWFARPROC lpFutureFunction1;
	DWFARPROC lpFutureFunction2;
	DWFARPROC lpFutureFunction3;
} COOLINFO;	 		

