unit hex;
{print hex numbers}
{Aug 1 91 Bob G initial edit}

interface
function ltohex(l: longint): string; {32 bit}
function vtohex(l: longint): string; {24 bit}
function itohex(n: integer): string; {16 bit}
function ptohex(n: integer): string; {12 bit}
function btohex(n: integer): string; {8 bit}

implementation

const
  hexstr: array[0..15] of char=('0','1','2','3','4','5','6','7',
    '8','9','a','b','c','d','e','f');

{---------------------}
function ltohex(l: longint): string;
{return l as 8 char hex string}

var
  tmpstr: string;

begin
  tmpstr[1]:=hexstr[(l and $f0000000) shr 28];
  tmpstr[2]:=hexstr[(l and $0f000000) shr 24];
  tmpstr[3]:=hexstr[(l and $00f00000) shr 20];
  tmpstr[4]:=hexstr[(l and $000f0000) shr 16];
  tmpstr[5]:=hexstr[(l and $0000f000) shr 12];
  tmpstr[6]:=hexstr[(l and $00000f00) shr 8];
  tmpstr[7]:=hexstr[(l and $000000f0) shr 4];
  tmpstr[8]:=hexstr[l  and $0000000f];
  tmpstr[0]:=chr(8);
  ltohex:=tmpstr;
end;

{---------------------}
function vtohex(l: longint): string;
{return l as 6 char hex string}

var
  tmpstr: string;

begin
  tmpstr[1]:=hexstr[(l and $00f00000) shr 20];
  tmpstr[2]:=hexstr[(l and $000f0000) shr 16];
  tmpstr[3]:=hexstr[(l and $0000f000) shr 12];
  tmpstr[4]:=hexstr[(l and $00000f00) shr 8];
  tmpstr[5]:=hexstr[(l and $000000f0) shr 4];
  tmpstr[6]:=hexstr[l  and $0000000f];
  tmpstr[0]:=chr(6);
  vtohex:=tmpstr;
end;

{---------------------}
function itohex(n: integer): string;
{return n as 4 char hex string}

var
  tmpstr: string;

begin
  tmpstr[1]:=hexstr[n shr 12];
  tmpstr[2]:=hexstr[(n and $0f00) shr 8];
  tmpstr[3]:=hexstr[(n and $00f0) shr 4];
  tmpstr[4]:=hexstr[n and $000f];
  tmpstr[0]:=chr(4);
  itohex:=tmpstr;
end;

{---------------------}
function ptohex(n: integer): string;
{return 12 bit pot n as 3 char hex string}

var
  tmpstr: string;

begin
  tmpstr[1]:=hexstr[n shr 8];
  tmpstr[2]:=hexstr[(n and $00f0) shr 4];
  tmpstr[3]:=hexstr[n and $000f];
  tmpstr[0]:=chr(3);
  ptohex:=tmpstr;
end;

{---------------------}
function btohex(n: integer):string;
{byte value n}

var
  tmpstr: string;

begin
  tmpstr[1]:=hexstr[(n and $00f0) shr 4];
  tmpstr[2]:=hexstr[n and $000f];
  tmpstr[0]:=chr(2);
  btohex:=tmpstr;
end;
end.
