program portuse;
{read io ports twice, compare, report differences}
{Dec 13 89 Bob Gardner initial edit}
{Jan 3 94 Bob G use hex unit}
{Dec 2 96 Bob G clean up to send to aol}

uses
  crt,hex;

type
  Tarr=array[0..$ff] of byte;

var
  i,baseport,err: integer;
  buf: Tarr;
  linbuf: array[0..15] of byte;
  c: char;

{--------------------}
procedure compbuf(p: integer);
{compare port contents starting at port p to buf}

var
  i,j,b,ndx: integer;
  c: char;

begin
  gotoxy(1,1);
  lowvideo;
  write('     ');
  for i:=0 to 15 do begin
    write(btohex(i),' ');       {header}
    if i=7 then write(' ');
  end;
  writeln;
  writeln;
  for i:=0 to 15 do begin       {for 16 rows}
    lowvideo;
    write(itohex(p+i*16),' ');  {port addr}
    for j:=0 to 15 do begin     {16 hex bytes}
      ndx:=i*16+j;
      b:=port[p+ndx];           {get byte from port}
      linbuf[j]:=b;             {save it in linbuf for ascii dump}
      if b=buf[ndx] then        {same as last pass?}
        lowvideo
      else
        highvideo;
      write(btohex(b),' ');     {dump hex}
      if j=7 then write(' ');
    end;
    write('  ');

    for j:=0 to 15 do begin
      ndx:=i*16+j;
      c:=chr(linbuf[j]);        {dump ascii}

      if c=chr(buf[ndx]) then   {same as last pass?}
        lowvideo
      else
        highvideo;
      if ord(c)>$20 then
        write(c)
      else
        write('.');
      if j=7 then write(' ');

      buf[ndx]:=b;              {update last pass buf}
    end;
    writeln;
  end;
  writeln;
end;

{--------------------}
begin {main program}
  writeln('Portuse     Dec 2 96 BobGardner@aol.com');
  if paramcount<>1 then begin
    writeln('usage: C>portuse 0|$100|$200|$300');
    exit;
  end;
  val(paramstr(1),baseport,err);
  for i:=0 to $ff do begin {fill buff initially}
    buf[i]:=port[baseport+i];
  end;
  clrscr;
  repeat
    compbuf(baseport);
  until keypressed;
  c:=readkey;
end.
