CODE	SEGMENT
	assume cs:code,ds:code,es:code,ss:code
	.386

DoDeviceReset	equ	0

MSG	macro	text
local	tl, le
	lea	si,[tl]
	call	string
	jmp	le
tl:
	db	text
	db	0
le:
endm

MSGN	macro	text
local	tl, le
	lea	si,[tl]
	call	string
	jmp	le
tl:
	db	text
	db	0dh, 0ah, 0
le:
endm

CRLF	macro
	lea	si,[newline]
	call	string
endm

	org	100h


start:
	jmp	real_start
;
scsimgr:	db	'SCSIMGR$',0	; Signature of the ASPI driver
Target:		db	0		; SCSI target ID for CD-ROM
TrackNum:	db	0		; Track number
FirstTrack:	db	0		; First track number
LastTrack:	db	0		; Last track number
BlockSize:	db	0		; Number of audio sectors to read
fname:		db	'CDDATA.WAV',0
handle:		dw	0		; File handle
ModeSet:	db	0		; Mode Select was sent to drive
Locked:		db	0		; Media is locked
newline:	db	0Dh,0Ah,0	; Data for CRLF
BigCount:	dd	0		; Count of sectors to read
TotCount:	dd	0		; Size of track
CurLba:		dd	0		; Current position on the disc
WaveHeader:	db	'RIFF'
		dd	0		; Length-8 will go here
		db	'WAVEfmt '
		dd	10h
		dw	1
		dw	2		; Number of channels
		dw	44100		; Samples per sec
		dw	0
		dw	0B110h		; ???
		dw	2
		dw	4		; Block Align
		dw	10h
		db	'data'
		dd	0		; Data length (FileLen-2C)
filelen:	dd	0		; Accumulated file length

modesave:	db	14h dup (0)
modedata:	db	0, 0A4h, 0, 8, 0, 0, 0, 0
		db	0, 0, 9, 30h, 23h, 6, 2, 0
		db	0, 0, 0, 0	; Data for Mode Select

CDB6		equ	6
CDB10		equ	10
SENSESIZE	equ	10

aspi_ptr:	dd	0		; Pointer to AXPI entry point
SRB:		db	64+CDB10+SENSESIZE dup (0)	; SCSI request block
SrbCmd		equ	SRB+0		; Command offset
SrbStatus	equ	SRB+1		; Status offset
SrbAdapter	equ	SRB+2		; Adapter ID offset
SrbFlags	equ	SRB+3		; Flags offset
SrbTarget	equ	SRB+8		; SCSI Target ID offset
SrbLun		equ	SRB+9		; SCSI LUN offset
SrbDevtype	equ	SRB+0Ah		; Drive Type Byte offset
SrbDataLen	equ	SRB+0Ah		; Data allocation length (dword)
SrbSenseLen	equ	SRB+0Eh		; Sense field length
SrbBuffer	equ	SRB+0Fh		; Buffer address (dword)
SrbCdbLen	equ	SRB+17h		; Size of CDB
CDB		equ	SRB+40h		; Actual CDB
OpCode		equ	CDB		; SCSI Operation Code

XFERNONE	equ	0
XFERREAD	equ	8
XFERWRITE	equ	10h
;

real_start:
	CRLF
	lea	dx,[scsimgr]
	mov	ax,3d00h
	int	21h
	jnc	aspi_ok
	MSGN	'ASPI Manager is not found'
	jmp	bad_exit

bad_exit:
	cmp	byte ptr [ModeSet],0
	jz	mode_ok
	mov	word ptr [SrbBuffer],offset modesave
	call	ModeSelect
mode_ok:
	cmp	byte ptr [Locked],0
	jz	lock_ok
	mov	al,0
	call	MediaLock
lock_ok:
	mov	ax,4C01h
	int	21h

aspi_ok:
	mov	bx,ax
	push	bx
	mov	ax,4402h
	lea	dx,[aspi_ptr]
	mov	cx,4
	int	21h
	pop	bx
	mov	ah,3eh
	int	21h

	MSG	'ASPI entry point '
	mov	eax,dword ptr [aspi_ptr]
	call	hexd
	CRLF

	mov	byte ptr [SrbCmd],0
	mov	byte ptr [SrbFlags],XFERNONE
	call	CallAspi

	MSG	'Host Adapter: '
	mov	byte ptr [SRB+2Ah],0	; ASCIIZ Host Adapter string
	lea	si,[SRB+1Ah]
	call	string
	CRLF

	MSG	'SCSI Manager: '
	mov	byte ptr [SRB+1Ah],0	; ASCIIZ Scsi Manager string
	lea	si,[SRB+0Ah]
	call	string
	CRLF

	call	ScanScsiDevices
	cmp	byte ptr [Target],0FFh		; FF if no CD-ROMs
	jnz	cdrom_found
	MSGN	'CD-ROM is not found on the SCSI bus'
	jmp	bad_exit

cdrom_found:
if DoDeviceReset
	call	ResetDevice
endif

	call	WaitReady
	mov	byte ptr [TrackNum],0
	mov	word ptr [SrbBuffer],offset TocBuffer
	call	ReadTOC				; read whole TOC
	test	byte ptr [TocBuffer+5],4	; If 1 - Data
	jz	audio_disc
	MSGN	'This is not an audio disc'
	jmp	bad_exit

audio_disc:
	call	Track_Info

	call	GetTrack			; Get start/length of track

	mov	eax,dword ptr [bx]		; Get starting address
	mov	dword ptr [CDB+6],eax
	mov	dword ptr [CurLba],eax
	mov	eax,dword ptr [si]		; Length of track
	and	eax,eax
	jnz	track_valid
	MSGN	'Track Info Data is invalid'
	jmp	bad_exit

track_valid:
	mov	byte ptr [BigCount+3],al
	mov	byte ptr [BigCount+2],ah
	shr	eax,10h
	mov	byte ptr [BigCount+1],al
	mov	byte ptr [BigCount],ah

	mov	eax,dword ptr [BigCount]
	mov	dword ptr [TotCount],eax

	MSG	'Track Length '
	mov	ax,word ptr [BigCount]
	mov	dx,word ptr [BigCount+2]
	call	ShowTime
	CRLF

	MSGN	'Reading...'

	mov	al,1
	call	MediaLock
	mov	byte ptr [Locked],1

	call	StartUnit
	call	WaitReady

	call	ModeSense
	mov	word ptr [SrbBuffer],offset modedata
	call	ModeSelect
	mov	byte ptr [ModeSet],1

	mov	byte ptr [BlockSize],0Ch

	int	3

	mov	eax,0Ch
	cmp	dword ptr [BigCount],eax	; Number of blocks left
	jae	do12b_a
	mov	al,byte ptr [BigCount]		; If less than 12
do12b_a:
	mov	byte ptr [BlockSize],al		; Minimum of the two
	call	StartCDAudio
	movzx	eax,byte ptr [BlockSize]
	sub	dword ptr [BigCount],eax	; Adjust counter

big_loop:
	mov	eax,0Ch
	cmp	dword ptr [BigCount],eax	; Number of blocks left
	jae	do12b_b
	int	3
	mov	eax,dword ptr [BigCount]	; If less than 12 left
do12b_b:
	push	word ptr [BlockSize]
	mov	byte ptr [BlockSize],al
	sub	dword ptr [BigCount],eax
	and	al,al
	jz	@f
	
	call	ReadCdAudio			; Start next read

@@:
	pop	ax				; Restore Prev. Blocksize
	and	al,al
	jz	track_done
	mov	ah,0
	mov	dx,2352
	mul	dx
	movzx	ecx,ax
	add	dword ptr [filelen],ecx
	mov	ah,40h
	lea	dx,[Buffer2]
	int	21h				; Write to file
	jc	no_write

	call	IsKey				; Check for user abort
	jc	aborting

	mov	al,0Dh
	call	conout
	mov	eax,dword ptr [TotCount]	; Print current position
	sub	eax,dword ptr [BigCount]
	call	ShowTime

	mov	al,byte ptr [BlockSize]		; Check if we are done
	and	al,al
	jz	big_loop

	call	ScsiWait			; Wait for CD-ROM
	call	Xlate
	jmp	big_loop

track_done:
	CRLF
	MSGN	'Track read complete'
	jmp	finishing

aborting:
	CRLF
	MSGN	'Process Aborted'
finishing:
	mov	word ptr [SrbBuffer],offset modesave
	call	ModeSelect
	mov	byte ptr [ModeSet],0

	mov	al,0
	call	MediaLock
	mov	byte ptr [Locked],0

	mov	bx,word ptr [handle]
	and	bx,bx
	jz	no_file

	mov	ax,4200h
	mov	cx,0
	mov	dx,4			; Move FP to first length field
	int	21h
	mov	ecx,8
	sub	dword ptr [filelen],ecx
	lea	dx,[filelen]
	mov	cx,4
	mov	ah,40h
	int	21h

	mov	ax,4200h
	mov	cx,0
	mov	dx,28h			; Move FP to first length field
	int	21h
	mov	ecx,2Ch-8
	sub	dword ptr [filelen],ecx
	lea	dx,[filelen]
	mov	cx,4
	mov	ah,40h
	int	21h
	jc	no_write

	mov	ah,3eh
	int	21h			; Close file
no_file:
	mov	ax,4c00h
	int	21h

no_write:
	MSGN	'Write failed'
	jmp	bad_exit

StartCdAudio	proc	near
	mov	eax,0Ch
	cmp	dword ptr [BigCount],eax	; Number of blocks left
	jae	sca_do12b
	mov	eax,dword ptr [BigCount]	; If less than 12
sca_do12b:
	mov	byte ptr [BlockSize],al
	
	call	ReadCdAudio

	int	3
	cmp	byte ptr ds:[80h],0	; Anything in DTA?
	jz	def_name
	mov	bl,ds:[80h]		; Load counter
	mov	bh,0
	add	bx,81h
	mov	cx,bx			; Remember end of string
	mov	byte ptr ds:[bx],0	; Null-terminate string
	mov	bx,81h
dta_skip_blank:
	cmp	byte ptr ds:[bx],' '	; Leading spaces will be skipped
	jnz	dta_check_zero
	inc	bx
	jmp	dta_skip_blank
dta_check_zero:
	cmp	byte ptr ds:[bx],0	; Was anything there?
	jz	def_name
	mov	dx,bx			; Point to filename
	mov	di,bx			; Check for extension
	mov	al,'.'
	sub	cx,bx			; Get string length
	cld
	repnz	scasb
	jz	dta_gotext
	mov	word ptr ds:[di],'W.'
	mov	word ptr ds:[di+2],'VA'
	mov	byte ptr ds:[di+4],0

dta_gotext:
	MSG	'Using Filename "'
	mov	si,dx
	call	string
	MSGN	'"'
	jmp	our_name

def_name:
	lea	dx,[fname]
our_name:
	mov	ax,3c02h
	mov	cx,0
	int	21h			; Create file
	mov	bx,ax
	mov	word ptr [handle],ax
	and	ax,ax
	jnz	create_ok
	pop	ax			; Drop return address
	MSGN	'Cannot create file'
	jmp	bad_exit

create_ok:
	lea	dx,[waveheader]
	mov	ecx,2Ch			; Length of header
	mov	ah,40h
	add	dword ptr [filelen],ecx
	int	21h			; Write to file
	jnc	header_ok
	pop	ax
	MSGN	'Cannot write wave header'
	jmp	bad_exit

header_ok:
	call	ScsiWait
	call	Xlate
	ret
StartCdAudio	endp

Xlate	proc	near
	mov	cx,3720h
	lea	si,[Buffer1]
	lea	di,[Buffer2]
	cld
xlat_loop:
	lodsw
	xchg	al,ah
	stosw
	loop	xlat_loop
	ret
Xlate	endp

ScsiCmd	proc	near
	mov	byte ptr [SrbCmd],2		; Execute SCSI command
	mov	byte ptr [SrbAdapter],0		; Adapter 0
	mov	al,byte ptr [Target]
	mov	byte ptr [SrbTarget],al		; Set SCSI ID
	mov	byte ptr [SrbLun],0		; LUN 0
	mov	byte ptr [SrbSenseLen],SENSESIZE
ScsiCmd	endp

CallAspi	proc	near
	mov	byte ptr [SrbStatus],0
	push	cs
	push	offset [SRB]
	call	dword ptr cs:[aspi_ptr]
	add	sp,4
wait_aspi:
	mov	al,byte ptr [SrbStatus]
	and	al,al
	jz	wait_aspi
	test	al,84h				; Check for error
	jnz	aspi_err
	ret
aspi_err:
	push	bx
	lea	bx,[CDB]
	add	bl,byte ptr [SrbCdbLen]
	adc	bh,0
	mov	ah,byte ptr [bx-1]
	pop	bx
	stc
	ret
CallAspi	endp

ClrCDB	proc	near
	xor	eax,eax
	mov	dword ptr [CDB],eax
	mov	dword ptr [CDB+4],eax
	mov	word ptr [CDB+8],ax
	ret
ClrCDB	endp

IsKey	proc	near
	mov	ah,1
	int	16h
	jz	key_done
	mov	ah,0
	int	16h
	cmp	al,1Bh
	jz	key_abort
	and	al,al
	jnz	key_done
	int	16h
key_done:
	clc
	ret
;
key_abort:
	stc
	ret
IsKey	endp

ScanScsiDevices	proc	near
	mov	dx,800h
	mov	byte ptr [Target],0FFh

scan_loop:
	mov	byte ptr [SrbCmd],1
	mov	byte ptr [SrbFlags],XFERNONE
	mov	byte ptr [SrbTarget],dl
	mov	byte ptr [SrbLun],0
	call	CallAspi
	jc	next_id
	MSG	'ID'
	mov	al,dl
	call	nibble
	MSG	': '

	mov	al,byte ptr [SrbDevtype]
	cmp	al,0
	jnz	ssd10
	MSG	'Direct Access Device:     '
	call	Show_Device
	jmp	next_id
ssd10:
	cmp	al,1
	jnz	ssd20
	MSG	'Sequential Access Device: '
	call	Show_Device
	jmp	next_id
ssd20:
	cmp	al,2
	jnz	ssd30
	MSG	'Printer Device:           '
	call	Show_Device
	jmp	next_id
ssd30:
	cmp	al,3
	jnz	ssd40
	MSG	'Processor Device:         '
	call	Show_Device
	jmp	next_id
ssd40:
	cmp	al,4
	jnz	ssd50
	MSG	'Write-Once Device:        '
	call	Show_Device
	jmp	next_id
;
ssd50:
	cmp	al,5
	jnz	ssd60
	MSG	'CD-ROM Device:            '
	mov	byte ptr [Target],dl
	call	Show_Device
	jmp	next_id
ssd60:
	cmp	al,6
	jnz	ssd70
	MSG	'Scanner Device:           '
	call	Show_Device
	jmp	next_id
ssd70:
	cmp	al,7
	jnz	ssd80
	MSG	'Optical Memory Device:    '
	call	Show_Device
	jmp	next_id
ssd80:
	cmp	al,8
	jnz	ssd90
	MSG	'Medium Changer Device:    '
	call	Show_Device
	jmp	next_id
ssd90:
	cmp	al,9
	jnz	ssd_what
	MSG	'Communication Device:     '
	call	Show_Device
	jmp	next_id
ssd_what:
	MSGN	'Unknown type :('
	jmp	next_id

next_id:
	inc	dl
	dec	dh
	jz	ssd_ret
	jmp	scan_loop

ssd_ret:
	ret
ScanScsiDevices	endp

Show_Device	proc	near
	push	dx
	push	word ptr [Target]
	mov	byte ptr [Target],dl
	call	Inquiry
	mov	byte ptr [Buffer1+20h],0
	lea	si,[Buffer1+8]
	call	string
	CRLF
	pop	word ptr [Target]
	pop	dx
	ret
Show_Device	endp

WaitReady	proc	near
	call	TestUnitReady
	jnc	unit_ready
	CRLF
	MSGN	'Waiting for Unit Ready...'
wr_10:
	call	TestUnitReady
	jnc	unit_ready
	call	IsKey
	jnc	wr_10
	pop	ax				; Drop return address
	jmp	aborting

unit_ready:
	ret
WaitReady	endp

if DoDeviceReset
ResetDevice	proc	near
	mov	byte ptr [SrbCmd],4		; Reset SCSI Device
	mov	byte ptr [SrbAdapter],0		; Adapter 0
	mov	al,byte ptr [Target]
	mov	byte ptr [SrbTarget],al		; Set SCSI ID
	mov	byte ptr [SrbLun],0		; LUN 0
	mov	byte ptr [SrbSenseLen],SENSESIZE
	call	CallAspi
	ret
ResetDevice	endp
endif

TestUnitReady	proc	near
	call	ClrCDB
	mov	byte ptr [OpCode],0
	mov	byte ptr [SrbFlags],XFERNONE
	mov	byte ptr [SrbCdbLen],CDB6
	call	ScsiCmd
	ret
TestUnitReady	endp

ReadTOC	proc	near
	call	ClrCDB
	mov	byte ptr [OpCode],43h		; Read TOC
	mov	byte ptr [SrbFlags],XFERREAD	; Read direction

	mov	al,byte ptr [TrackNum]
	mov	byte ptr [CDB+6],al

	push	bx
	mov	bx,324h
	and	al,al
	jz	rtoc_all
	mov	bx,8
rtoc_all:
	mov	byte ptr [CDB+7],bh
	mov	byte ptr [CDB+8],bl		; 804 bytes max TOC size

	mov	byte ptr [SrbCdbLen],CDB10
	mov	word ptr [SrbBuffer+2],cs
	mov	word ptr [SrbDataLen],bx
	mov	word ptr [SrbDataLen+2],0
	pop	bx

	call	ScsiCmd
	jnc	rtoc_ret

	MSGN	'Read of TOC Failed'
	pop	ax				; Drop return address
	jmp	bad_exit

rtoc_ret:
	ret
ReadTOC	endp

GetTrack	proc	near	
	int	3
	cmp	byte ptr ds:[80h],0		; Is there parameter?
	jz	gt_noparm
	mov	eax,dword ptr ds:[80h]		; Get parameter
	mov	dword ptr [Buffer1+1],eax	; Stuff into buffer
gt_normalize:
	cmp	ah,' '				; First char space?
	jnz	gt_parm
	mov	bl,al				; Save counter
	shr	eax,8				; Remove leading space
	mov	al,bl				; Restore counter
	dec	al				; One char less
	mov	dword ptr [Buffer1+1],eax		; Stuff into buffer
	jnz	gt_normalize			; Loop
gt_noparm:
	MSG	'Which track do you want to read? ('
	mov	al,byte ptr [FirstTrack]	; First track
	call	decimal
	call	hexbnz
	mov	al,'-'
	call	conout
	mov	al,byte ptr [LastTrack]		; Last track
	call	decimal
	call	hexbnz
	MSG	') '
	lea	dx,[Buffer1]
	mov	byte ptr [Buffer1],4
	mov	ah,0Ah
	int	21h				; Get string from keyboard
gt_parm:
	CRLF
	mov	al,byte ptr [Buffer1+2]		; First char
	sub	al,'0'
	cmp	byte ptr [Buffer1+1],2		; Was there two digits?
	jnz	gt1dig
	mov	ah,10
	mul	ah
	add	al,byte ptr [Buffer1+3]
	sub	al,'0'
gt1dig:
	mov	byte ptr [TrackNum],al
	lea	si,[TrackLenBuf+4]
	mov	cl,byte ptr [LastTrack]
	sub	cl,byte ptr [FirstTrack]
	inc	cl
	mov	ch,0				; CX - num of tracks
	lea	bx,[TocBuffer+8]		; First track data
toc_loop:
	cmp	al,[bx-2]
	jz	track_found
	add	bx,8
	add	si,4
	loop	toc_loop
	MSGN	'Track not found'
	pop	ax				; Drop return address
	jmp	bad_exit
;
track_found:
	pusha
	MSG	'Using track '
	mov	al,byte ptr [TrackNum]
	call	decimal
	call	hexbnz
	CRLF
	popa
	clc
	ret
GetTrack	endp

Track_Info	proc	near
	CRLF
	mov	al,byte ptr [TocBuffer+2]
	mov	byte ptr [FirstTrack],al
	mov	byte ptr [TrackNum],0AAh
	mov	al,byte ptr [TocBuffer+3]
	mov	byte ptr [LastTrack],al
	mov	word ptr [SrbBuffer],offset TocBuffer+804
	call	ReadTOC				; Get start of Leadout

	mov	al,byte ptr [LastTrack]
	sub	al,byte ptr [FirstTrack]
	inc	al
	movzx	cx,al				; CX - number of tracks

	lea	bx,[TocBuffer+8]		; Start of TOC
	lea	si,[TrackLenBuf+4]		; Start of Track Length table
calc_len_loop:
	mov	eax,dword ptr [bx+8]		; Start of next track
	call	Intel2Moto
	mov	ecx,eax
	mov	eax,dword ptr [bx]		; Start of this track
	call	Intel2Moto
	sub	ecx,eax
	mov	eax,ecx
	call	Intel2Moto
	mov	dword ptr [si],eax		; Update size of this track

	add	bx,8				; Next track start
	add	si,4				; Next track length
	loop	calc_len_loop

	mov	eax,dword ptr [TocBuffer+804+8]	; Start of leadout
	call	Intel2Moto
	mov	ecx,eax
	mov	eax,dword ptr [bx-8]		; Start of last track
	call	Intel2Moto
	sub	ecx,eax
	mov	eax,ecx
	call	Intel2Moto
	mov	dword ptr [si-4],eax		; Update size of last track

	mov	al,byte ptr [FirstTrack]
	mov	byte ptr [TrackNum],al
	lea	bx,[TocBuffer+8]
	lea	si,[TrackLenBuf+4]
info_loop:
	push	si
	mov	al,byte ptr [TrackNum]
	call	decimal
	call	hexb
	MSG	':   '

	mov	eax,[bx]			; Start of track
	call	Intel2Moto
	
	call	ShowTimeFull

	MSG	'      Length:   '

	pop	si
	mov	eax,[si]			; Length of track
	push	si
	call	Intel2Moto
	call	ShowTimeFull

	CRLF

	add	bx,8				; Next start of track
	pop	si
	add	si,4				; Next length of track

	mov	al,byte ptr [TrackNum]
	inc	al
	mov	byte ptr [TrackNum],al
	cmp	al,byte ptr [LastTrack]
	jbe	info_loop

	MSG	' Leadout:   '

	mov	eax,[bx]
	call	Intel2Moto
	call	ShowTimeFull

	CRLF
	CRLF
	ret
Track_Info	endp

Inquiry	proc	near
	call	ClrCDB
	mov	byte ptr [OpCode],12h		; Inquiry
	mov	byte ptr [CDB+4],24h		; Data length
	mov	byte ptr [SrbFlags],XFERREAD
	mov	byte ptr [SrbCdbLen],CDB6
	mov	word ptr [SrbBuffer],offset Buffer1
	mov	word ptr [SrbBuffer+2],cs
	mov	word ptr [SrbDataLen],24h
	mov	word ptr [SrbDataLen+2],0
	call	ScsiCmd
	ret
Inquiry	endp

ModeSense	proc	near
	call	ClrCDB
	mov	byte ptr [OpCode],1Ah		; Mode sense
	mov	byte ptr [CDB+2],23h
	mov	byte ptr [CDB+4],14h
	mov	byte ptr [SrbFlags],XFERREAD
	mov	byte ptr [SrbCdbLen],CDB6
	mov	word ptr [SrbBuffer],offset modesave
	mov	word ptr [SrbBuffer+2],cs
	mov	word ptr [SrbDataLen],14h
	mov	word ptr [SrbDataLen+2],0
	call	ScsiCmd
	ret
ModeSense	endp

ModeSelect	proc	near
	call	ClrCDB
	mov	byte ptr [OpCode],15h		; Mode Select
	mov	byte ptr [CDB+1],10h
	mov	byte ptr [CDB+4],14h
	mov	byte ptr [SrbFlags],XFERWRITE
	mov	byte ptr [SrbCdbLen],CDB6
	mov	word ptr [SrbBuffer+2],cs
	mov	word ptr [SrbDataLen],14h
	mov	word ptr [SrbDataLen+2],0
	call	ScsiCmd
	ret
ModeSelect	endp

StartUnit	proc	near
	call	ClrCDB
	mov	byte ptr [OpCode],1Bh		; Start unit
	mov	byte ptr [CDB+1],0		; No Immed bit
	mov	byte ptr [CDB+4],1		; Start
	mov	byte ptr [SrbFlags],XFERNONE
	mov	byte ptr [SrbCdbLen],CDB6
	call	ScsiCmd
	ret
StartUnit	endp

ReadCdAudio	proc	near
	call	ClrCDB
	mov	byte ptr [OpCode],28h		; Read
	mov	byte ptr [SrbFlags],XFERREAD	; Read direction

	mov	eax,dword ptr [CurLba]
	mov	dword ptr [CDB+2],eax

	movzx	eax,byte ptr [BlockSize]	; Advance current LBA
	add	byte ptr [CurLba+3],al
	adc	byte ptr [CurLba+2],0
	adc	byte ptr [CurLba+1],0
	adc	byte ptr [CurLba],0

	mov	byte ptr [SrbCdbLen],CDB10
	mov	word ptr [SrbBuffer],offset Buffer1
	mov	word ptr [SrbBuffer+2],cs

	mov	byte ptr [CDB+7],0
	mov	al,byte ptr [BlockSize]
	mov	byte ptr [CDB+8],al		; 12 Blocks or less
	mov	ah,0
	mov	dx,2352				; Size of audio sector
	mul	dx
	mov	word ptr [SrbDataLen],ax	; 12*2352
	mov	word ptr [SrbDataLen+2],0

	mov	byte ptr [SrbCmd],2		; Execute SCSI command
	mov	byte ptr [SrbAdapter],0		; Adapter 0
	mov	al,byte ptr [Target]
	mov	byte ptr [SrbTarget],al		; Set SCSI ID
	mov	byte ptr [SrbLun],0		; LUN 0
	mov	byte ptr [SrbSenseLen],SENSESIZE

	mov	byte ptr [SrbStatus],0
	push	cs
	push	offset [SRB]
	call	dword ptr cs:[aspi_ptr]
	add	sp,4

	mov	al,byte ptr [SrbStatus]
	and	al,al
	jz	rca_exit
	test	al,84h				; Check for error
	jz	rca_exit

	lea	bx,[CDB]
	add	bl,byte ptr [SrbCdbLen]
	adc	bh,0
	mov	ah,byte ptr [bx-1]
	stc
rca_exit:
	ret
ReadCdAudio	endp

ScsiWait	proc	near
	mov	al,byte ptr cs:[BlockSize]
	and	al,al				; Was there anything to read?
	jz	sw_exit				; Just return

	mov	al,byte ptr [SrbStatus]
	and	al,al
	jz	ScsiWait
	test	al,84h				; Check for error
	jz	sw_exit

	lea	bx,[CDB]
	add	bl,byte ptr [SrbCdbLen]
	adc	bh,0
	mov	ah,byte ptr [bx-1]

	int	3
	push	ax
	CRLF
	MSG	'Read Failed: '
	pop	ax
	call	hexb
	mov	al,ah
	call	hexb

	MSG	' at MSF '
	push	eax
	push	ebx
	mov	eax,dword ptr [CurLba]
	call	Intel2Moto
	movzx	ebx,byte ptr [BlockSize]
	sub	eax,ebx
	call	ShowTimeFull

	MSG	'. Read of '
	mov	al,byte ptr [BlockSize]
	call	hexbnz
	MSGN	' blocks was attempted.'
	pop	ebx
	pop	eax

	pop	ax				; Drop return address
	jmp	bad_exit
sw_exit:
	ret
ScsiWait	endp

MediaLock	proc	near
	push	ax
	call	ClrCDB
	mov	byte ptr [OpCode],1Eh		; Prevent/allow
	pop	ax
	mov	byte ptr [CDB+4],al
	mov	byte ptr [SrbFlags],XFERNONE
	mov	byte ptr [SrbCdbLen],CDB6
	call	ScsiCmd
	ret
MediaLock	endp

string	proc	near
	mov	al,[si]
	and	al,al
	jz	str90
	call	conout
	inc	si
	jmp	string
;
str90:
	ret
string	endp

hexd	proc	near
	push	bx
	push	eax
	pop	bx
	pop	ax
	call	hexw
	mov	al,':'
	call	conout
	mov	ax,bx
	pop	bx
hexd	endp

hexw	proc	near
	push	ax
	mov	al,ah
	call	hexb
	pop	ax
hexw	endp

hexb	proc	near
	push	ax
	shr	al,4
	call	nibble
	pop	ax
hexb	endp

nibble	proc	near
	and	al,0Fh
	cmp	al,9
	jbe	nib_dig
	add	al,7
nib_dig:
	add	al,'0'
nibble	endp

conout	proc	near
	push	ax
	mov	ah,0Eh
	int	10h
	pop	ax
	ret
conout	endp

hexbnz	proc	near
	test	al,0F0h
	jnz	hexb
	jmp	nibble
hexbnz	endp

decimal	proc	near
	push	bx
	mov	ah,0
	mov	bl,10
	div	bl
	rol	al,4
	or	al,ah
	pop	bx
	ret
decimal	endp

ShowTime	proc	near
	pusha

	push	eax
	pop	ax
	pop	dx
	mov	bx,75*60
	div	bx				; Get number of frames
	call	decimal
	call	hexb

	mov	al,':'
	call	conout

	mov	ax,dx
	mov	bl,75
	div	bl
	call	decimal
	call	hexb

	popa
	ret
ShowTime	endp

ShowTimeFull	proc	near
	pusha

	push	eax
	pop	ax
	pop	dx
	mov	bx,75*60
	div	bx				; Get number of frames
	call	decimal
	call	hexb

	mov	al,':'
	call	conout

	mov	ax,dx
	mov	bl,75
	div	bl
	push	ax
	call	decimal
	call	hexb

	mov	al,'.'
	call	conout

	pop	ax
	mov	al,ah
	call	decimal
	call	hexb

	popa
	ret
ShowTimeFull	endp

Intel2Moto	proc	near
	push	cx
	push	eax
	pop	ax
	pop	cx
	xchg	cl,ch
	xchg	al,ah
	push	ax
	push	cx
	pop	eax
	pop	cx
	ret
Intel2Moto	endp
	
TocBuffer	label	byte		; db	804 dup (0)
					; db	8 dup (0)
TrackLenBuf	equ	TocBuffer+812	; db	400 dup (0)
Buffer1		equ	TrackLenBuf+400	; label	byte
Buffer2		equ	Buffer1+6E40h

CODE	ENDS

	end	start

	end
