VERSION 4.00
Begin VB.Form AddFile 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   Caption         =   "Add File to .ZIP Archive"
   ClientHeight    =   4440
   ClientLeft      =   1350
   ClientTop       =   2250
   ClientWidth     =   5160
   ControlBox      =   0   'False
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   0
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   4845
   Left            =   1290
   LinkTopic       =   "Form2"
   ScaleHeight     =   4440
   ScaleWidth      =   5160
   Top             =   1905
   Width           =   5280
   Begin VB.CheckBox chkRelativeDirectoryNames 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Use &Relative directory names"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   1320
      Width           =   3015
   End
   Begin VB.CheckBox chkUseFullPathname 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Use Full &Pathname"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   960
      Width           =   2295
   End
   Begin VB.CommandButton btnCancel 
      Appearance      =   0  'Flat
      BackColor       =   &H00000000&
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3720
      TabIndex        =   9
      Top             =   3600
      Width           =   1095
   End
   Begin VB.CommandButton btnOK 
      Appearance      =   0  'Flat
      BackColor       =   &H00000000&
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   2400
      TabIndex        =   8
      Top             =   3600
      Width           =   1095
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Rep&lacement Options"
      ForeColor       =   &H80000008&
      Height          =   1335
      Left            =   240
      TabIndex        =   5
      Top             =   2040
      Width           =   4575
      Begin VB.OptionButton optReplaceOnlyIfNewer 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Replace only if newer than file in .ZIP archive"
         ForeColor       =   &H80000008&
         Height          =   375
         Left            =   120
         TabIndex        =   7
         Top             =   720
         Value           =   -1  'True
         Width           =   4215
      End
      Begin VB.OptionButton optReplaceAlways 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "Replace &Always"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   360
         Width           =   3135
      End
   End
   Begin VB.CheckBox chkForceFilename 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Force filename to &Uppercase"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   1680
      Width           =   4095
   End
   Begin VB.TextBox txtFilename 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Height          =   285
      Left            =   240
      TabIndex        =   1
      Top             =   480
      Width           =   4575
   End
   Begin VB.Label Label1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Filename:"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   975
   End
End
Attribute VB_Name = "AddFile"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

' The Add File to .ZIP Archive dialog has a Use Full Pathname
' option. If clicked, the full pathname of the file to be unzipped appears.
' If not, it disappears. The only way to ensure it can be
' restored to the full pathname is to save it in this variable on start, when the
' form loads.
Dim FullPathname As String

Private Sub btnCancel_Click()
' What it does:
'   Quits the "Add File to .ZIP Archive" dialog without accepting any changes.
'
    Me.Hide
End Sub

Private Sub btnOK_Click()
' What it does:
'   Executes "Add File to .ZIP Archive" dialog, which allows the user to selecte a file and add it to the .ZIP file.
'   The user has already selected the file and its name has already been placed into txtFilename.Text.
    ' Preserves cursor while hourglass is displayed.
    Dim Cursor As Integer

    ' Return code for calls to DLL
    Dim ErrorCode As Integer

    ' Preserves Zip control's property used to display DynaZip dialogs.
    Dim TempQuietFlag As Integer

    If Not FileExists((txtFilename.Text)) Then
        Me.Hide
        Exit Sub
    End If

    ' Initialize the ZIP component.
    initZipCmdStruct Form1!Zip

    ' Preserve full pathname if it hasn't been already.
    If chkUseFullPathname.Value = 1 Then
        ' User wants to include full pathname.
        ' Form1!Zip.ZipSubOptions = Form1!Zip.ZipSubOptions Or ZSO_RELATIVEPATHFLAG
        Form1!Zip.NoDirectoryNamesFlag = False
    Else
        ' User wants only relative pathname.
        ' Form1!Zip.ZipSubOptions = Form1!Zip.ZipSubOptions And (Not ZSO_RELATIVEPATHFLAG)
        Form1!Zip.NoDirectoryNamesFlag = True
    End If

    ' Handle relative directory option.
    If chkRelativeDirectoryNames.Value = 1 Then
        Form1!Zip.ZipSubOptions = Form1!Zip.ZipSubOptions Or ZSO_RELATIVEPATHFLAG
    Else
        Form1!Zip.ZipSubOptions = Form1!Zip.ZipSubOptions And (Not ZSO_RELATIVEPATHFLAG)
        ' ///
    End If

    ' Preserve cursor.
    Cursor = Screen.MousePointer
    Screen.MousePointer = CURSOR_HOURGLASS

    ' Issue periodic notifications during zip process.
    Form1!Zip.MajorStatusFlag = True
    Form1!Zip.MinorStatusFlag = True

    Form1!Zip.ZIPFile = Form1!Label1
    Form1!Zip.ItemList = txtFilename.Text

    If chkForceFilename Then
        ' Force filenames to uppercase in archive.
        Form1!Zip.DosifyFlag = True
    Else
        Form1!Zip.DosifyFlag = False
    End If

    ' Make the zip/unzip progress status bars visible.
    ShowStatusIndicators

    ' Assume current operation is not to be canceled.
    gCancel = False


    If AddFile!optReplaceAlways = True Then
        ' This works even on the first file of a new archive.
        Form1!Zip.ActionDZ = ZIP_ADD
    Else
        ' Bug: Puts up a warning dialog in case of a new .ZIP archive
        ' and the first file is being added.
        ' Ugly fix: Suppress these dialogs!
        ' Save flag indicating whether Dynazip's built-in dialogs
        ' should be used.
        TempQuietFlag = Form1!Zip.QuietFlag
        ' Disable DynaZip's built-in dialogs.
        Form1!Zip.QuietFlag = True
        ' Add file(s) to archive.
        Form1!Zip.ActionDZ = ZIP_UPDATE
        ' Restore state of verbosity.
        Form1!Zip.QuietFlag = Form1!Zip.QuietFlag
    End If

    ' Now that file set has changed, redisplay grid full of filenames.
    DisplayFilesInArchive (Form1!Label1)

    ' Reset the status indicators.
    ClearStatus Form1!MajorStatus
    ClearStatus Form1!MinorStatus

    ' Make them disappear.
    HideStatusIndicators
    
    ' Restore cursor.
    Screen.MousePointer = Cursor

    Me.Hide
End Sub

Private Sub chkUseFullPathname_Click()
' What it does:
'   Allows the user to toggle between the full pathname of the
'   file and the filename/extension only.
'   That's why whenever a file is selected it's saved in both
'   gAddFileOnlyFilename and gAddFileFullPathname.
    If chkUseFullPathname.Value = 0 Then
        txtFilename.Text = gAddFileOnlyFilename
    End If
    If chkUseFullPathname.Value = 1 Then
        txtFilename.Text = gAddFileFullPathname
    End If
End Sub

Private Sub Form_Load()
    ' Center this form on the screen.
    CenterForm Me
End Sub

