VERSION 4.00
Begin VB.Form Form1 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   Caption         =   "FreeZip"
   ClientHeight    =   5775
   ClientLeft      =   1050
   ClientTop       =   975
   ClientWidth     =   7260
   BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   6465
   Icon            =   "FORM1.frx":0000
   KeyPreview      =   -1  'True
   Left            =   990
   LinkTopic       =   "Form1"
   ScaleHeight     =   5775
   ScaleWidth      =   7260
   Top             =   345
   Width           =   7380
   Begin VB.PictureBox Picture1 
      Align           =   1  'Align Top
      BorderStyle     =   0  'None
      Height          =   975
      Left            =   0
      ScaleHeight     =   65
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   484
      TabIndex        =   9
      Top             =   0
      Width           =   7260
      Begin ComctlLib.Toolbar Toolbar 
         Height          =   840
         Left            =   0
         TabIndex        =   1
         Top             =   0
         Width           =   7260
         _ExtentX        =   12806
         _ExtentY        =   1482
         ButtonWidth     =   1482
         ButtonHeight    =   1376
         AllowCustomize  =   0   'False
         ImageList       =   "ImageList1"
         BeginProperty Buttons {0713E452-850A-101B-AFC0-4210102A8DA7} 
            NumButtons      =   9
            BeginProperty Button1 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Caption         =   "Open"
               Key             =   "Open"
               ToolTipText     =   "Open a .ZIP archive and display its contents"
               Object.Tag             =   ""
               ImageIndex      =   1
            EndProperty
            BeginProperty Button2 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Caption         =   "New"
               Key             =   "New"
               ToolTipText     =   "Create a .ZIP archive (file)"
               Object.Tag             =   ""
               ImageIndex      =   2
            EndProperty
            BeginProperty Button3 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Caption         =   "Quit"
               Key             =   "Quit"
               ToolTipText     =   "Exit FreeZip"
               Object.Tag             =   ""
               ImageIndex      =   3
            EndProperty
            BeginProperty Button4 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Object.Tag             =   ""
               ImageIndex      =   4
               Style           =   3
               Value           =   1
            EndProperty
            BeginProperty Button5 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Caption         =   "Add"
               Key             =   "Add"
               ToolTipText     =   "Add a file to the .ZIP archive"
               Object.Tag             =   ""
               ImageIndex      =   4
            EndProperty
            BeginProperty Button6 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Caption         =   "Unzip"
               Key             =   "Unzip"
               ToolTipText     =   "Extract a file or group of files from the .ZIP archive"
               Object.Tag             =   ""
               ImageIndex      =   5
            EndProperty
            BeginProperty Button7 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Caption         =   "Delete"
               Key             =   "Delete"
               ToolTipText     =   "Remove a file or group of files from the .ZIP archive"
               Object.Tag             =   ""
               ImageIndex      =   6
            EndProperty
            BeginProperty Button8 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Object.Tag             =   ""
               Style           =   3
               Value           =   1
            EndProperty
            BeginProperty Button9 {0713F354-850A-101B-AFC0-4210102A8DA7} 
               Caption         =   "Help"
               Key             =   "Help"
               ToolTipText     =   "Learn how to use FreeZip"
               Object.Tag             =   ""
               ImageIndex      =   7
            EndProperty
         EndProperty
      End
   End
   Begin VB.PictureBox Picture2 
      Align           =   2  'Align Bottom
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   315
      Left            =   0
      ScaleHeight     =   315
      ScaleWidth      =   7260
      TabIndex        =   6
      Top             =   5460
      Width           =   7260
      Begin VB.Label lblStatus 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   0
         Width           =   8535
      End
   End
   Begin VsflexLib.vsFlexArray Grid1 
      Height          =   3495
      Left            =   120
      TabIndex        =   0
      Top             =   1200
      Visible         =   0   'False
      Width           =   7095
      _Version        =   65536
      _ExtentX        =   12515
      _ExtentY        =   6165
      _StockProps     =   100
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      FormatString    =   ""
      ConvInfo        =   1413738674
      Rows            =   50
      Cols            =   5
      FixedRows       =   1
      FixedCols       =   0
      BackColor       =   -2147483643
      ForeColor       =   -2147483640
      BackColorFixed  =   -2147483633
      ForeColorFixed  =   -2147483630
      BackColorSel    =   -2147483635
      ForeColorSel    =   -2147483634
      BackColorBkg    =   12632256
      WordWrap        =   0   'False
      TextStyle       =   0
      TextStyleFixed  =   0
      ScrollTrack     =   0   'False
      FocusRect       =   0
      HighLight       =   1
      Redraw          =   -1  'True
      ScrollBars      =   3
      RowHeightMin    =   0
      FillStyle       =   0
      GridLines       =   1
      GridLinesFixed  =   2
      GridColor       =   12632256
      GridColorFixed  =   0
      SelectionMode   =   1
      MergeCells      =   0
      PictureType     =   0
      AllowBigSelection=   -1  'True
      AllowUserResizing=   1
   End
   Begin ComctlLib.ImageList ImageList1 
      Left            =   5280
      Top             =   600
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   32
      ImageHeight     =   32
      MaskColor       =   12632256
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   7
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "FORM1.frx":030A
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "FORM1.frx":0624
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "FORM1.frx":093E
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "FORM1.frx":0C58
            Key             =   ""
         EndProperty
         BeginProperty ListImage5 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "FORM1.frx":0F72
            Key             =   ""
         EndProperty
         BeginProperty ListImage6 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "FORM1.frx":128C
            Key             =   ""
         EndProperty
         BeginProperty ListImage7 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "FORM1.frx":15A6
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin CSFormLib.CSForm CSForm1 
      Left            =   6360
      Top             =   4920
      _version        =   262144
      _extentx        =   847
      _extenty        =   847
      _stockprops     =   0
      acceptfiles     =   -1  'True
      virtualheight   =   437
      clientwidth     =   484
      clientheight    =   385
   End
   Begin DstatocxLibCtl.Dstatocx MajorStatus 
      Height          =   255
      Left            =   1320
      TabIndex        =   8
      Top             =   4800
      Visible         =   0   'False
      Width           =   5655
      _version        =   65536
      _extentx        =   9975
      _extenty        =   450
      _stockprops     =   13
      font            =   "FORM1.frx":18C0
      statuspercent   =   0
      statusoldpercent=   0
      markercolor     =   65280
      statustext      =   ""
      use3dflag       =   -1  'True
   End
   Begin DstatocxLibCtl.Dstatocx MinorStatus 
      Height          =   255
      Left            =   1320
      TabIndex        =   7
      Top             =   5160
      Visible         =   0   'False
      Width           =   5655
      _version        =   65536
      _extentx        =   9975
      _extenty        =   450
      _stockprops     =   13
      font            =   "FORM1.frx":18EC
      statuspercent   =   0
      statusoldpercent=   0
      markercolor     =   65280
      statustext      =   ""
      use3dflag       =   -1  'True
   End
   Begin Duzocx1LibCtl.Duzocx1 Unzip 
      Left            =   6360
      Top             =   4680
      _version        =   65536
      _extentx        =   741
      _extenty        =   741
      _stockprops     =   0
      zipfile         =   ""
      filespec        =   ""
      unzipindex      =   -1
      destination     =   ""
      backgroundprocessflag=   0   'False
      majorstatusflag =   -1  'True
      minorcancelflag =   0   'False
      minorstatusflag =   -1  'True
      freshenflag     =   0   'False
      updateflag      =   -1  'True
      ifun            =   1
      overwriteflag   =   0   'False
      quietflag       =   0   'False
      testflag        =   0   'False
      nodirectorynamesflag=   0   'False
      recurseflag     =   0   'False
      nodirectoryitemsflag=   0   'False
      returncount     =   0
      returnstring    =   ""
      diagnosticflag  =   0   'False
      convertlftocrlfflag=   0   'False
      decryptflag     =   0   'False
      decryptcode     =   ""
      messagecallbackflag=   0   'False
      renamecallbackflag=   0   'False
      unzipsuboptions =   0
      errorcode       =   0
      zi_index        =   0
      zi_osize        =   0
      zi_csize        =   0
      zi_cmethod      =   0
      zi_coption      =   0
      zi_cpathtype    =   0
      zi_crc_32       =   0
      zi_datetime     =   ""
      zi_filename     =   ""
      zi_attr         =   0
      overwritereadonlyflag=   0   'False
      ignorelongnamesflag=   0   'False
      manglelongnamesflag=   0   'False
      unzipstringoffset=   0
      unzipstringsize =   0
   End
   Begin Dzocx1LibCtl.Dzocx1 Zip 
      Left            =   6720
      Top             =   4680
      _version        =   65536
      _extentx        =   741
      _extenty        =   741
      _stockprops     =   0
      zipfile         =   ""
      itemlist        =   ""
      backgroundprocessflag=   0   'False
      majorstatusflag =   -1  'True
      minorstatusflag =   -1  'True
      minorcancelflag =   0   'False
      dosifyflag      =   0   'False
      recurseflag     =   0   'False
      compressionfactor=   5
      quietflag       =   0   'False
      pathfortempflag =   0   'False
      temppath        =   ""
      fixflag         =   0   'False
      fixharderflag   =   0   'False
      includevolumeflag=   0   'False
      deleteoriginalflag=   0   'False
      growexistingflag=   0   'False
      nodirectorynamesflag=   0   'False
      convertlftocrlfflag=   0   'False
      addcommentflag  =   0   'False
      comment         =   ""
      afterdateflag   =   0   'False
      date            =   ""
      oldaslatestflag =   0   'False
      includeonlyfollowingflag=   0   'False
      includefollowing=   ""
      excludefollowingflag=   0   'False
      excludefollowing=   ""
      nodirectoryentriesflag=   0   'False
      includesysandhiddenflag=   0   'False
      dontcompressthesesuffixesflag=   0   'False
      storesuffixes   =   ""
      diagnosticflag  =   0   'False
      encryptflag     =   0   'False
      encryptcode     =   ""
      messagecallbackflag=   0   'False
      multivolumecontrol=   0
      zipsuboptions   =   0
      errorcode       =   0
      actiondz        =   0
      relativepathflag=   0   'False
      ignorelongnamesflag=   0   'False
      manglelongnamesflag=   0   'False
      mvsyshide       =   0   'False
      mvcdfirst       =   0   'False
      mvformat        =   0   'False
      mvlowdense      =   0   'False
      mvsubdir        =   0   'False
      mvusemulti      =   0   'False
      mvwipe          =   0   'False
      extprogtitle    =   ""
      extprogflag     =   0   'False
      extprogcancancelflag=   0   'False
      memoryblocksize =   0
      zipstring       =   ""
   End
   Begin MSComDlg.CommonDialog CMDialog1 
      Left            =   5880
      Top             =   4680
      _ExtentX        =   847
      _ExtentY        =   847
      FontSize        =   4.23948e-38
   End
   Begin VB.Label lblZipFile 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Zip Archive:"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   4800
      Visible         =   0   'False
      Width           =   1095
   End
   Begin VB.Label lblCurrentFile 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Filename:"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   5160
      Visible         =   0   'False
      Width           =   1095
   End
   Begin VB.Label Label1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      ForeColor       =   &H80000008&
      Height          =   195
      Left            =   120
      TabIndex        =   2
      Top             =   960
      Visible         =   0   'False
      Width           =   8655
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      HelpContextID   =   1000
      Begin VB.Menu mnuFileNew 
         Caption         =   "&New"
         HelpContextID   =   1010
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open..."
         HelpContextID   =   1020
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
         HelpContextID   =   1080
      End
   End
   Begin VB.Menu mnuZip 
      Caption         =   "&Zip"
      HelpContextID   =   7000
      Begin VB.Menu mnuZipUnzipSelectedFiles 
         Caption         =   "Unzip &Selected files..."
         HelpContextID   =   7010
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuZipUnzipAllFiles 
         Caption         =   "&Unzip All files..."
         HelpContextID   =   7020
         Shortcut        =   ^U
      End
      Begin VB.Menu mnuZipSep0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuZipAddFileToArchive 
         Caption         =   "&Add file to archive..."
         HelpContextID   =   7030
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuZipDeleteSelectedFiles 
         Caption         =   "&Delete selected files..."
         HelpContextID   =   7040
         Shortcut        =   {DEL}
      End
      Begin VB.Menu mnuZipDeleteAllFiles 
         Caption         =   "Delete All Fi&les..."
         HelpContextID   =   7050
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      HelpContextID   =   9000
      Begin VB.Menu mnuHelpContents 
         Caption         =   "&Contents..."
         HelpContextID   =   9020
      End
      Begin VB.Menu mnuHelpSearchForHelpOn 
         Caption         =   "&Search for Help on..."
         HelpContextID   =   9025
      End
      Begin VB.Menu mnuHelpSep0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About "
         HelpContextID   =   9030
      End
   End
   Begin VB.Menu mnuSelectedFiles 
      Caption         =   "&Selected Files"
      HelpContextID   =   8000
      Visible         =   0   'False
      Begin VB.Menu mnuSelectedFilesUnzip 
         Caption         =   "&Unzip..."
         HelpContextID   =   7010
      End
      Begin VB.Menu mnuSelectedFilesDelete 
         Caption         =   "&Delete..."
         HelpContextID   =   7040
      End
      Begin VB.Menu mnuSelectedFilesSort 
         Caption         =   "&Sort"
      End
      Begin VB.Menu mnuSelectedFilesSep0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSelectedFilesExit 
         Caption         =   "E&xit"
         HelpContextID   =   1080
      End
   End
   Begin VB.Menu mnuNoSelectedFiles 
      Caption         =   "&No Selected Files"
      HelpContextID   =   8500
      Visible         =   0   'False
      Begin VB.Menu mnuNoSelectedFilesOpen 
         Caption         =   "&Open..."
         HelpContextID   =   1020
      End
      Begin VB.Menu mnuNoSelectedFilesNew 
         Caption         =   "&New..."
         HelpContextID   =   1010
      End
      Begin VB.Menu mnuNoSelectedFilesSep0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuNoSelectedFilesExit 
         Caption         =   "E&xit"
         HelpContextID   =   1080
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Option Explicit

Private Sub btnAdd_Click()
    DoAddFileToArchive
End Sub

Private Sub btnDelete_Click()
' What it does:
'   Deletes selected files.
'
    ' Deletes selected files.
    ' False means deleted only selected, instead of all at once.
    DoDeleteSelectedFiles False
    ' Return focus to the grid.
    If Form1!Grid1.Visible = True Then
        Form1!Grid1.SetFocus
    End If
End Sub

Private Sub btnNew_Click()
' What it does:
'   Resets controls and clears them out so that a new .ZIP archive can be created.
'
    DoCreateZipFile
    ' Return focus to the grid.
    If Form1!Grid1.Visible = True Then
        Form1!Grid1.SetFocus
    End If
End Sub

Private Sub btnOpen_Click()
'   Displays the standard Open dialog.
'   Allows user to selecte a .ZIP archive.
'   Displays the contents of the .ZIP archive.
    DoFileOpen ""
End Sub

Private Sub btnQuit_Click()
    DoFileExit
End Sub

Private Sub btnUnzip_Click()
    UnzipTo!optSelectedFiles = True
    DoUnzipSelectedFiles
    ' Return focus to the grid.
    If Form1!Grid1.Visible = True Then
        Form1!Grid1.SetFocus
    End If
End Sub

Private Sub cmdHelp_Click()
    DoCmdHelpContents
    ' Return focus to the grid, but only if it's visible.
    ' (It's not, for example, when FreeZip starts without a file named on the command line.)
    If Form1!Grid1.Visible = True Then
        Form1!Grid1.SetFocus
    End If
End Sub


Private Sub CSForm1_DropFiles(ByVal nFiles As Integer, ByVal X As Single, ByVal Y As Single, ByVal Client As Boolean)
' What it does:
'   Gives FreeZip drag and drop capabilities.
'   When user drags the name of a .ZIP archive from the File Manager
'   or Explorer, automatically opens that archive and displays its contents.
'
'
' Parameters:
'   Not used. Only the CSForm control's DropFile() array is used.
'
' See also:
'   DisplayFilesInArchive.
'
' Notes:
'   Works on only 1 file. Has no way to handle groups of files.
'
    If FileExists((CSForm1.DropFile(1))) Then
        ' Show information about each file in archive.
        DisplayFilesInArchive (CSForm1.DropFile(1))
    Else
        ' File doesn't exist. Don't bother.
        Exit Sub
    End If

End Sub


Private Sub Form_Activate()
' What it does:
'   Ensures grid is invisible if no .ZIP archive is loaded.
'   Too many illegal operations can occur with the grid
'   visible and no archive opened.
'
' See also:
'   Form_Load
'
    ' If there's no file loaded, the grid should be invisible.
    If Form1.Label1 = "" Then
        Form1!Grid1.Visible = False
    End If
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
' What it does:
'   Allows use of Escape key to cancel lengthy operations.
'   If user presses Escape, sets global flag.
'
' See also:
'   KeyPreview property for this form.
'
    If KeyAscii = KEY_ESCAPE Then
        ' User wants to cancel current operation.
        gCancel = True
    Else
        gCancel = False
    End If


End Sub

Private Sub Form_Load()
' What it does:
'   Intializes FreeZip upon startup--
'   Shows splash screen if allowed,
'   obtains name of .ZIP archive from the command line,
'   checks for presence of help file, etc.
'
' See also:
'   DoFileExit
'

    ' Center this form on the screen.
    CenterForm Me

    ' # of seconds splash screen is up (this should be stored as a setting).
    gSplashMax = 3

    ' Show splash screen if profile setting allows it.
    If GetSetting(STR_PROFILE_OPTIONS, STR_PROFILE_SHOW_SPLASH, "1") = "1" Then
        ' Put up splash screen.
        ' Make it modal.
        Splash.Show 1
    End If

    ' Construct what is in essence a constant representing newlines
    ' (VB3 doesn't allow this kind of intialization of a string constant).
    vbCRLF = Chr(13) & Chr(10)
    
    ' Obtain name of program from a constant (for ease of
    ' localization) and display it in the window caption.
    Form1.Caption = PROGRAM_NAME
    
    ' Note that no file has been opened yet.
    gFileOpen = False

    ' Give Windows a gulp of air every once in awhile
    ' during zipping & unzipping of files.
    Unzip.BackgroundProcessFlag = True
    Zip.BackgroundProcessFlag = True

    ' Determine name of help file based on name of .EXE.
    App.HelpFile = App.Path & "\" & App.EXEName & ".HLP"

    ' See if the help file is present and set flag accordingly.
    ' Disable Help menu item if help file is unavailable.
    If FileExists((App.HelpFile)) Then
        gHelpFilePresent = True
        ' mnuHelp.Enabled = True
    Else
        gHelpFilePresent = False
        ' mnuHelp.Enabled = False
    End If

    ' Make appropriate controls (e.g. menu items and toolbar buttons) available.
    UpdateUserInterface

    ' Use this same file for the common dialog Action's HelpCommand.
    Form1.CMDialog1.HelpFile = App.HelpFile

    ' "Personalize" the About item on the Help menu.
    mnuHelpAbout.Caption = mnuHelpAbout.Caption & PROGRAM_NAME & "..."

    ' If there was a file named on the command line, load it.
    If Command$ <> "" Then
        DoFileOpen Command$
    End If

End Sub

Private Sub Form_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
' What it does:
'   Snags right mouse button to put up a context menu.

    ' Respond only to right button.
    If Button <> RIGHT_BUTTON Then
        Exit Sub
    End If

    If Grid1.Visible = False Or Grid1.row <= 0 Then
        ' Popup the open/new/exit choices if grid is empty.
        PopupMenu mnuNoSelectedFiles
    Else
        ' Popup the unzip/delete/exit choices if not.
        PopupMenu mnuSelectedFiles
    End If


End Sub

Private Sub Grid1_DblClick()
' What it does:
'   Allows user to unzip a file by double-clicking it.
'
' Notes:
'   A lot can happen if no file is at the cursor position, or the
'   selection mode is no longer constrained to rows, etc.
'   Most of this routine, therefore, is avoiding runtime errors.
'
    ' Do nothing if the grid is empty (no files).
    If Grid1.row <= 0 Then
        Exit Sub
    End If

    ' Ensure grid has highlight & is in row-select mode.
    SelectRow

    ' Make sure the current column is the one with the filename
    ' in it, so that the filename (instead of the date or whatever)
    ' is passed to the unzip routine.
    Grid1.col = COL_FILENAME
    
    ' If no filename is present, just make sure selection is constrained to rows and exit immediately.
    If Grid1.Text = "" Then
        ' Select by rows.
        Grid1.SelectionMode = 1
        Exit Sub
    End If

    ' Set Unzip To dialog's "Selected Files" button, to make sure that
    ' the entire archive is not unzipped by accident.
    UnzipTo!optSelectedFiles = True
    DoUnzipSelectedFiles
End Sub

Private Sub Grid1_KeyDown(KeyCode As Integer, Shift As Integer)
' What it does:
'   Allows user to press Enter to unzip the selected file.
'
' Parameters:
'   KeyCode: ASCII value of key that was pressed.
'
' See also:
'   This control's KeyUp event.
'   This form's KeyPreview property.
'
    Select Case KeyCode
        ' If user presses Enter, bring up unzip dialog for this file.
        Case KEY_RETURN
            DoUnzipSelectedFiles
    End Select
End Sub

Private Sub Grid1_KeyUp(KeyCode As Integer, Shift As Integer)
' What it does:
'   Ensures that the status message is always up to date.
'
' Parameters:
'   Not used.
'
' See also:
'   This control's KeyDown event.
'   This form's KeyPreview property.
'
    ' Display # of files selected in status bar.
    ShowNumberOfFilesSelected
End Sub

Private Sub Grid1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
' What it does:
'   Snags right mouse button to put up a context menu.
'
    ' Do nothing if the grid is empty (no files).
    If Grid1.row <= 0 Then
        Exit Sub
    End If

    ' Ensure grid has highlight & is in row-select mode.
    SelectRow

    ' If right button, put up a context menu.
    If Button = RIGHT_BUTTON Then
        PopupMenu mnuSelectedFiles
    End If


End Sub

Private Sub Grid1_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
' What it does:
'   Ensures that the status message is always up to date.
    ' Display # of files selected in status bar.
    ShowNumberOfFilesSelected
End Sub

Private Sub mnuFileExit_Click()
    DoFileExit
End Sub

Private Sub mnuFileNew_Click()
    DoCreateZipFile
End Sub

Private Sub mnuFileOpen_Click()
    DoFileOpen ""
End Sub

Private Sub mnuHelpAbout_Click()
    Call ShellAbout(Form1.hwnd, App.Title, "FreeZip " & MAJOR_VERSION & "." & MINOR_VERSION & " from Visual Developer" & Chr(13) & "Copyright 1996 by Tom Campbell.", Form1.Icon)
End Sub

Private Sub mnuHelpContents_Click()
    DoCmdHelpContents
End Sub

Private Sub mnuHelpSearchForHelpOn_Click()
    DoCmdHelpSearch
End Sub

Private Sub mnuNoSelectedFilesExit_Click()
    DoFileExit
End Sub

Private Sub mnuNoSelectedFilesNew_Click()
    DoCreateZipFile
End Sub

Private Sub mnuNoSelectedFilesOpen_Click()
    DoFileOpen ""
End Sub

Private Sub mnuSelectedFilesDelete_Click()
    ' False means don't delete all files in archive.
    DoDeleteSelectedFiles False
End Sub

Private Sub mnuSelectedFilesExit_Click()
    DoFileExit
End Sub

Private Sub mnuSelectedFilesSort_Click()
    ' Determine which row the mouse was clicked in.
    Select Case Form1!Grid1.MouseCol
        Case COL_FILENAME
            SortByFilename

        Case COL_UNCOMPRESSED_SIZE
            SortByUncompressedSize
    End Select
End Sub

Private Sub mnuSelectedFilesUnzip_Click()
    UnzipTo!optSelectedFiles = True
    DoUnzipSelectedFiles
End Sub

Private Sub mnuZip_Click()
    ' Make appropriate controls (e.g. menu items and toolbar buttons) available.
    UpdateUserInterface
End Sub

Private Sub mnuZipAddFileToArchive_Click()
    DoAddFileToArchive
End Sub

Private Sub mnuZipCreateZipFile_Click()
    DoCreateZipFile
End Sub

Private Sub mnuZipDeleteAllFiles_Click()
    ' True means delete all files in archive.
    DoDeleteSelectedFiles True
End Sub

Private Sub mnuZipDeleteSelectedFiles_Click()
    ' False means don't delete all files in archive.
    DoDeleteSelectedFiles False
End Sub

Private Sub mnuZipUnzipAllFiles_Click()
    ' Set the "unzip all" option in the Unzip To dialog.
    UnzipTo!optAllFiles = True
    DoUnzipSelectedFiles
End Sub

Private Sub mnuZipUnzipSelectedFiles_Click()
    ' Set the "Selected Files" option in the Unzip To dialog.
    UnzipTo!optSelectedFiles = True
    DoUnzipSelectedFiles
End Sub

Private Sub StatusBar_GotFocus()

End Sub

Private Sub Toolbar1_ButtonClick(ByVal Button As Button)
    DoFileOpen ""
End Sub

Private Sub Toolbar_ButtonClick(ByVal Button As Button)
    Select Case Button.Key
        Case "Open"
            ' Put up standard Open dialog and select a .ZIP archive.
            DoFileOpen ""

        Case "New"
            ' Resets controls and clears them out so that a new .ZIP archive can be created.
            DoCreateZipFile
            ' Return focus to the grid.
            If Form1!Grid1.Visible = True Then
                Form1!Grid1.SetFocus
            End If

        Case "Quit"
            ' Close up shop and exit to Windows.
            DoFileExit

        Case "Add"
            DoAddFileToArchive
        
        Case "Unzip"
            ' Extracts all selected files from archive.
            UnzipTo!optSelectedFiles = True
            DoUnzipSelectedFiles
            ' Return focus to the grid.
            If Form1!Grid1.Visible = True Then
                Form1!Grid1.SetFocus
            End If
        
        Case "Delete"
            ' False means don't delete all files in archive.
            DoDeleteSelectedFiles False
            ' Return focus to the grid.
            If Form1!Grid1.Visible = True Then
                Form1!Grid1.SetFocus
            End If
            
        Case "Help"
            ' Displays the first help topic.
            DoCmdHelpContents
            ' Return focus to the grid, but only if it's visible.
            ' (It's not, for example, when FreeZip starts without a file named on the command line.)
            If Form1!Grid1.Visible = True Then
                Form1!Grid1.SetFocus
            End If
    End Select
End Sub

Private Sub Unzip_UnZIPMajorStatus(ItemName As String, Percent As Long, Cancel As Integer)
' What it does:
'   Updates status indicator bar, which is displayed while files are being processed in the archive.
'   The major status indicator is used on the whole archive.
'   The minor status indicaotr is used on files inside the archive.
'
  Form1!MajorStatus.StatusPercent = Percent
  Form1!MajorStatus.StatusText = ItemName
End Sub

Private Sub Unzip_UnZIPMinorStatus(ItemName As String, Percent As Long, Cancel As Integer)
' What it does:
'   Updates status indicator bar, which is displayed while files are being processed in the archive.
'   The major status indicator is used on the whole archive.
'   The minor status indicaotr is used on files inside the archive.
'
  Form1!MinorStatus.StatusPercent = Percent
  Form1!MinorStatus.StatusText = ItemName
End Sub

Private Sub Zip_ZIPMajorStatus(ItemName As String, Percent As Long, Cancel As Integer)
' What it does:
'   Updates status indicator bar, which is displayed while files are being processed in the archive.
'   The major status indicator is used on the whole archive.
'   The minor status indicaotr is used on files inside the archive.
'
  Form1!MajorStatus.StatusPercent = Percent
  Form1!MajorStatus.StatusText = ItemName
  ' Call UpdateWindow(Form1!MajorStatus.hWnd)
End Sub

Private Sub Zip_ZIPMinorStatus(ItemName As String, Percent As Long, Cancel As Integer)
' What it does:
'   Updates status indicator bar, which is displayed while files are being processed in the archive.
'   The major status indicator is used on the whole archive.
'   The minor status indicaotr is used on files inside the archive.
'
    Form1!MinorStatus.StatusPercent = Percent
    Form1!MinorStatus.StatusText = ItemName
    ' Call UpdateWindow(Form1!MinorStatus.hWnd)
End Sub

