VERSION 4.00
Begin VB.Form UnzipTo 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   Caption         =   "Unzip To"
   ClientHeight    =   4710
   ClientLeft      =   225
   ClientTop       =   780
   ClientWidth     =   7380
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   0
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   5115
   Icon            =   "UNZIPTO.frx":0000
   Left            =   165
   LinkTopic       =   "Form2"
   ScaleHeight     =   4710
   ScaleWidth      =   7380
   Top             =   435
   Width           =   7500
   Begin VB.CheckBox chkReplaceReadOnly 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Replace Read-Onl&y Files"
      ForeColor       =   &H80000008&
      Height          =   375
      Left            =   3360
      TabIndex        =   13
      Top             =   3480
      Width           =   2655
   End
   Begin VB.CommandButton btnOK 
      Appearance      =   0  'Flat
      BackColor       =   &H00000000&
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   4680
      TabIndex        =   14
      Top             =   4080
      Width           =   1095
   End
   Begin VB.CommandButton btnCancel 
      Appearance      =   0  'Flat
      BackColor       =   &H00000000&
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   6000
      TabIndex        =   15
      Top             =   4080
      Width           =   1095
   End
   Begin VB.CheckBox chkReplaceFiles 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Replace Files by the Same Name"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   3360
      TabIndex        =   12
      Top             =   3240
      Width           =   3375
   End
   Begin VB.Frame Frame2 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Which Files to Unzip"
      ForeColor       =   &H80000008&
      Height          =   1095
      Left            =   3360
      TabIndex        =   9
      Top             =   1920
      Width           =   3735
      Begin VB.OptionButton optSelectedFiles 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "S&elected Files"
         ForeColor       =   &H80000008&
         Height          =   315
         Left            =   120
         TabIndex        =   11
         Top             =   600
         Value           =   -1  'True
         Width           =   2775
      End
      Begin VB.OptionButton optAllFiles 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "&All Files"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   360
         Width           =   2775
      End
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "D&irectory Options:"
      ForeColor       =   &H80000008&
      Height          =   1095
      Left            =   3360
      TabIndex        =   6
      Top             =   720
      Width           =   3735
      Begin VB.OptionButton optUnzipToBase 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "Un&zip All Files to One Directory"
         ForeColor       =   &H80000008&
         Height          =   315
         Left            =   120
         TabIndex        =   8
         Top             =   600
         Width           =   3135
      End
      Begin VB.OptionButton optUseDirectoryStructure 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Use Directory Structure in Archive"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   360
         Value           =   -1  'True
         Width           =   3495
      End
   End
   Begin VB.DriveListBox Drive1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Height          =   315
      Left            =   3360
      TabIndex        =   5
      Top             =   360
      Width           =   3735
   End
   Begin VB.DirListBox Dir1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Height          =   3405
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   3015
   End
   Begin VB.TextBox txtCreateSubdirectory 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Height          =   285
      Left            =   120
      TabIndex        =   3
      Top             =   4080
      Width           =   3015
   End
   Begin VB.Label Label3 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Dri&ve:"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   3360
      TabIndex        =   4
      Top             =   120
      Width           =   1935
   End
   Begin VB.Label Label2 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Create &Subdirectory:"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   3840
      Width           =   2895
   End
   Begin VB.Label Label1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Directory:"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1935
   End
End
Attribute VB_Name = "UnzipTo"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Private Sub btnCancel_Click()
    Me.Hide
End Sub

Private Sub btnOK_Click()
' What it does:
'   Executes the Unzip To dialog. The user has selected a file or
'   set of files and clicked the OK button. Now they need to be unzipped.
'
' Notes:
'   Should handle the following cases:
'   - One file
'   - All files
'   - No files
'   - File(s) already exist in target directory
'

    ' If nonzero, the filename should be added to the
    ' list of files to unzip.
    Dim AddThisFile As Integer

    ' Answer from get yet/no/all dialog.
    Dim Answer As String

    ' Subdirectory user wants to create.
    Dim CreateSubdirectory As String

    ' Preserves value of "Replace files by the same name" checkbox, which
    ' may be written to temporarily if users chooses "Yes to all".
    Dim CurrReplaceFiles As Integer

    ' Subdirectory to be unzipped to.
    Dim Destination  As String

    ' Loop counter.
    Dim EachFile As Integer

    ' Return value from profile routines
    Dim ErrorCode As Integer

    ' Filename retrieved from grid.
    Dim Filename As String

    ' List of all files to extract from the archive.
    Dim Files As String

    ' # of files selected.
    Dim NumFiles As Integer

    ' # of files (out of the list of selected files) user finally
    ' decides to extract. This can differ from NumFiles in the case
    ' where some of the files to be extracted already exist in the
    ' target directory, and the user decides not to overwrite one
    ' or more of them.
    Dim NumToUnzip

    Dim TItems As Integer

    ' This is the logic called by DoUnzipSelectedFiles.

    ' The subdirectory this gets zipped to is the directory
    ' listbox Dir1, and any subdirectory below it is
    ' in UnzipTo!txtCreateSubdirectory.Text.  The latter should not
    ' have a leading backslash.
    CreateSubdirectory = UnzipTo!txtCreateSubdirectory.Text

    ' Remove any leading backslash only.
    If Left(CreateSubdirectory, 1) = "\" Then
        CreateSubdirectory = Right(CreateSubdirectory, Len(CreateSubdirectory) - 1)
    End If

    ' Append the directory the user wants to create, if any, with that
    ' in the dir listbox.
    ' Ignore any trailing backslash in the directory listbox specification.
    If Right(UnzipTo!Dir1.Path, 1) = "\" Then
        Destination = UnzipTo!Dir1.Path & CreateSubdirectory
    Else
        Destination = UnzipTo!Dir1.Path & "\" & CreateSubdirectory
    End If

    ' Make sure the destination directory has a trailing backslash.
    If Right(Destination, 1) <> "\" Then
        Destination = Destination & "\"
    End If
    
    ' Initialize the Unzip control.
    initUnzipCmdStruct Form1!Unzip

    'Destination = UnzipTo!Dir1.Path & Destination

    If UnzipTo!optUseDirectoryStructure Then
        Form1!Unzip.NoDirectoryNamesFlag = False
    Else
        Form1!Unzip.NoDirectoryNamesFlag = True
    End If

    ' Force the unzip control's "Replace files without asking" flag
    ' to be true at all times.
    ' This is because our code handles the overwrite option
    ' for these reasons:
    ' 1. Keeps all dialogs in application uniform
    ' 2. Allows use of "Yes to All" option.
    Form1!Unzip.OverwriteFlag = True

    'If UnzipTo!chkReplaceFiles Then
    '    Form1!Unzip.OverwriteFlag = True
    'Else
    '    Form1!Unzip.OverwriteFlag = False
    'End If


    ' Preserve value of this checkbox.
    CurrReplaceFiles = UnzipTo!chkReplaceFiles.Value

    NumToUnzip = 0

    ' Assume current operation is not to be canceled.
    gCancel = False

    ' Update profile, making this the default directory to unzip to.
     SaveSetting App.EXEName, STR_PROFILE_DIRECTORIES, STR_PROFILE_UNZIP_TO, Destination

    If UnzipTo!optAllFiles Then
        Form1!Unzip.Filespec = "*.*"
        If GetYesNo("Extract entire .ZIP file to " & Destination & "?", "Unzip all?") <> "Yes" Then
            Exit Sub
        End If
        ' Special meaning: unzip all.
        NumToUnzip = UNZIP_ALL_FILES
    Else
        ' Unzip selected files.
        ' Filename is in 1st column.
        'Form1!Grid1.Col = 0
        'Form1!Grid1.Row = Form1!Grid1.Row

        ' Determine how many files have been selected.
        NumFiles = Form1!Grid1.RowSel - Form1!Grid1.row + 1

        For EachFile = 1 To NumFiles
            ' Obtain the filename from the grid, and its path.
            ' Filename = Destination & Form1!Grid1.Text
            Filename = Form1!Grid1.Text
            
            ' Assume this file will be added to the list of files
            ' to unzip.
            AddThisFile = True

            ' If user is trying to extract a file from an archive, and that file
            ' already exists in the target directory, ask for confirmation.
            If UnzipTo!chkReplaceFiles = False Then

                ' "Replace files by the same name" is not checked, so confirm.
                ' This must handle these cases:
                If CreateSubdirectory = "" Then
                    If FileExists(Destination & Filename) Then
                        ' Answer = GetYesNoAll("File " & Destination & Form1!Grid1.Text & " exists." & Chr(13) & "Replace it?", "Replace this file?")
                        Answer = GetYesNoAll("File " & Filename & " exists." & Chr(13) & "Replace it?", "Replace this file?")
                        Select Case Answer
                            Case "Yes"
                                AddThisFile = True

                            Case "No"
                                AddThisFile = False

                            Case "Cancel"
                                If GetYesNo("Stop unzipping files? This means none of the selected files will be unzipped.", "Cancel") = "Yes" Then
                                    Exit Sub
                                End If

                            Case "Yes to All"
                                ' User has decided to throw caution to
                                ' the wind and replace all existing files
                                ' without confirmation.
                                UnzipTo!chkReplaceFiles.Value = 1
                                AddThisFile = True
                        End Select
                    End If
                End If
            Else
                ' "Replace files by the same name" is checked, so don't bother to confirm.
                AddThisFile = True

            End If


            ' It's now been determined whether this file should be added to
            ' the list of files to extract from the archive.
            If AddThisFile Then
        
                'Add to list.
                Files = Files & Filename

                ' Track # of files selected to extract.
                NumToUnzip = NumToUnzip + 1
            
                ' If the end of the list has NOT been reached, add a delimiter character
                ' to separate filenames in the list to extract from the archive.
                If EachFile < NumFiles Then
                    Files = Files & " "
                End If

            End If
            
            ' Go down a row to retrieve the next filename.
            If EachFile < NumFiles Then
                Form1!Grid1.row = Form1!Grid1.row + 1
            End If
            Next EachFile
        
        ' Finished constructing the list of files to be extracted.
        Form1!Unzip.Filespec = Files

    End If

    ' If user chose no files to unzip, exit immediately.
    If NumToUnzip = 0 Then
        Me.Hide
        Exit Sub
    End If

    ' Reset the status indicators.
    ClearStatus Form1!MajorStatus
    ClearStatus Form1!MinorStatus

    ' Make the zip/unzip progress status bars visible.
    ShowStatusIndicators

    ' Restore the state of this checkbox, which may have changed.
    UnzipTo!chkReplaceFiles.Value = CurrReplaceFiles

    ' Issue periodic notifications during zip process.
    Form1!Unzip.MajorStatusFlag = True
    Form1!Unzip.MinorStatusFlag = True

    Form1!Unzip.Destination = Destination
    Me.Hide

    ' Unzip the files.
    Form1!Unzip.ActionDZ = UNZIP_EXTRACT
    ' Reset the status indicators.
    ClearStatus Form1!MajorStatus
    ClearStatus Form1!MinorStatus

    ' Make them disappear.
    HideStatusIndicators

End Sub

Private Sub Drive1_Change()
    ' When Drive changes, set Dir path.
    Dir1.Path = Drive1.Drive
End Sub

Private Sub Form_Activate()
' What it does:
'   The Unzip form has come up.
'   Keep track of current "unzip to" directory and update
'   controls according to how the form was activated--that is,
'   handle special cases such as no files selected, which is assumed to
'   to mean the whole archive to should be unzipped.
'
' See also:
'   This form's OK button handler.
'

    ' Used by profile string routine
    Dim FilenameLen As Integer
    
    ' Fixed-length buffer required by API routine.
    Dim Pathname As String
    
    ' Update profile, making this the default directory to unzip to.
    Pathname = GetSetting(STR_PROFILE_DIRECTORIES, STR_PROFILE_UNZIP_TO, (App.Path))
    ' Make it the default directory only if that directory still exists.
    If DirExists(Pathname) Then
        UnzipTo!Dir1.Path = Pathname
    End If

    ' When then Unzip command has been executed with no files selected,
    ' assume user wishes unzip the whole archive.
    If Form1!Grid1.HighLight = False Then
        ' When a .ZIP archive file has just been opened, the
        ' Highlight property for the grid is turned off until the user
        ' selects a file or even moves the cursor.
        ' Highlight = False indicates that the user hasn't selected
        ' any files, therefore the whole archive should be unzipped by default.
        UnzipTo!optSelectedFiles.Value = False
        ' Assume user wants to unzip all files.
        UnzipTo!optAllFiles.Value = True

    Else
        ' The user has selected 1 or more files.
        'UnzipTo!optSelectedFiles.Value = True
        ' Assume user wants to unzip only selected files.
        ' UnzipTo!optAllFiles.Value = False
    End If

End Sub

Private Sub Form_Load()
    ' Center this form on the screen.
    CenterForm Me

    ' Assume user wants to unzip all files the first time the form is
    ' brought up, on the assumption that it's a new .ZIP archive the user
    ' has downloaded from the net or whatever and it's to be unzipped all at once.
    UnzipTo!optAllFiles.Value = True
End Sub

