/* VIDEO CONTROL FUNCTIONS */
            
#include "basic.h"
#include "video.h"
    
void print( int row, int col, int fcolor, int bcolor, char *buf )
{
	prow = row;
	if( (row + wt - 1) > wb )
		prow = wb, scrollup( 1 );
	LOCATE( prow, col );
	COLOR( fcolor, bcolor );
	_outtext( buf );
}

int setvmode( int mode )
{
    inregs.h.ah = SET_VMODE;
    inregs.h.al = (unsigned char) mode;       /* set al to mode value, see video.h */
    int86( VIDEO, &inregs, &outregs );
    return outregs.x.ax;
}

int getpage( void )
{
    inregs.h.ah = GET_MODE;
    int86( VIDEO, &inregs, &outregs );
    return (int) outregs.h.bh;      /* page value */
}

int setcursor( int row, int col, int page )
{
    inregs.h.ah = SET_CURSOR;
    inregs.h.dh = (unsigned char) row;
    inregs.h.dl = (unsigned char) col;
    inregs.h.bh = (unsigned char) page;
    int86( VIDEO, &inregs, &outregs);
    return outregs.x.ax;
}

int getcursor( int *row, int *col, int page )
{
    inregs.h.ah = GET_CURSOR;
    inregs.h.bh = (unsigned char) page;
    int86( VIDEO, &inregs, &outregs );
    *row = outregs.h.dh;     
    *col = outregs.h.dl;     
    return outregs.x.ax;
}

void putcharatt( int ch, int at )
{
    int row, col, page = getpage();

    inregs.h.bh = (unsigned char) page;  /* set active page          */
    inregs.h.ah = 9;                    /* write char/attr function */
    inregs.x.cx = 1;                    /* print just one character */
    inregs.h.al = (unsigned char) ch;   /* character to print       */
    inregs.h.bl = (unsigned char) at;   /* attribute to use         */
    int86( VIDEO, &inregs, &outregs );  /* print it                 */
    getcursor( &row, &col, page ); /* find cursor position     */
    if( col < 79 )
        setcursor( row, col + 1, page );/* move to right            */
    else if( row < 24 )
        setcursor( row +1, 0, page);    /* or to next line          */
    else                                
        setcursor( 0, 0, page );        /* or to home position      */
}

void backspace( int at )
{
    int row, col;

    getcursor( &row, &col, getpage() );
    if( col >= 0 )
        {
        setcursor( row, col - 1, getpage() );
	   putcharatt( 8, at );
        setcursor( row, col - 1, getpage() );
        }
    else
	   setcursor( row - 1, 79, getpage() );
}

int setborder( int color )
{
    inregs.h.ah = 11;
    inregs.h.bh = 0;
    inregs.h.bl = (unsigned char) color;
    int86( VIDEO, &inregs, &outregs );
    return outregs.x.ax;
}

int clear( void )
{
    inregs.h.ah = SCROLLUP; 
    inregs.h.al = 0;
    inregs.h.bh = 7;
    inregs.x.cx = 0;
    inregs.h.dh = 24;
    inregs.h.dl = 79;
    int86( VIDEO, &inregs, &outregs); 
    return outregs.x.ax;
}

void home( void )
{
    setcursor( 0, 0, getpage() );
}

void bottom( void )
{
    setcursor( 24, 79, getpage() );
}

int cursorup( void )
{
    int row, col;
    int status = 1;

    getcursor( &row, &col, getpage() );
    if( row > 0 )
        setcursor( row - 1, col, getpage() );
    else
        {
        setcursor( row, col, getpage() );
        status = 0;
        }
    return status;
}

int cursorleft( void )
{
    int row, col;
    int status = 1;

    getcursor( &row, &col, getpage() );
    if( col > 0 )
       setcursor( row, col - 1, getpage() );
    else
       {
       setcursor( row, col, getpage() );
       status = 0;
       }
    return status;
}

int cursorright( void )
{
    int row, col;
    int status = 1;

    getcursor( &row, &col, getpage() );
    if (col < 79)
       setcursor( row, col + 1, getpage() );
    else
       {
       setcursor( row, col, getpage() );
       status = 0;
       }
    return status;
}

int cursordown( void )
{
    int row, col;
    int status = 1;

    getcursor( &row, &col, getpage() );
    if( row < 24 )
       setcursor( row + 1, col, getpage() );
    else
       {
       setcursor( row, col, getpage() );
       status = 0;
       }
    return status;
}

int cursorset( int flag )     /* turns cursor on/off             */
{                              /* flag = 0 is OFF, flag > 0 is ON */     
    int top, bottom, cols;     /* top of cursor                   */

    inregs.h.ah = CURSOR_TYPE;  /* set cursor size signal       */
    inregs.h.ch = (char)top;    /* put top into ch register     */
    inregs.h.cl = (char)bottom; /* put bottom into cl register  */

    if( !flag )                 /* clear cursor if flag = 0     */
        inregs.x.cx = 0x2000;
    
    int86( VIDEO, &inregs, &outregs); 
    return outregs.x.ax;
}

int scrollup( int lines )
{
     inregs.h.ah = SCROLLUP;
     inregs.h.al = (unsigned char) lines;
     inregs.h.bh = (unsigned char)_getbkcolor();
     inregs.x.cx = (int) (wt-1) << 8 | (wl-1); /* ch=top, cl=left  */
     inregs.x.dx = (int) (wb-1) << 8 | (wr-1); /* dh=bottom, dl=right */
     int86( VIDEO, &inregs, &outregs );
     return outregs.x.ax;
}

int scrolldown( int lines )
{
     inregs.h.ah = SCROLLDOWN;
     inregs.h.al = (unsigned char) lines;
     inregs.h.bh = (unsigned char)_getbkcolor();
     inregs.x.cx = (int) (wt-1) << 8 | (wl-1); /* ch=top, cl=left  */
     inregs.x.dx = (int) (wb-1) << 8 | (wr-1); /* dh=bottom, dl=right */
     int86( VIDEO, &inregs, &outregs );
     return outregs.x.ax;
}

