/* VIDEO.H  header file  */

#define VIDEO           0x10
#define NON_DISPLAY     0x00       /* primary monochrome attributes */
#define UNDERLINE       0x01
#define NORMAL_DISPLAY  0x07
#define INVERSE         0x70
#define BLACK           0x00       /* primary color attributes */
#define BLUE            0x01       /* foreground or background */
#define GREEN           0x02
#define CYAN            0x03
#define RED             0x04
#define MAGENTA         0x05
#define BROWN           0x06
#define WHITE           0x07
#define GREY            0x08       /* highlighted color attributes */
#define LT_BLUE         0x09       /* not legal background colors  */
#define LT_GREEN        0x0A
#define LT_CYAN         0x0B
#define LT_RED          0x0C
#define LT_MAGENTA      0x0D
#define YELLOW          0x0E
#define HOTWHITE        0x0F
#define HIGHLIGHT       8       /* OR these with primary attributes */
#define BLINK           16
#define BW40_MODE       0          /* video modes for ROM BIOS  */
#define CO40_MODE       1
#define BW80_MODE       2
#define CO80_MODE       3
#define CO320_MODE      4
#define BW320_MODE      5
#define BW640_MODE      6
#define MONO_MODE       7
#define E320X200_MODE   0x0D
#define E640X200_MODE   0x0E
#define EGA_MONO_MODE   0x0F
#define EGA_MODE        0x10
#define SET_VMODE       0          /* ROM BIOS function values */
#define CURSOR_TYPE     1
#define SET_CURSOR      2
#define GET_CURSOR      3
#define SETPAGE         5
#define SCROLLUP        6
#define SCROLLDOWN      7
#define V_GCA           8
#define V_WCA           9
#define V_WC           10
#define V_WTTY         14
#define GET_MODE       15
#define MONO_SEG       0xB000      /* screen buffer segments */
#define COLOR_SEG      0xB800
#define MONO_BASE      0x3B0       /* CRT base values */
#define COLOR_BASE     0x3D0
#define CRT_STATUS     0x0A        /* status port addresses    */
#define M6845_INDEX    0x04        /* add to base value above  */
#define M6845_DATA     0x05
#define CRT_CTRL       0x08
#define MONO_ADAPTER   0           /* determine video adapter  */
#define CGA_ADAPTER    1           
#define EGA_ADAPTER    2         
#define BLOCK          0x0007      /* define cursor shape w/CURSOR() */
#define HALFBLOCK      0x0407
#define LINE2          0x0607
#define LINE1          0x0707
#define NO_CURSOR      0x2000
#define CURSORSET( x ) _settextcursor( ( 8 - lines ) << 8) |  7  )
#define CURSOR( x )    _settextcursor( x )           /* cursor control */
#define CURSOR_ON      _settextcursor( LINE2 )
#define CURSOR_OFF     _settextcursor( NO_CURSOR )
#define GET_CURS_POS   cursor = _gettextposition()   
#define CLEAR_WINDOW   _clearscreen( _GWINDOW )
#define WRAP_ON        _wrapon( _GWRAPON )
#define WRAP_OFF       _wrapon( _GWRAPOFF )
#define VIEW_PRINT( w, x, y, z )                            \
					wt = w, wl = x, wb = y, wr = z;    \                        \
                         _settextwindow( wt, wl, wb, wr )

#define CLS              _clearscreen( _GCLEARSCREEN );     \
                         LOCATE( 1, 1 )

#define LOCATE( x, y )   _settextposition( (short)x, (short)y )

#define COLOR( x, y )    _settextcolor( (short) x );        \
                         _setbkcolor( (long) y );

#define SAVE_SCREEN      oldfore = (int) _gettextcolor();   \
                         oldback = (int) _getbkcolor();     \
                         oldpos  = _gettextposition();      \
                         oldcurs = _gettextcursor();

#define RESTORE_SCREEN   _settextcolor( (short) oldfore );  \
                         _setbkcolor( (long) oldback );     \
                         _clearscreen( _GCLEARSCREEN );     \
                         _settextposition( oldpos.row, oldpos.col );  \
                         _settextcursor( oldcurs );         \
                         CURSOR_ON;

#define MAX_SCREEN_LINE  81

#define BACKSPACE        backspace( NON_DISPLAY );

int  setvmode( int mode );
int  getpage( void );
int  setcursor( int row, int col, int page );
int  getcursor( int *row, int *col, int page );
void putcharatt( int ch, int at );
void backspace( int at );
int  setborder( int color );
int  clear( void );
void home( void );
void bottom( void );
int  cursorup( void );
int  cursorleft( void );
int  cursorright( void );
int  cursordown( void );
int  cursorset( int flag );     /* turns cursor on/off */
void print( int row, int col, int fore, int back, char *buffer );
int  scrollup( int lines );
int  scrolldown( int lines );




