/*	PG_PARSE.H
	Copyright (C) 1992	Keith L. Robertson	All Rights Reserved

	Declares the types and functions needed to compile
	the parser and parsing tables (and the parsing table generator).
	Also declare parse (), called by driver program to parse the input.

	Any user of this file must type-define LEX_INFO before #including it.
*/
#ifndef PG_PARSE_H
#define	PG_PARSE_H

#ifndef TYPES_H
 #include <types.h>
#endif

#if __cplusplus
extern "C" {
#endif


/****  The point of all this... Call parse () to parse the input.  ****/
VOID	parse ();


/****  Used by the semantic actions.  ****/
/* To access symbol attributes. */
extern	LEX_INFO*	attr;

/* To advance the input stream to a particular token or set of tokens. */
VOID	skip_to_token (USHORT tok);
VOID	skip_to_bittok (USHORT* tokmap);


/* ------------------------------------- */

typedef VOID	(*SEM_ACTION) ();

typedef	struct	{	/* Indexed by production number. */
    UCHAR	nonterm;		/* Nonterminal leading the production */
    SCHAR	size_m1;		/* rhs.count() - 1  */
    SEM_ACTION	sem_action;		/* Semantic action. */
}	PRODUCTION_INFO;


/* ------------------------------------- */

typedef USHORT	ACTION;
#define		action_part(act)	(act >> 14)
#define		second_part(act)	(act & 0x3fff)
#define		action_mix(act,sec)	((act << 14) | sec)

#define		JUMP_ACTION	0
#define		REDUCE_ACTION	1
#define		SHIFT_ACTION	2
#define		ACCEPT_ACTION	3

#define		error(sec)	action_mix(JUMP_ACTION,0)
#define		jump(sec)	action_mix(JUMP_ACTION,sec)
#define		reduce(sec)	action_mix(REDUCE_ACTION,sec)
#define		no_change(sec)	action_mix(SHIFT_ACTION,0)
#define		shift(sec)	action_mix(SHIFT_ACTION,sec)
#define		accept(sec)	action_mix(ACCEPT_ACTION,0)


typedef struct	{
    USHORT	token;
    ACTION	action;
}	ACTION_ITEM;

#define		BM		0x4000		/* Lookup token by bitmap */
#define		ERR_TK		0x4ffe
#define		ANY_TK		0x4fff
#define		BR		0x8000		/* BRanch */
/* if (token & BR), branch to ACTION_ITEM (token^BR)
			and on ANY_TK do the given action. */

/* Must preserve the order:  ERR_TK < ANY_TK < BR.
   BR must have a bit set that will be clear in all other tokens,
   and there must be room beneath for any item set, or state, number. 
*/


/* ------------------------------------- */

typedef struct	{
    USHORT	cur_state;
    USHORT	nxt_state;
}	GOTO_LIST_ITEM;
#define		ANY_ST		0x7fff
#define		BG		0x8000		/* Lookup cur_state by bitmap */


#if __cplusplus
}
#endif

#endif	/* PG_PARSE_H */
