{**************************************************************************
  SOURCE.PAS, MyApp Main program

  Copyright (C) 1996 BitSoft Development, L.L.C.

  Generated by Turbo Vision Resource WorkShop
***************************************************************************}

program SOURCE;

uses
  Drivers, Objects, Views, Dialogs, Menus, Validate, App,
  { Add the support units to the uses clause. }
  About, Menu, Status, HintStat, Types;

var
  ResFile: PResourceFile;
  { Used only for retrieving the hint strings }

type
  TMyApp = Object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

constructor TMyApp.Init;
begin
  inherited Init;
  { In most cases, you will want to disable these when there are no
    windows open in the desktop. }
  DisableCommands([cmSave, cmSaveAs, cmSaveAll]);

  { Open the resource file with the string list }
  ResFile := New(PResourceFile, Init(New(PBufStream, Init('SOURCE.RES',
    stOpenRead, 4096))));

  { Load the string list from the resource file }
  RegisterType(RStringList);
  Hints := PStringList(ResFile^.Get('Hints'));
end;

destructor TMyApp.Done;
begin
  inherited Done;

  { Dispose of the resource file }
  Dispose(ResFile, Done);

  { Dispose of the string list that we created }
  if Hints <> nil then
    Dispose(Hints, Done);
end;

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  case Event.What of
    evCommand:
      case Event.Command of
        { Add the event handler for displaying the "About..." box. }
        cmAbout : ExecuteDialog(MakeAboutBox, nil);
      end;
  end;
end;

procedure TMyApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := MakeSampleMenu;
end;

procedure TMyApp.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := MakeSampleStatus;
end;

var
  MyApp: TMyApp;

begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.

