{**************************************************************************
  HINTSAPP.PAS, MyApp Main program

  Copyright (C) 1996, BitSoft Development, L.L.C.

  Generated by Turbo Vision Resource WorkShop
***************************************************************************}

{ This is the skeleton file generated by Turbo Vision Resource Workshop.
  We have modified it a little, in order to use all the resources we have
  created for this sample application.  All the changes have been documented
  in the code. }

program HINTSAPP;

uses
  Drivers, Objects, Views, Dialogs, Menus, Validate, App,
  { Add the support units to the uses clause. }
  Status, HintStat, Types;

var
  ResFile: PResourceFile;

type
  TMyApp = Object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

constructor TMyApp.Init;
begin
  ResFile := New(PResourceFile, Init(New(PBufStream, Init('HINTAPP.RES',
    stOpenRead, 4096))));
  RegisterObjects;
  RegisterViews;
  RegisterDialogs;
  RegisterValidate;
  RegisterMenus;
  RegisterApp;
  inherited Init;
  { In most cases, you will want to disable these when there are no
    windows open in the desktop. }
  DisableCommands([cmSave, cmSaveAs, cmSaveAll]);

  { Load the string list from the resource file }
  RegisterType(RStringList);
  Hints := PStringList(ResFile^.Get('Hints'));
end;

destructor TMyApp.Done;
begin
  inherited Done;
  Dispose(ResFile, Done);

  { Dispose of the string list that we created }
  if Hints <> nil then
    Dispose(Hints, Done);
end;

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  case Event.What of
    evCommand:
      case Event.Command of
        { Add the event handler for displaying the "About..." box. }
        cmAbout : ExecuteDialog(PDialog(ResFile^.Get('AboutBox')), nil);
      end;
  end;
end;

procedure TMyApp.InitMenuBar;
var
  R: TRect;
  T : PMenuItem;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := PMenuBar(ResFile^.Get('SampleMenu'));
  MenuBar^.ChangeBounds(R);
end;

procedure TMyApp.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  { Instead of getting the status line from a resource file, we are
    using the generated Make file for our custom status line object. }
  StatusLine := MakeSampleStatus;
  StatusLine^.ChangeBounds(R);
end;

var
  MyApp: TMyApp;

begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.

