/*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* IPAGE - Interactive File Paginator.
* NEW LINE SOFTWARE, Inc.
* P.O. Box 3433, Englewood, CO 80155-9957
*
* This file contains the source code for the IPAGE.EXE program. The
* program derives the pathname to the IPAGE.S script based on its own
* location, verifies that the IPAGE.S script exists, and then executes
* CIEX with this script name.
*
* CIEX (c) 1993, 1994.
* Freely distributed. For reference only.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*/
#include <stdio.h>

main(int argc, char *argv[])
{
   int i = 0;
   char *argptr[4];
   char scriptname[70];

   /* Derive pathname to the script. */

   strcpy(scriptname, argv[0]);
   i = strlen(scriptname);
   while (i > 0 && scriptname[i] != '.') i--;
   scriptname[i] = '\0';
   strcat(scriptname, ".S");

   /* Verify the script file exists. */

   if (access(scriptname, 0) != 0)
   {
      /* The script does not exist. */

      printf("\n");
      printf("----------------------------------------------------------\n");
      printf("Program Installation Error.\n");
      printf("----------------------------------------------------------\n");
      printf("!? - ERROR: Cannot find script %s.\n", scriptname);
      printf("The script must reside in same directory as this program.\n");
      printf("Verify proper program installation before continuing.\n");
      printf("Refer to README.TXT file for more information.\n");
      printf("----------------------------------------------------------\n");
      return(0);
   }
   /* Execute the CIEX interpreter as follows. */

   argptr[0] = "CIEX.EXE";
   argptr[1] = scriptname;
   if (argc == 2)
   {
      /* Pass in the name of the script, and file to paginate. */

      argptr[2] = argv[1];
      argptr[3] = NULL;
   }
   else
   {
      /* Just pass in the name of the script. */

      argptr[2] = NULL;
   }
   printf("\n");
   printf("Freely Distributed by New Line Software, Inc., 1994\n");
   printf("Executing: CIEX %s\n", scriptname);

   /* Overlay the CIEX script here. */

   if (execvp("CIEX.EXE", argptr) != 0)
   {
      /* The execv call failed. */

      printf("\n");
      printf("----------------------------------------------------------\n");
      perror("CIEX.EXE");
      printf("----------------------------------------------------------\n");
      printf("!? - ERROR: Cannot find the CIEX interpreter.\n");
      printf("CIEX.EXE must be in user's PATH for proper operation.\n");
      printf("Acquire, and install CIEX before continuing.\n");
      printf("Refer to README.TXT file for more information.\n");
      printf("----------------------------------------------------------\n");
   }
   /* Not reached. */

   return(0);
}
