
//       ANIM8 demo for VIVID raytracer

#define plum   (.9 .7 .9)
#define morf_color  (%object1 color%)  // <--- **** ANIM8 COMMAND ****

studio {
	from -40 -80 20
	at 10 0 10
	up 0 0 1
	angle 80
	res %w% %h%   // <---- ****** ANIM8 macros
	aspect 4/3
	antialias adaptive
	threshold 4
	bkg plum
	haze .001
}
light { type point falloff 0 position 500 -900 280 color 1 1 1 }
light { type point falloff 0 position -500 -200 190 color .9 .8 .4 }
light { type point falloff 0 position 240 -180 90 color .5 .6 .9 }


surface {
	texture {
		pattern checker
		scale 40 40 0
		surface { diff (.5 .5 .7) }
		surface { diff (.4 .4 .5) }
	}
}
ring {
	center 0 0 -10
	normal 0 0 1
	radius 50000
}
	
surface { diff morf_color }
transform {
    scale      10
    rotate     0 0 0
    translate  0 0 0
}

// #include cube.vo
polygon { points 4
    vertex (-1 -1 -1) vertex (1 -1 -1) vertex (1 1 -1) vertex (-1 1 -1) }
polygon { points 4
    vertex (-1 -1 -1) vertex (-1 1 -1) vertex (-1 1 1) vertex (-1 -1 1) }
polygon { points 4
    vertex (-1 1 -1) vertex (1 1 -1) vertex (1 1 1) vertex (-1 1 1) }
polygon { points 4
    vertex (1 1 -1) vertex (1 -1 -1) vertex (1 -1 1) vertex (1 1 1) }
polygon { points 4
    vertex (1 -1 -1) vertex (-1 -1 -1) vertex (-1 -1 1) vertex (1 -1 1) }
polygon { points 4
    vertex (-1 -1 1) vertex (-1 1 1) vertex (1 1 1) vertex (1 -1 1) }


