
//      ANIM8 demo for VIVID raytracer

#define plum   (.9 .7 .9)
#define white  (1 1 1)

studio {
	from -50 -140 55
	at 20 0 50
	up 0 0 1
	angle 80
	res %w% %h%   // <-- ************ ANIM8 macros *************
	aspect 4/3
	antialias adaptive
	threshold 4
	bkg plum
	haze .001
}
light { type point falloff 0 position 500 -900 280 color 1 1 1 }
light { type point falloff 0 position -500 -800 390 color .8 .7 .4 }
light { type point falloff 0 position 200 -400 490 color .5 .6 .9 }


surface {
	texture {
		pattern checker
		scale 40 40 0
		surface { diff (.5 .5 .7) }
		surface { diff (.4 .4 .5) }
	}
}
ring {
	center 0 0 -10
	normal 0 0 1
	radius 50000
}
	
surface { diff white }
transform {
    scale      10
    rotate     0 0 0
    translate  %object1 translate% // <-- **** ANIM8 ANIMATION COMMAND ****
}

// #include cube.vo
polygon { points 4
    vertex (-1 -1 -1) vertex (1 -1 -1) vertex (1 1 -1) vertex (-1 1 -1) }
polygon { points 4
    vertex (-1 -1 -1) vertex (-1 1 -1) vertex (-1 1 1) vertex (-1 -1 1) }
polygon { points 4
    vertex (-1 1 -1) vertex (1 1 -1) vertex (1 1 1) vertex (-1 1 1) }
polygon { points 4
    vertex (1 1 -1) vertex (1 -1 -1) vertex (1 -1 1) vertex (1 1 1) }
polygon { points 4
    vertex (1 -1 -1) vertex (-1 -1 -1) vertex (-1 -1 1) vertex (1 -1 1) }
polygon { points 4
    vertex (-1 -1 1) vertex (-1 1 1) vertex (1 1 1) vertex (1 -1 1) }


