/*
    camdemo1.pov  -  anim8 animator demo
     panning a camera object

    demo by mark willis
    maw01@mindspring.com
    not copyrighted - distribute this file freely
*/

camera {
  location  < %camera translate% >
  direction <0.0, 0.0, 1.0>
  sky       <0.0, 0.0, 1.0>
  up        <0.0, 0.0, 1.0>
  right     <0.0, 0.0, 1.333>
  look_at   < %sphere translate% >
}

light_source { <500.0, -900.0, 480.0>  color rgb <1.0, 1.0, 1.0> }
light_source { <-500.0, -800.0, 190.0> color rgb <0.8, 0.7, 0.4> }
light_source { <200.0, -400.0, 90.0>  color rgb <0.5, 0.6, 0.9> }

fog {color red 0.2 green 0.2 blue 0.3 distance 1000}

plane {   // ground
  z,0
  texture { pigment { color rgb <0.5, 0.5, 0.7> } }
  translate <0.0, 0.0, -7.5>
}

#declare dim = 5.0
object {  // cube
  box {<-dim,-dim,-dim>,<dim,dim,dim>}
  texture {
    pigment { color rgb <0.2, 0.3, 0.5> }
    finish {
      ambient      0.3
      diffuse      0.7
      brilliance   0.4
      phong        1.00
    }
  }
  translate < %cube translate% > // <-- **** ANIM8 ANIMATION COMMAND ****
}

object {  // sphere
  sphere {<0,0,0>, 5.0}
  texture {
    pigment { color rgb <0.5, 0.6, 0.9> }
    finish {
      ambient      0.1
      diffuse      0.6
      phong        1.00
      reflection   0.7 
    }
  }
  translate < %sphere translate% >  // ** ANIM8 ANIMATION COMMAND **
}


