/*
    linkdemo.pov  -  anim8 animator demo
     A sphere moving above a checkered plane.

    demo by mark willis
    maw01@mindspring.com
    not copyrighted - distribute this file freely
*/

camera {
  location  <-30.0, -130.0, 50.0>
  direction <0.0, 0.0, 1.0>
  sky       <0.0, 0.0, 1.0>
  up        <0.0, 0.0, 1.0>
  right     <0.0, 0.0, 1.333>
  look_at   <0.0, 0.0, 30.0>
}

light_source { <500.0, -900.0, 580.0>  color rgb <1.0, 1.0, 1.0> }
light_source { <-500.0, -800.0, 490.0> color rgb <0.8, 0.7, 0.4> }
light_source { <200.0, -400.0, 390.0>  color rgb <0.5, 0.6, 0.9> }

fog {color red 0.2 green 0.2 blue 0.3 distance 4000}

plane {   // ground
  z,0
  texture {
    pigment {
      checker
        color rgb <0.5, 0.5, 0.7>
        color rgb <0.4, 0.4, 0.5>
    }
    scale <80.0, 80.0, 1.0>
  }
  translate <0.0, 0.0, -10.0>
  rotate <0.0, 0.0, 20.0>
}

object {  // object1
  sphere {<0,0,0>,10.0}
  texture {
    pigment { color rgb <0.2, 0.5, 0.8> }
    finish {
      ambient      0.2
      diffuse      0.5
      brilliance   0.4
      phong        1.00
      phong_size   100.00
    }
  }
  translate < %object1 translate% >  // ** ANIM8 ANIMATION COMMAND **
}

object {  // object2
  sphere {<0,0,0>,3.0}
  texture {
    pigment { color rgb <0.7, 0.5, 0.1> }
    finish {
      ambient      0.2
      diffuse      0.5
      brilliance   0.4
      phong        1.00
      phong_size   100.00
    }
  }
  translate < %object2 translate% >  // ** ANIM8 ANIMATION COMMAND **
}
