(*
 * Interface to EPLAY.DLL and EPLAY32.DLL for Borland Delphi.
 *)

unit EGI;

interface

{ Include Windows types }
uses WinTypes, WinProcs, messages;

{ Parameters for FlicGetParam() and FlicSetParam() }
Const
  FLIC_PARAM_ISPLAYING         = 0;  { 1=FLIC file is currently playing }
  FLIC_PARAM_WIDTH             = 1;
  FLIC_PARAM_HEIGHT            = 2;
  FLIC_PARAM_NUMFRAMES         = 3;  { total number of frames }
  FLIC_PARAM_CURFRAME          = 4;  { current frame number }
  FLIC_PARAM_CONTINUOUS        = 5;  { segment is continuous (it has a ring frame) }
  FLIC_PARAM_SPEED             = 6;  { playback speed, set to 0 for max. speed }
  FLIC_PARAM_DESIGNSPEED       = 7;  { design speed, read from FLIC file }
  FLIC_PARAM_REALSPEED         = 8;  { real playback speed }
  FLIC_PARAM_MODE              = 9;  { BitBlt mode }
  FLIC_PARAM_LOOP              =10;  { loop frames or only play once }
  FLIC_PARAM_NUMSEGMENTS       =11;
  FLIC_PARAM_CURSEGMENT        =12;
  FLIC_PARAM_XPOS              =13;  { position of the animation in the window }
  FLIC_PARAM_YPOS              =14;
  FLIC_PARAM_LABEL             =15;  { label of the current frame (-1 if none) }
  FLIC_PARAM_CHGPAL            =16;  { use current palette, don't create a new one }
  FLIC_PARAM_VERSION           =17;  { current version of EGI player }
  FLIC_PARAM_SEGLABEL          =18;  { the label of the current segment }
  FLIC_PARAM_DRAWFRAME         =19;  { draw the frames? }
  FLIC_PARAM_FRNOTIFY          =20;  { notify for each frame? }
  FLIC_PARAM_MASK              =21;  { masks present (0=no, 1=bitmap, 2=skip-copy, 3=both) }
  FLIC_PARAM_ID                =22;  { user specified id }
  FLIC_PARAM_MSGNUM            =23;  { value of FLIC_NOTIFY }
  FLIC_PARAM_KEYFREQ           =24;  { key frame interval (0 if there are no key frames) }
  FLIC_PARAM_SKIPDELTAS        =25;  { skip all delta frames up to the next key frame }
  FLIC_PARAM_PALMODE           =26;  { palette mode }
  FLIC_PARAM_IDENTPAL          =27;  { 1:1 mapping DIB colour table to palette? }

type

{ Values for FLIC_PARAM_MODE }
TFLIC_PARAM_MODE =
(
  FLIC_MODE_BITBLT,
  FLIC_MODE_DIBTODEV,
  FLIC_MODE_STRETCHDIB,
  FLIC_MODE_WING,
  FLIC_MODE_DIBSECTION,
  FLIC_MODES
);

{ Values for FLIC_PARAM_PALMODE }
TFLIC_PARAM_PALMODE =
(
  FLIC_PAL_ADAPT,       { adapt to system palette }
  FLIC_PAL_ANIM,        { use the palette from the FLIC file (default) }
  FLIC_PAL_SPECIFIC,    { use the palette passed in by FlicSetHandle() }
  FLIC_PALMODES
);

{ Parameters for FlicGetData() }
FLIC_GET_DATA =
(
  FLIC_DATA_BITMAP,     { pointer to the pixel data }
  FLIC_DATA_PALETTE,    { pointer to the RGB table }
  FLIC_DATA_MASK,       { pointer to the bitmap mask data }
  FLIC_DATA_BITMAPINFO  { pointer to the BITMAPINFO structure }
);

{ Parameters for FlicGetHandle() }
FLIC_GET_HANDLE =
(
  FLIC_HANDLE_PALETTE,  { handle to the palette }
  FLIC_HANDLE_BITMAP,   { handle to device dependent bitmap of the frame }
  FLIC_HANDLE_MASK,     { handle to the bitmap mask }
  FLIC_HANDLE_WINGDC,   { handle to WinG Display Context }
  FLIC_HANDLE_WINGBMP,  { handle to WinG bitmap handle }
  FLIC_HANDLE_MUTEX     { handle to Win32 "mutex" semaphore for bitmap }
);

{ Parameters for FlicGetRect() }
FLIC_GET_RECT =
(
  FLIC_RECT_BOUNDING,   { bounding box of frame differences }
  FLIC_RECT_MASK,       { bounding box of the mask }
  FLIC_RECT_FIRST,      { first rectangle of the region of frame differences }
  FLIC_RECT_NEXT        { next rectangle of the region of frame differences }
);

{ Returned bits for FlicNextFrame() }
const
  FLIC_FRAME_PAL      = $0001; { palette needs updating }
  FLIC_FRAME_IMG      = $0002; { image needs updating, use FlicPaint() }
  FLIC_FRAME_LAST     = $0004; { last frame has played }
  FLIC_FRAME_RING     = $0008; { ring frame has played (reset to 2nd frame) }
  FLIC_FRAME_LABEL    = $0010; { a label was reached }
  FLIC_FRAME_DECODED  = $8000; { the frame was decoded correctly }

{ Returned values for FlicError() }
type

  FLIC_ERROR =
  (
    FLIC_ERR_NONE,
    FLIC_ERR_FOPEN,
    FLIC_ERR_FORMAT,
    FLIC_ERR_FREAD,
    FLIC_ERR_MEMORY,
    FLIC_ERR_PARAM,
    FLIC_ERR_INVALID,
    FLIC_ERR_MUTEX,
    FLIC_ERR_UNSUPPORTED
  );

{ Message posted to the owner window when a label is reached or a segment ends }
const

  FLIC_NOTIFY  = WM_USER+98;

  FN_LABEL     = 0;    { reached a label (LOWORD(lParam)==label) }
  FN_LASTFRAME = 1;    { played last frame }
  FN_FRAME     = 2;    { played (another) frame }

TYPE

  LPRECT = ^TRECT;
  LPVOID = ^DWORD;
  LPFLIC = ^LongInt;


{$ifdef WIN32}
        { 32-bit }
function FlicClose(pFlic : LPFLIC) : boolean; stdcall;
function FlicCreateWindow ( szCaption     : PCHAR;
                            dwStyle       : longint;
                            x, y          : integer;
                            width, height : integer;
                            hwndParent    : THandle;
                            hinst         : word) : THandle; stdcall;
function  FlicError     (pflic : LPFLIC) : integer; stdcall;
function  FlicGetData   (pflic : LPFLIC; code : integer) : LPVOID; stdcall;
function  FlicGetHandle (pflic : LPFLIC; hdc : HDC; code : integer) : THandle; stdcall;
function  FlicGetParam  (pflic : LPFLIC; code : integer) : integer; stdcall;
function  FlicGetRect   (pflic : LPFLIC; code : integer; lpRect : PRECT) : boolean; stdcall;
function  FlicNextFrame (pflic : LPFLIC) : word; stdcall;
Function  FlicOpen      (szFilename : pchar) : LPFLIC; stdcall;
procedure FlicPaint     (pflic : LPFLIC; _hdc : THandle; bPaintAll : boolean); stdcall;
function  FlicPlay      (pflic : LPFLIC; hwnd : THandle) : boolean; stdcall;
function  FlicSetParam  (pflic : LPFLIC; code: integer; value: integer) : boolean; stdcall;
function  FlicSetHandle (pflic : LPFLIC; code: integer; handle: THandle) : boolean; stdcall;
function  FlicStop      (pflic : LPFLIC) : boolean; stdcall;

{$else}
        { 16-bit }
function FlicClose(pFlic : LPFLIC) : boolean;
function FlicCreateWindow ( szCaption     : PCHAR;
                            dwStyle       : longint;
                            x, y          : integer;
                            width, height : integer;
                            hwndParent    : THandle;
                            hinst         : word) : THandle;
function  FlicError     (pflic : LPFLIC) : integer;
function  FlicGetData   (pflic : LPFLIC; code : integer) : LPVOID;
function  FlicGetHandle (pflic : LPFLIC; hdc : HDC; code : integer) : THandle;
function  FlicGetParam  (pflic : LPFLIC; code : integer) : integer;
function  FlicGetRect   (pflic : LPFLIC; code : integer; lpRect : PRECT) : boolean;
function  FlicNextFrame (pflic : LPFLIC) : word;
Function  FlicOpen      (szFilename : pchar) : LPFLIC;
procedure FlicPaint     (pflic : LPFLIC; _hdc : THandle; bPaintAll : boolean);
function  FlicPlay      (pflic : LPFLIC; hwnd : THandle) : boolean;
function  FlicSetParam  (pflic : LPFLIC; code: integer; value: integer) : boolean;
function  FlicSetHandle (pflic : LPFLIC; code: integer; handle: THandle) : boolean;
function  FlicStop      (pflic : LPFLIC) : boolean;

{$endif}


implementation

{$ifdef WIN32}
        { 32-bit }
function  FlicClose        ; stdcall; external 'eplay32.dll';
function  FlicCreateWindow ; stdcall; external 'eplay32.dll';
function  FlicError        ; stdcall; external 'eplay32.dll';
function  FlicGetData      ; stdcall; external 'eplay32.dll';
function  FlicGetHandle    ; stdcall; external 'eplay32.dll';
function  FlicGetParam     ; stdcall; external 'eplay32.dll';
function  FlicGetRect      ; stdcall; external 'eplay32.dll';
function  FlicNextFrame    ; stdcall; external 'eplay32.dll';
Function  FlicOpen         ; stdcall; external 'eplay32.dll';
procedure FlicPaint        ; stdcall; external 'eplay32.dll';
function  FlicPlay         ; stdcall; external 'eplay32.dll';
function  FlicSetParam     ; stdcall; external 'eplay32.dll';
function  FlicSetHandle    ; stdcall; external 'eplay32.dll';
function  FlicStop         ; stdcall; external 'eplay32.dll';

{$else}
        { 16-bit }
function  FlicClose        ; external 'eplay.dll';
function  FlicCreateWindow ; external 'eplay.dll';
function  FlicError        ; external 'eplay.dll';
function  FlicGetData      ; external 'eplay.dll';
function  FlicGetHandle    ; external 'eplay.dll';
function  FlicGetParam     ; external 'eplay.dll';
function  FlicGetRect      ; external 'eplay.dll';
function  FlicNextFrame    ; external 'eplay.dll';
Function  FlicOpen         ; external 'eplay.dll';
procedure FlicPaint        ; external 'eplay.dll';
function  FlicPlay         ; external 'eplay.dll';
function  FlicSetParam     ; external 'eplay.dll';
function  FlicSetHandle    ; external 'eplay.dll';
function  FlicStop         ; external 'eplay.dll';

{$endif}

end.
