/*
	Filename    :   ixetest.c
	Author      :   Ray E. Bornert II
	Date        :   1993-MAY-07

	Copyright (C) 1993 HixoxiH Software.  All rights reserved
*/

/*
compile line for 80286 and below:
	bcc -ml ixetest.c
compile line for 80386 and above:
	bcc -ml -3 ixetest.c
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <mem.h>
#include <bios.h>
#include "ixeblit.h"

unsigned char *VM = (unsigned char *)MK_FP(0xA000,0);
unsigned char far *ixe;

void VIDEOMODE(int n)
{
	struct REGPACK reg;
	reg.r_ax = n;
	intr(0x10,&reg);
}

void main( int argc, char *argv[] )
{
	long t0,t1,blits,seconds;
	long ixeLength,i=0;
	unsigned int ixeWidth,ixeHeight;
	int c;
	FILE *fixe;
	
	//this will not have any effect if emm386 is installed
	disableInt13();
	atexit(enableInt13);
	
	if (argc < 2)
	{
		printf("I need an .IXE to test\n");
		return;
	}

	ixe = (unsigned char *)farmalloc(65536L); //can't be larger
	if (!ixe)
	{
		printf("Could not allocate 64k buffer for ixe\n");
		return;
	}

	fixe = fopen(argv[1],"rb");
	if (!fixe)
	{
		printf("Could not open %s\n",argv[1]);
		return;
	}
	while ((c=fgetc(fixe))!=EOF)
		ixe[i++]=c;
	fclose(fixe);

	ixeLength = i;
//  ixeWidth = *(unsigned short *)(&(ixe[ixeLength-4]));
	ixeHeight = *(unsigned short *)(&(ixe[ixeLength-2]));

	if (ixe[0] == 0x8B)
	{
		printf("Only non-planar ixe's for this example, Please.\n");
		return;
	}
	
	VIDEOMODE(0x13);
	
	t0=biostime(0,0L);
	for(blits=0;;blits++)
	{
//      ixeBlitXY(VM,ixe,320,random(320),random(200));
		ixeBlitXY16(VM,ixe,320,random(320),random(200-ixeHeight));
//      ixeBlitXY16(VM,ixe,320,blits%320,blits/320);
//      ixeBlitXY32(VM,ixe,320,random(320),random(200));
		if (kbhit())
			break;
	}
	t1=biostime(0,0L);
	
	VIDEOMODE(3);
	
	seconds = (((t1-t0)*10L)/182);
	if (seconds == 0) 
		return;
	printf("%li blits / second\n",blits/seconds);

}

