// Persistence Of Vision raytracer version 3.0 sample file.
// File by Chris Young.
// This file modified by Patrick LeBlanc 1996 for use with
// PCG.EXE V1.  Area lights were removed for speed.

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"

// PCG data file
#include "spline.inc"

#declare Dist=27.5

camera{location <0,30,-180> direction 3*z look_at -y*5}

#default {finish{ambient .4}}

union {
  cone {-y*6,2,y,.5 open pigment{Red} finish {ambient .5 } }
  light_source{
     0 Red*Intensity.x spotlight radius 15  falloff 18 point_at -y
  }
  translate <-30,20,0>
}

union {
  cone {-y*6,2,y,.5 open pigment{Green} finish {ambient .5 } }
  light_source{
     0 Green*Intensity.y spotlight radius 15  falloff 18 point_at -y
  }
  translate <-10,20,0>
}
union {
  cone {-y*6,2,y,.5 open pigment{Blue} finish {ambient .5 } }
  light_source{
     0 Blue*Intensity.z spotlight radius 15  falloff 18 point_at -y
  }
  translate <10,20,0>
}

union {
  cone {-y*6,2,y,.5 open pigment{White} finish {ambient .5 } }
  light_source{
     0 White*(Intensity.x + Intensity.y + Intensity.z) spotlight radius 15  falloff 18 point_at -y
  }
  translate <30,20,0>
}

plane {y,-22 pigment{White}}

sphere{<-30-6,-20,-4>,2 pigment{White} finish{phong 1}}
sphere{<-10-6,-20,-4>,2 pigment{White} finish{phong 1}}
sphere{< 10-6,-20,-4>,2 pigment{White} finish{phong 1}}
sphere{< 30-6,-20,-4>,2 pigment{White} finish{phong 1}}

sphere{<-30-2,-7.5,-1>,2 pigment{White} finish{phong 1}}
sphere{<-10-2,-7.5,-1>,2 pigment{White} finish{phong 1}}
sphere{< 10-2,-7.5,-1>,2 pigment{White} finish{phong 1}}
sphere{< 30-2,-7.5,-1>,2 pigment{White} finish{phong 1}}

sphere{<-30+2,5,0>,2 pigment{White} finish{phong 1}}
sphere{<-10+2,5,0>,2 pigment{White} finish{phong 1}}
sphere{< 10+2,5,0>,2 pigment{White} finish{phong 1}}
sphere{< 30+2,5,0>,2 pigment{White} finish{phong 1}}

light_source {<-100,100,-250> White*.6 shadowless }
