#include <windows.h>
#pragma argsused
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#ifndef __WIN32__
# include <dir.h>
#endif
#include "hlpacces.h"

#ifdef __WIN32__
# define _export	// Microsoft C can't stand that
#endif


/* ---- Array storing the List of Files to manage in this Process... ---- */

typedef struct
        {
          LPCSTR FileName;
          LPCSTR FileTitle;
        } FILEINFO, FAR *LPFILEINFO;

int        FileCount=0;
LPFILEINFO FileInfo=NULL;


/* ---- Structure transfered to the Topic-Enumeration Procedure --------- */
typedef struct
        { HIFS   ifs;                           /* File-System of the help file */
          FILE  *CNT,                           /* File Handle to the CNT-File */
                *TOC;                           /* File Handle to the TOC-File */
          LPCSTR FileName;                      /* File-Name of the .HLP-File */
        } APPLICATION_PRIVATE_DATA, FAR *LPAPPLICATION_PRIVATE_DATA;



typedef struct
        {
          DWORD TopicOffset,    /* TopicOffset that needs to be found */
                BestOffset,     /* Best match for the offset we had till Now */
                BestHash;       /* Hash-Code for this best Match we had */
        } SCAN_PRIVATE_DATA, FAR *LPSCAN_PRIVATE_DATA;


        BOOL CALLBACK ContextEnumerationProcedure(DWORD dwHashValue, DWORD dwTopicOffset, LPARAM lParam)
        {
          LPSCAN_PRIVATE_DATA dta = (LPSCAN_PRIVATE_DATA) lParam;

          if (abs(  dwTopicOffset - dta->TopicOffset) <
              abs(dta->BestOffset - dta->TopicOffset)
             )
             { dta->BestOffset = dwTopicOffset;
               dta->BestHash   = dwHashValue;
             }

          return TRUE;

        }





/* FindBestContextIdForTopicOffset
 *
 * Tries to find a Context-String that fits to open the given TopicOffset
 */
DWORD FindBestHashForTopicOffset(
        HIFS   ifs,
        DWORD  TopicOffset)
{
  SCAN_PRIVATE_DATA dta;

  memset(&dta, 0, sizeof(dta));
  dta.TopicOffset = TopicOffset;
  dta.BestOffset  = 0x7fffffffL;

  HlpEnumContext(ifs, ContextEnumerationProcedure, (LPARAM)(LPSTR)&dta);

  return dta.BestHash;
}


	BOOL FAR PASCAL TitleEnumerationProcedure(LPCSTR lpszTitle, DWORD dwTopicOffset, LPARAM lParam)
	{ LPAPPLICATION_PRIVATE_DATA appdta = (LPAPPLICATION_PRIVATE_DATA) lParam;
          DWORD  Hash;
          char   ContextString[50];

          Hash = FindBestHashForTopicOffset(appdta->ifs, dwTopicOffset);

          HlpCreateStringForHashValue(Hash, ContextString);

          if (*lpszTitle)       // Topics without at Title are supposed to be Popups
             fprintf(appdta->TOC, "2 %s=%s@%s\n", lpszTitle, ContextString, appdta->FileName);

	  return TRUE;
	}



/* WriteLinks
 *
 * Write Link-Informations to CNT-File
 */
void WriteLinks(FILE *CNT)
{
  int  i;

  char szTOC[MAX_PATH];


  for (i=0; i<FileCount; ++i)
      fprintf(CNT, ":INDEX %s=%s\n", FileInfo[i].FileTitle, FileInfo[i].FileName);

  for (i=0; i<FileCount; ++i)
      fprintf(CNT, ":LINK %s\n", FileInfo[i].FileName);

  for (i=0; i<FileCount; ++i)
  {
      strcpy(szTOC, FileInfo[i].FileName);
      if (strrchr(szTOC, '.')) *strrchr(szTOC, '.')=0;

      fprintf(CNT, ":INCLUDE %s.TOC\n", szTOC);
  }
}



/* CreateCNTFile
 *
 * Creates a CNT and a TOC-File for one Help File.
 */
void CreateCNTFile(LPFILEINFO FileInfo)
{
  LPCSTR                   FileName=FileInfo->FileName;
  APPLICATION_PRIVATE_DATA appdta;
  char                     szCNT[MAX_PATH],
                           szTOC[MAX_PATH];

  if (NULL!=(appdta.ifs   = IFSOpen(FileName)))
  {
      strcpy(szCNT, FileName);
      if (strrchr(szCNT, '.')) *strrchr(szCNT, '.')=0;
      strcpy(szTOC, szCNT);
      strcat(szCNT, ".CNT");
      strcat(szTOC, ".TOC");

      appdta.CNT      = fopen(szCNT, "wt");
      appdta.TOC      = fopen(szTOC, "wt");
      appdta.FileName = FileName;

      if (appdta.CNT != NULL &&
          appdta.TOC != NULL)
      {
         WriteLinks(appdta.CNT);

         fprintf(appdta.TOC, "1 %s\n", FileInfo->FileTitle);

         HlpEnumTitles(appdta.ifs, TitleEnumerationProcedure, (LPARAM)&appdta);

         fclose(appdta.CNT);
         fclose(appdta.TOC);
      }
      else
         printf("Could not open output files for %s\n",FileName);

      IFSClose(appdta.ifs);
  } else
      printf("File %s could not be opened\n", FileName);
}


/* CollectFiles
 *
 * Collects files that match the Wildcard specs.
 */
void CollectFiles(LPCSTR WildCards)
{
  int             rtn;
  BOOL            found=FALSE;
  LPHELPFILETITLE lptit;
  HIFS            ifs;      

# ifdef __WIN32__
  HANDLE          hff;
  WIN32_FIND_DATA ff;
  if (NULL!=(hff=FindFirstFile(WildCards, &ff)))
  { 
  for (rtn=0;
      !rtn;
       rtn=!FindNextFile(hff, &ff))
  if (NULL!=(ifs=IFSOpen(ff.cFileName)))
  {
    FileInfo=FileInfo
                ?(LPFILEINFO) realloc(FileInfo, (FileCount+1)*sizeof(FILEINFO))
                :(LPFILEINFO)  malloc(          (FileCount+1)*sizeof(FILEINFO));
    FileInfo[FileCount].FileName=strdup(ff.cFileName);

    if (NULL!=(lptit=HlpGetHelpTitle(ifs)))
    {
       FileInfo[FileCount].FileTitle=strdup(lptit->HelpTitle ? lptit->HelpTitle : "No Title");
       HlpFreeHelpTitle(lptit);
    } else
       FileInfo[FileCount].FileTitle=strdup("No Help File");

    FileCount++;
    found=TRUE;
    IFSClose(ifs);
  }
    FindClose(hff);
  }
# else
  struct ffblk    ff;
  for (rtn=findfirst(WildCards, &ff, 0);
      !rtn;
       rtn=findnext(&ff))
  if (NULL!=(ifs=IFSOpen(ff.ff_name)))
  {
    FileInfo=FileInfo
                ?(LPFILEINFO) realloc(FileInfo, (FileCount+1)*sizeof(FILEINFO))
                :(LPFILEINFO)  malloc(          (FileCount+1)*sizeof(FILEINFO));
    FileInfo[FileCount].FileName=strdup(ff.ff_name);

    if (NULL!=(lptit=HlpGetHelpTitle(ifs)))
    {
       FileInfo[FileCount].FileTitle=strdup(lptit->HelpTitle ? lptit->HelpTitle : "No Title");
       HlpFreeHelpTitle(lptit);
    } else
       FileInfo[FileCount].FileTitle=strdup("No Help File");

    FileCount++;
    found=TRUE;
    IFSClose(ifs);
  }
# endif

  if (!found)
     printf("Warning: Could not find a match for:%s\n",WildCards);
}




main(int argc, char **argv)
{ int                      i;

  if (argc>1)
  {
      while (argc>1)
      {
        CollectFiles(argv[1]);
        argc--;
        argv++;
      }

      for (i=0; i<FileCount; ++i)
         CreateCNTFile(FileInfo+i);

  }
  else
    printf("TCNT:     Simple Example program for Help Access Library\n"
           "          Creates and Maintains CNT-Files for multi-file help projects\n"
           "USGAGE:   TCNT <Filename with Wildcards>\n"
           "          All Help-Files need to reside in the same (current) Directory\n" 
           "(C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany");

  return 0;
}